/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.common.enums.trade.DeliverCode;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.deliver.MallDeliverEntity;
import cc.lechun.mall.entity.deliver.OrderDeliverRecordVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderExpressEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.deliver.DeliverInterface;
import cc.lechun.mall.iservice.deliver.DeliverRouteInterface;
import cc.lechun.mall.iservice.trade.MallOrderExpressInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.mall.service.deliver.DeliverModeFactory;
import cc.lechun.mall.service.trade.MallOrderService;
import cc.lechun.utils.PinYinHelper;
import cc.lechun.utils.shunfeng.ShunFenUtils;
import cc.lechun.utils.yto.YtoUtils;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeliverRouteService
implements DeliverRouteInterface {
    private static final Logger log = LoggerFactory.getLogger(DeliverRouteService.class);
    @Autowired
    private MallOrderExpressInterface expressInterface;
    @Autowired
    private MallOrderService orderService;
    @Autowired
    private DeliverInterface deliverInterface;
    @Autowired
    private MallTradeInterface tradeInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private YtoUtils ytoUtils;
    @Autowired
    private ShunFenUtils shunFenUtils;

    @Override
    public BaseJsonVo getRouteInfo(String orderNo, Boolean fromCustomer) {
        log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f3\uff0corderNo={}", (Object)orderNo);
        boolean isSubscribe = false;
        BaseJsonVo jsonVo = this.getDeliverParam(orderNo);
        if (!jsonVo.isSuccess()) {
            return jsonVo;
        }
        DeliverParam param = (DeliverParam)jsonVo.getValue();
        log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f4\uff0corderNo={}", (Object)orderNo);
        MallOrderExpressEntity expressEntity = this.expressInterface.getExpressEntity(param.getDeliverCode(), param.wayBillNo);
        if (expressEntity != null) {
            boolean bl = isSubscribe = expressEntity.getIsSubscribe() == 1;
            if (expressEntity.getStatus() == 3 && !expressEntity.getData().isEmpty()) {
                isSubscribe = true;
                this.expressToConfirmGoods(expressEntity);
                log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f5\uff0corderNo={},expressEntity={}", (Object)orderNo, (Object)JsonUtils.toJson((Object)expressEntity, (boolean)false));
                return BaseJsonVo.success((Object)expressEntity);
            }
        }
        Object kuaidiInterface = DeliverModeFactory.getDeliverMode(DeliverCode.valueIsExists(param.getDeliverCode()) ? DeliverCode.valueOf(param.getDeliverCode()) : DeliverCode.jum);
        log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f6\uff0ccode={},orderNo={}", (Object)param.getDeliverCode(), (Object)orderNo);
        if (DeliverCode.jum.getValue().equals(param.getDeliverCode()) && !fromCustomer.booleanValue()) {
            return BaseJsonVo.error((String)"\u5ba2\u6237\u5728\u5fae\u4fe1\u5546\u57ce\u8ba2\u5355\u8be6\u60c5\u624d\u80fd\u67e5\u770b\u7279\u6b8a\u7269\u6d41\uff0c\u5176\u4ed6\u6765\u6e90\u5747\u4e0d\u53ef\u67e5\u8be2");
        }
        log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f7\uff0ccode={},orderNo={}", (Object)param.getDeliverCode(), (Object)orderNo);
        MallOrderExpressEntity expressEntity1 = kuaidiInterface.getRouteInfo(param.deliverCode, param.wayBillNo, param.phone);
        log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f11\uff0corderNo={},expressEntity1={}", (Object)orderNo, (Object)JsonUtils.toJson((Object)expressEntity1, (boolean)false));
        if (expressEntity1 != null) {
            log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f12\uff0corderNo={}", (Object)orderNo);
            try {
                expressEntity = expressEntity1;
                if (expressEntity != null) {
                    expressEntity.setIsSubscribe(isSubscribe ? 1 : 0);
                    expressEntity.setOrderNo(orderNo);
                    this.expressInterface.saveExpress(expressEntity);
                    expressEntity.setLastTime(new Date());
                    this.expressToConfirmGoods(expressEntity);
                }
                if (!DeliverCode.valueIsExists(param.getDeliverCode()) && !isSubscribe) {
                    this.pullRouteInfo(orderNo);
                }
            }
            catch (Exception e) {
                log.error("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f12-000\uff0corderNo={},\u62a5\u9519\u4e86\uff1a", (Object)orderNo, (Object)e);
                throw e;
            }
        }
        log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f12-0\uff0corderNo={},\u8fd4\u56de\u7684expressEntity\u662f:{}", (Object)orderNo, (Object)JsonUtils.toJson((Object)expressEntity, (boolean)false));
        return BaseJsonVo.success((Object)expressEntity);
    }

    @Override
    @ReadThroughSingleCache(namespace="DeliverRouteService.getRouteInfoForWexin", expiration=300)
    public List<OrderDeliverRecordVo> getRouteInfoForWexin(@ParameterValueKeyProvider String orderNo, Boolean fromCustomer) {
        log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f2\uff0corderNo={}", (Object)orderNo);
        BaseJsonVo jsonVo = this.getRouteInfo(orderNo, fromCustomer);
        log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f12-1\uff0corderNo={},jsonVo={}", (Object)orderNo, (Object)JsonUtils.toJson((Object)jsonVo, (boolean)false));
        if (!jsonVo.isSuccess()) {
            log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f12-2\uff0c\u6211\u4e86\u4e2a\u53bb\uff0c\u600e\u4e48\u5931\u8d25\u4e86\u554a\uff0corderNo={},jsonVo={}", (Object)orderNo, (Object)JsonUtils.toJson((Object)jsonVo, (boolean)false));
            return new ArrayList<OrderDeliverRecordVo>();
        }
        log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f13\uff0corderNo={},jsonVo={}", (Object)orderNo, (Object)JsonUtils.toJson((Object)jsonVo, (boolean)false));
        MallOrderExpressEntity expressEntity = (MallOrderExpressEntity)jsonVo.getValue();
        log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f14\uff0corderNo={},expressEntity={}", (Object)orderNo, (Object)JsonUtils.toJson((Object)expressEntity, (boolean)false));
        if (expressEntity != null) {
            String data = expressEntity.getData();
            if (data == null || data.isEmpty()) {
                return new ArrayList<OrderDeliverRecordVo>();
            }
            log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f15\uff0corderNo={},data={}", (Object)orderNo, (Object)data);
            try {
                JSONArray jsonArray = new JSONArray(data);
                ArrayList<OrderDeliverRecordVo> vos = new ArrayList<OrderDeliverRecordVo>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    OrderDeliverRecordVo vo = new OrderDeliverRecordVo();
                    vo.setContent(jsonObject.getString("context"));
                    vo.setCreateTime(DateUtils.getDateFromString((String)jsonObject.getString("time")));
                    vo.setPushTime(DateUtils.getDateFromString((String)jsonObject.getString("ftime")));
                    vos.add(vo);
                }
                log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f16\uff0corderNo={},vos={}", (Object)orderNo, (Object)JsonUtils.toJson(vos, (boolean)false));
                return vos;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        log.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f17\uff0corderNo={}", (Object)orderNo);
        return new ArrayList<OrderDeliverRecordVo>();
    }

    @Override
    public BaseJsonVo pullRouteInfo(String orderNo) {
        BaseJsonVo jsonVo = this.getDeliverParam(orderNo);
        if (!jsonVo.isSuccess()) {
            return jsonVo;
        }
        DeliverParam param = (DeliverParam)jsonVo.getValue();
        if (!param.getDeliverCode().equals("shunfeng")) {
            return BaseJsonVo.error((String)"\u5feb\u9012100\u6ca1\u5145\u94b1\uff0c\u4e0d\u652f\u6301\u8ba2\u9605\u4e86");
        }
        Object kuaidiInterface = DeliverModeFactory.getDeliverMode(param.getDeliverCode().equals("shunfeng") ? DeliverCode.shunfeng : DeliverCode.kuaidi100);
        MallOrderExpressEntity expressEntity = kuaidiInterface.pullRouteInfo(param.deliverCode, param.wayBillNo, param.phone);
        if (expressEntity != null) {
            expressEntity.setOrderNo(orderNo);
            return this.expressInterface.saveExpress(expressEntity);
        }
        return BaseJsonVo.error((String)("\u63d0\u4ea4\u8ba2\u9605\u4fe1\u606f\u5f02\u5e38,\u8ba2\u5355\u53f7\uff1a" + orderNo));
    }

    @Override
    public BaseJsonVo expressCallBack(String deliverNo, String param) {
        Object kuaidiInterface = DeliverModeFactory.getDeliverMode(deliverNo.equals("shunfeng") ? DeliverCode.shunfeng : (deliverNo.equals("zto") ? DeliverCode.zto : DeliverCode.kuaidi100));
        log.info("expressCallBack:kuaidiInterface:" + kuaidiInterface == null ? null : JsonUtils.toJson(kuaidiInterface, (boolean)false));
        MallOrderExpressEntity expressEntity = kuaidiInterface.expressCallBack(deliverNo, param);
        if (expressEntity == null) {
            return BaseJsonVo.error((String)"\u4e0d\u80fd\u83b7\u53d6\u7269\u6d41\u4fe1\u606f");
        }
        MallOrderExpressEntity search = this.expressInterface.getExpressEntity(expressEntity.getDeliverNo(), expressEntity.getExpressNo());
        log.info("expressCallBack_search:" + (search == null ? 0 : 1));
        if (search == null) {
            MallOrderEntity orderEntity = new MallOrderEntity();
            MallDeliverEntity deliverEntity = new MallDeliverEntity();
            deliverEntity.setRemark(expressEntity.getDeliverNo());
            deliverEntity = this.deliverInterface.getDeliverSigle(deliverEntity);
            orderEntity.setWaybillNo(expressEntity.getExpressNo());
            orderEntity = this.orderService.getmallOrder(orderEntity);
            if (orderEntity == null) {
                return BaseJsonVo.error((String)("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u7269\u6d41\u5355\u53f7\uff1a" + expressEntity.getExpressNo()));
            }
            search = new MallOrderExpressEntity();
            search.setCreateTime(new Date());
            search.setOrderNo(orderEntity.getOrderNo());
            search.setExpressNo(expressEntity.getExpressNo());
            search.setDeliverNo(expressEntity.getDeliverNo());
        }
        search.setStatus(expressEntity.getStatus());
        search.setIsSubscribe(1);
        search.setSubscribeCode("200");
        search.setLastTime(expressEntity.getLastTime());
        search.setComplateTime(expressEntity.getComplateTime());
        search.setData(expressEntity.getData());
        BaseJsonVo baseJsonVo = this.expressInterface.saveExpress(search);
        this.expressToConfirmGoods(search);
        log.info("expressCallBack_\u4fdd\u5b58:" + baseJsonVo.isSuccess() + ",\u7269\u6d41\u5355\u53f7\uff1a" + search.getExpressNo());
        return baseJsonVo;
    }

    private BaseJsonVo getDeliverParam(String orderNo) {
        MallOrderEntity orderEntity = this.orderService.getmallOrder(orderNo);
        if (orderEntity == null) {
            return BaseJsonVo.error((String)("\u8ba2\u5355\u53f7:" + orderNo + "\u7684\u8ba2\u5355\u4e0d\u5b58\u5728"));
        }
        MallDeliverEntity deliverEntity = new MallDeliverEntity();
        deliverEntity.setEdbName(orderEntity.getDeliverName());
        deliverEntity = this.deliverInterface.getDeliverSigle(deliverEntity);
        if (deliverEntity == null) {
            deliverEntity = new MallDeliverEntity();
            deliverEntity.setDeliverName(orderEntity.getDeliverName());
            deliverEntity = this.deliverInterface.getDeliverSigle(deliverEntity);
            if (deliverEntity == null) {
                deliverEntity = new MallDeliverEntity();
                deliverEntity.setDeliverId(IDGenerate.getUniqueIdStr());
                deliverEntity.setEdbId(orderEntity.getDeliverId());
                deliverEntity.setEdbName(orderEntity.getDeliverName());
                deliverEntity.setDeliverName(orderEntity.getDeliverName());
                deliverEntity.setRemark(PinYinHelper.getPinYin(orderEntity.getDeliverName()));
                this.deliverInterface.insertDeliver(deliverEntity);
            } else {
                deliverEntity.setEdbId(orderEntity.getDeliverId());
                deliverEntity.setEdbName(orderEntity.getDeliverName());
                deliverEntity.setRemark(PinYinHelper.getPinYin(orderEntity.getDeliverName()));
                this.deliverInterface.updateDeliver(deliverEntity);
            }
        }
        if (deliverEntity == null) {
            return BaseJsonVo.error((String)("\u7269\u6d41\u516c\u53f8ID:" + orderEntity.getDeliverId() + "\u7684\u7269\u6d41\u516c\u53f8\u4e0d\u5b58\u5728"));
        }
        if (deliverEntity.getRemark() == null || deliverEntity.getRemark().isEmpty()) {
            return BaseJsonVo.error((String)"\u8bf7\u8bbe\u7f6e\u7269\u6d41\u516c\u53f8\u5907\u6ce8\u5b57\u6bb5\u4e3a\u7269\u6d41\u516c\u53f8\u7684\u7f16\u53f7");
        }
        String deliverCode = deliverEntity.getRemark();
        String wayBillNo = orderEntity.getWaybillNo();
        String phone = orderEntity.getConsigneePhone();
        if (wayBillNo == null || wayBillNo.isEmpty()) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u7269\u6d41\u5355\u53f7\uff0c\u65e0\u6cd5\u8ba2\u9605\u548c\u67e5\u8be2");
        }
        DeliverParam param = new DeliverParam();
        param.setDeliverCode(deliverCode);
        param.setPhone(phone);
        param.setWayBillNo(wayBillNo);
        return BaseJsonVo.success((Object)param);
    }

    private void expressToConfirmGoods(MallOrderExpressEntity expressEntity) {
        MallOrderMainEntity orderMainEntity;
        MallOrderEntity orderEntity;
        if (expressEntity.getStatus() != null && expressEntity.getStatus() == 3 && (orderEntity = this.orderService.getmallOrder(expressEntity.getOrderNo())) != null && (orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderEntity.getOrderMainNo())) != null) {
            this.tradeInterface.confirmGoods(orderMainEntity.getCustomerId(), orderEntity.getOrderMainNo(), expressEntity.getOrderNo(), expressEntity.getComplateTime() == null ? expressEntity.getLastTime() : expressEntity.getComplateTime());
        }
    }

    @Override
    public BaseJsonVo YtoCallBack(String logistics_interface, String data_digest, String type, String clientId) {
        return this.ytoUtils.callBack(logistics_interface, data_digest, type, clientId);
    }

    public class DeliverParam {
        private String deliverCode;
        private String wayBillNo;
        private String phone;

        public String getDeliverCode() {
            return this.deliverCode;
        }

        public void setDeliverCode(String deliverCode) {
            this.deliverCode = deliverCode;
        }

        public String getWayBillNo() {
            return this.wayBillNo;
        }

        public void setWayBillNo(String wayBillNo) {
            this.wayBillNo = wayBillNo;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }
    }
}

