/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.common.enums.trade.DeliverCode;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.mall.entity.trade.MallOrderExpressEntity;
import cc.lechun.mall.iservice.deliver.DeliverKuaidiInterface;
import cc.lechun.mall.iservice.trade.MallOrderExpressInterface;
import cc.lechun.utils.ems.EmsUtils;
import cc.lechun.utils.ems.entity.CallBackRout;
import cc.lechun.utils.ems.entity.WaybillRoute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmsService
implements DeliverKuaidiInterface {
    @Autowired
    private EmsUtils emsUtils;
    @Autowired
    private MallOrderExpressInterface expressInterface;

    @Override
    public DeliverCode getCode() {
        return DeliverCode.ems;
    }

    @Override
    public MallOrderExpressEntity getRouteInfo(String deliverCode, String wayBillNo, String phone) {
        try {
            List<WaybillRoute> routes = this.emsUtils.trace(wayBillNo);
            ArrayList lst = new ArrayList();
            int i = 0;
            Date lastTime = null;
            for (WaybillRoute r : routes) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("time", DateUtils.formatDate((Date)r.getOpTime(), (String)""));
                map.put("ftime", DateUtils.formatDate((Date)r.getOpTime(), (String)""));
                map.put("context", r.getOpDesc());
                lst.add(map);
                if (i == 0) {
                    lastTime = r.getOpTime();
                }
                if (lastTime == null || r.getOpTime().after(lastTime)) {
                    lastTime = r.getOpTime();
                }
                ++i;
            }
            if (lst.size() > 0) {
                MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
                expressEntity.setDeliverNo(deliverCode);
                expressEntity.setCreateTime(new Date());
                expressEntity.setData(JsonUtils.toJson(lst, (boolean)false));
                expressEntity.setExpressNo(wayBillNo);
                expressEntity.setLastTime(lastTime);
                expressEntity.setComplateTime(lastTime);
                expressEntity.setIsSubscribe(1);
                expressEntity.setStatus(this.getStatus(routes.get(0).getOpCode()));
                return expressEntity;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Integer getStatus(String opCode) {
        if ("10".equals(opCode)) {
            return 1;
        }
        if ("20".equals(opCode)) {
            return 0;
        }
        if ("70".equals(opCode)) {
            return 5;
        }
        if ("80".equals(opCode)) {
            return 3;
        }
        return 0;
    }

    @Override
    public MallOrderExpressEntity pullRouteInfo(String deliverCode, String wayBillNo, String phone) {
        return null;
    }

    @Override
    public MallOrderExpressEntity expressCallBack(String deliverNo, String param) {
        try {
            String expressNo = "";
            List routes = JsonUtils.getListByArray(CallBackRout.class, (String)param);
            routes = routes.stream().sorted(Comparator.comparing(CallBackRout::getOpTime).reversed()).collect(Collectors.toList());
            ArrayList lst = new ArrayList();
            int i = 0;
            Date lastTime = new Date();
            for (CallBackRout r : routes) {
                if (StringUtils.isEmpty((String)expressNo) && StringUtils.isNotEmpty((String)r.getTraceNo())) {
                    expressNo = r.getTraceNo();
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("time", DateUtils.formatDate((Date)r.getOpTime(), (String)""));
                map.put("ftime", DateUtils.formatDate((Date)r.getOpTime(), (String)""));
                map.put("context", r.getOpDesc());
                lst.add(map);
                if (i == 0) {
                    lastTime = r.getOpTime();
                }
                ++i;
            }
            if (lst.size() > 0) {
                MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
                expressEntity.setDeliverNo(DeliverCode.ems.getName());
                expressEntity.setCreateTime(new Date());
                expressEntity.setData(JsonUtils.toJson(lst, (boolean)false));
                expressEntity.setExpressNo(expressNo);
                expressEntity.setLastTime(lastTime);
                expressEntity.setIsSubscribe(1);
                expressEntity.setStatus(this.getStatus(((CallBackRout)routes.get(0)).getOpCode()));
                return expressEntity;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

