/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.trade.DeliverCode;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallOrderExpressEntity;
import cc.lechun.mall.iservice.deliver.DeliverKuaidiInterface;
import cc.lechun.utils.jd.JdUtils;
import com.jd.open.api.sdk.domain.etms.TraceQueryJsf.response.get.TraceDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JDService
implements DeliverKuaidiInterface {
    private Logger logger = LoggerFactory.getLogger(JDService.class);
    @Autowired
    private JdUtils jdUtils;
    @Autowired
    private RedisService redisService;

    @Override
    public DeliverCode getCode() {
        return DeliverCode.jd;
    }

    @Override
    public MallOrderExpressEntity getRouteInfo(String deliverCode, String wayBillNo, String phone) {
        block14: {
            String key;
            try {
                key = "GET_ROUTE_INFO:" + wayBillNo + "\uff1a\u4eac\u4e1c\u7269\u6d41\u8c03\u7528\u6b21\u6570";
                Integer o = (Integer)this.redisService.get(key);
                if (o == null) {
                    this.redisService.getAndSet(key, 1);
                    long dateDiffSecond = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1));
                    this.redisService.setExpire(key, dateDiffSecond, TimeUnit.SECONDS);
                    this.logger.info("{}:\u4eac\u4e1c\u7269\u6d41\u8c03\u7528\u6b21\u6570:{}", (Object)wayBillNo, (Object)1);
                } else {
                    this.redisService.increment(key, 1L);
                    this.logger.info("{}:\u4eac\u4e1c\u7269\u6d41\u8c03\u7528\u6b21\u6570:{}", (Object)wayBillNo, (Object)(o + 1));
                }
            }
            catch (Exception e) {
                this.logger.error("{}\u8ba1\u7b97\u4eac\u4e1c\u7269\u6d41\u8c03\u7528\u6b21\u6570\u5f02\u5e38", (Object)wayBillNo, (Object)e);
            }
            try {
                key = "GET_ROUTE_INFO_REAL:" + wayBillNo;
                String info = (String)this.redisService.get(key);
                if (info != null) {
                    MallOrderExpressEntity entity = (MallOrderExpressEntity)JsonUtils.fromJson((String)info, MallOrderExpressEntity.class);
                    return entity;
                }
            }
            catch (Exception e) {
                this.logger.error("{}\u83b7\u53d6\u4eac\u4e1c\u7269\u6d41\u7f13\u5b58\u5f02\u5e38", (Object)wayBillNo, (Object)e);
            }
            try {
                BaseJsonVo<List<TraceDTO>> routesRst = this.jdUtils.trace(wayBillNo);
                if (!routesRst.isSuccess()) {
                    this.logger.error("[{}]\u83b7\u53d6\u4e0d\u5230\u4eac\u4e1c\u7269\u6d41\u4fe1\u606f", (Object)wayBillNo);
                    return null;
                }
                ArrayList lst = new ArrayList();
                int i = 0;
                Date lastTime = null;
                for (TraceDTO traceDetail : (List)routesRst.getValue()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("time", traceDetail.getOpeTime().replaceAll("/", "-"));
                    map.put("ftime", traceDetail.getOpeTime().replaceAll("/", "-"));
                    map.put("context", traceDetail.getOpeRemark());
                    lst.add(map);
                    if (lastTime == null || DateUtils.StrToDate((String)traceDetail.getOpeTime(), (String)"yyyy/MM/dd HH:mm:ss").after(lastTime)) {
                        lastTime = DateUtils.StrToDate((String)traceDetail.getOpeTime(), (String)"yyyy/MM/dd HH:mm:ss");
                    }
                    ++i;
                }
                if (lst.size() <= 0) break block14;
                MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
                expressEntity.setDeliverNo(deliverCode);
                expressEntity.setCreateTime(new Date());
                Collections.reverse(lst);
                expressEntity.setData(JsonUtils.toJson(lst, (boolean)false));
                expressEntity.setExpressNo(wayBillNo);
                expressEntity.setLastTime(lastTime);
                expressEntity.setComplateTime(lastTime);
                expressEntity.setIsSubscribe(1);
                expressEntity.setStatus(this.getStatus(((TraceDTO)((List)routesRst.getValue()).get(((List)routesRst.getValue()).size() - 1)).getOpeTitle()));
                try {
                    String key2 = "GET_ROUTE_INFO_REAL:" + wayBillNo;
                    this.redisService.setnx(key2, JsonUtils.toJson((Object)expressEntity, (boolean)false));
                    this.redisService.setExpire(key2, 3600L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    this.logger.error("{}\u4fdd\u5b58\u4eac\u4e1c\u7269\u6d41\u7f13\u5b58\u5f02\u5e38", (Object)wayBillNo, (Object)e);
                }
                return expressEntity;
            }
            catch (Exception e) {
                this.logger.error("[{}]\u83b7\u53d6\u4eac\u4e1c\u7269\u6d41\u4fe1\u606f\u5f02\u5e38", (Object)wayBillNo, (Object)e);
            }
        }
        return null;
    }

    private Integer getStatus(String opeTitle) {
        if ("\u59a5\u6295".equals(opeTitle)) {
            return 3;
        }
        if ("\u5feb\u9012\u7b7e\u6536".equals(opeTitle)) {
            return 1;
        }
        return 0;
    }

    @Override
    public MallOrderExpressEntity pullRouteInfo(String deliverCode, String wayBillNo, String phone) {
        return null;
    }

    @Override
    public MallOrderExpressEntity expressCallBack(String thirdExpressNo, String param) {
        return null;
    }
}

