/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.apiinvoke.baseservice.SMSInvoke;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.trade.DeliverCode;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.mall.entity.trade.MallOrderExpressEntity;
import cc.lechun.mall.iservice.deliver.DeliverKuaidiInterface;
import cc.lechun.utils.HttpUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JUMService
implements DeliverKuaidiInterface {
    private Logger logger = LoggerFactory.getLogger(JUMService.class);
    String host = "https://jmexpresv2.market.alicloudapi.com";
    String path = "/express/query-v2";
    String method = "POST";
    String appcode = "4283dea1b8d54be2ba8bfe1bb1e7922d";
    @Autowired
    SMSInvoke smsInvoke;
    @Autowired
    private RedisService redisService;

    @Override
    public MallOrderExpressEntity getRouteInfo(String deliverCode, String wayBillNo, String phone) {
        block25: {
            String key;
            try {
                key = "GET_ROUTE_INFO:" + wayBillNo + "\uff1aJUM\u7269\u6d41\u8c03\u7528\u6b21\u6570";
                Integer o = (Integer)this.redisService.get(key);
                if (o == null) {
                    this.redisService.getAndSet(key, 1);
                    long dateDiffSecond = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1));
                    this.redisService.setExpire(key, dateDiffSecond, TimeUnit.SECONDS);
                    this.logger.info("{}:JUM\u7269\u6d41\u8c03\u7528\u6b21\u6570:{}", (Object)wayBillNo, (Object)1);
                } else {
                    this.redisService.increment(key, 1L);
                    this.logger.info("{}:JUM\u7269\u6d41\u8c03\u7528\u6b21\u6570:{}", (Object)wayBillNo, (Object)(o + 1));
                }
            }
            catch (Exception e) {
                this.logger.error("{}\u8ba1\u7b97JUM\u7269\u6d41\u8c03\u7528\u6b21\u6570\u5f02\u5e38", (Object)wayBillNo, (Object)e);
            }
            try {
                key = "GET_ROUTE_INFO_REAL:" + wayBillNo;
                String info = (String)this.redisService.get(key);
                if (info != null) {
                    MallOrderExpressEntity entity = (MallOrderExpressEntity)JsonUtils.fromJson((String)info, MallOrderExpressEntity.class);
                    return entity;
                }
            }
            catch (Exception e) {
                this.logger.error("{}\u83b7\u53d6JUM\u7269\u6d41\u7f13\u5b58\u5f02\u5e38", (Object)wayBillNo, (Object)e);
            }
            this.logger.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f8\uff0cwayBillNo={}", (Object)wayBillNo);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "APPCODE " + this.appcode);
            headers.put("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            HashMap<String, String> querys = new HashMap<String, String>();
            HashMap<String, String> bodys = new HashMap<String, String>();
            if (StringUtils.isNotEmpty((String)phone)) {
                bodys.put("mobile", phone);
            }
            if (!StringUtils.isNotEmpty((String)wayBillNo)) {
                return null;
            }
            bodys.put("number", wayBillNo);
            try {
                HttpResponse response = HttpUtils.doPost(this.host, this.path, this.method, headers, querys, bodys);
                String s = EntityUtils.toString((HttpEntity)response.getEntity());
                this.logger.info("{}\u901a\u8fc7\u805a\u7f8e\u667a\u6570\u83b7\u53d6\u7269\u6d41\u4fe1\u606f:{}", (Object)wayBillNo, (Object)s);
                if (StringUtils.isEmpty((String)s)) {
                    this.logger.info("\u805a\u7f8e\u667a\u6570\u6b20\u8d39\u4e86");
                    if (this.redisService.get("JUM_NOT_IN_SERVICE") == null) {
                        this.smsInvoke.pushMessage("18612519503", "\u805a\u7f8e\u667a\u6570\u6b20\u8d39\u4e86", "");
                        this.smsInvoke.pushMessage("15910702720", "\u805a\u7f8e\u667a\u6570\u6b20\u8d39\u4e86", "");
                        this.redisService.save("JUM_NOT_IN_SERVICE", 1, 172800L);
                    }
                    return null;
                }
                Map rtnMap = (Map)JsonUtils.fromJson((String)s, Map.class);
                if (rtnMap.containsKey("code") && (Integer)rtnMap.get("code") == 200) {
                    if (!rtnMap.containsKey("data")) {
                        this.logger.error("\u901a\u8fc7\u805a\u7f8e\u667a\u6570\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\u5931\u8d25\uff0c\u53c2\u6570[deliverCode={},wayBillNo={},phone={}],\u8fd4\u56de\uff1a{}", new Object[]{deliverCode, wayBillNo, phone, s});
                        try {
                            String key2 = "GET_ROUTE_INFO_REAL:" + wayBillNo;
                            this.redisService.save(key2, JsonUtils.toJson((Object)new MallOrderExpressEntity(), (boolean)false));
                            this.redisService.setExpire(key2, 3600L, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            this.logger.error("{}\u4fdd\u5b58\u4eac\u4e1c\u7269\u6d41\u7f13\u5b58\u5f02\u5e38", (Object)wayBillNo, (Object)e);
                        }
                        return null;
                    }
                    Map dataMap = (Map)rtnMap.get("data");
                    ArrayList lst = new ArrayList();
                    if (!dataMap.containsKey("theLastTime") || !dataMap.containsKey("logisticsTraceDetails")) {
                        this.logger.error("\u901a\u8fc7\u805a\u7f8e\u667a\u6570\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\u5931\u8d25\uff0c\u53c2\u6570[deliverCode={},wayBillNo={},phone={}],\u8fd4\u56de\uff1a{}", new Object[]{deliverCode, wayBillNo, phone, s});
                        try {
                            String key3 = "GET_ROUTE_INFO_REAL:" + wayBillNo;
                            this.redisService.save(key3, JsonUtils.toJson((Object)new MallOrderExpressEntity(), (boolean)false));
                            this.redisService.setExpire(key3, 3600L, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            this.logger.error("{}\u4fdd\u5b58\u4eac\u4e1c\u7269\u6d41\u7f13\u5b58\u5f02\u5e38", (Object)wayBillNo, (Object)e);
                        }
                        return null;
                    }
                    Date lastTime = DateUtils.StrToDate((String)((String)dataMap.get("theLastTime")));
                    for (Map traceDetail : (List)dataMap.get("logisticsTraceDetails")) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("time", DateUtils.formatDate((Date)new Date((Long)traceDetail.get("time")), (String)""));
                        map.put("ftime", (String)map.get("time"));
                        map.put("context", (String)traceDetail.get("desc"));
                        map.put("sign_code", (String)traceDetail.get("logisticsStatus"));
                        lst.add(map);
                    }
                    if (lst.size() <= 0) break block25;
                    MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
                    expressEntity.setDeliverNo(deliverCode);
                    expressEntity.setCreateTime(new Date());
                    Collections.reverse(lst);
                    expressEntity.setData(JsonUtils.toJson(lst, (boolean)false));
                    expressEntity.setExpressNo(wayBillNo);
                    expressEntity.setLastTime(lastTime);
                    expressEntity.setComplateTime(lastTime);
                    expressEntity.setIsSubscribe(1);
                    expressEntity.setStatus(this.getStatus((String)dataMap.get("logisticsStatus")));
                    this.logger.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f9\uff0cwayBillNo={},expressEntity={}", (Object)wayBillNo, (Object)JsonUtils.toJson((Object)expressEntity, (boolean)false));
                    try {
                        String key4 = "GET_ROUTE_INFO_REAL:" + wayBillNo;
                        this.redisService.save(key4, JsonUtils.toJson((Object)expressEntity, (boolean)false));
                        this.redisService.setExpire(key4, 3600L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        this.logger.error("{}\u4fdd\u5b58\u4eac\u4e1c\u7269\u6d41\u7f13\u5b58\u5f02\u5e38", (Object)wayBillNo, (Object)e);
                    }
                    return expressEntity;
                }
                this.logger.error("\u901a\u8fc7\u805a\u7f8e\u667a\u6570\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\u5931\u8d25\uff0c\u53c2\u6570[deliverCode={},wayBillNo={},phone={}],\u8fd4\u56decode={},taskNo={},msg={}", new Object[]{deliverCode, wayBillNo, phone, rtnMap.get("code"), rtnMap.get("taskNo"), rtnMap.get("msg")});
            }
            catch (Exception e) {
                this.logger.error("\u805a\u7f8e\u667a\u6570\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\u5931\u8d25\uff0cwayBillNo={},\u5f02\u5e38:", (Object)wayBillNo, (Object)e);
            }
        }
        this.logger.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f10\uff0cwayBillNo={}", (Object)wayBillNo);
        try {
            String key = "GET_ROUTE_INFO_REAL:" + wayBillNo;
            MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
            expressEntity.setDeliverNo(deliverCode);
            expressEntity.setCreateTime(new Date());
            expressEntity.setExpressNo(wayBillNo);
            expressEntity.setLastTime(new Date());
            expressEntity.setStatus(0);
            this.redisService.save(key, JsonUtils.toJson((Object)expressEntity, (boolean)false));
            this.redisService.setExpire(key, 3600L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.logger.error("{}\u4fdd\u5b58\u4eac\u4e1c\u7269\u6d41\u7f13\u5b58\u5f02\u5e38", (Object)wayBillNo, (Object)e);
        }
        return null;
    }

    @Override
    public MallOrderExpressEntity pullRouteInfo(String deliverCode, String wayBillNo, String phone) {
        return null;
    }

    @Override
    public MallOrderExpressEntity expressCallBack(String thirdExpressNo, String param) {
        return null;
    }

    @Override
    public DeliverCode getCode() {
        return DeliverCode.jum;
    }

    private Integer getStatus(String opeTitle) {
        if ("SIGN".equals(opeTitle) || "AGENT_SIGN".equals(opeTitle)) {
            return 3;
        }
        if ("ACCEPT".equals(opeTitle)) {
            return 1;
        }
        if ("TRANSPORT".equals(opeTitle)) {
            return 0;
        }
        if ("DELIVERING".equals(opeTitle)) {
            return 5;
        }
        return 0;
    }
}

