/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.apiinvoke.ec.AddressInvoke;
import cc.lechun.ec.entity.DistrictEntity;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.deliver.MallAreaMapper;
import cc.lechun.mall.entity.deliver.MallAreaEntity;
import cc.lechun.mall.iservice.deliver.MallAreaInterface;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallAreaService
extends BaseService
implements MallAreaInterface {
    @Autowired
    private MallAreaMapper areaMapper;
    @Autowired
    private AddressInvoke addressInvoke;
    private static final String AREA_LIST_CACHE_KEY = "area_list_cache";
    private static final long CACHE_EXPIRATION_TIME = 43200L;

    private List<MallAreaEntity> getAreaErp(String cityId, String areaId, String areaName) {
        HashMap<String, Object> mapParam = new HashMap<String, Object>();
        mapParam.put("cityId", cityId);
        mapParam.put("areaId", areaId);
        mapParam.put("areaName", areaName);
        this.logger.info("\u8c03\u7528ERP3.0\u83b7\u53d6areaList, \u53c2\u6570: {}", (Object)JSON.toJSONString(mapParam));
        try {
            BaseJsonVo<List<DistrictEntity>> baseJsonVo = this.addressInvoke.getAreaList(mapParam);
            this.logger.info("ERP3.0 \u8fd4\u56de\u7684\u53c2\u6570: {}", (Object)JSON.toJSONString(baseJsonVo));
            if (!baseJsonVo.isSuccess()) {
                return this.getAreaListFromCache();
            }
            String result = JsonUtils.toJson((Object)baseJsonVo.getResult(), (boolean)false);
            if (StringUtils.isEmpty((String)result)) {
                return null;
            }
            List<MallAreaEntity> mallAreaEntityList = this.parseAreaList(result);
            if (!mallAreaEntityList.isEmpty()) {
                this.cacheAreaList(mallAreaEntityList);
            }
            return mallAreaEntityList;
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528ERP3.0\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f: {}", (Object)e.getMessage(), (Object)e);
            return this.getAreaListFromCache();
        }
    }

    private List<MallAreaEntity> getAreaListFromCache() {
        String cachedData;
        Object data = this.redisCacheUtil.get(AREA_LIST_CACHE_KEY);
        if (data != null && StringUtils.isNotEmpty((String)(cachedData = data.toString()))) {
            return JSON.parseArray((String)cachedData, MallAreaEntity.class);
        }
        return null;
    }

    private void cacheAreaList(List<MallAreaEntity> areaList) {
        if (!this.redisCacheUtil.exists(AREA_LIST_CACHE_KEY)) {
            this.redisCacheUtil.set(AREA_LIST_CACHE_KEY, (Object)JSON.toJSONString(areaList), Long.valueOf(43200L));
            this.logger.info("\u533a\u57df\u5217\u8868\u7f13\u5b58\u5df2\u66f4\u65b0");
        }
    }

    private List<MallAreaEntity> parseAreaList(String jsonData) {
        JSONArray jsonArrayArea = JSON.parseArray((String)jsonData);
        return jsonArrayArea.stream().map(obj -> {
            JSONObject jsonObject = (JSONObject)obj;
            MallAreaEntity mallAreaEntity = new MallAreaEntity();
            mallAreaEntity.setAreaId(jsonObject.getInteger("code"));
            mallAreaEntity.setAreaName(jsonObject.getString("name"));
            mallAreaEntity.setCityId(jsonObject.getInteger("parentcode"));
            mallAreaEntity.setStatus(jsonObject.getInteger("coldstatus"));
            mallAreaEntity.setOrdinaryStatus(jsonObject.getInteger("nomalstatus"));
            return mallAreaEntity;
        }).collect(Collectors.toList());
    }

    @Override
    @ReadThroughSingleCache(namespace="getAreaIsOpen", expiration=300)
    public BaseJsonVo getAreaIsOpen(@ParameterValueKeyProvider Integer areaId) {
        if (areaId == null) {
            return BaseJsonVo.paramError((String)"\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u5730\u5740");
        }
        List<MallAreaEntity> mallAreaEntityArrayList = this.getAreaErp(null, String.valueOf(areaId), null);
        if (mallAreaEntityArrayList != null && mallAreaEntityArrayList.size() > 0) {
            int areaIsOpen = 1;
            MallAreaEntity mallAreaEntity = mallAreaEntityArrayList.get(0);
            Integer status = mallAreaEntity.getStatus();
            Integer ordinaryStatus = mallAreaEntity.getOrdinaryStatus();
            areaIsOpen = 3;
            if (status == 1 && ordinaryStatus == 0) {
                areaIsOpen = 1;
            }
            if (status == 0 && ordinaryStatus == 1) {
                areaIsOpen = 2;
            }
            if (status == 1 && ordinaryStatus == 1) {
                areaIsOpen = 4;
            }
            return BaseJsonVo.success((Object)areaIsOpen);
        }
        return BaseJsonVo.paramError((String)"\u83b7\u53d6\u4fe1\u606f\u5931\u8d25");
    }

    @Override
    @ReadThroughSingleCache(namespace="getArea", expiration=300)
    public MallAreaEntity getArea(@ParameterValueKeyProvider Integer areaId) {
        if (areaId == null) {
            return null;
        }
        List<MallAreaEntity> mallAreaEntityArrayList = this.getAreaErp(null, String.valueOf(areaId), null);
        if (mallAreaEntityArrayList != null && mallAreaEntityArrayList.size() > 0) {
            return mallAreaEntityArrayList.get(0);
        }
        return null;
    }

    @Override
    public List<MallAreaEntity> getAreaList(Integer cityId) {
        List<MallAreaEntity> mallAreaEntityArrayList = this.getAreaErp(String.valueOf(cityId), null, null);
        if (mallAreaEntityArrayList != null && mallAreaEntityArrayList.size() > 0) {
            return mallAreaEntityArrayList;
        }
        return null;
    }

    @Override
    public MallAreaEntity getAreaByName(String areaName) {
        List<MallAreaEntity> mallAreaEntityArrayList = this.getAreaErp(null, null, areaName);
        if (mallAreaEntityArrayList != null && mallAreaEntityArrayList.size() > 0) {
            return mallAreaEntityArrayList.get(0);
        }
        return null;
    }
}

