/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.apiinvoke.ec.AddressInvoke;
import cc.lechun.ec.entity.DistrictEntity;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.deliver.MallCityEntity;
import cc.lechun.mall.iservice.deliver.MallCityInterface;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallCityService
extends BaseService
implements MallCityInterface {
    @Autowired
    private AddressInvoke addressInvoke;
    private static final String CITY_LIST_CACHE_KEY = "city_list_cache";
    private static final long CACHE_EXPIRATION_TIME = 86400L;

    private List<MallCityEntity> getCityErp(String cityId, String cityName) {
        HashMap<String, Object> mapParam = new HashMap<String, Object>();
        mapParam.put("cityId", cityId);
        mapParam.put("cityName", cityName);
        this.logger.info("\u8c03\u7528ERP3.0\u83b7\u53d6cityList, \u53c2\u6570: {}", (Object)JSON.toJSONString(mapParam));
        try {
            BaseJsonVo<List<DistrictEntity>> baseJsonVo;
            try {
                baseJsonVo = this.addressInvoke.getCityList(mapParam);
                if (baseJsonVo == null || !baseJsonVo.isSuccess()) {
                    return this.getCityListFromCache();
                }
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528ERP3.0\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f: {}", (Object)e.getMessage(), (Object)e);
                return this.getCityListFromCache();
            }
            String result = JsonUtils.toJson((Object)baseJsonVo.getResult(), (boolean)false);
            this.logger.info("\u8c03\u7528ERP3.0\u8fd4\u56de\u7684\u53c2\u6570: {}", (Object)result);
            if (StringUtils.isEmpty((String)result)) {
                return null;
            }
            List<MallCityEntity> mallCityEntityList = this.parseCityList(result);
            if (!mallCityEntityList.isEmpty()) {
                this.cacheCityList(mallCityEntityList);
            }
            return mallCityEntityList;
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528ERP3.0\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f: {}", (Object)e.getMessage(), (Object)e);
            return this.getCityListFromCache();
        }
    }

    private List<MallCityEntity> getCityListFromCache() {
        String cachedData;
        Object data = this.redisCacheUtil.get(CITY_LIST_CACHE_KEY);
        if (data != null && StringUtils.isNotEmpty((String)(cachedData = data.toString()))) {
            return JSON.parseArray((String)cachedData, MallCityEntity.class);
        }
        return null;
    }

    private void cacheCityList(List<MallCityEntity> cityList) {
        if (!this.redisCacheUtil.exists(CITY_LIST_CACHE_KEY)) {
            this.redisCacheUtil.set(CITY_LIST_CACHE_KEY, (Object)JSON.toJSONString(cityList), Long.valueOf(86400L));
            this.logger.info("\u57ce\u5e02\u5217\u8868\u7f13\u5b58\u5df2\u66f4\u65b0");
        }
    }

    private List<MallCityEntity> parseCityList(String jsonData) {
        JSONArray jsonArrayCity = JSON.parseArray((String)jsonData);
        return jsonArrayCity.stream().map(obj -> {
            JSONObject jsonObject = (JSONObject)obj;
            MallCityEntity mallCityEntity = new MallCityEntity();
            mallCityEntity.setCityId(jsonObject.getInteger("code"));
            mallCityEntity.setCityName(jsonObject.getString("name"));
            mallCityEntity.setProvinceId(jsonObject.getInteger("parentcode"));
            mallCityEntity.setStatus(jsonObject.getInteger("coldstatus"));
            mallCityEntity.setOpenCityStatus(jsonObject.getInteger("freshstatus"));
            mallCityEntity.setOrdinaryStatus(jsonObject.getInteger("nomalstatus"));
            return mallCityEntity;
        }).collect(Collectors.toList());
    }

    @Override
    @ReadThroughSingleCache(namespace="getCity", expiration=300)
    public MallCityEntity getCity(@ParameterValueKeyProvider Integer cityId) {
        if (cityId == null) {
            return null;
        }
        List<MallCityEntity> mallCityEntityList = this.getCityErp(String.valueOf(cityId), null);
        if (mallCityEntityList != null && mallCityEntityList.size() > 0) {
            this.logger.info("{}", (Object)mallCityEntityList.get(0).toString());
            return mallCityEntityList.get(0);
        }
        return null;
    }

    @Override
    @ReadThroughSingleCache(namespace="getCity", expiration=300)
    public MallCityEntity getCityByName(String cityName) {
        if (StringUtils.isNotEmpty((String)cityName)) {
            List<MallCityEntity> mallCityEntityList = this.getCityErp(null, cityName);
            if (mallCityEntityList != null && mallCityEntityList.size() > 0) {
                return mallCityEntityList.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public List<MallCityEntity> getCityList() {
        List<MallCityEntity> mallCityEntityList = this.getCityErp(null, null);
        return mallCityEntityList;
    }
}

