/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.deliver.MallOrderDeliverRecordMapper;
import cc.lechun.mall.entity.deliver.OrderDeliverRecordVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.iservice.deliver.DeliverRouteInterface;
import cc.lechun.mall.iservice.deliver.MallOrderDeliverRecordInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallOrderDeliverRecordService
extends BaseService
implements MallOrderDeliverRecordInterface {
    @Autowired
    private MallOrderDeliverRecordMapper orderDeliverRecordMapper;
    @Autowired
    private DeliverRouteInterface deliverRouteInterface;
    @Autowired
    private MallOrderInterface orderInterface;

    @Override
    @ReadThroughSingleCache(namespace="MallOrderDeliverRecordService.getDeliverRecordList", expiration=60)
    public List<OrderDeliverRecordVo> getDeliverRecordList(@ParameterValueKeyProvider String orderNo) {
        try {
            MallOrderEntity orderEntity = this.orderInterface.getmallOrder(orderNo);
            if (orderEntity == null) {
                new ArrayList();
            }
            if (orderEntity.getPickupTime() != null && orderEntity.getPickupTime().before(DateUtils.getDateFromString((String)"2019-03-11 00:00:00"))) {
                List<OrderDeliverRecordVo> orderDeliverRecordVos = this.orderDeliverRecordMapper.getDeliverRecordList(orderNo);
                if (orderDeliverRecordVos != null) {
                    orderDeliverRecordVos.sort(Comparator.comparing(OrderDeliverRecordVo::getPushTime).reversed().thenComparing(OrderDeliverRecordVo::getOrderdeliverRecordId).reversed());
                }
                return orderDeliverRecordVos;
            }
            this.logger.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f1\uff0corderNo={}", (Object)orderNo);
            List<OrderDeliverRecordVo> routeInfoForWexin = this.deliverRouteInterface.getRouteInfoForWexin(orderNo, true);
            this.logger.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f18\uff0corderNo={},routeInfoForWexin={}", (Object)orderNo, (Object)JsonUtils.toJson(routeInfoForWexin, (boolean)false));
            return routeInfoForWexin;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("AUV,\u6765\u83b7\u53d6\u7269\u6d41\u4fe1\u606f19\uff0corderNo={}", (Object)orderNo);
            return new ArrayList<OrderDeliverRecordVo>();
        }
    }
}

