/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.common.enums.trade.DeliverCode;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallOrderExpressEntity;
import cc.lechun.mall.iservice.deliver.DeliverKuaidiInterface;
import cc.lechun.mall.iservice.trade.MallOrderExpressInterface;
import cc.lechun.utils.tracking.TrackingUtils;
import cc.lechun.utils.tracking.entity.TrackingInfo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrackingService
implements DeliverKuaidiInterface {
    @Autowired
    private TrackingUtils trackingUtils;
    @Autowired
    private MallOrderExpressInterface expressInterface;

    @Override
    public DeliverCode getCode() {
        return DeliverCode.tracking;
    }

    @Override
    public MallOrderExpressEntity getRouteInfo(String deliverCode, String wayBillNo, String phone) {
        try {
            List<TrackingInfo> routes = this.trackingUtils.trace(wayBillNo);
            ArrayList lst = new ArrayList();
            int i = 0;
            Date lastTime = null;
            for (TrackingInfo r : routes) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("time", DateUtils.formatDate((Date)r.getCheckpoint_date(), (String)""));
                map.put("ftime", DateUtils.formatDate((Date)r.getCheckpoint_date(), (String)""));
                map.put("context", r.getTracking_detail());
                lst.add(map);
                if (lastTime == null || r.getCheckpoint_date().after(lastTime)) {
                    lastTime = r.getCheckpoint_date();
                }
                ++i;
            }
            if (lst.size() > 0) {
                MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
                expressEntity.setDeliverNo(this.trackingUtils.getName(wayBillNo));
                expressEntity.setCreateTime(new Date());
                expressEntity.setData(JsonUtils.toJson(lst, (boolean)false));
                expressEntity.setExpressNo(wayBillNo);
                expressEntity.setLastTime(lastTime);
                expressEntity.setIsSubscribe(1);
                expressEntity.setStatus(this.getStatus(routes.get(0).getCheckpoint_delivery_status()));
                return expressEntity;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public BaseJsonVo importOrder(String wayBillNo) {
        return this.trackingUtils.importTrackingNumber(wayBillNo);
    }

    private Integer getStatus(String opCode) {
        if ("pending".equals(opCode)) {
            return 2;
        }
        if ("notfound".equals(opCode)) {
            return 2;
        }
        if ("transit".equals(opCode)) {
            return 1;
        }
        if ("delivered".equals(opCode)) {
            return 3;
        }
        if ("exception".equals(opCode)) {
            return 2;
        }
        return 0;
    }

    @Override
    public MallOrderExpressEntity pullRouteInfo(String deliverCode, String wayBillNo, String phone) {
        return null;
    }

    @Override
    public MallOrderExpressEntity expressCallBack(String thirdExpressNo, String param) {
        try {
            JSONObject jsonObject = JSON.parseObject((String)param);
            if (jsonObject != null && jsonObject.getIntValue("code") == 200) {
                JSONObject data = jsonObject.getJSONObject("data");
                List routes = JsonUtils.getListByArray(TrackingInfo.class, (String)data.get((Object)"trackinfo").toString());
                ArrayList lst = new ArrayList();
                int i = 0;
                Date lastTime = null;
                for (TrackingInfo r : routes) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("time", DateUtils.formatDate((Date)r.getCheckpoint_date(), (String)""));
                    map.put("ftime", DateUtils.formatDate((Date)r.getCheckpoint_date(), (String)""));
                    map.put("context", r.getTracking_detail());
                    lst.add(map);
                    if (lastTime == null || r.getCheckpoint_date().after(lastTime)) {
                        lastTime = r.getCheckpoint_date();
                    }
                    ++i;
                }
                if (lst.size() > 0) {
                    MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
                    expressEntity.setDeliverNo(this.trackingUtils.getName(data.getString("tracking_number")));
                    expressEntity.setCreateTime(new Date());
                    expressEntity.setData(JsonUtils.toJson(lst, (boolean)false));
                    expressEntity.setExpressNo(data.getString("tracking_number"));
                    expressEntity.setLastTime(lastTime);
                    expressEntity.setComplateTime(lastTime);
                    expressEntity.setIsSubscribe(1);
                    expressEntity.setStatus(this.getStatus(((TrackingInfo)routes.get(0)).getCheckpoint_delivery_status()));
                    return expressEntity;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

