/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.common.enums.trade.DeliverCode;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.mall.entity.trade.MallOrderExpressEntity;
import cc.lechun.mall.iservice.deliver.DeliverKuaidiInterface;
import cc.lechun.mall.iservice.trade.MallOrderExpressInterface;
import cc.lechun.utils.yto.YtoUtils;
import cc.lechun.utils.yto.entity.WaybillRoute;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YtoService
implements DeliverKuaidiInterface {
    @Autowired
    private YtoUtils ytoUtils;
    @Autowired
    private MallOrderExpressInterface expressInterface;

    @Override
    public DeliverCode getCode() {
        return DeliverCode.yuantong;
    }

    @Override
    public MallOrderExpressEntity getRouteInfo(String deliverCode, String wayBillNo, String phone) {
        try {
            List<WaybillRoute> routes = this.ytoUtils.trace(wayBillNo);
            ArrayList lst = new ArrayList();
            int i = 0;
            Date lastTime = null;
            for (WaybillRoute r : routes) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("time", r.getUpload_Time());
                map.put("ftime", r.getUpload_Time());
                map.put("context", r.getProcessInfo());
                lst.add(map);
                if (lastTime == null || DateUtils.StrToDate((String)r.getUpload_Time(), (String)"yyyy-MM-dd HH:mm:ss").after(lastTime)) {
                    lastTime = DateUtils.StrToDate((String)r.getUpload_Time(), (String)"yyyy-MM-dd HH:mm:ss");
                }
                ++i;
            }
            if (lst.size() > 0) {
                MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
                expressEntity.setDeliverNo(deliverCode);
                expressEntity.setCreateTime(new Date());
                expressEntity.setData(JsonUtils.toJson(lst, (boolean)false));
                expressEntity.setExpressNo(wayBillNo);
                expressEntity.setLastTime(lastTime);
                expressEntity.setComplateTime(lastTime);
                expressEntity.setIsSubscribe(1);
                expressEntity.setStatus(this.getStatus(routes.get(0).getInfoContent()));
                return expressEntity;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Integer getStatus(String InfoContent) {
        if ("SIGNED".equals(InfoContent)) {
            return 3;
        }
        if ("FORWARDING".equals(InfoContent)) {
            return 7;
        }
        if ("TMS_RETURN".equals(InfoContent)) {
            return 6;
        }
        if ("SENT_SCAN".equals(InfoContent)) {
            return 5;
        }
        if ("INBOUND".equals(InfoContent)) {
            return 5;
        }
        return 0;
    }

    @Override
    public MallOrderExpressEntity pullRouteInfo(String deliverCode, String wayBillNo, String phone) {
        return null;
    }

    @Override
    public MallOrderExpressEntity expressCallBack(String deliverNo, String param) {
        return null;
    }
}

