/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.common.enums.trade.DeliverCode;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallOrderExpressEntity;
import cc.lechun.mall.iservice.deliver.DeliverKuaidiInterface;
import cc.lechun.utils.zto.ZtoUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZtoService
implements DeliverKuaidiInterface {
    private Logger logger = LoggerFactory.getLogger(ZtoService.class);
    @Autowired
    ZtoUtils ztoUtils;

    @Override
    public DeliverCode getCode() {
        return DeliverCode.zto;
    }

    @Override
    public MallOrderExpressEntity getRouteInfo(String deliverCode, String wayBillNo, String phone) {
        BaseJsonVo trace = null;
        try {
            trace = this.ztoUtils.trace(wayBillNo);
        }
        catch (IOException e) {
            this.logger.info("\u4e2d\u901a\u83b7\u53d6\u7269\u6d41\u62a5\u9519", (Throwable)e);
            return null;
        }
        this.logger.info("\u4e2d\u901a\u83b7\u53d6\u7269\u6d41\u7ed3\u679c:{}", (Object)JsonUtils.toJson((Object)trace, (boolean)false));
        if (!trace.isSuccess()) {
            this.logger.info("\u4e2d\u901a\u83b7\u53d6\u7269\u6d41\u5931\u8d25:{}", (Object)JsonUtils.toJson((Object)trace, (boolean)false));
            return null;
        }
        Map lastTrace = (Map)trace.getValue();
        ArrayList lst = new ArrayList();
        Date lastTime = new Date(Long.valueOf((String)lastTrace.get("scanDate")));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("time", DateUtils.formatDate((Date)new Date(Long.valueOf((String)lastTrace.get("scanDate"))), (String)""));
        map.put("ftime", (String)map.get("time"));
        map.put("context", (String)lastTrace.get("desc"));
        lst.add(map);
        if (lst.size() > 0) {
            MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
            expressEntity.setDeliverNo(deliverCode);
            expressEntity.setCreateTime(new Date());
            expressEntity.setData(JsonUtils.toJson(lst, (boolean)false));
            expressEntity.setExpressNo(wayBillNo);
            expressEntity.setLastTime(lastTime);
            expressEntity.setComplateTime(lastTime);
            expressEntity.setIsSubscribe(1);
            expressEntity.setStatus(this.getStatus((String)map.get("scanType")));
            return expressEntity;
        }
        return null;
    }

    private Integer getStatus(String opeTitle) {
        if ("\u7b7e\u6536".equals(opeTitle)) {
            return 3;
        }
        if ("\u6536\u4ef6".equals(opeTitle)) {
            return 1;
        }
        return 0;
    }

    @Override
    public MallOrderExpressEntity pullRouteInfo(String deliverCode, String wayBillNo, String phone) {
        return null;
    }

    @Override
    public MallOrderExpressEntity expressCallBack(String thirdExpressNo, String param) {
        Map lastTrace = null;
        try {
            lastTrace = (Map)JsonUtils.fromJson((String)param, Map.class);
            ArrayList lst = new ArrayList();
            Date lastTime = new Date(Long.valueOf((String)lastTrace.get("scanDate")));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("time", DateUtils.formatDate((Date)new Date(Long.valueOf((String)lastTrace.get("scanDate"))), (String)""));
            map.put("ftime", (String)map.get("time"));
            map.put("context", (String)lastTrace.get("desc"));
            lst.add(map);
            if (lst.size() > 0) {
                MallOrderExpressEntity expressEntity = new MallOrderExpressEntity();
                expressEntity.setDeliverNo(DeliverCode.zto.getValue());
                expressEntity.setCreateTime(new Date());
                expressEntity.setData(JsonUtils.toJson(lst, (boolean)false));
                expressEntity.setExpressNo((String)lastTrace.get("billCode"));
                expressEntity.setLastTime(lastTime);
                expressEntity.setComplateTime(lastTime);
                expressEntity.setIsSubscribe(1);
                expressEntity.setStatus(this.getStatus((String)map.get("scanType")));
                return expressEntity;
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String a = "{\"facilityCode\":\"02299\",\"nextNodeCode\":\"82622\",\"nextCity\":\"\u9ed4\u5357\u5e03\u4f9d\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde\",\"actionTime\":\"2022-09-30 15:44:51\",\"city\":\"\u5929\u6d25\u5e02\",\"nextNodeName\":\"\u9f99\u91cc\u8c37\u811a\u9547\",\"action\":\"DEPARTURE\",\"billCode\":\"73100052531313\",\"facilityName\":\"\u5929\u6d25\u4e2d\u8f6c\u90e8\",\"desc\":\"\u3010\u5929\u6d25\u5e02\u3011\u5feb\u4ef6\u79bb\u5f00\u3010\u5929\u6d25\u4e2d\u8f6c\u90e8\u3011\u53d1\u5f80\u9f99\u91cc\u8c37\u811a\u9547\"}";
        try {
            Map map = (Map)JsonUtils.fromJson((String)a, Map.class);
            System.out.println(map);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

