/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributionInviteMapper;
import cc.lechun.mall.entity.distribution.DistributionInviteEntity;
import cc.lechun.mall.entity.distribution.DistributorEntity;
import cc.lechun.mall.entity.distribution.DistributorGroupEntity;
import cc.lechun.mall.entity.distribution.DistributorRelationEntity;
import cc.lechun.mall.entity.distribution.QiyeweixinExternalContactEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.distribution.DistributionInviteInterface;
import cc.lechun.mall.iservice.distribution.DistributionInviteLogInterface;
import cc.lechun.mall.iservice.distribution.DistributorGroupInterface;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.iservice.distribution.DistributorRelationInterface;
import cc.lechun.mall.iservice.distribution.QiyeweixinExternalContactInterface;
import com.github.pagehelper.util.StringUtil;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DistributionInviteService
extends BaseService<DistributionInviteEntity, String>
implements DistributionInviteInterface {
    @Resource
    private DistributionInviteMapper distributionInviteMapper;
    @Autowired
    DistributorInterface distributorInterface;
    @Autowired
    DistributorRelationInterface distributorRelationInterface;
    @Autowired
    DistributionInviteInterface inviteInterface;
    @Autowired
    DistributionInviteLogInterface inviteLogInterface;
    @Autowired
    DictionaryInterface dictionaryInterface;
    @Autowired
    DistributorGroupInterface distributorGroupInterface;
    @Autowired
    QiyeweixinExternalContactInterface qiyeweixinExternalContactInterface;

    @Override
    @Transactional
    public Boolean invite(String distributorRelationCode, String customerId, String refererOrTicketNo, int inviteType) {
        DistributorRelationEntity relationEntity1;
        DistributorGroupEntity groupEntity;
        DistributorEntity distributorEntity;
        if (StringUtil.isEmpty((String)customerId)) {
            this.logger.info("\u7528\u6237Id\u4e3a\u7a7a");
            return false;
        }
        if (StringUtil.isNotEmpty((String)refererOrTicketNo) && refererOrTicketNo.length() > 255) {
            refererOrTicketNo = refererOrTicketNo.substring(0, 254);
        }
        String key = distributorRelationCode + "_" + customerId + "_1_" + inviteType;
        if (inviteType == 2) {
            key = distributorRelationCode + "_" + customerId + "_1_" + inviteType + "_" + refererOrTicketNo;
        }
        this.logger.info("invite,key:" + key);
        if (this.redisCacheUtil.get(key) != null) {
            this.logger.info("invite,key\u4e3a\u7a7a");
            return false;
        }
        Boolean inviteResult = true;
        Integer renewable = 0;
        DistributorRelationEntity param = new DistributorRelationEntity();
        param.setDistributorRelationCode(distributorRelationCode);
        BaseJsonVo<DistributorRelationEntity> relationEntity = this.distributorRelationInterface.checkDistributorByRelationCode(distributorRelationCode);
        if (!relationEntity.isSuccess()) {
            this.logger.info("\u5206\u9500\u5458\uff1a" + relationEntity.getMessage());
            return false;
        }
        if (inviteType == 1 && refererOrTicketNo != null && refererOrTicketNo.contains("getCoupon") && (distributorEntity = (DistributorEntity)this.distributorInterface.selectByPrimaryKey(((DistributorRelationEntity)relationEntity.getValue()).getDistributorId())) != null && (groupEntity = (DistributorGroupEntity)this.distributorGroupInterface.selectByPrimaryKey(distributorEntity.getGroupId())) != null && Integer.valueOf(0).equals(groupEntity.getMarkStatus())) {
            this.logger.info("\u5206\u9500\uff1a\u4e0d\u540c\u65f6\u6807\u6ce8\u4f18\u60e0\u5238\u548c\u8fde\u63a5");
            return false;
        }
        if (((DistributorRelationEntity)relationEntity.getValue()).getSelfable() == 0 && customerId.equals(((DistributorRelationEntity)relationEntity.getValue()).getRelationUserId())) {
            int logId = this.inviteLogInterface.insertAndReturnAutoIncrementID(false, (DistributorRelationEntity)relationEntity.getValue(), customerId, inviteType, refererOrTicketNo, null, null, renewable);
            this.logger.info("\u5206\u9500\uff1a\u4e0d\u5141\u8bb8\u9080\u8bf7\u81ea\u5df1");
            return false;
        }
        if (((DistributorRelationEntity)relationEntity.getValue()).getDistributorable() == 0 && (relationEntity1 = this.distributorRelationInterface.getDistributorRelationByRelationUserId(customerId, 1)) != null) {
            int logId = this.inviteLogInterface.insertAndReturnAutoIncrementID(false, (DistributorRelationEntity)relationEntity.getValue(), customerId, inviteType, refererOrTicketNo, null, null, renewable);
            this.logger.info("\u5206\u9500\uff1a\u4e0d\u5141\u8bb8\u9080\u8bf7\u5206\u9500\u5458");
            return false;
        }
        DistributionInviteEntity inviteParam = new DistributionInviteEntity();
        inviteParam.setInvitedCustomerId(customerId);
        inviteParam.setInviteType(inviteType);
        DistributionInviteEntity hasInvite = this.distributionInviteMapper.findByInvitedCustomerId(customerId, inviteType, DateUtils.now());
        if (hasInvite != null && inviteType == 1) {
            if (((DistributorRelationEntity)relationEntity.getValue()).getRelationUserId().equals(hasInvite.getDistributorRelationUserId())) {
                if (((DistributorRelationEntity)relationEntity.getValue()).getRenewable() == 1) {
                    this.inviteLogInterface.updateLogStatusDisabled(hasInvite.getInviteLogId());
                    renewable = 1;
                    inviteResult = false;
                } else {
                    inviteResult = false;
                }
            } else {
                BaseJsonVo<DistributorRelationEntity> inviter = this.distributorRelationInterface.checkDistributorByRelationUserId(hasInvite.getDistributorRelationUserId());
                if (inviter.isSuccess()) {
                    if (((DistributorRelationEntity)inviter.getValue()).getRobbedable() == 0) {
                        inviteResult = false;
                    } else {
                        hasInvite.setInvalidTime(DateUtils.now());
                        hasInvite.setUpdateTime(DateUtils.now());
                        this.updateByPrimaryKey(hasInvite);
                        this.inviteLogInterface.updateLogStatusDisabled(hasInvite.getInviteLogId());
                    }
                } else {
                    hasInvite.setInvalidTime(DateUtils.now());
                    hasInvite.setUpdateTime(DateUtils.now());
                    this.updateByPrimaryKey(hasInvite);
                    this.inviteLogInterface.updateLogStatusDisabled(hasInvite.getInviteLogId());
                }
            }
        }
        String inviteId = IDGenerate.getUniqueIdStr();
        int logId = this.inviteLogInterface.insertAndReturnAutoIncrementID(inviteResult, (DistributorRelationEntity)relationEntity.getValue(), customerId, inviteType, refererOrTicketNo, inviteId, hasInvite != null ? hasInvite.getInviteLogId() : null, renewable);
        if (logId > 0 && renewable == 1 && hasInvite != null) {
            hasInvite.setInviteTime(DateUtils.now());
            hasInvite.setUpdateTime(DateUtils.now());
            hasInvite.setInvalidTime(DateUtils.getAddDateByDay((Date)DateUtils.getAddDateBySecond((Date)DateUtils.currentDate(), (int)86399), (int)((DistributorRelationEntity)relationEntity.getValue()).getEffectiveDays()));
            hasInvite.setInviteSource(refererOrTicketNo);
            hasInvite.setInviteLogId(logId);
            this.updateByPrimaryKey(hasInvite);
        }
        if (inviteResult.booleanValue()) {
            DistributionInviteEntity invite = new DistributionInviteEntity();
            invite.setId(inviteId);
            invite.setDistributorId(((DistributorRelationEntity)relationEntity.getValue()).getDistributorId());
            invite.setDistributorRelationId(((DistributorRelationEntity)relationEntity.getValue()).getId());
            invite.setDistributorRelationUserId(((DistributorRelationEntity)relationEntity.getValue()).getRelationUserId());
            invite.setInvitedCustomerId(customerId);
            invite.setInviteLogId(logId);
            invite.setInviteType(inviteType);
            invite.setInviteTime(new Date());
            invite.setInviteSource(refererOrTicketNo);
            Integer effective_days = ((DistributorRelationEntity)relationEntity.getValue()).getEffectiveDays() > 0 ? ((DistributorRelationEntity)relationEntity.getValue()).getEffectiveDays() : Integer.valueOf(this.dictionaryInterface.getDictionary(1000, 206, "EFFECTIVE_DAYS").getDictionaryName());
            invite.setInvalidTime(DateUtils.getAddDateByDay((Date)DateUtils.getAddDateBySecond((Date)DateUtils.currentDate(), (int)86399), (int)effective_days));
            invite.setUpdateTime(DateUtils.now());
            this.insertSelective(invite);
        }
        long day = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1));
        this.logger.info("\u5206\u9500\uff1a\u5b8c\u6210\uff0c\u5b58\u7f13\u5b58");
        this.redisCacheUtil.set(key, (Object)key, Long.valueOf(day));
        return inviteResult;
    }

    @Override
    public DistributionInviteEntity findInviteMe(MallOrderMainEntity orderMainEntity) {
        String relationUserId;
        DistributorRelationEntity relationEntity;
        BaseJsonVo<DistributorRelationEntity> jsonVo;
        if (StringUtil.isNotEmpty((String)orderMainEntity.getNcpBat()) && (jsonVo = this.distributorRelationInterface.checkDistributorByRelationCode(orderMainEntity.getNcpBat())).isSuccess() && this.distributorInterface.checkInviteType(((DistributorRelationEntity)jsonVo.getValue()).getDistributorId(), 1).isSuccess()) {
            DistributionInviteEntity inviteMe = new DistributionInviteEntity();
            inviteMe.setDistributorId(((DistributorRelationEntity)jsonVo.getValue()).getDistributorId());
            inviteMe.setDistributorRelationId(((DistributorRelationEntity)jsonVo.getValue()).getId());
            inviteMe.setDistributorRelationUserId(((DistributorRelationEntity)jsonVo.getValue()).getRelationUserId());
            inviteMe.setId("");
            inviteMe.setInvitedCustomerId(orderMainEntity.getCustomerId());
            inviteMe.setInvalidTime(DateUtils.getAddDateByDay((Date)new Date(), (int)1));
            inviteMe.setInviteLogId(0);
            inviteMe.setInviteSource("\u76f4\u63a5\u94fe\u63a5");
            inviteMe.setInviteType(1);
            inviteMe.setPlatformId(4);
            inviteMe.setInviteTime(orderMainEntity.getCreateTime());
            return inviteMe;
        }
        QiyeweixinExternalContactEntity entity = new QiyeweixinExternalContactEntity();
        entity.setCustomerId(orderMainEntity.getCustomerId());
        entity = (QiyeweixinExternalContactEntity)this.qiyeweixinExternalContactInterface.getSingle(entity);
        if (entity != null && (relationEntity = this.distributorRelationInterface.getDistributorRelationByRelationUserId(relationUserId = entity.getQyWeixinUserid(), 1)) != null && this.distributorInterface.checkInviteType(relationEntity.getDistributorId(), 2).isSuccess()) {
            DistributionInviteEntity e = new DistributionInviteEntity();
            e.setDistributorId(relationEntity.getDistributorId());
            e.setDistributorRelationId(relationEntity.getId());
            e.setDistributorRelationUserId(relationUserId);
            e.setId("");
            e.setInvitedCustomerId(orderMainEntity.getCustomerId());
            e.setInvalidTime(DateUtils.getAddDateByDay((Date)new Date(), (int)10000));
            e.setInviteTime(entity.getCreateTime());
            e.setInviteLogId(0);
            e.setInviteSource("\u5f52\u5c5e");
            e.setInviteType(1);
            e.setPlatformId(4);
            return e;
        }
        DistributionInviteEntity e = this.distributionInviteMapper.findByInvitedCustomerId(orderMainEntity.getCustomerId(), 1, DateUtils.now());
        if (e != null && this.distributorInterface.checkInviteType(e.getDistributorId(), 8).isSuccess()) {
            return e;
        }
        return null;
    }
}

