/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.active.entity.active.ActiveCustomerEntity;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveInviteLogEntity;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.entity.invite.ActiveInviteDetailEntity;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveCommonInterface;
import cc.lechun.active.iservice.active.ActiveCustomerInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActiveInviteLogInterface;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.cashticket.CashStatusEnum;
import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.CustomerNickVo;
import cc.lechun.mall.entity.distribution.ActiveGiftAdressVo;
import cc.lechun.mall.entity.distribution.ActiveGiftInviteInfoVo;
import cc.lechun.mall.entity.distribution.ActiveGiftPropertyInfoVo;
import cc.lechun.mall.entity.distribution.ActiveGiftRechangeResultVo;
import cc.lechun.mall.entity.distribution.ActiveGiftRechangeVo;
import cc.lechun.mall.entity.distribution.ActiveGiftTakedAuthVo;
import cc.lechun.mall.entity.distribution.GiftRechangeStatusEnum;
import cc.lechun.mall.entity.distribution.PromtionerMobileVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.distribution.DistributorGrowthActiveInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import com.alibaba.fastjson.JSONObject;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DistributorGrowthActiveService
implements DistributorGrowthActiveInterface {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallProductPicInterface picService;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private ActivePropertyInterface activePropertyInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    DistributorGrowthActiveInterface distributorGrowthActiveInterface;
    @Autowired
    private ActiveInviteInterface activeInviteInterface;
    @Autowired
    ActiveCommonInterface activeCommonInterface;
    @Autowired
    private RedisService redisService;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private TemplateMessageInterface templateMessageInterface;
    @Autowired
    private MessageInterface messageInterface;
    @Autowired
    MallOrderProductInterface orderProductInterface;
    @Autowired
    ActiveInviteLogInterface activeInviteLogInterface;
    @Autowired
    ActiveCustomerInterface activeCustomerInterface;
    @Autowired
    private ActiveCashticketInterface cashticketInterface;
    @Autowired
    protected ActiveQrcodeInterface activeQrcodeService;
    @Autowired
    CashticketCustomerInterface cashticketCustomerService;

    @Override
    public BaseJsonVo<ActiveGiftTakedAuthVo> getActiveGiftTakedInfoVo(String source, String bindCode, String customerId) {
        Integer joinStatus;
        CustomerEntity customerEntity;
        this.logger.info("\u9080\u8bf7\u4eba:{},\u6d3b\u52a8bindCode={},\u53c2\u4e0e\u7528\u6237:{}", new Object[]{source, bindCode, customerId});
        ActiveInviteLogEntity activeInviteLogEntity = new ActiveInviteLogEntity();
        activeInviteLogEntity.setBindCode(bindCode);
        activeInviteLogEntity.setInviteId(source);
        activeInviteLogEntity.setCustomerId(customerId);
        activeInviteLogEntity.setCreateTime(DateUtils.now());
        activeInviteLogEntity.setFromStatus(0);
        activeInviteLogEntity.setOrderMainNo("");
        activeInviteLogEntity.setMessage("\u6253\u5f00\u9080\u8bf7\u8fde\u63a5");
        this.activeInviteLogInterface.saveInviteLog(activeInviteLogEntity);
        ActiveGiftTakedAuthVo activeGiftTakedAuthVo = new ActiveGiftTakedAuthVo();
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        activeGiftTakedAuthVo.setActivePicList(this.picService.getProductPicUrlMap(activeEntity.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue()));
        ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = this.distributorGrowthActiveInterface.getActiveGiftPropertyInfoVo(bindCode);
        BeanUtils.copyProperties((Object)activeGiftPropertyInfoVo, (Object)activeGiftTakedAuthVo);
        activeGiftTakedAuthVo.setCanTakedStatus(1);
        activeGiftTakedAuthVo.setHeadImageUrl("");
        activeGiftTakedAuthVo.setNickName("");
        if (StringUtils.isEmpty((String)source)) {
            ActiveInviteDetailEntity activeInviteDetailEntity = this.activeInviteInterface.getActiveInviteDetailEntity(customerId, bindCode);
            if (activeInviteDetailEntity == null) {
                activeGiftTakedAuthVo.setCanTakedStatus(0);
                this.logger.info("\u7528\u6237:{},\u9080\u8bf7\u4eba\u4e3a\u7a7a", (Object)customerId);
                activeGiftTakedAuthVo.setReson("\u9700\u8981\u901a\u8fc7\u9080\u8bf7\u9886\u53d6\u5662~~");
                return BaseJsonVo.success((Object)activeGiftTakedAuthVo);
            }
            source = activeInviteDetailEntity.getCustomerId();
        }
        if ((customerEntity = this.customerInterface.getCustomer(source)) == null) {
            activeGiftTakedAuthVo.setCanTakedStatus(0);
            activeGiftTakedAuthVo.setReson("\u9700\u8981\u7ecf\u8fc7\u9080\u8bf7\u624d\u80fd\u9886\u53d6\u793c\u7269\u5662~~~");
            this.logger.info("\u7528\u6237\uff1a{}\u9080\u8bf7\u4eba\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u9886\u53d6\u793c\u7269\u4e86", (Object)customerId);
            return BaseJsonVo.success((Object)activeGiftTakedAuthVo);
        }
        activeGiftTakedAuthVo.setNickName(customerEntity.getNickName());
        activeGiftTakedAuthVo.setHeadImageUrl(customerEntity.getHeadImageUrl());
        if (Objects.equals(source, customerId)) {
            activeGiftTakedAuthVo.setCanTakedStatus(0);
            activeGiftTakedAuthVo.setReson(activeGiftPropertyInfoVo.getNotAllowSelfTakedDesc());
            return BaseJsonVo.success((Object)activeGiftTakedAuthVo);
        }
        BaseJsonVo baseJsonVo = this.activeInterface.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            this.logger.info("\u6d3b\u52a8\uff1a{},{}\u4e0d\u80fd\u9080\u8bf7\u4e86", (Object)activeEntity.getActiveName(), (Object)baseJsonVo.getMessage());
            return BaseJsonVo.success((Object)activeGiftTakedAuthVo);
        }
        int orderNo = this.orderProductInterface.getUserCategoryBuyCount(customerId, Integer.parseInt(activeGiftPropertyInfoVo.getProductCategoryId()));
        this.logger.info("\u7528\u6237:{},\u54c1\u7c7b:{},\u5355\u6570:{}", new Object[]{customerId, activeGiftPropertyInfoVo.getProductCategoryId(), orderNo});
        activeGiftTakedAuthVo.setCanTakedStatus(1);
        if (orderNo > 0) {
            this.logger.info("\u7528\u6237\uff1a{}\u4e0d\u662f\u5546\u54c1:{}\u65b0\u7528\u6237,\u7528\u6237\u8be5\u54c1\u7c7b\u8ba2\u5355\u6570:{} \u4e0d\u80fd\u9886\u53d6\u793c\u7269\u4e86", new Object[]{customerId, activeGiftPropertyInfoVo.getProductName(), orderNo});
            activeGiftTakedAuthVo.setCanTakedStatus(0);
            activeGiftTakedAuthVo.setReson(activeGiftPropertyInfoVo.getNotAllowOldUserTakedDesc());
            return BaseJsonVo.success((Object)activeGiftTakedAuthVo);
        }
        if (activeEntity.getActiveType() == 37 && (joinStatus = this.activeCustomerInterface.getJoinActiveStatus(customerId, activeEntity.getActiveType())) > 0) {
            this.logger.info("\u7528\u6237\uff1a{}\u6d3b\u52a8\u53c2\u4e0e\u72b6\u6001:{} \u4e0d\u80fd\u9886\u53d6\u793c\u7269\u4e86", (Object)customerId, (Object)joinStatus);
            activeGiftTakedAuthVo.setCanTakedStatus(0);
            activeGiftTakedAuthVo.setTakedStatus(1);
            activeGiftTakedAuthVo.setReson(activeGiftPropertyInfoVo.getNotAllowOldUserTakedDesc());
            return BaseJsonVo.success((Object)activeGiftTakedAuthVo);
        }
        this.activeInviteInterface.saveActiveInvite(source, bindCode, customerId);
        activeGiftTakedAuthVo.setSubscribe((Integer)((Map)this.activeCommonInterface.checkUserSubscribe(customerId, PlatFormEnum.LECHUN_WECHAT_MAIN.getValue()).getValue()).get("subscribe"));
        if (activeGiftTakedAuthVo.getSubscribe() == 0) {
            activeGiftTakedAuthVo.setReson("\u9700\u8981\u5173\u6ce8\u516c\u4f17\u53f7\u624d\u80fd\u9886\u53d6\u5662~~");
            activeGiftTakedAuthVo.setArticleUrl(activeGiftPropertyInfoVo.getArticleUrl());
        }
        this.logger.info("\u7528\u6237{}\u5173\u6ce8\u516c\u4f17\u53f7\u72b6\u6001:{} 1 \u5df2\u5173\u6ce8 0 \u672a\u5173\u6ce8", (Object)customerId, (Object)activeGiftTakedAuthVo.getSubscribe());
        activeGiftTakedAuthVo.setNeedAuth(1);
        if (this.redisService.get(customerId + ":author") == null) {
            activeGiftTakedAuthVo.setReson("\u9700\u8981\u6388\u6743\u7528\u6237\u4fe1\u606f\u624d\u80fd\u9886\u53d6\u5662~~");
            activeGiftTakedAuthVo.setNeedAuth(0);
        }
        this.logger.info("\u7528\u6237{} \u6388\u6743\u5934\u50cf\u6635\u79f0\u72b6\u6001:{} 0 \u672a\u6388\u6743\uff0c1 \u5df2\u6388\u6743", (Object)customerId, (Object)activeGiftTakedAuthVo.getNeedAuth());
        activeGiftTakedAuthVo.setQywxStatus(StringUtils.isNotEmpty((String)this.customerInterface.getQiyeweixinContactor(customerId)) ? 1 : 0);
        if (activeGiftTakedAuthVo.getQywxStatus() == 0) {
            activeGiftTakedAuthVo.setReson("\u9700\u8981\u6dfb\u52a0\u4f01\u4e1a\u5fae\u4fe1\u624d\u80fd\u9886\u53d6\u5662~~");
            activeGiftTakedAuthVo.setArticleUrl(activeGiftPropertyInfoVo.getArticleUrl());
        }
        this.logger.info("\u7528\u6237{} \u52a0\u4f01\u4e1a\u5fae\u4fe1\u72b6\u6001:{} 0 \u52a0\uff0c1 \u5df2\u52a0", (Object)customerId, (Object)activeGiftTakedAuthVo.getQywxStatus());
        return BaseJsonVo.success((Object)activeGiftTakedAuthVo);
    }

    @Override
    public BaseJsonVo takedGift(String source, String bindCode, String customerId) {
        this.logger.info(" \u9080\u8bf7\u4eba:{},\u6d3b\u52a8bindCode={},\u53c2\u4e0e\u7528\u6237:{}", new Object[]{source, bindCode, customerId});
        ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = this.distributorGrowthActiveInterface.getActiveGiftPropertyInfoVo(bindCode);
        int orderNo = this.orderProductInterface.getUserCategoryBuyCount(customerId, Integer.parseInt(activeGiftPropertyInfoVo.getProductCategoryId()));
        if (orderNo > 0) {
            this.logger.info("\u7528\u6237\uff1a{}\u4e0d\u662f\u5546\u54c1:{}\u65b0\u7528\u6237,\u7528\u6237\u8be5\u54c1\u7c7b\u8ba2\u5355\u6570:{}", new Object[]{customerId, activeGiftPropertyInfoVo.getProductName(), orderNo});
            return BaseJsonVo.error((String)activeGiftPropertyInfoVo.getNotAllowOldUserTakedDesc());
        }
        if (StringUtils.isEmpty((String)source)) {
            ActiveInviteDetailEntity activeInviteDetailEntity = this.activeInviteInterface.getActiveInviteDetailEntity(customerId, bindCode);
            if (activeInviteDetailEntity == null) {
                this.logger.info("\u70b9\u51fb\u9886\u53d6\u6309\u94ae\uff0c\u7528\u6237:{},\u9080\u8bf7\u4eba\u4e3a\u7a7a", (Object)customerId);
                return BaseJsonVo.error((String)"\u9700\u8981\u901a\u8fc7\u9080\u8bf7\u9886\u53d6\u5662~~");
            }
            source = activeInviteDetailEntity.getCustomerId();
        }
        if (Objects.equals(source, customerId)) {
            return BaseJsonVo.error((String)activeGiftPropertyInfoVo.getNotAllowSelfTakedDesc());
        }
        ActiveInviteEntity activeInviteEntity = this.activeInviteInterface.getActiveInviteEntity(source, bindCode);
        if (activeInviteEntity == null) {
            return BaseJsonVo.error((String)"\u9700\u8981\u901a\u8fc7\u9080\u8bf7\u9886\u53d6\u5662~~");
        }
        if (activeInviteEntity.getInviteCount() <= 0) {
            return BaseJsonVo.error((String)activeGiftPropertyInfoVo.getNotHasGiftDesc());
        }
        int subcript = (Integer)((Map)this.activeCommonInterface.checkUserSubscribe(customerId, PlatFormEnum.LECHUN_WECHAT_MAIN.getValue()).getValue()).get("subscribe");
        this.logger.info("\u7528\u6237{}\u5173\u6ce8\u516c\u4f17\u53f7\u72b6\u6001:{} 1 \u5df2\u5173\u6ce8 0 \u672a\u5173\u6ce8", (Object)customerId, (Object)subcript);
        if (subcript == 0) {
            return BaseJsonVo.error((String)"\u9700\u8981\u5173\u6ce8\u516c\u4f17\u53f7\u624d\u80fd\u9886\u53d6\u793c\u7269\u5662~~");
        }
        if (this.redisService.get(customerId + ":author") == null) {
            return BaseJsonVo.error((String)"\u9700\u8981\u6388\u6743\u7528\u6237\u5934\u50cf\u6635\u79f0\u8003\u9a8c\u9886\u53d6\u793c\u7269\u5662~~");
        }
        this.logger.info("\u7528\u6237{}\u5df2\u6388\u6743\u5934\u50cf\u6635\u79f0 ", (Object)customerId);
        if (StringUtils.isEmpty((String)this.customerInterface.getQiyeweixinContactor(customerId))) {
            return BaseJsonVo.error((String)"\u9700\u8981\u6dfb\u52a0\u4f01\u4e1a\u5fae\u4fe1\u597d\u53cb\u624d\u80fd\u9886\u53d6\u793c\u7269\u5662~~");
        }
        this.logger.info("\u7528\u6237{} \u5df2\u52a0\u4f01\u4e1a\u5fae\u4fe1", (Object)customerId);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo<ActiveGiftInviteInfoVo> getActiveGiftInviteInfoVo(String bindCode, String customerId, Integer platformId) {
        ActiveGiftInviteInfoVo activeGiftInviteInfoVo = new ActiveGiftInviteInfoVo();
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = this.distributorGrowthActiveInterface.getActiveGiftPropertyInfoVo(bindCode);
        BeanUtils.copyProperties((Object)activeGiftPropertyInfoVo, (Object)activeGiftInviteInfoVo);
        activeGiftInviteInfoVo.setShareSuccessDesc(activeGiftPropertyInfoVo.getShareSuccessDesc());
        activeGiftInviteInfoVo.setTemplateMessageList(this.templateMessageInterface.getTempMessageListBySence(9, platformId));
        activeGiftInviteInfoVo.setActivePicList(this.picService.getProductPicUrlMap(activeEntity.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue()));
        activeGiftInviteInfoVo.setBindCode(bindCode);
        activeGiftInviteInfoVo.setProductName(activeGiftPropertyInfoVo.getProductName());
        activeGiftInviteInfoVo.setStatus(1);
        BaseJsonVo baseJsonVo = this.activeInterface.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            activeGiftInviteInfoVo.setStatus(0);
            activeGiftInviteInfoVo.setReson(baseJsonVo.getMessage());
            return BaseJsonVo.success((Object)activeGiftInviteInfoVo);
        }
        ActiveInviteEntity activeInviteEntity = this.activeInviteInterface.getActiveInviteEntity(customerId, bindCode, activeEntity);
        activeGiftInviteInfoVo.setPrice(activeGiftPropertyInfoVo.getPrice());
        activeGiftInviteInfoVo.setStatus(activeInviteEntity.getInviteCount() >= 1 ? 1 : 0);
        activeGiftInviteInfoVo.setRemain(activeInviteEntity.getInviteCount());
        activeGiftInviteInfoVo.setReson(activeInviteEntity.getInviteCount() >= 1 ? "" : activeGiftPropertyInfoVo.getNotHasGiftDesc());
        return BaseJsonVo.success((Object)activeGiftInviteInfoVo);
    }

    @Override
    @ReadThroughSingleCache(namespace="DistributorGrowthActiveService.getActiveGiftPropertyInfoVo", expiration=120)
    public ActiveGiftPropertyInfoVo getActiveGiftPropertyInfoVo(@ParameterValueKeyProvider String bindCode) {
        ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = new ActiveGiftPropertyInfoVo();
        List<ActivePropertyEntity> propertyList = this.activePropertyInterface.getActivePropertyList(bindCode);
        if (CollectionUtils.isEmpty(propertyList)) {
            this.logger.error("\u6d3b\u52a8bindCode={}\u5c5e\u6027\u672a\u914d\u7f6e:\u8bf7\u68c0\u67e5", (Object)bindCode);
            return activeGiftPropertyInfoVo;
        }
        this.setTakedPageDesc(activeGiftPropertyInfoVo, propertyList);
        this.setArticleUrl(activeGiftPropertyInfoVo, propertyList);
        this.setJoinActiveAllowNum(activeGiftPropertyInfoVo, propertyList);
        this.setProductName(activeGiftPropertyInfoVo, propertyList);
        this.setShareSuccessDesc(activeGiftPropertyInfoVo, propertyList);
        this.setNotHasGiftDesc(activeGiftPropertyInfoVo, propertyList);
        this.setNotHasInviteQualification(activeGiftPropertyInfoVo, propertyList);
        this.setNotAllowSelfTakedDesc(activeGiftPropertyInfoVo, propertyList);
        this.setNotAllowOldUserTakedDesc(activeGiftPropertyInfoVo, propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "ipLimitCount", propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "addressLimitCount", propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "miniBuyMilkLimitCount", propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "allBuyMilkLimitCount", propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "closeOrderBuy", propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "salesPersonMoblie", propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "baseInviteNum", propertyList);
        this.setFilds(activeGiftPropertyInfoVo, "activeUrl", propertyList);
        this.logger.info("\u6d3b\u52a8\u5c5e\u6027:{}", (Object)activeGiftPropertyInfoVo.toString());
        return activeGiftPropertyInfoVo;
    }

    @Override
    public BaseJsonVo setInviteOrder(String source, String bindCode, String customerId, String orderMainNo, Integer platFormId) {
        return this.activeInviteInterface.setActiveInviteOrder(source, bindCode, customerId, orderMainNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo updateInviteWithoutOrder(String source, final String bindCode, final String customerId, String phone, final Integer platFormId) {
        if (StringUtils.isEmpty((String)source)) {
            ActiveInviteDetailEntity activeInviteDetailEntity = this.activeInviteInterface.getActiveInviteDetailEntity(customerId, bindCode);
            if (activeInviteDetailEntity == null) {
                return BaseJsonVo.error((String)"\u9700\u8981\u901a\u8fc7\u9080\u8bf7\u9886\u53d6\u5662");
            }
            source = activeInviteDetailEntity.getCustomerId();
        }
        final ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        final ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = this.distributorGrowthActiveInterface.getActiveGiftPropertyInfoVo(bindCode);
        BaseJsonVo baseJsonVo = this.activeInterface.validateActive(customerId, bindCode, phone, activeGiftPropertyInfoVo);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        final String sourceCustomerId = source;
        baseJsonVo = this.activeInviteInterface.setActiveInviteSuccess4NoOrder(bindCode, customerId, source);
        if (baseJsonVo.isSuccess()) {
            baseJsonVo = this.activeCustomerInterface.saveActiveCustomerRecord(activeEntity, customerId, source, 1);
            if (!baseJsonVo.isSuccess()) {
                throw new RuntimeException("\u4fdd\u5b58\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5");
            }
            ExecutorService pool = Executors.newFixedThreadPool(1);
            try {
                pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        HashMap<String, String> map = new HashMap<String, String>();
                        CustomerEntity customerEntity = DistributorGrowthActiveService.this.customerInterface.getCustomer(customerId);
                        map.put("giftName", activeGiftPropertyInfoVo.getProductName());
                        map.put("nickName", customerEntity != null ? customerEntity.getNickName() : "\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec");
                        map.put("date", DateUtils.formatDate((Date)DateUtils.now(), (String)""));
                        map.put("giftStatus", "\u5df2\u9886\u53d6");
                        map.put("bindCode", bindCode);
                        DistributorGrowthActiveService.this.logger.info("\u63a8\u9001\u6d88\u606f\u7528\u6237:{}", (Object)sourceCustomerId);
                        DistributorGrowthActiveService.this.messageInterface.sendWechatMessage("inviteGift", sourceCustomerId, map);
                        List<ActiveQrcodeEntity> qrcodeList = DistributorGrowthActiveService.this.activeQrcodeService.getQrcodeListByActiveNo(activeEntity.getActiveNo());
                        ActiveInviteEntity activeInviteEntity = DistributorGrowthActiveService.this.activeInviteInterface.getActiveInviteEntity(sourceCustomerId, bindCode);
                        DistributorGrowthActiveService.this.logger.info("\u6d3b\u52a8\u8981\u6c42\u9080\u8bf7\u4eba\u6570:{},\u8fd8\u53ef\u4ee5\u9080\u8bf7\u4eba\u6570:{},\u6700\u5c11\u9080\u8bf7\u4eba\u6570:{}", new Object[]{activeEntity.getInviteNum(), activeInviteEntity.getInviteCount(), activeGiftPropertyInfoVo.getBaseInviteNum()});
                        if (activeEntity.getInviteNum() - activeInviteEntity.getInviteCount() >= activeGiftPropertyInfoVo.getBaseInviteNum()) {
                            String sourceKey = sourceCustomerId + ":Invite:reward:" + bindCode;
                            DistributorGrowthActiveService.this.logger.info("sourceKey={}", (Object)sourceKey);
                            if (DistributorGrowthActiveService.this.redisService.get(sourceKey) == null) {
                                BaseJsonVo baseJsonVo = DistributorGrowthActiveService.this.activeCustomerInterface.saveActiveCustomerRecord(activeEntity, sourceCustomerId, "", 1);
                                if (baseJsonVo.isSuccess()) {
                                    String ticketNo = baseJsonVo.getValue().toString();
                                    ActiveQrcodeEntity activeQrcodeEntity = qrcodeList.get(0);
                                    if (activeQrcodeEntity != null && StringUtils.isNotEmpty((String)activeQrcodeEntity.getBindCode())) {
                                        baseJsonVo = DistributorGrowthActiveService.this.cashticketInterface.sendTicket4Base(sourceCustomerId, activeQrcodeEntity.getBindCode(), "", platFormId, true, null, "");
                                        DistributorGrowthActiveService.this.logger.info("\u7ed9\u9001\u793c\u7528\u6237:{},bindCode={}\u4f18\u60e0\u5238\u53d1\u653e:{}", new Object[]{customerId, bindCode, baseJsonVo.isSuccess()});
                                        if (baseJsonVo.isSuccess()) {
                                            DistributorGrowthActiveService.this.redisService.save(sourceKey, 1);
                                        }
                                    } else {
                                        DistributorGrowthActiveService.this.logger.info("\u7528\u6237:{},\u6d3b\u52a8:{}\u6ca1\u6709\u914d\u7f6e\u4e8c\u7ef4\u7801", (Object)sourceCustomerId, (Object)activeEntity.getActiveName());
                                    }
                                    List<Integer> ticketIdList = DistributorGrowthActiveService.this.cashticketInterface.getCashticketTicketId(activeQrcodeEntity.getBindCode(), sourceCustomerId);
                                    for (Integer item : ticketIdList) {
                                        DistributorGrowthActiveService.this.redisService.save(item.toString(), ticketNo);
                                    }
                                    DistributorGrowthActiveService.this.redisService.save(ticketNo, ticketIdList);
                                } else {
                                    DistributorGrowthActiveService.this.logger.info("\u7528\u6237:{}\u4fdd\u5b58\u5151\u6362\u7801\u5931\u8d25", (Object)sourceCustomerId);
                                }
                            } else {
                                DistributorGrowthActiveService.this.logger.info("\u7528\u6237:{}\u5956\u52b1\u5df2\u9886\u53d6", (Object)sourceCustomerId);
                            }
                        }
                        if (qrcodeList.size() > 1) {
                            ActiveQrcodeEntity activeQrcodeEntity = qrcodeList.get(1);
                            if (DistributorGrowthActiveService.this.redisService.get(customerId + ":Join:reward" + bindCode) == null) {
                                BaseJsonVo baseResult = DistributorGrowthActiveService.this.cashticketInterface.sendTicket4Base(customerId, activeQrcodeEntity.getBindCode(), "", platFormId, true, null, "");
                                DistributorGrowthActiveService.this.logger.info("\u7ed9\u9886\u53d6\u7528\u6237:{},bindCode={}\u4f18\u60e0\u5238\u53d1\u653e:{}", new Object[]{customerId, bindCode, baseResult.isSuccess()});
                                if (baseResult.isSuccess()) {
                                    DistributorGrowthActiveService.this.redisService.save(customerId + ":Join:reward" + bindCode, 1);
                                }
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error(e.getMessage());
            }
            finally {
                pool.shutdown();
            }
        }
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo getRechangCode(String bindCode, String customerId) {
        BaseJsonVo<ActiveCustomerEntity> baseJsonVo = this.activeCustomerInterface.getRechangeCode(customerId, bindCode);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        ActiveGiftRechangeVo activeGiftRechangeVo = new ActiveGiftRechangeVo();
        activeGiftRechangeVo.setRechangeStatus(((ActiveCustomerEntity)baseJsonVo.getValue()).getStatus());
        activeGiftRechangeVo.setRechangeStatusName(activeGiftRechangeVo.getRechangeStatus() == 2 ? "\u5df2\u6838\u9500" : "\u672a\u6838\u9500");
        ArrayList<ActiveGiftAdressVo> activeGiftAdressVoList = new ArrayList();
        ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = this.distributorGrowthActiveInterface.getActiveGiftPropertyInfoVo(bindCode);
        String addressJson = "[{\"cityName\":\"\u5317\u4eac\",\"shopAddress\":[{\"name\":\"loe\u5317\u4eac\u56fd\u8d38\u4e09\u671f\u5e97\"},{\"name\":\"Ole\u5317\u4eac\u91d1\u878d\u8857\u5e97\"},{\"name\":\"7 fresh\u5317\u4eac\u4e94\u5f69\u57ce\u5e97\"},{\"name\":\"7fresh\u5317\u4eac\u5e7f\u5b89\u95e8\u5e97\"},{\"name\":\"7fresh\u5317\u4eac\u65f6\u4ee3lift\u5e97\"},{\"name\":\"7fresh\u5317\u4eac\u6cf0\u79be\u4e2d\u592e\u5e7f\u573a\u5e97\"},{\"name\":\"\u4e03\u9c9c\u8d85\u5e02\u5927\u65cf\u5e7f\u573a\u5e97\"},{\"name\":\"\u4e03\u9c9c\u8d85\u5e02\u5317\u4eac\u9996\u521b\u5965\u7279\u83b1\u65af\u5e97\"},{\"name\":\"\u4e03\u9c9c\u8d85\u5e02\u901a\u5dde\u5317\u4eacONE\u5e97\"},{\"name\":\"\u5317\u4eac\u76d2\u9a6c\u897f\u76f4\u95e8\u5e97\"},{\"name\":\"\u5317\u4eac\u76d2\u9a6c\u897f\u76f4\u95e8\u5e97\"},{\"name\":\"\u5317\u4eac\u76d2\u9a6c\u5341\u91cc\u5821\u5e97\"},{\"name\":\"\u5317\u4eac\u76d2\u9a6c\u7ea2\u83b2\u5e97\"},{\"name\":\"\u5317\u4eac\u76d2\u9a6c\u5927\u6210\u5e97\"},{\"name\":\"\u5317\u4eac\u76d2\u9a6c\u77f3\u666f\u5c71\u516b\u89d2\u5e97\"}]},{\"cityName\":\"\u897f\u5b89\",\"shopAddress\":[{\"name\":\"\u897f\u5b89\u76d2\u9a6c\u5927\u90fd\u835f\u5e97\"},{\"name\":\"\u897f\u5b89\u76d2\u9a6c\u66f2\u6c5f\u5e97\"},{\"name\":\"\u897f\u5b89\u76d2\u9a6c\u65b0\u5174\u5e97\"},{\"name\":\"\u897f\u5b89\u76d2\u9a6c\u5170\u5c9b\u5e97\"},{\"name\":\"\u897f\u5b89\u76d2\u9a6c\u6587\u666f\u5e97\"},{\"name\":\"\u897f\u5b89\u76d2\u9a6c\u592a\u767d\u5e97\"},{\"name\":\"\u897f\u5b89\u76d2\u9a6c\u661f\u5ea7\u5e97\"},{\"name\":\"\u897f\u5b89\u76d2\u9a6c\u6fb3\u5821\u5e97\"}]},{\"cityName\":\"\u4e0a\u6d77\",\"shopAddress\":[{\"name\":\"\u4e0a\u6d77\u76d2\u9a6c\u65b0\u6c5f\u6e7e\u5e97\"},{\"name\":\"\u4e0a\u6d77\u76d2\u9a6c\u66f9\u5bb6\u6e21\u5e97\"},{\"name\":\"\u4e0a\u6d77\u76d2\u9a6c\u5b9d\u5730\u5e97\"},{\"name\":\"\u4e0a\u6d77\u76d2\u9a6c\u91d1\u6865\u5e97\"},{\"name\":\"\u4e0a\u6d77\u76d2\u9a6c\u4e01\u9999\u56fd\u9645\"},{\"name\":\"\u4e0a\u6d77\u76d2\u9a6c\u6768\u9ad8\u5357\u8def\u5e97\"},{\"name\":\"\u4e0a\u6d77\u9759\u5b89\u5609\u91ccOLE\u5e97\"}]},{\"cityName\":\"\u5927\u8fde\",\"shopAddress\":[{\"name\":\"\u5927\u8fde\u53cb\u8c0a\u5546\u57ce\"},{\"name\":\"\u5927\u8fde\u9ea6\u51ef\u4e50\u603b\u5e97\"},{\"name\":\"\u5927\u8fdeBigu\u51ef\u4e39\"},{\"name\":\"\u5927\u8fde\u76d2\u9a6c\u9ad8\u65b0\u5e97\"},{\"name\":\"\u5927\u8fde\u76d2\u9a6c\u897f\u5c97\u5e97\"},{\"name\":\"\u5927\u8fde\u76d2\u9a6c\u91d1\u5dde\u5e97\"},{\"name\":\"\u5927\u8fde\u65b0\u739b\u7279\u9752\u6ce5\"},{\"name\":\"\u5927\u8fdebigu\u4e2d\u592e\u5927\u9053\"},{\"name\":\"\u5927\u8fde\u9ea6\u51ef\u4e50\u897f\u5b89\u8def\"}]}]";
        activeGiftAdressVoList = JSONObject.parseArray((String)addressJson, ActiveGiftAdressVo.class);
        activeGiftRechangeVo.setActiveGiftAdressVoList(activeGiftAdressVoList);
        activeGiftRechangeVo.setRechangeCode(((ActiveCustomerEntity)baseJsonVo.getValue()).getRechangeCode().substring(0, 4) + " " + ((ActiveCustomerEntity)baseJsonVo.getValue()).getRechangeCode().substring(4, 8));
        return BaseJsonVo.success((Object)activeGiftRechangeVo);
    }

    @Override
    public BaseJsonVo setRechange(String bindCode, String rechangeCode, String mobile, String customerId) {
        List ticketIdList;
        this.logger.info("\u6838\u9500\u5458:{},\u5151\u6362\u7801:{},bindCode:{},\u6838\u9500\u5458\u624b\u673a\u53f7{}", new Object[]{customerId, rechangeCode, bindCode, mobile});
        ActiveGiftRechangeResultVo activeGiftRechangeResultVo = new ActiveGiftRechangeResultVo();
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        BaseJsonVo baseJsonVo = this.activeInterface.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            activeGiftRechangeResultVo.setRechangeStatus(GiftRechangeStatusEnum.Rechange_fail.getValue());
            activeGiftRechangeResultVo.setMessage(baseJsonVo.getMessage());
            return baseJsonVo;
        }
        BaseJsonVo<ActiveCustomerEntity> rechangStatusJsonVo = this.activeCustomerInterface.getGiftRechangeStatus(rechangeCode, bindCode);
        if (!rechangStatusJsonVo.isSuccess()) {
            activeGiftRechangeResultVo.setMessage(rechangStatusJsonVo.getMessage());
            activeGiftRechangeResultVo.setRechangeStatus(0);
            return rechangStatusJsonVo;
        }
        if (((ActiveCustomerEntity)rechangStatusJsonVo.getValue()).getStatus().intValue() == GiftRechangeStatusEnum.Rechanged.getValue()) {
            activeGiftRechangeResultVo.setMessage(GiftRechangeStatusEnum.Rechanged.getName());
            activeGiftRechangeResultVo.setRechangeStatus(GiftRechangeStatusEnum.Rechanged.getValue());
            return BaseJsonVo.error((String)"\u6838\u9500\u5931\u8d25\uff0c\u5151\u6362\u7801\u5df2\u5151\u6362");
        }
        ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = this.distributorGrowthActiveInterface.getActiveGiftPropertyInfoVo(bindCode);
        List mobileVoList = JSONObject.parseArray((String)activeGiftPropertyInfoVo.getSalesPersonMoblie(), PromtionerMobileVo.class);
        if (CollectionUtils.isEmpty((Collection)mobileVoList)) {
            throw new RuntimeException("\u4fc3\u9500\u5458\u624b\u673a\u53f7\u6709\u8bef");
        }
        if (!mobileVoList.stream().anyMatch(m -> Objects.equals(m.getM().trim(), mobile))) {
            activeGiftRechangeResultVo.setMessage("\u5151\u6362\u5931\u8d25,\u4fc3\u9500\u5458\u624b\u673a\u53f7\u4e0d\u5b58\u5728");
            activeGiftRechangeResultVo.setRechangeStatus(0);
            return BaseJsonVo.error((String)"\u5151\u6362\u5931\u8d25,\u4fc3\u9500\u5458\u624b\u673a\u53f7\u4e0d\u5b58\u5728\u6216\u6ca1\u6709\u7ed1\u5b9a\u624b\u673a\u53f7");
        }
        ActiveCustomerEntity update = (ActiveCustomerEntity)rechangStatusJsonVo.getValue();
        update.setRechangeTime(DateUtils.now());
        update.setRechangeUser(customerId);
        update.setStatus(2);
        this.activeCustomerInterface.updateActiveCustomerRecord(update);
        activeGiftRechangeResultVo.setMessage(GiftRechangeStatusEnum.Rechange_succ.getName());
        activeGiftRechangeResultVo.setRechangeStatus(GiftRechangeStatusEnum.Rechange_succ.getValue());
        if (this.redisService.get(rechangeCode) != null && CollectionUtils.isNotEmpty((Collection)(ticketIdList = (List)this.redisService.get(rechangeCode)))) {
            for (Integer item : ticketIdList) {
                rechangStatusJsonVo.getValue();
                this.cashticketInterface.updateCashticketStatus(item, update.getCustomerId(), CashStatusEnum.jinyong);
            }
        }
        return BaseJsonVo.success((Object)activeGiftRechangeResultVo);
    }

    @Override
    public BaseJsonVo setRechange(String rechangeCode, String customerId) {
        this.logger.info("\u6838\u9500\u5458:{},\u5151\u6362\u7801:{}", (Object)customerId, (Object)rechangeCode);
        BaseJsonVo<ActiveCustomerEntity> rechangStatusJsonVo = this.activeCustomerInterface.getGiftRechangeStatus(rechangeCode, "");
        if (!rechangStatusJsonVo.isSuccess()) {
            return rechangStatusJsonVo;
        }
        ActiveCustomerEntity update = (ActiveCustomerEntity)rechangStatusJsonVo.getValue();
        update.setRechangeTime(DateUtils.now());
        update.setRechangeUser(customerId);
        update.setStatus(2);
        this.activeCustomerInterface.updateActiveCustomerRecord(update);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo sendCash(String customerId, Integer cashticketId, int platformId) {
        this.logger.info("\u7528\u6237:{} \u4f30\u91cf\u5238id:{}", (Object)customerId, (Object)cashticketId);
        try {
            CashticketCustomerEntity cashticketCustomerEntity = this.cashticketCustomerService.getCashticketCustomer(cashticketId);
            BaseJsonVo baseJsonVo = this.activeInviteInterface.setActiveInviteSuccessByCustomerId(cashticketCustomerEntity.getBindCode(), customerId, 2);
            if (baseJsonVo.isSuccess()) {
                this.logger.info("\u7528\u6237:{} \u9080\u8bf7InviteId:{}", (Object)customerId, baseJsonVo.getValue());
                ActiveInviteEntity activeInviteEntity = this.activeInviteInterface.getActiveInviteEntity((String)baseJsonVo.getValue());
                ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(activeInviteEntity.getBindCode());
                this.logger.info("\u7528\u6237:{}\u53ef\u7528\u6b21\u6570:{},\u6d3b\u52a8\u6bcf\u6b21\u8981\u6c42\u5151\u6362\u6b21\u6570:{}", new Object[]{activeInviteEntity.getCustomerId(), activeInviteEntity.getBalanceCount(), activeEntity.getInviteNum()});
                if (activeInviteEntity.getBalanceCount() > 0 && activeInviteEntity.getBalanceCount() % activeEntity.getInviteNum() == 0) {
                    List<ActiveQrcodeEntity> qrcodeEntityList = this.activeQrcodeService.getQrcodeListByActiveNo(activeEntity.getActiveNo());
                    if (CollectionUtils.isEmpty(qrcodeEntityList)) {
                        this.logger.error("\u6d3b\u52a8:{}\u672a\u914d\u9001\u8d60\u54c1\u5238", (Object)activeEntity.getActiveName());
                        return BaseJsonVo.success((Object)"");
                    }
                    baseJsonVo = this.cashticketInterface.sendTicket4Base(activeInviteEntity.getCustomerId(), qrcodeEntityList.get(0).getBindCode(), "", platformId, true, null, "");
                    if (baseJsonVo.isSuccess()) {
                        this.activeInviteInterface.updateInviteNum2(activeInviteEntity.getInviteId(), activeEntity.getInviteNum());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u6267\u884c\u51fa\u9519:{}", (Object)e.getMessage());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo checkHasInvite(String customerId, String bindCode) {
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        if (activeEntity.getActiveType() == 41) {
            return this.activeInviteInterface.getActiveInviteDetailEntity(customerId, bindCode) == null ? BaseJsonVo.error((String)"\u9700\u8981\u88ab\u9080\u8bf7\u624d\u80fd\u9886\u53d6~~") : BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.success((Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseJsonVo updateInvite(final String bindCode, final String customerId, String orderMainNo) {
        final BaseJsonVo baseJsonVo = this.activeInviteInterface.setActiveInviteSuccess(bindCode, customerId, orderMainNo);
        if (baseJsonVo.isSuccess()) {
            ExecutorService pool = Executors.newFixedThreadPool(1);
            try {
                pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        HashMap<String, String> map = new HashMap<String, String>();
                        ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = DistributorGrowthActiveService.this.distributorGrowthActiveInterface.getActiveGiftPropertyInfoVo(bindCode);
                        CustomerEntity customerEntity = DistributorGrowthActiveService.this.customerInterface.getCustomer(customerId);
                        map.put("giftName", activeGiftPropertyInfoVo.getProductName());
                        map.put("nickName", customerEntity != null ? customerEntity.getNickName() : "\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec");
                        map.put("date", DateUtils.formatDate((Date)DateUtils.now(), (String)""));
                        map.put("giftStatus", "\u5df2\u9886\u53d6");
                        map.put("bindCode", bindCode);
                        DistributorGrowthActiveService.this.logger.info("\u63a8\u9001\u6d88\u606f\u7528\u6237:{}", baseJsonVo.getValue());
                        DistributorGrowthActiveService.this.messageInterface.sendWechatMessage("inviteGift", (String)baseJsonVo.getValue(), map);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error(e.getMessage());
            }
            finally {
                pool.shutdown();
            }
        }
        return baseJsonVo;
    }

    @Override
    public List<CustomerNickVo> getInviteCustomerNickVoList(String bindCode, String customerId) {
        return this.activeInviteInterface.getInviteCustomerNickVoList(bindCode, customerId);
    }

    private void setTakedPageDesc(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("takedPageDesc", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setTakedPageDesc(propertyEntityOptional.get().getPropertyValue());
        }
    }

    private void setArticleUrl(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("articleUrl", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setArticleUrl(propertyEntityOptional.get().getPropertyValue());
        }
    }

    private void setJoinActiveAllowNum(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("joinActiveAllowNum", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setJoinActiveAllowNum(Integer.valueOf(propertyEntityOptional.get().getPropertyValue()));
        }
    }

    private void setProductName(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        MallProductEntity productEntity;
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("productId", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent() && StringUtils.isNotEmpty((String)propertyEntityOptional.get().getPropertyValue()) && (productEntity = this.productInterface.getProduct(propertyEntityOptional.get().getPropertyValue())) != null) {
            activeGiftPropertyInfoVo.setProductName(productEntity.getProName());
            activeGiftPropertyInfoVo.setPrice(new BigDecimal(productEntity.getProPrice()));
            activeGiftPropertyInfoVo.setProductId(productEntity.getProId());
            activeGiftPropertyInfoVo.setProductCategoryId(productEntity.getProductCategoryId());
            activeGiftPropertyInfoVo.setTransportType(productEntity.getTransportType());
        }
    }

    private void setShareSuccessDesc(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("shareSuccessDesc", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setShareSuccessDesc(propertyEntityOptional.get().getPropertyValue());
        }
    }

    private void setNotHasGiftDesc(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("notHasGiftDesc", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setNotHasGiftDesc(propertyEntityOptional.get().getPropertyValue());
        }
    }

    private void setNotHasInviteQualification(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("notHasInviteQualification", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setNotHasInviteQualification(propertyEntityOptional.get().getPropertyValue());
        }
    }

    private void setNotAllowSelfTakedDesc(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("notAllowSelfTakedDesc", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setNotAllowSelfTakedDesc(propertyEntityOptional.get().getPropertyValue());
        }
    }

    private void setNotAllowOldUserTakedDesc(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals("notAllowOldUserTakedDesc", activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            activeGiftPropertyInfoVo.setNotAllowOldUserTakedDesc(propertyEntityOptional.get().getPropertyValue());
        }
    }

    private void setFilds(ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo, String propertyName, List<ActivePropertyEntity> propertyList) {
        Optional<ActivePropertyEntity> propertyEntityOptional = propertyList.stream().filter(activePropertyEntity -> Objects.equals(propertyName, activePropertyEntity.getPropertyKey())).findFirst();
        if (propertyEntityOptional.isPresent()) {
            try {
                Class<Object> type = activeGiftPropertyInfoVo.getClass().getDeclaredField(propertyName).getType();
                Method setMethod = activeGiftPropertyInfoVo.getClass().getMethod("set" + this.captureName(propertyName), type);
                if (type.isAssignableFrom(String.class)) {
                    setMethod.invoke((Object)activeGiftPropertyInfoVo, propertyEntityOptional.get().getPropertyValue());
                }
                if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
                    setMethod.invoke((Object)activeGiftPropertyInfoVo, Integer.parseInt(propertyEntityOptional.get().getPropertyValue()));
                }
                if (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Double.class)) {
                    setMethod.invoke((Object)activeGiftPropertyInfoVo, Double.parseDouble(propertyEntityOptional.get().getPropertyValue()));
                }
                if (type.isAssignableFrom(Float.TYPE) || type.isAssignableFrom(Float.class)) {
                    setMethod.invoke((Object)activeGiftPropertyInfoVo, Float.valueOf(Float.parseFloat(propertyEntityOptional.get().getPropertyValue())));
                }
                if (type.isAssignableFrom(Boolean.TYPE) || type.isAssignableFrom(Boolean.class)) {
                    setMethod.invoke((Object)activeGiftPropertyInfoVo, Boolean.parseBoolean(propertyEntityOptional.get().getPropertyValue()));
                }
                if (type.isAssignableFrom(BigDecimal.class)) {
                    setMethod.invoke((Object)activeGiftPropertyInfoVo, new BigDecimal(propertyEntityOptional.get().getPropertyValue()));
                }
                if (type.isAssignableFrom(Date.class)) {
                    setMethod.invoke((Object)activeGiftPropertyInfoVo, DateUtils.StrToDate((String)propertyEntityOptional.get().getPropertyValue(), (String)"yyyy-MM-dd"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String captureName(String name) {
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }
}

