/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.DistributorItemMapper;
import cc.lechun.mall.entity.distribution.DistributorItemDetailEntity;
import cc.lechun.mall.entity.distribution.DistributorItemEntity;
import cc.lechun.mall.iservice.distribution.DistributorItemDetailInterface;
import cc.lechun.mall.iservice.distribution.DistributorItemInterface;
import com.github.pagehelper.util.StringUtil;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributorItemService
extends BaseService<DistributorItemEntity, Integer>
implements DistributorItemInterface {
    @Resource
    private DistributorItemMapper distributorItemMapper;
    @Autowired
    private DistributorItemDetailInterface detailInterface;

    @Override
    public BaseJsonVo<BigDecimal> getDistributorItemPercentageByItemId(String itemId, Integer itemType, Integer distributorGroupId) {
        if (StringUtil.isEmpty((String)itemId)) {
            return BaseJsonVo.error((String)"ItemId\u4e3a\u7a7a");
        }
        DistributorItemEntity param = new DistributorItemEntity();
        param.setItemId(itemId);
        param.setItemType(itemType);
        param.setIsDistribution(1);
        DistributorItemEntity rtn = (DistributorItemEntity)this.getSingle(param);
        if (rtn != null) {
            if (Integer.valueOf(0).equals(rtn.getPercentageType())) {
                return BaseJsonVo.success((Object)rtn.getPercentage());
            }
            DistributorItemDetailEntity distributorItemDetail = this.detailInterface.getDistributorItemDetail(rtn.getId(), distributorGroupId);
            if (distributorItemDetail != null && Integer.valueOf(1).equals(distributorItemDetail.getIsDistribution())) {
                return BaseJsonVo.success((Object)distributorItemDetail.getPercentage());
            }
        }
        return BaseJsonVo.success((Object)BigDecimal.ZERO);
    }
}

