/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.apiinvoke.bi.CustomerProductInvoke;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.QiyeweixinExternalContactMapper;
import cc.lechun.mall.entity.distribution.QiyeweixinExternalContactEntity;
import cc.lechun.mall.iservice.distribution.QiyeweixinExternalContactInterface;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QiyeweixinExternalContactService
extends BaseService<QiyeweixinExternalContactEntity, Integer>
implements QiyeweixinExternalContactInterface {
    @Resource
    private QiyeweixinExternalContactMapper qiyeweixinExternalContactMapper;
    @Autowired
    private CustomerProductInvoke customerProductInvoke;

    @Override
    public Boolean isQyCustomer(String mobile, String buyerId) {
        Integer i = this.qiyeweixinExternalContactMapper.isQyCustomer(mobile);
        if (i != null && i > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean isQyCustomerNew(String mobile, String buyerId) {
        if (StringUtils.isNotEmpty((String)mobile) && mobile.length() == 11 && !mobile.contains("*")) {
            Integer i = this.qiyeweixinExternalContactMapper.isQyCustomer(mobile);
            if (i != null && i > 0) {
                return true;
            }
            i = this.qiyeweixinExternalContactMapper.getMobileIsQWUser(mobile);
            if (i != null && i > 0) {
                return true;
            }
        }
        if (StringUtils.isNotEmpty((String)buyerId)) {
            Integer i;
            String customerId = this.qiyeweixinExternalContactMapper.getGlobalCustomerId(buyerId);
            if (StringUtils.isNotEmpty((String)customerId) && (i = this.qiyeweixinExternalContactMapper.getCustomerIdIsQWUser(customerId)) != null && i > 0) {
                return true;
            }
            List<String> mobiles = this.qiyeweixinExternalContactMapper.getGlobalMobiles(buyerId);
            if (mobiles != null && mobiles.size() > 0) {
                for (String globalMobile : mobiles) {
                    Integer i2 = this.qiyeweixinExternalContactMapper.isQyCustomer(globalMobile);
                    if (i2 != null && i2 > 0) {
                        return true;
                    }
                    i2 = this.qiyeweixinExternalContactMapper.getMobileIsQWUser(globalMobile);
                    if (i2 == null || i2 <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Boolean isQyCustomerByConsigneePhone(String mobile) {
        Integer i = this.qiyeweixinExternalContactMapper.isQyCustomerByConsigneePhone(mobile);
        return i != null && i > 0;
    }

    @Override
    public Boolean isQyCustomerByCustomerId(String customerId) {
        QiyeweixinExternalContactEntity param = new QiyeweixinExternalContactEntity();
        param.setCustomerId(customerId);
        List list = this.qiyeweixinExternalContactMapper.getList(param);
        return list != null && list.size() > 0;
    }
}

