/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution;

import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.distribution.ShareMapper;
import cc.lechun.mall.entity.distribution.ShareEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.distribution.ShareInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import com.github.pagehelper.util.StringUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShareService
extends BaseService<ShareEntity, Integer>
implements ShareInterface {
    @Autowired
    ShareMapper shareMapper;
    @Autowired
    OssService ossService;
    @Autowired
    MallProductInterface productInterface;
    @Autowired
    MallPromotionInterface promotionInterface;
    @Autowired
    MallGroupInterface groupInterface;
    @Autowired
    CustomerInterface customerInterface;
    @Autowired
    private MallProductPicInterface mallProductPicInterface;
    @Autowired
    private MallPromotionProductInterface mallPromotionProductInterface;

    @Override
    public ShareEntity findByPage(String page, Integer platformId) {
        ShareEntity param = new ShareEntity();
        param.setPageName(page.indexOf("?") > 0 ? page.substring(0, page.indexOf("?")) : page);
        param.setDefaultConfig(0);
        List list = this.getList(param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (ShareEntity)list.get(0);
        }
        String[] pageUrls = page.split("/");
        page = pageUrls[pageUrls.length - 1].split("\\.")[0];
        if (4 == platformId) {
            page = pageUrls[pageUrls.length - 1].split("\\?")[0];
        }
        param.setPageName(page);
        list = this.getList(param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (ShareEntity)list.get(0);
        }
        return this.getDefaultShareEntity();
    }

    private ShareEntity getDefaultShareEntity() {
        ShareEntity param = new ShareEntity();
        param.setDefaultConfig(1);
        List listDefault = this.getList(param);
        if (listDefault != null && listDefault.size() > 0) {
            return (ShareEntity)listDefault.get(0);
        }
        param.setShareDigest("\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec");
        param.setShareTitle("\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec");
        param.setShareImageUrl("imgStorage/3075236650530049932.png");
        return param;
    }

    @Override
    public BaseJsonVo getShare(String pageUrl, String inviteCode, String productId, Integer groupType, int platformId) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(pageUrl == null ? "" : pageUrl).append(platformId).append(inviteCode == null ? "" : inviteCode).append(productId == null ? "" : productId).append(groupType == null ? "" : groupType);
        String key = MD5.sign((String)keyBuilder.toString());
        Object cacheData = this.redisCacheUtil.get(key);
        if (cacheData != null) {
            return BaseJsonVo.success((Object)((Map)cacheData));
        }
        if (StringUtils.isEmpty((String)pageUrl)) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u914d\u7f6e\u5206\u4eab");
        }
        if (pageUrl.endsWith("/")) {
            pageUrl = pageUrl + "index.html";
        }
        HashMap<String, String> shareMap = new HashMap<String, String>();
        shareMap.put("qrcodeUrl", "");
        ShareEntity share = StringUtils.isNotEmpty((String)productId) ? this.getProductShare(productId) : this.findByPage(pageUrl, platformId);
        shareMap.put("title", StringUtil.isEmpty((String)share.getShareTitle()) ? null : this.getShareProductContent(share.getShareTitle(), "\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec", productId, groupType));
        shareMap.put("digest", StringUtil.isEmpty((String)share.getShareDigest()) ? null : this.getShareProductContent(share.getShareDigest(), "\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec", productId, groupType));
        if (StringUtils.isEmpty((String)share.getShareUrl())) {
            share.setShareUrl(pageUrl);
        }
        shareMap.put("imageUrl", this.getShareProudctPic(share.getShareImageUrl1(), share.getShareImageUrl(), productId, groupType));
        shareMap.put("ncp_bat", inviteCode);
        this.redisCacheUtil.set(key, shareMap, Long.valueOf(3600L));
        return BaseJsonVo.success(shareMap);
    }

    private ShareEntity getProductShare(String productId) {
        MallProductEntity productEntity = this.productInterface.getProduct(productId);
        if (productEntity == null || productEntity.getProState() == 1) {
            return new ShareEntity();
        }
        ShareEntity share = new ShareEntity();
        String title = "@\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec \u60f3\u9080\u8bf7\u4f60\u4e00\u8d77\u901b\u4e00\u901b\u4e50\u7eaf\u535a\u7269\u9986";
        String digest = "\u6211\u6b63\u5728\u4e50\u7eaf\u535a\u7269\u9986\u53c2\u89c2\uff0c\u91cc\u9762\u7684\u85cf\u54c1\u7adf\u7136\u4f1a\u8bf4\u8bdd\u3002#\u4e50\u7eaf\u535a\u7269\u9986\u91cc\u9762\u7684\u85cf\u54c1\u7adf\u7136\u6d3b\u8fc7\u6765\u4e86\uff0c\u5feb\u6765\u770b\u770b\uff01";
        Object titleObject = this.redisCacheUtil.get("MUSEUM_SHARE_TITLE");
        Object digestObject = this.redisCacheUtil.get("MUSEUM_SHARE_DIGEST");
        if (titleObject != null) {
            title = titleObject.toString().replace("{productName}", productEntity.getProName()).replace("{nickName}", "\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec");
        }
        if (digestObject != null) {
            digest = digestObject.toString().replace("{productName}", productEntity.getProName()).replace("{nickName}", "\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec");
        }
        share.setShareTitle(title);
        share.setShareDigest(digest);
        share.setShareImageUrl("1000/sysImg/BF429A38-3F40-49FF-8A13-00F0132FE482.png");
        return share;
    }

    private String getShareProudctPic(String picParam, String picDefault, String productId, Integer groupType) {
        List<String> lst;
        Map<String, Integer> map;
        String defaultpicUrl;
        String string = defaultpicUrl = StringUtil.isEmpty((String)picDefault) ? null : this.ossService.getImageResoure(picDefault);
        if (StringUtils.isNotEmpty((String)productId) && groupType != null && (map = this.getPicIndexByPicParam(picParam, groupType)) != null && (lst = this.mallProductPicInterface.getProductPicUrl(productId = this.getrealId(productId, groupType), map.get("picType"))) != null && lst.size() > 0) {
            String picurl = "";
            if (lst.size() > map.get("index")) {
                picurl = lst.get(map.get("index"));
                if (StringUtils.isEmpty((String)picurl)) {
                    picurl = lst.get(0);
                }
            } else {
                picurl = lst.get(0);
            }
            if (StringUtils.isNotEmpty((String)picurl)) {
                return picurl;
            }
        }
        return defaultpicUrl;
    }

    private String getrealId(String productId, Integer groupType) {
        MallPromotionProductEntity promotionProductEntity;
        if (groupType == 1 && (promotionProductEntity = this.mallPromotionProductInterface.getPromotionProductEntity(productId)) != null) {
            return promotionProductEntity.getPromotionProductId();
        }
        return productId;
    }

    private Map<String, Integer> getPicIndexByPicParam(String picParam, Integer groupType) {
        if (StringUtils.isEmpty((String)picParam)) {
            return null;
        }
        try {
            String[] c = picParam.split("\\[");
            if (c.length == 2) {
                String pic = c[0];
                pic = pic.replace("{", "").trim();
                Integer index = Integer.parseInt(c[1].split("\\]")[0].trim());
                Integer picType = this.getPicType(pic, groupType);
                HashedMap map = new HashedMap();
                map.put("picType", picType);
                map.put("index", index);
                return map;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Integer getPicType(String picParam, Integer groupType) {
        Integer pre = 0;
        if (groupType == 1) {
            pre = 100;
        }
        if (groupType == 2) {
            pre = 50;
        }
        if (groupType == 4) {
            pre = 0;
        }
        if (groupType == 5) {
            pre = 150;
        }
        switch (picParam) {
            case "picBig": {
                return pre + 1;
            }
            case "picList": {
                return pre + 2;
            }
            case "picNutrition": {
                return pre + 3;
            }
            case "picBuy": {
                return pre + 4;
            }
            case "picSmall": {
                return pre + 5;
            }
            case "picDetail": {
                return pre + 6;
            }
            case "picRecommend": {
                return pre + 7;
            }
        }
        return pre + 5;
    }

    @Override
    public String getShareProductContent(String content, String nickName, String productId, Integer groupType) {
        MallProductGroupEntity productEntity;
        if (StringUtil.isNotEmpty((String)nickName)) {
            content = content.replace("{nickName}", nickName);
        }
        if (groupType == null || productId == null) {
            return this.replaceEmptyTagContent(content);
        }
        if (groupType == 1) {
            MallPromotionEntity productEntity2 = this.promotionInterface.getPromotion(productId);
            if (productEntity2 != null) {
                content = this.replaceContent(content, productEntity2);
            }
        } else if (groupType == 4) {
            MallProductEntity productEntity3 = this.productInterface.getProduct(productId);
            if (productEntity3 != null) {
                content = this.replaceContent(content, productEntity3);
            }
        } else if (groupType == 2 && (productEntity = this.groupInterface.getGroup(productId)) != null) {
            content = this.replaceContent(content, productEntity);
        }
        return this.replaceEmptyTagContent(content);
    }

    private <T> String replaceEmptyTagContent(String content) {
        List<String> filters = this.extractMessageByRegular(content);
        for (String b : filters) {
            content = content.replace("{" + b + "}", "");
        }
        return content;
    }

    private <T> String replaceContent(String content, T t) {
        try {
            List<String> filters = this.extractMessageByRegular(content);
            for (String b : filters) {
                Object value = BeanUtils.getFieldValue(t, (String)b);
                if (value == null) continue;
                content = content.replace("{" + b + "}", value.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    public List<String> extractMessageByRegular(String msg) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern p = Pattern.compile("\\{([^}]*)\\}");
        Matcher m = p.matcher(msg);
        while (m.find()) {
            list.add(m.group().substring(1, m.group().length() - 1));
        }
        return list;
    }

    @Override
    public BaseJsonVo getDefaultShare(String pageUrl, String inviteCode, String productId, Integer groupType) {
        Map<String, String> shareMap = new HashMap<String, String>();
        ShareEntity share = this.getDefaultShareEntity();
        String key = "DefaultShare:" + (pageUrl == null ? "" : pageUrl) + (inviteCode == null ? "" : inviteCode) + (productId == null ? "" : productId) + (groupType == null ? "" : groupType);
        Object o = this.redisCacheUtil.get(key = MD5.sign((String)key));
        if (o != null) {
            shareMap = (Map)o;
            return BaseJsonVo.success(shareMap);
        }
        try {
            shareMap.put("title", StringUtil.isEmpty((String)share.getShareTitle()) ? null : MessageFormat.format(share.getShareTitle(), "\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec"));
            shareMap.put("digest", StringUtil.isEmpty((String)share.getShareDigest()) ? null : MessageFormat.format(share.getShareDigest(), "\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec"));
            shareMap.put("imageUrl", StringUtil.isEmpty((String)share.getShareImageUrl()) ? null : this.ossService.getImageResoure(share.getShareImageUrl()));
            shareMap.put("url", (String)(StringUtil.isEmpty((String)share.getShareUrl()) ? (pageUrl == null ? null : pageUrl) : share.getShareUrl()));
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u9ed8\u8ba4\u5206\u4eab\u8bbe\u7f6e\u51fa\u9519", (Throwable)e);
            shareMap.put("title", "");
            shareMap.put("digest", "");
            shareMap.put("url", "");
            shareMap.put("imageUrl", "");
        }
        this.logger.info("\u5206\u4eaburl:{}", shareMap.get("url"));
        shareMap.put("ncp_bat", inviteCode);
        this.redisCacheUtil.set(key, shareMap, Long.valueOf(600L));
        return BaseJsonVo.success(shareMap);
    }
}

