/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution.inviteGift;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveInviteLogEntity;
import cc.lechun.active.entity.invite.ActiveInviteDetailEntity;
import cc.lechun.active.entity.invite.ActiveInviteEntity;
import cc.lechun.active.iservice.active.ActiveCommonInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActiveInviteLogInterface;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.distribution.ActiveGiftInviteInfoVo;
import cc.lechun.mall.entity.distribution.ActiveGiftPropertyInfoVo;
import cc.lechun.mall.entity.distribution.ActiveGiftTakedAuthVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import cc.lechun.mall.service.distribution.inviteGift.BaseInviteGift;
import cc.lechun.mall.service.distribution.inviteGift.InviteGiftHandle;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="inviteGift_33")
public class DeliverProductHandle
implements InviteGiftHandle {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ActiveInviteLogInterface activeInviteLogInterface;
    @Autowired
    private MallProductPicInterface picService;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private ActivePropertyInterface activePropertyInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private RedisService redisService;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private ActiveInviteInterface activeInviteInterface;
    @Autowired
    MallOrderProductInterface orderProductInterface;
    @Autowired
    ActiveCommonInterface activeCommonInterface;
    @Autowired
    private TemplateMessageInterface templateMessageInterface;
    @Autowired
    BaseInviteGift baseInviteGift;

    @Override
    public BaseJsonVo<ActiveGiftInviteInfoVo> getActiveGiftInviteInfoVo(ActiveEntity activeEntity, String customerId, Integer platformId) {
        ActiveGiftInviteInfoVo activeGiftInviteInfoVo = new ActiveGiftInviteInfoVo();
        String bindCode = activeEntity.getBindCode();
        ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = this.baseInviteGift.getActiveGiftPropertyInfoVo(bindCode);
        BeanUtils.copyProperties((Object)activeGiftPropertyInfoVo, (Object)activeGiftInviteInfoVo);
        activeGiftInviteInfoVo.setShareSuccessDesc(activeGiftPropertyInfoVo.getShareSuccessDesc());
        activeGiftInviteInfoVo.setTemplateMessageList(this.templateMessageInterface.getTempMessageListBySence(9, platformId));
        activeGiftInviteInfoVo.setActivePicList(this.picService.getProductPicUrlMap(activeEntity.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue()));
        activeGiftInviteInfoVo.setBindCode(bindCode);
        activeGiftInviteInfoVo.setProductName(activeGiftPropertyInfoVo.getProductName());
        activeGiftInviteInfoVo.setStatus(1);
        BaseJsonVo baseJsonVo = this.activeInterface.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            activeGiftInviteInfoVo.setStatus(0);
            activeGiftInviteInfoVo.setReson(baseJsonVo.getMessage());
            return BaseJsonVo.success((Object)activeGiftInviteInfoVo);
        }
        ActiveInviteEntity activeInviteEntity = this.activeInviteInterface.getActiveInviteEntity(customerId, bindCode, activeEntity);
        activeGiftInviteInfoVo.setPrice(activeGiftPropertyInfoVo.getPrice());
        activeGiftInviteInfoVo.setStatus(activeInviteEntity.getInviteCount() >= 1 ? 1 : 0);
        activeGiftInviteInfoVo.setRemain(activeInviteEntity.getInviteCount());
        activeGiftInviteInfoVo.setReson(activeInviteEntity.getInviteCount() >= 1 ? "" : activeGiftPropertyInfoVo.getNotHasGiftDesc());
        return BaseJsonVo.success((Object)activeGiftInviteInfoVo);
    }

    @Override
    public BaseJsonVo<ActiveGiftTakedAuthVo> getActiveGiftTakedInfoVo(String source, ActiveEntity activeEntity, String customerId) {
        CustomerEntity customerEntity;
        String bindCode = activeEntity.getBindCode();
        this.logger.info("\u9080\u8bf7\u4eba:{},\u6d3b\u52a8bindCode={},\u53c2\u4e0e\u7528\u6237:{}", new Object[]{source, bindCode, customerId});
        ActiveInviteLogEntity activeInviteLogEntity = new ActiveInviteLogEntity();
        activeInviteLogEntity.setBindCode(bindCode);
        activeInviteLogEntity.setInviteId(source);
        activeInviteLogEntity.setCustomerId(customerId);
        activeInviteLogEntity.setCreateTime(DateUtils.now());
        activeInviteLogEntity.setFromStatus(0);
        activeInviteLogEntity.setOrderMainNo("");
        activeInviteLogEntity.setMessage("\u6253\u5f00\u9080\u8bf7\u8fde\u63a5");
        this.activeInviteLogInterface.saveInviteLog(activeInviteLogEntity);
        ActiveGiftTakedAuthVo activeGiftTakedAuthVo = new ActiveGiftTakedAuthVo();
        activeGiftTakedAuthVo.setActivePicList(this.picService.getProductPicUrlMap(activeEntity.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue()));
        ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = this.baseInviteGift.getActiveGiftPropertyInfoVo(bindCode);
        BeanUtils.copyProperties((Object)activeGiftPropertyInfoVo, (Object)activeGiftTakedAuthVo);
        activeGiftTakedAuthVo.setCanTakedStatus(1);
        activeGiftTakedAuthVo.setHeadImageUrl("");
        activeGiftTakedAuthVo.setNickName("");
        if (StringUtils.isEmpty((String)source)) {
            ActiveInviteDetailEntity activeInviteDetailEntity = this.activeInviteInterface.getActiveInviteDetailEntity(customerId, bindCode);
            if (activeInviteDetailEntity == null) {
                activeGiftTakedAuthVo.setCanTakedStatus(0);
                this.logger.info("\u7528\u6237:{},\u9080\u8bf7\u4eba\u4e3a\u7a7a", (Object)customerId);
                activeGiftTakedAuthVo.setReson("\u9700\u8981\u901a\u8fc7\u9080\u8bf7\u9886\u53d6\u5662~~");
                return BaseJsonVo.success((Object)activeGiftTakedAuthVo);
            }
            source = activeInviteDetailEntity.getCustomerId();
        }
        if ((customerEntity = this.customerInterface.getCustomer(source)) == null) {
            activeGiftTakedAuthVo.setCanTakedStatus(0);
            activeGiftTakedAuthVo.setReson("\u9700\u8981\u7ecf\u8fc7\u9080\u8bf7\u624d\u80fd\u9886\u53d6\u793c\u7269\u5662~~~");
            this.logger.info("\u7528\u6237\uff1a{}\u9080\u8bf7\u4eba\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u9886\u53d6\u793c\u7269\u4e86", (Object)customerId);
            return BaseJsonVo.success((Object)activeGiftTakedAuthVo);
        }
        activeGiftTakedAuthVo.setNickName(customerEntity.getNickName());
        activeGiftTakedAuthVo.setHeadImageUrl(customerEntity.getHeadImageUrl());
        if (Objects.equals(source, customerId)) {
            activeGiftTakedAuthVo.setCanTakedStatus(0);
            activeGiftTakedAuthVo.setReson(activeGiftPropertyInfoVo.getNotAllowSelfTakedDesc());
            return BaseJsonVo.success((Object)activeGiftTakedAuthVo);
        }
        BaseJsonVo baseJsonVo = this.activeInterface.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            this.logger.info("\u6d3b\u52a8\uff1a{},{}\u4e0d\u80fd\u9080\u8bf7\u4e86", (Object)activeEntity.getActiveName(), (Object)baseJsonVo.getMessage());
            return BaseJsonVo.success((Object)activeGiftTakedAuthVo);
        }
        int orderNo = this.orderProductInterface.getUserCategoryBuyCount(customerId, Integer.parseInt(activeGiftPropertyInfoVo.getProductCategoryId()));
        this.logger.info("\u7528\u6237:{},\u54c1\u7c7b:{},\u5355\u6570:{}", new Object[]{customerId, activeGiftPropertyInfoVo.getProductCategoryId(), orderNo});
        activeGiftTakedAuthVo.setCanTakedStatus(1);
        if (orderNo > 0) {
            this.logger.info("\u7528\u6237\uff1a{}\u4e0d\u662f\u5546\u54c1:{}\u65b0\u7528\u6237,\u7528\u6237\u8be5\u54c1\u7c7b\u8ba2\u5355\u6570:{} \u4e0d\u80fd\u9886\u53d6\u793c\u7269\u4e86", new Object[]{customerId, activeGiftPropertyInfoVo.getProductName(), orderNo});
            activeGiftTakedAuthVo.setCanTakedStatus(0);
            activeGiftTakedAuthVo.setReson(activeGiftPropertyInfoVo.getNotAllowOldUserTakedDesc());
            return BaseJsonVo.success((Object)activeGiftTakedAuthVo);
        }
        this.activeInviteInterface.saveActiveInvite(source, bindCode, customerId);
        activeGiftTakedAuthVo.setSubscribe((Integer)((Map)this.activeCommonInterface.checkUserSubscribe(customerId, PlatFormEnum.LECHUN_WECHAT_MAIN.getValue()).getValue()).get("subscribe"));
        if (activeGiftTakedAuthVo.getSubscribe() == 0) {
            activeGiftTakedAuthVo.setReson("\u9700\u8981\u5173\u6ce8\u516c\u4f17\u53f7\u624d\u80fd\u9886\u53d6\u5662~~");
            activeGiftTakedAuthVo.setArticleUrl(activeGiftPropertyInfoVo.getArticleUrl());
        }
        this.logger.info("\u7528\u6237{}\u5173\u6ce8\u516c\u4f17\u53f7\u72b6\u6001:{} 1 \u5df2\u5173\u6ce8 0 \u672a\u5173\u6ce8", (Object)customerId, (Object)activeGiftTakedAuthVo.getSubscribe());
        activeGiftTakedAuthVo.setNeedAuth(1);
        if (this.redisService.get(customerId + ":author") == null) {
            activeGiftTakedAuthVo.setReson("\u9700\u8981\u6388\u6743\u7528\u6237\u4fe1\u606f\u624d\u80fd\u9886\u53d6\u5662~~");
            activeGiftTakedAuthVo.setNeedAuth(0);
        }
        this.logger.info("\u7528\u6237{} \u6388\u6743\u5934\u50cf\u6635\u79f0\u72b6\u6001:{} 0 \u672a\u6388\u6743\uff0c1 \u5df2\u6388\u6743", (Object)customerId, (Object)activeGiftTakedAuthVo.getNeedAuth());
        activeGiftTakedAuthVo.setQywxStatus(StringUtils.isNotEmpty((String)this.customerInterface.getQiyeweixinContactor(customerId)) ? 1 : 0);
        if (activeGiftTakedAuthVo.getQywxStatus() == 0) {
            activeGiftTakedAuthVo.setReson("\u9700\u8981\u6dfb\u52a0\u4f01\u4e1a\u5fae\u4fe1\u624d\u80fd\u9886\u53d6\u5662~~");
            activeGiftTakedAuthVo.setArticleUrl(activeGiftPropertyInfoVo.getArticleUrl());
        }
        this.logger.info("\u7528\u6237{} \u52a0\u4f01\u4e1a\u5fae\u4fe1\u72b6\u6001:{} 0 \u52a0\uff0c1 \u5df2\u52a0", (Object)customerId, (Object)activeGiftTakedAuthVo.getQywxStatus());
        return BaseJsonVo.success((Object)activeGiftTakedAuthVo);
    }

    @Override
    public BaseJsonVo takedGift(String source, ActiveEntity activeEntity, String customerId) {
        String bindCode = activeEntity.getBindCode();
        this.logger.info(" \u9080\u8bf7\u4eba:{},\u6d3b\u52a8bindCode={},\u53c2\u4e0e\u7528\u6237:{}", new Object[]{source, bindCode, customerId});
        ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = this.baseInviteGift.getActiveGiftPropertyInfoVo(bindCode);
        int orderNo = this.orderProductInterface.getUserCategoryBuyCount(customerId, Integer.parseInt(activeGiftPropertyInfoVo.getProductCategoryId()));
        if (orderNo > 0) {
            this.logger.info("\u7528\u6237\uff1a{}\u4e0d\u662f\u5546\u54c1:{}\u65b0\u7528\u6237,\u7528\u6237\u8be5\u54c1\u7c7b\u8ba2\u5355\u6570:{}", new Object[]{customerId, activeGiftPropertyInfoVo.getProductName(), orderNo});
            return BaseJsonVo.error((String)activeGiftPropertyInfoVo.getNotAllowOldUserTakedDesc());
        }
        if (StringUtils.isEmpty((String)source)) {
            ActiveInviteDetailEntity activeInviteDetailEntity = this.activeInviteInterface.getActiveInviteDetailEntity(customerId, bindCode);
            if (activeInviteDetailEntity == null) {
                this.logger.info("\u70b9\u51fb\u9886\u53d6\u6309\u94ae\uff0c\u7528\u6237:{},\u9080\u8bf7\u4eba\u4e3a\u7a7a", (Object)customerId);
                return BaseJsonVo.error((String)"\u9700\u8981\u901a\u8fc7\u9080\u8bf7\u9886\u53d6\u5662~~");
            }
            source = activeInviteDetailEntity.getCustomerId();
        }
        if (Objects.equals(source, customerId)) {
            return BaseJsonVo.error((String)activeGiftPropertyInfoVo.getNotAllowSelfTakedDesc());
        }
        ActiveInviteEntity activeInviteEntity = this.activeInviteInterface.getActiveInviteEntity(source, bindCode);
        if (activeInviteEntity == null) {
            return BaseJsonVo.error((String)"\u9700\u8981\u901a\u8fc7\u9080\u8bf7\u9886\u53d6\u5662~~");
        }
        if (activeInviteEntity.getInviteCount() <= 0) {
            return BaseJsonVo.error((String)activeGiftPropertyInfoVo.getNotHasGiftDesc());
        }
        int subcript = (Integer)((Map)this.activeCommonInterface.checkUserSubscribe(customerId, PlatFormEnum.LECHUN_WECHAT_MAIN.getValue()).getValue()).get("subscribe");
        this.logger.info("\u7528\u6237{}\u5173\u6ce8\u516c\u4f17\u53f7\u72b6\u6001:{} 1 \u5df2\u5173\u6ce8 0 \u672a\u5173\u6ce8", (Object)customerId, (Object)subcript);
        if (subcript == 0) {
            return BaseJsonVo.error((String)"\u9700\u8981\u5173\u6ce8\u516c\u4f17\u53f7\u624d\u80fd\u9886\u53d6\u793c\u7269\u5662~~");
        }
        if (this.redisService.get(customerId + ":author") == null) {
            return BaseJsonVo.error((String)"\u9700\u8981\u6388\u6743\u7528\u6237\u5934\u50cf\u6635\u79f0\u8003\u9a8c\u9886\u53d6\u793c\u7269\u5662~~");
        }
        this.logger.info("\u7528\u6237{}\u5df2\u6388\u6743\u5934\u50cf\u6635\u79f0 ", (Object)customerId);
        if (StringUtils.isEmpty((String)this.customerInterface.getQiyeweixinContactor(customerId))) {
            return BaseJsonVo.error((String)"\u9700\u8981\u6dfb\u52a0\u4f01\u4e1a\u5fae\u4fe1\u597d\u53cb\u624d\u80fd\u9886\u53d6\u793c\u7269\u5662~~");
        }
        this.logger.info("\u7528\u6237{} \u5df2\u52a0\u4f01\u4e1a\u5fae\u4fe1", (Object)customerId);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo updateInviteWithoutOrder(String source, ActiveEntity activeEntity, String customerId, String phone, Integer platFormId) {
        this.logger.info("\u65b9\u6cd5updateInviteWithoutOrder\u672a\u5b9e\u73b0 \u5e38\u6e29\u5546\u54c1\u8d70\u7ebf\u4e0a\u914d\u9001");
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo getRechangCode(ActiveEntity activeEntity, String customerId) {
        this.logger.info("\u65b9\u6cd5getRechangCode\u672a\u5b9e\u73b0 \u5e38\u6e29\u5546\u54c1\u8d70\u7ebf\u4e0a\u914d\u9001");
        return BaseJsonVo.success((Object)"");
    }
}

