/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.distribution.inviteGift;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.invite.ActiveInviteDetailEntity;
import cc.lechun.active.entity.invite.RankListBaseVo;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.distribution.ActiveGiftInviteInfoVo;
import cc.lechun.mall.entity.distribution.ActiveGiftPropertyInfoVo;
import cc.lechun.mall.entity.distribution.ActiveGiftTakedAuthVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.distribution.BaseInviteGiftInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import cc.lechun.mall.service.distribution.inviteGift.InviteGiftHandle;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="inviteGift_41")
public class RechangeProduct3Handle
implements InviteGiftHandle {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallProductPicInterface picService;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private ActivePropertyInterface activePropertyInterface;
    @Autowired
    private ActiveInviteInterface activeInviteInterface;
    @Autowired
    private TemplateMessageInterface templateMessageInterface;
    @Autowired
    BaseInviteGiftInterface baseInviteGift;
    @Autowired
    private CustomerInterface customerInterface;

    @Override
    public BaseJsonVo<ActiveGiftInviteInfoVo> getActiveGiftInviteInfoVo(ActiveEntity activeEntity, String customerId, Integer platformId) {
        String bindCode = activeEntity.getBindCode();
        this.activeInviteInterface.getActiveInviteEntity(customerId, bindCode, activeEntity);
        ActiveGiftInviteInfoVo activeGiftInviteInfoVo = new ActiveGiftInviteInfoVo();
        ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = this.baseInviteGift.getActiveGiftPropertyInfoVo(bindCode);
        BeanUtils.copyProperties((Object)activeGiftPropertyInfoVo, (Object)activeGiftInviteInfoVo);
        activeGiftInviteInfoVo.setShareSuccessDesc(activeGiftPropertyInfoVo.getShareSuccessDesc());
        activeGiftInviteInfoVo.setTemplateMessageList(this.templateMessageInterface.getTempMessageListBySence(2, platformId));
        activeGiftInviteInfoVo.setActivePicList(this.picService.getProductPicUrlMap(activeEntity.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue()));
        int sort = 0;
        sort = Math.abs(customerId.hashCode()) % activeGiftInviteInfoVo.getActivePicList().get(ProductPicTypeEnum.ACT_HEAD.getName()).size();
        activeGiftInviteInfoVo.setActiveHeadPic(activeGiftInviteInfoVo.getActivePicList().get(ProductPicTypeEnum.ACT_HEAD.getName()).get(sort));
        activeGiftInviteInfoVo.setBindCode(bindCode);
        activeGiftInviteInfoVo.setStatus(1);
        BaseJsonVo baseJsonVo = this.activeInterface.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            activeGiftInviteInfoVo.setStatus(0);
            activeGiftInviteInfoVo.setReson(baseJsonVo.getMessage());
            return BaseJsonVo.success((Object)activeGiftInviteInfoVo);
        }
        activeGiftInviteInfoVo.setStatus(1);
        List<RankListBaseVo> rankListBaseVoList = this.activeInviteInterface.getRankList(bindCode, customerId, (Integer)2);
        if (CollectionUtils.isNotEmpty(rankListBaseVoList)) {
            rankListBaseVoList.forEach(rankListBaseVo -> {
                ActiveGiftInviteInfoVo.InviteCustomer inviteCustomer = new ActiveGiftInviteInfoVo.InviteCustomer();
                inviteCustomer.setHeadImageUrl(rankListBaseVo.getHeadImageUrl());
                activeGiftInviteInfoVo.getInviteCustomerList().add(inviteCustomer);
            });
        }
        return BaseJsonVo.success((Object)activeGiftInviteInfoVo);
    }

    @Override
    public BaseJsonVo<ActiveGiftTakedAuthVo> getActiveGiftTakedInfoVo(String source, ActiveEntity activeEntity, String customerId) {
        CustomerEntity customerEntity;
        String bindCode = activeEntity.getBindCode();
        ActiveGiftTakedAuthVo activeGiftTakedAuthVo = new ActiveGiftTakedAuthVo();
        ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = this.baseInviteGift.getActiveGiftPropertyInfoVo(bindCode);
        BeanUtils.copyProperties((Object)activeGiftPropertyInfoVo, (Object)activeGiftTakedAuthVo);
        if (StringUtils.isNotEmpty((String)source) && (customerEntity = this.customerInterface.getCustomer(source)) != null) {
            activeGiftTakedAuthVo.setNickName(customerEntity.getNickName());
            activeGiftTakedAuthVo.setHeadImageUrl(customerEntity.getHeadImageUrl());
        }
        activeGiftTakedAuthVo.setActivePicList(this.picService.getProductPicUrlMap(activeEntity.getActiveNo(), SalesTypeEnum.SALES_ACTIVE.getValue()));
        BaseJsonVo baseJsonVo = this.activeInterface.checkActiveEnable(activeEntity);
        if (!baseJsonVo.isSuccess()) {
            this.logger.info("\u6d3b\u52a8\uff1a{},{}\u4e0d\u80fd\u9080\u8bf7\u4e86", (Object)activeEntity.getActiveName(), (Object)baseJsonVo.getMessage());
            activeGiftTakedAuthVo.setCanTakedStatus(0);
            activeGiftTakedAuthVo.setReson(baseJsonVo.getMessage());
            return baseJsonVo;
        }
        if (Objects.equals(source, customerId)) {
            activeGiftTakedAuthVo.setCanTakedStatus(0);
            activeGiftTakedAuthVo.setReson(activeGiftPropertyInfoVo.getNotAllowSelfTakedDesc());
            return BaseJsonVo.error((String)"\u4e0d\u80fd\u9080\u8bf7\u81ea\u5df1\u5662~");
        }
        ActiveInviteDetailEntity activeInviteDetailEntity = this.activeInviteInterface.getActiveInviteDetailEntity(customerId, bindCode);
        if (activeInviteDetailEntity != null && StringUtils.isNotEmpty((String)source) && !source.equals(activeInviteDetailEntity.getCustomerId())) {
            activeGiftTakedAuthVo.setCanTakedStatus(0);
            activeGiftTakedAuthVo.setReson("\u5df2\u7ecf\u88ab\u5176\u4ed6\u7528\u6237\u9080\u8bf7\u8fc7\u4e86");
            return BaseJsonVo.error((String)"\u5df2\u7ecf\u88ab\u5176\u4ed6\u7528\u6237\u9080\u8bf7\u8fc7\u4e86");
        }
        activeGiftTakedAuthVo.setCanTakedStatus(1);
        if (StringUtils.isNotEmpty((String)source)) {
            this.activeInviteInterface.saveActiveInvite(source, activeEntity, customerId);
        }
        return BaseJsonVo.success((Object)activeGiftTakedAuthVo);
    }

    @Override
    public BaseJsonVo takedGift(String source, ActiveEntity activeEntity, String customerId) {
        String bindCode = activeEntity.getBindCode();
        this.logger.info(" \u9080\u8bf7\u4eba:{},\u6d3b\u52a8bindCode={},\u53c2\u4e0e\u7528\u6237:{}", new Object[]{source, bindCode, customerId});
        return this.setInviteSuccess(source, activeEntity, customerId);
    }

    @Override
    public BaseJsonVo updateInviteWithoutOrder(String source, ActiveEntity activeEntity, String customerId, String phone, Integer platFormId) {
        return this.setInviteSuccess(source, activeEntity, customerId);
    }

    private BaseJsonVo setInviteSuccess(String source, ActiveEntity activeEntity, String customerId) {
        String bindCode = activeEntity.getBindCode();
        if (StringUtils.isEmpty((String)source)) {
            ActiveInviteDetailEntity activeInviteDetailEntity = this.activeInviteInterface.getActiveInviteDetailEntity(customerId, bindCode);
            if (activeInviteDetailEntity == null) {
                return BaseJsonVo.error((String)"\u9700\u8981\u901a\u8fc7\u9080\u8bf7\u9886\u53d6\u5662~");
            }
            source = activeInviteDetailEntity.getCustomerId();
        }
        if (Objects.equals(source, customerId)) {
            return BaseJsonVo.error((String)"\u9700\u8981\u5206\u4eab\u7ed9\u597d\u53cb\u624d\u53ef\u4ee5\u5662~");
        }
        this.activeInviteInterface.setActiveInviteSuccess4NoOrder(bindCode, customerId, source);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo getRechangCode(ActiveEntity activeEntity, String customerId) {
        return BaseJsonVo.success((Object)"");
    }
}

