/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.feign;

import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.feign.FeignCallErrorLogMapper;
import cc.lechun.mall.entity.feign.FeignCallErrorLogEntity;
import cc.lechun.mall.iservice.feign.FeignCallErrorLogInterface;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.FeignException;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class FeignCallErrorLogService
extends BaseService<FeignCallErrorLogEntity, Integer>
implements FeignCallErrorLogInterface {
    @Resource
    private FeignCallErrorLogMapper feignCallErrorLogMapper;
    private final ObjectMapper objectMapper = new ObjectMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logFeignError(final String serviceName, final String requestUrl, final String requestMethod, final String requestParams, final Throwable throwable) {
        ExecutorService pool = Executors.newFixedThreadPool(1);
        try {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    FeignCallErrorLogService.this.logger.info("\u4fdd\u5b58\u8c03\u7528\u5f02\u5e38\u65e5\u5fd7");
                    FeignCallErrorLogEntity log = new FeignCallErrorLogEntity();
                    log.setServiceName(serviceName);
                    log.setRequestUrl(requestUrl.length() > 255 ? requestUrl.substring(0, 254) : requestUrl);
                    log.setRequestMethod(requestMethod);
                    log.setRequestParams(requestParams != null ? requestParams : "{}");
                    log.setResponseStatus(throwable != null ? FeignCallErrorLogService.this.getFeignStatus(throwable) : 200);
                    log.setExceptionType(throwable != null ? throwable.getClass().getSimpleName() : "");
                    log.setExceptionMsg(throwable != null ? throwable.getMessage() : "");
                    log.setCreatedAt(new Date());
                    FeignCallErrorLogService.this.feignCallErrorLogMapper.insertSelective(log);
                    FeignCallErrorLogService.this.logger.info("\u4fdd\u5b58\u8c03\u7528\u5f02\u5e38\u65e5\u5fd7\u6210\u529f");
                }
            });
        }
        catch (Exception ex) {
            this.logger.error("\u8bb0\u5f55 Feign \u5f02\u5e38\u65e5\u5fd7\u5931\u8d25", (Throwable)ex);
        }
        finally {
            pool.shutdown();
        }
    }

    private Integer getFeignStatus(Throwable throwable) {
        if (throwable instanceof FeignException) {
            return ((FeignException)throwable).status();
        }
        return null;
    }
}

