/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.item;

import cc.lechun.active.entity.active.IndexActiveVo;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.reserve.ReserveInterface;
import cc.lechun.common.enums.cashticket.CashRuleTypeEnum;
import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.item.IndexItemMapper;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleVo;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.item.BuildPageEntity;
import cc.lechun.mall.entity.item.IndexItemEntity;
import cc.lechun.mall.entity.item.IndexNavEntity;
import cc.lechun.mall.entity.item.IndexNavVo;
import cc.lechun.mall.entity.item.NavTypeEnum;
import cc.lechun.mall.entity.sales.MallIndexGroupVo;
import cc.lechun.mall.entity.sales.MallIndexProductVo;
import cc.lechun.mall.entity.sales.MallIndexPromotionVo;
import cc.lechun.mall.entity.sales.MallProductCategoryEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallOrderProductVo;
import cc.lechun.mall.entity.trade.OrderListVo;
import cc.lechun.mall.iservice.cashticket.CashticketBatchNewRuleInterface;
import cc.lechun.mall.iservice.item.MallBuildPageInterface;
import cc.lechun.mall.iservice.item.MallIndexItemInterface;
import cc.lechun.mall.iservice.item.MallIndexNavInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductCategoryInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallIndexItemService
extends BaseService
implements MallIndexItemInterface {
    @Autowired
    private IndexItemMapper indexItemMapper;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallBuildPageInterface buildPageInterface;
    @Autowired
    private MallIndexNavInterface indexNavInterface;
    @Autowired
    private MallVipInterface vipInterface;
    @Autowired
    private MallIndexItemInterface indexItemInterface;
    @Autowired
    private CashticketBatchNewRuleInterface cashticketBatchNewRuleService;
    @Autowired
    private ReserveInterface reserveInterface;
    @Autowired
    private MallProductCategoryInterface productCategoryInterface;
    @Autowired
    private MallTradeInterface tradeInterface;

    @Override
    @ReadThroughSingleCache(namespace="IndexItemList", expiration=3600)
    public List<IndexItemEntity> getList(@ParameterValueKeyProvider String navId) {
        IndexItemEntity indexItemEntity = new IndexItemEntity();
        indexItemEntity.setNavId(navId);
        List indexItemEntities = this.indexItemMapper.getList(indexItemEntity);
        if (indexItemEntities != null && indexItemEntities.size() > 0) {
            indexItemEntities.sort((c1, c2) -> c1.getItemSn().compareTo(c2.getItemSn()));
        }
        return indexItemEntities;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallIndexItemService.getIndexItemEntity", expiration=600)
    public IndexItemEntity getIndexItemEntity(@ParameterValueKeyProvider(order=0) String proId, @ParameterValueKeyProvider(order=1) Integer saleType, @ParameterValueKeyProvider(order=2) Integer platformId) {
        return this.indexItemMapper.getIndexItemEntity(proId, saleType, platformId);
    }

    @Override
    public BaseJsonVo getIndexNavProductList(Integer platformId, String customerId, int itemType, Integer vipLevel) {
        if (StringUtils.isEmpty((String)customerId)) {
            return this.indexItemInterface.getIndexNavProductListWithoutSpeedupNoLogin(platformId, customerId, itemType);
        }
        return this.indexItemInterface.getIndexNavProductListWithoutSpeedup(platformId, customerId, itemType, vipLevel);
    }

    @Override
    public IndexNavVo getIndexNavVo(String indexNavId, String customerId, Integer platformId) {
        IndexNavEntity indexNavEntity = this.indexNavInterface.getIndexNav(indexNavId);
        List<IndexNavEntity> navs = this.indexNavInterface.getEnableIndexNavList(platformId);
        String isVip = this.vipInterface.isVipDayNow() != false ? "isvipday" : "notvipday";
        return this.getIndexNavVo(indexNavEntity, isVip, navs, customerId, platformId, 0);
    }

    @Override
    @ReadThroughSingleCache(namespace="IndexNavProductList", expiration=120)
    public List<IndexNavVo> getIndexNavProductListWithoutSpeedupNoLogin(final @ParameterValueKeyProvider(order=0) Integer platformId, final @ParameterValueKeyProvider(order=1) String customerId, @ParameterValueKeyProvider(order=2) Integer itemType, @ParameterValueKeyProvider(order=3) String ticketBatchId) {
        List<IndexNavEntity> navs = this.indexNavInterface.getEnableIndexNavList(platformId);
        final ArrayList<IndexNavVo> navVos = new ArrayList<IndexNavVo>();
        final String isVip = this.vipInterface.isVipDayNow() != false ? "isvipday" : "notvipday";
        final List<CashticketBatchNewRuleVo> ruleVoList = this.cashticketBatchNewRuleService.getCashRule(ticketBatchId);
        final List<MallProductCategoryEntity> categoryListlist = this.productCategoryInterface.getCategoryList();
        try {
            ExecutorService pool = Executors.newFixedThreadPool(navs.size());
            for (final IndexNavEntity nav : navs) {
                pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        List<IndexItemEntity> indexItemEntities = MallIndexItemService.this.indexItemInterface.getList(nav.getIndexNavId());
                        IndexNavVo indexNavVo = new IndexNavVo();
                        indexNavVo.setIndexNavId(nav.getIndexNavId());
                        indexNavVo.setCountDown(nav.getCountdown());
                        indexNavVo.setModuleId(nav.getBuildPageId());
                        indexNavVo.setNavModuleId(nav.getNavBuildPageId());
                        indexNavVo.setTerminal(nav.getPlatformId());
                        indexNavVo.setNavName(nav.getNavName());
                        indexNavVo.setNavName1(nav.getNavName1());
                        indexNavVo.setNavName2(nav.getNavName2());
                        indexNavVo.setNavName3(nav.getNavName3());
                        indexNavVo.setNavSn(nav.getNavSn());
                        indexNavVo.setNavIcon(nav.getNavIcon());
                        indexNavVo.setIsvipday(isVip);
                        indexNavVo.setPlatformId(nav.getPlatformId());
                        indexNavVo.setParentIndexNavId(nav.getParentIndexNavId());
                        ArrayList<Object> objects = new ArrayList<Object>();
                        ArrayList<MallIndexPromotionVo> removeobjects = new ArrayList<MallIndexPromotionVo>();
                        MallIndexPromotionVo indexPromotionVo = new MallIndexPromotionVo();
                        MallIndexGroupVo indexGroupVo = new MallIndexGroupVo();
                        MallIndexProductVo indexProductVo = new MallIndexProductVo();
                        if (CollectionUtils.isNotEmpty(indexItemEntities)) {
                            for (IndexItemEntity indexItemEntity : indexItemEntities) {
                                if (!CollectionUtils.isNotEmpty((Collection)ruleVoList)) continue;
                                if (indexItemEntity.getItemType().equals("1")) {
                                    indexPromotionVo = MallIndexItemService.this.getIndexPromotion(customerId, platformId, indexItemEntity, 0);
                                    if (indexPromotionVo == null || !indexPromotionVo.getValid().booleanValue()) {
                                        MallIndexItemService.this.logger.info("\u4fc3\u9500:{},{}", (Object)indexPromotionVo.getPromotionId(), (Object)indexPromotionVo.getInvalidReason());
                                        continue;
                                    }
                                } else if (indexItemEntity.getItemType().equals("4")) {
                                    indexProductVo = MallIndexItemService.this.getIndexProduct(customerId, platformId, indexItemEntity, true, 0);
                                } else if (indexItemEntity.getItemType().equals("2")) {
                                    indexGroupVo = MallIndexItemService.this.getIndexGroup(customerId, platformId, indexItemEntity);
                                }
                                for (CashticketBatchNewRuleVo ruleVo : ruleVoList) {
                                    String pro;
                                    int n;
                                    int n2;
                                    String[] arr;
                                    if (indexItemEntity.getItemType().equals("1")) {
                                        MallPromotionVO promotionVO;
                                        BaseJsonVo promotionVOBaseJsonVo;
                                        if (!Objects.equals(indexPromotionVo.getUseCoupon(), 1) || indexPromotionVo == null || !indexPromotionVo.getValid().booleanValue()) continue;
                                        arr = ruleVo.getDetailIds().split(",");
                                        boolean canUsed = false;
                                        if (ruleVo.getRuleType().intValue() == CashRuleTypeEnum.cuxiao.getValue()) {
                                            String[] stringArray = arr;
                                            n2 = stringArray.length;
                                            for (n = 0; n < n2; ++n) {
                                                pro = stringArray[n];
                                                if (!Objects.equals(pro, indexItemEntity.getProId())) continue;
                                                canUsed = true;
                                                break;
                                            }
                                        } else if (ruleVo.getRuleType().intValue() == CashRuleTypeEnum.product_class.getValue() && (promotionVOBaseJsonVo = MallIndexItemService.this.promotionInterface.buildPromotionVO(indexPromotionVo.getPromotionId(), 1, true)).isSuccess() && (promotionVO = (MallPromotionVO)promotionVOBaseJsonVo.getValue()).getValid().booleanValue()) {
                                            if (promotionVO.getProductType().equals(String.valueOf(SalesTypeEnum.SALES_GROUP.getValue()))) {
                                                for (MallProductVO productVO : promotionVO.getGroup().getProductList()) {
                                                    canUsed = false;
                                                    canUsed = MallIndexItemService.this.checkCategoryUsedCash(arr, categoryListlist, productVO.getProductCategoryId());
                                                    if (canUsed) continue;
                                                    break;
                                                }
                                            } else if (promotionVO.getProductType().equals(String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()))) {
                                                canUsed = false;
                                                canUsed = MallIndexItemService.this.checkCategoryUsedCash(arr, categoryListlist, promotionVO.getProduct().getProductCategoryId());
                                            }
                                        }
                                        if (!canUsed) continue;
                                        objects.add(indexPromotionVo);
                                        if (indexPromotionVo.getEndTime().before(DateUtils.now())) {
                                            removeobjects.add(indexPromotionVo);
                                        }
                                        if (nav.getCountdown() != 1) continue;
                                        indexNavVo.setSecond(indexPromotionVo.getSecond());
                                        indexNavVo.setSeconds(indexPromotionVo.getSeconds());
                                        indexNavVo.setBeginTime(indexPromotionVo.getBeginTime());
                                        indexNavVo.setEndTime(indexPromotionVo.getEndTime());
                                        indexNavVo.setHour(indexPromotionVo.getHour());
                                        indexNavVo.setMinute(indexPromotionVo.getMinute());
                                        continue;
                                    }
                                    if (indexItemEntity.getItemType().equals("4")) {
                                        arr = ruleVo.getDetailIds().split(",");
                                        if (indexProductVo == null) continue;
                                        boolean canUsed = false;
                                        if (ruleVo.getRuleType().intValue() == CashRuleTypeEnum.danpin.getValue()) {
                                            String[] promotionVOBaseJsonVo = arr;
                                            n2 = promotionVOBaseJsonVo.length;
                                            for (n = 0; n < n2; ++n) {
                                                pro = promotionVOBaseJsonVo[n];
                                                if (!pro.equals(indexProductVo.getProductId())) continue;
                                                canUsed = true;
                                                break;
                                            }
                                        } else if (ruleVo.getRuleType().intValue() == CashRuleTypeEnum.product_class.getValue()) {
                                            MallProductEntity productEntity = MallIndexItemService.this.productInterface.getProduct(indexProductVo.getProductId());
                                            canUsed = MallIndexItemService.this.checkCategoryUsedCash(arr, categoryListlist, productEntity.getProductCategoryId());
                                            MallIndexItemService.this.logger.info("\u5546\u54c1:{},\u54c1\u7c7b:{},\u662f\u5426\u53ef\u7528\u5238:{}", new Object[]{indexProductVo.getProductName(), productEntity.getProductCategoryId(), canUsed});
                                        }
                                        if (!canUsed) continue;
                                        objects.add(indexProductVo);
                                        continue;
                                    }
                                    if (!indexItemEntity.getItemType().equals("2")) continue;
                                    arr = ruleVo.getDetailIds().split(",");
                                    if (ruleVo.getRuleType().intValue() != CashRuleTypeEnum.taozhuang.getValue() || indexGroupVo == null) continue;
                                    for (String pro2 : arr) {
                                        if (!pro2.equals(indexItemEntity.getProId())) continue;
                                        objects.add(indexGroupVo);
                                    }
                                }
                            }
                        }
                        if (objects.size() > removeobjects.size()) {
                            objects.removeAll(removeobjects);
                        }
                        if (objects.size() > 0) {
                            indexNavVo.setItems(objects);
                            if (objects.size() > 0) {
                                indexNavVo.setItems(objects);
                            }
                            navVos.add(indexNavVo);
                        }
                    }
                });
            }
            pool.shutdown();
            boolean loop = true;
            while (loop = !pool.awaitTermination(2L, TimeUnit.SECONDS)) {
            }
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
        }
        navVos.sort((c1, c2) -> c1.getNavSn().compareTo(c2.getNavSn()));
        return navVos;
    }

    private boolean checkCategoryUsedCash(String[] arr, List<MallProductCategoryEntity> categoryListlist, String productCategoryId) {
        boolean canUsed = false;
        for (String pro : arr) {
            ArrayList<MallProductCategoryEntity> resultList = new ArrayList<MallProductCategoryEntity>();
            if (!CollectionUtils.isNotEmpty(categoryListlist)) continue;
            List<MallProductCategoryEntity> enableCategoryList = this.getCategoryChildrenList(pro, resultList, categoryListlist);
            this.logger.info("\u54c1\u7c7b:{},\u5b50\u54c1\u7c7b:{}", (Object)pro, (Object)JsonUtils.toJson(enableCategoryList, (boolean)false));
            if (!CollectionUtils.isNotEmpty(enableCategoryList)) continue;
            for (MallProductCategoryEntity categoryEntity : enableCategoryList) {
                if (!Objects.equals(categoryEntity.getCategoryId(), productCategoryId)) continue;
                canUsed = true;
                break;
            }
            if (canUsed) break;
        }
        return canUsed;
    }

    private List<MallProductCategoryEntity> getCategoryChildrenList(String categoryId, List<MallProductCategoryEntity> resultList, List<MallProductCategoryEntity> list) {
        Optional<MallProductCategoryEntity> selfOptional;
        List tempList = list.stream().filter(mallProductCategoryEntity -> Objects.equals(mallProductCategoryEntity.getParentId(), categoryId)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(tempList)) {
            resultList.addAll(tempList);
            Iterator iterator = tempList.iterator();
            if (iterator.hasNext()) {
                MallProductCategoryEntity categoryEntity = (MallProductCategoryEntity)iterator.next();
                return this.getCategoryChildrenList(categoryEntity.getCategoryId(), resultList, list);
            }
        }
        if ((selfOptional = list.stream().filter(mallProductCategoryEntity -> Objects.equals(mallProductCategoryEntity.getCategoryId(), categoryId)).findFirst()).isPresent()) {
            resultList.add(selfOptional.get());
        }
        return resultList;
    }

    @Override
    @ReadThroughSingleCache(namespace="getIndexNavList", expiration=300)
    public List<IndexNavVo> getIndexNavList(@ParameterValueKeyProvider Integer platformId) {
        List<IndexNavEntity> navs = this.indexNavInterface.getEnableIndexNavList(platformId);
        ArrayList<IndexNavVo> tempList = new ArrayList<IndexNavVo>();
        ArrayList<IndexNavVo> result = new ArrayList<IndexNavVo>();
        if (navs != null && navs.size() > 0) {
            String isVip = this.vipInterface.isVipDayNow() != false ? "isvipday" : "notvipday";
            for (IndexNavEntity nav : navs) {
                IndexNavVo indexNavVo = new IndexNavVo();
                BeanUtils.copyProperties((Object)nav, (Object)indexNavVo);
                indexNavVo.setIsvipday(isVip);
                BuildPageEntity buildPageEntity = this.buildPageInterface.getBuildPage(nav.getBuildPageId());
                indexNavVo.setWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
                tempList.add(indexNavVo);
            }
            for (IndexNavVo indexNavVo : tempList) {
                List<IndexNavVo> navsList = tempList.stream().filter(navEntiy -> StringUtils.isNotEmpty((String)navEntiy.getParentIndexNavId()) && navEntiy.getParentIndexNavId().equals(indexNavVo.getIndexNavId())).collect(Collectors.toList());
                if (navsList.size() > 0) {
                    indexNavVo.setChildren(navsList);
                }
                if (!StringUtils.isEmpty((String)indexNavVo.getParentIndexNavId())) continue;
                result.add(indexNavVo);
            }
        }
        return result;
    }

    private BaseJsonVo getIndexNavProductListWithoutSpeedupNoCache(Integer platformId, String customerId, int itemType, Integer vipLevel) {
        Object showNav = this.redisCacheUtil.get("INDEX_SHOW_NAV" + platformId);
        Object showNavIcon = this.redisCacheUtil.get("INDEX_SHOW_NAV_ICON" + platformId);
        Integer[] navShowIcon = new Integer[]{0, 0};
        if (showNav != null && showNav instanceof Integer && (Integer)showNav == 1) {
            navShowIcon[0] = 1;
        }
        if (showNavIcon != null && showNavIcon instanceof Integer && (Integer)showNavIcon == 1) {
            navShowIcon[1] = 1;
        }
        HashMap<String, Serializable> rtnMap = new HashMap<String, Serializable>();
        rtnMap.put("showNav", navShowIcon[0]);
        rtnMap.put("showNavIcon", navShowIcon[1]);
        List<IndexNavEntity> navs = this.indexNavInterface.getEnableIndexNavList(platformId);
        ArrayList<IndexNavVo> navVos = new ArrayList<IndexNavVo>();
        String isVip = this.vipInterface.isVipDayNow() != false ? "isvipday" : "notvipday";
        try {
            ExecutorService pool = Executors.newFixedThreadPool(3);
            for (IndexNavEntity nav : navs) {
                if (!Objects.equals(nav.getIsShow(), 1)) continue;
                pool.execute(() -> {
                    IndexNavVo indexNavVo = this.getIndexNavVo(nav, isVip, navs, customerId, platformId, vipLevel);
                    if (indexNavVo.getNavSn() == null) {
                        indexNavVo.setNavSn(0);
                    }
                    this.logger.info("\u6dfb\u52a0\u9996\u9875\u680f\u76ee:{},\u680f\u76eeid:{}", (Object)indexNavVo.getNavName(), (Object)indexNavVo.getIndexNavId());
                    navVos.add(indexNavVo);
                });
            }
            pool.shutdown();
            boolean loop = true;
            while (loop = !pool.awaitTermination(5L, TimeUnit.SECONDS)) {
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u9996\u9875\u5bfc\u822a\u5f02\u5e38", (Throwable)e);
        }
        if (navVos.size() > 0) {
            try {
                navVos.sort((c1, c2) -> c1.getNavSn().compareTo(c2.getNavSn()));
                navVos.removeIf(c -> StringUtils.isEmpty((String)c.getIndexNavId()));
            }
            catch (Exception e) {
                this.logger.error("\u9996\u9875\u5bfc\u822a\u6392\u5e8f\u5f02\u5e38", (Throwable)e);
            }
            for (IndexNavVo indexNavVo : navVos) {
                List<IndexNavVo> navsList = navVos.stream().filter(navEntiy -> StringUtils.isNotEmpty((String)navEntiy.getParentIndexNavId()) && navEntiy.getParentIndexNavId().equals(indexNavVo.getIndexNavId())).collect(Collectors.toList());
                if (navsList.size() <= 0) continue;
                indexNavVo.setChildren(navsList);
            }
            navVos.removeIf(c -> StringUtils.isNotEmpty((String)c.getParentIndexNavId()));
        }
        rtnMap.put("navs", navVos);
        return BaseJsonVo.success(rtnMap);
    }

    @NotNull
    private IndexNavVo getIndexNavVo(IndexNavEntity nav, String isVip, List<IndexNavEntity> navs, String customerId, Integer platformId, Integer vipLevel) {
        IndexNavVo indexNavVo = new IndexNavVo();
        indexNavVo.setIndexNavId(nav.getIndexNavId());
        indexNavVo.setCountDown(nav.getCountdown());
        indexNavVo.setModuleId(nav.getBuildPageId());
        indexNavVo.setNavModuleId(nav.getNavBuildPageId());
        indexNavVo.setTerminal(nav.getPlatformId());
        indexNavVo.setNavName(nav.getNavName());
        indexNavVo.setNavName1(nav.getNavName1());
        indexNavVo.setNavName2(nav.getNavName2());
        indexNavVo.setNavName3(nav.getNavName3());
        indexNavVo.setNavSn(nav.getNavSn());
        indexNavVo.setNavIcon(nav.getNavIcon());
        indexNavVo.setIsvipday(isVip);
        indexNavVo.setPlatformId(nav.getPlatformId());
        indexNavVo.setParentIndexNavId(nav.getParentIndexNavId());
        BuildPageEntity buildPageEntity = this.buildPageInterface.getBuildPage(nav.getBuildPageId());
        indexNavVo.setWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
        List navsList = navs.stream().filter(navEntiy -> Objects.equals(navEntiy.getParentIndexNavId(), nav.getIndexNavId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(navsList)) {
            if (Objects.equals(nav.getNavType(), NavTypeEnum.product.getValue())) {
                List<IndexItemEntity> indexItemEntities = this.indexItemInterface.getList(nav.getIndexNavId());
                this.addNavProductList(nav, customerId, platformId, indexItemEntities, indexNavVo, vipLevel);
            } else if (Objects.equals(nav.getNavType(), NavTypeEnum.my_product_list.getValue())) {
                this.logger.info("\u6211\u7684\u5c6f\u8d27\u6e05\u5355:{}", (Object)JsonUtils.toJson((Object)nav, (boolean)false));
                List<OrderListVo> orderListVoList = this.tradeInterface.getOrderList(customerId, 0, OrderSourceEnum.CART.getValue(), 10, 1);
                if (CollectionUtils.isEmpty(orderListVoList)) {
                    this.logger.info("\u7528\u6237\uff1a{}\u65e0\u5386\u53f2\u8d2d\u7269\u8bb0\u5f55\u4e0d\u663e\u793a\u5c6f\u8d27\u6e05\u5355", (Object)customerId);
                    nav.setIsShow(0);
                } else {
                    this.logger.info("\u6211\u7684\u5c6f\u8d27\u6e05\u5355\u8ba2\u5355:{}", (Object)JsonUtils.toJson(orderListVoList, (boolean)false));
                    ArrayList<IndexItemEntity> indexItemEntities = new ArrayList<IndexItemEntity>();
                    int sort = 0;
                    boolean stop = false;
                    HashSet<String> produtSet = new HashSet<String>();
                    for (OrderListVo orderListVo : orderListVoList) {
                        for (MallOrderProductVo orderProductVo : orderListVo.getOrderProductVos()) {
                            BuildPageEntity buildPageEntity2;
                            this.logger.info("\u5546\u54c1:{} set:{}", (Object)orderProductVo.toString(), (Object)JsonUtils.toJson(produtSet, (boolean)false));
                            if (produtSet.contains(orderProductVo.getItemId())) continue;
                            if (sort > 10) {
                                stop = true;
                                break;
                            }
                            if (orderProductVo.getProductType() != SalesTypeEnum.SALES_PRODUCT.getValue() && orderProductVo.getProductType() != SalesTypeEnum.SALES_PROMOTION.getValue()) continue;
                            IndexItemEntity indexItemEntity = this.indexItemInterface.getIndexItemEntity(orderProductVo.getItemId(), orderProductVo.getProductType(), platformId);
                            this.logger.info("\u9996\u9875\u5546\u54c1\u5bf9\u8c61:{}", (Object)indexItemEntity.toString());
                            if (indexItemEntity == null || !StringUtils.isNotEmpty((String)indexItemEntity.getIndexItemId()) || Objects.equals(orderProductVo.getProductType(), SalesTypeEnum.SALES_PROMOTION.getValue()) && !Objects.equals((buildPageEntity2 = this.buildPageInterface.getBuildPage(indexItemEntity.getDetailBuildPageId())).getWebFlag(), "skuPromotion")) continue;
                            indexItemEntity.setItemSn(sort);
                            indexItemEntities.add(indexItemEntity);
                            produtSet.add(orderProductVo.getItemId());
                            ++sort;
                        }
                        if (!stop) continue;
                        break;
                    }
                    this.logger.info("\u6784\u5efa\u5c6f\u8d27\u6e05\u5355:{}", (Object)JsonUtils.toJson(indexItemEntities, (boolean)false));
                    this.addNavProductList(nav, customerId, platformId, indexItemEntities, indexNavVo, 0);
                }
            }
        }
        return indexNavVo;
    }

    private void addNavProductList(IndexNavEntity nav, String customerId, Integer platformId, List<IndexItemEntity> indexItemEntities, IndexNavVo indexNavVo, Integer vipLevel) {
        ArrayList<Object> objects = new ArrayList<Object>();
        ArrayList removeobjects = new ArrayList();
        if (indexItemEntities != null) {
            ArrayList<MallIndexProductVo> sortList = new ArrayList<MallIndexProductVo>();
            for (IndexItemEntity indexItemEntity : indexItemEntities) {
                MallIndexProductVo indexProductVo;
                if (!Objects.equals(indexItemEntity.getIndexShowType(), 1)) continue;
                if (indexItemEntity.getItemType().equals("4")) {
                    indexProductVo = this.getIndexProduct(customerId, platformId, indexItemEntity, true, vipLevel);
                    if (indexProductVo == null) continue;
                    objects.add(indexProductVo);
                    continue;
                }
                if (indexItemEntity.getItemType().equals("1")) {
                    MallIndexPromotionVo indexPromotionVo = this.getIndexPromotion(customerId, platformId, indexItemEntity, vipLevel);
                    if (indexPromotionVo == null) continue;
                    if (!indexPromotionVo.getValid().booleanValue()) {
                        this.logger.info("\u4fc3\u9500:{},{} \u4e0d\u80fd\u6dfb\u52a0\u5230\u680f\u76ee\u4e0a", (Object)indexPromotionVo.getProductName(), (Object)indexPromotionVo.getInvalidReason());
                        continue;
                    }
                    objects.add(indexPromotionVo);
                    if (nav.getCountdown() != 1) continue;
                    indexNavVo.setSecond(indexPromotionVo.getSecond());
                    indexNavVo.setSeconds(indexPromotionVo.getSeconds());
                    indexNavVo.setBeginTime(indexPromotionVo.getBeginTime());
                    indexNavVo.setEndTime(indexPromotionVo.getEndTime());
                    indexNavVo.setHour(indexPromotionVo.getHour());
                    indexNavVo.setMinute(indexPromotionVo.getMinute());
                    continue;
                }
                if (indexItemEntity.getItemType().equals("5")) {
                    IndexActiveVo indexActiveVo = this.getIndexActive(customerId, platformId, indexItemEntity);
                    if (indexActiveVo == null) continue;
                    objects.add(indexActiveVo);
                    if (nav.getCountdown() != 1) continue;
                    indexNavVo.setSecond(indexActiveVo.getSecond());
                    indexNavVo.setSeconds(indexActiveVo.getSeconds());
                    indexNavVo.setBeginTime(indexActiveVo.getBeginTime());
                    indexNavVo.setEndTime(indexActiveVo.getEndTime());
                    indexNavVo.setHour(indexActiveVo.getHour());
                    indexNavVo.setMinute(indexActiveVo.getMinute());
                    continue;
                }
                if (indexItemEntity.getItemType().equals("2")) {
                    MallIndexGroupVo indexGroupVo = this.getIndexGroup(customerId, platformId, indexItemEntity);
                    if (indexGroupVo == null) continue;
                    objects.add(indexGroupVo);
                    continue;
                }
                if (!indexItemEntity.getItemType().equals("6") || (indexProductVo = this.getIndexProduct(customerId, platformId, indexItemEntity, false, 0)) == null) continue;
                sortList.add(indexProductVo);
            }
            if (sortList.size() > 0) {
                Comparator<MallIndexProductVo> bySn = Comparator.comparing(MallIndexProductVo::getItemSn);
                Comparator<MallIndexProductVo> byReserveCount = Comparator.comparing(MallIndexProductVo::getReserveCount).reversed();
                sortList.sort(bySn.thenComparing(byReserveCount));
                Object temp = null;
                if (objects.size() == 1) {
                    temp = objects.get(0);
                    objects.clear();
                }
                objects.addAll(sortList);
                if (temp != null) {
                    objects.add(temp);
                }
            }
        }
        if (objects.size() > removeobjects.size()) {
            objects.removeAll(removeobjects);
        }
        indexNavVo.setItems(objects);
        if (objects.size() > 0) {
            indexNavVo.setItems(objects);
        }
    }

    @Override
    @ReadThroughSingleCache(namespace="IndexNavProductListNoLogin", expiration=300)
    public BaseJsonVo getIndexNavProductListWithoutSpeedupNoLogin(@ParameterValueKeyProvider(order=0) Integer platformId, String customerId, @ParameterValueKeyProvider(order=1) int itemType) {
        return this.getIndexNavProductListWithoutSpeedupNoCache(platformId, customerId, itemType, 0);
    }

    @Override
    @ReadThroughSingleCache(namespace="IndexNavProductList", expiration=60)
    public BaseJsonVo getIndexNavProductListWithoutSpeedup(@ParameterValueKeyProvider(order=0) Integer platformId, @ParameterValueKeyProvider(order=1) String customerId, @ParameterValueKeyProvider(order=2) int itemType, @ParameterValueKeyProvider(order=3) Integer vipLevel) {
        return this.getIndexNavProductListWithoutSpeedupNoCache(platformId, customerId, itemType, vipLevel);
    }

    private MallIndexPromotionVo getIndexPromotion(String customerId, int platformId, IndexItemEntity indexItemEntity, Integer vipLevel) {
        MallIndexPromotionVo indexPromotionVo = null;
        BaseJsonVo baseJsonVo = this.promotionInterface.buildIndexPromotionVo(indexItemEntity.getProId(), customerId, vipLevel);
        if (baseJsonVo.isSuccess()) {
            indexPromotionVo = (MallIndexPromotionVo)baseJsonVo.getValue();
            BuildPageEntity buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getDetailBuildPageId());
            indexPromotionVo.setModuleDetailId(indexItemEntity.getDetailBuildPageId());
            indexPromotionVo.setDetailWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getBuildPageId());
            indexPromotionVo.setWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexPromotionVo.setModuleId(indexItemEntity.getBuildPageId());
            indexPromotionVo.setItemSn(indexItemEntity.getItemSn());
            indexPromotionVo.setDetailUrl(this.getItemDetailUrl("/template/pagebuild/", platformId, indexItemEntity.getNavId(), Integer.valueOf(indexItemEntity.getItemType()), indexItemEntity.getProId()));
        }
        return indexPromotionVo;
    }

    private MallIndexGroupVo getIndexGroup(String customerId, int platformId, IndexItemEntity indexItemEntity) {
        BaseJsonVo baseJsonVo;
        MallIndexGroupVo indexGroupVo = null;
        if (indexItemEntity != null && (baseJsonVo = this.groupInterface.buildIndexGroupVo(indexItemEntity.getProId(), customerId)).isSuccess()) {
            BuildPageEntity buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getDetailBuildPageId());
            indexGroupVo = (MallIndexGroupVo)baseJsonVo.getValue();
            indexGroupVo.setModuleDetailId(indexItemEntity.getDetailBuildPageId());
            indexGroupVo.setDetailWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexGroupVo.setModuleId(indexItemEntity.getBuildPageId());
            buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getBuildPageId());
            indexGroupVo.setWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexGroupVo.setItemSn(indexItemEntity.getItemSn());
            indexGroupVo.setDetailUrl(this.getItemDetailUrl("/template/pagebuild/", platformId, indexItemEntity.getNavId(), Integer.valueOf(indexItemEntity.getItemType()), indexItemEntity.getProId()));
        }
        return indexGroupVo;
    }

    private MallIndexProductVo getIndexProduct(String customerId, int platformId, IndexItemEntity indexItemEntity, boolean check, Integer vipLevel) {
        MallIndexProductVo indexProductVo = null;
        BaseJsonVo<MallIndexProductVo> baseJsonVo = this.productInterface.buildIndexProductVo(indexItemEntity.getProId(), customerId, check, vipLevel);
        if (baseJsonVo.isSuccess()) {
            BuildPageEntity buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getDetailBuildPageId());
            indexProductVo = (MallIndexProductVo)baseJsonVo.getValue();
            indexProductVo.setModuleDetailId(indexItemEntity.getDetailBuildPageId());
            indexProductVo.setDetailWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexProductVo.setModuleId(indexItemEntity.getBuildPageId());
            indexProductVo.setItemSn(indexItemEntity.getItemSn());
            buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getBuildPageId());
            indexProductVo.setWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexProductVo.setDetailUrl(this.getItemDetailUrl("/template/pagebuild/", platformId, indexItemEntity.getNavId(), Integer.valueOf(indexItemEntity.getItemType()), indexItemEntity.getProId()));
            if (indexProductVo.getItemType() == SalesTypeEnum.SALES_OFF_PRODUCT.getValue() && StringUtils.isNotEmpty((String)customerId)) {
                indexProductVo.setReserveCount(this.reserveInterface.getReserveCount(indexProductVo.getProductId(), SalesTypeEnum.SALES_OFF_PRODUCT.getValue()));
                indexProductVo.setReserveStatus(this.reserveInterface.getReserve(customerId, indexProductVo.getProductId(), SalesTypeEnum.SALES_OFF_PRODUCT.getValue()));
            }
            if (platformId == PlatFormEnum.LECHUN_MINI.getValue() && Objects.equals(indexProductVo.getWebFlag(), "lechun_sku")) {
                indexProductVo.setWebFlag("sku");
            }
        }
        return indexProductVo;
    }

    private IndexActiveVo getIndexActive(String customerId, int platformId, IndexItemEntity indexItemEntity) {
        IndexActiveVo indexActiveVo = null;
        BaseJsonVo<IndexActiveVo> baseJsonVo = this.activeInterface.buildIndexActiveVo(indexItemEntity.getProId(), customerId);
        if (baseJsonVo.isSuccess()) {
            BuildPageEntity buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getDetailBuildPageId());
            indexActiveVo = (IndexActiveVo)baseJsonVo.getValue();
            indexActiveVo.setModuleDetailId(indexItemEntity.getDetailBuildPageId());
            indexActiveVo.setDetailWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexActiveVo.setModuleId(indexItemEntity.getBuildPageId());
            buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getBuildPageId());
            indexActiveVo.setItemSn(indexItemEntity.getItemSn());
            indexActiveVo.setWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexActiveVo.setDetailUrl(this.getItemDetailUrl("/template/pagebuild/", platformId, indexItemEntity.getNavId(), Integer.valueOf(indexItemEntity.getItemType()), indexItemEntity.getProId()));
        }
        return indexActiveVo;
    }

    @Override
    public String getItemDetailUrl(String modulePath, int platformId, String navId, int itemType, String itemId) {
        return modulePath + platformId + "_" + navId + "_" + itemType + "_" + itemId + ".html";
    }

    public List<MallSelectDataVo> getItems(int itemType, int platformGroupId) {
        if (itemType == SalesTypeEnum.SALES_PRODUCT.getValue()) {
            return this.productInterface.getOptionProductList(platformGroupId);
        }
        if (itemType == SalesTypeEnum.SALES_GROUP.getValue()) {
            return this.groupInterface.getOptionGroupList(platformGroupId);
        }
        if (itemType == SalesTypeEnum.SALES_PROMOTION.getValue()) {
            return this.promotionInterface.getOptionPromotionList(platformGroupId);
        }
        if (itemType == SalesTypeEnum.SALES_ACTIVE.getValue()) {
            return this.activeInterface.getOptionActiveList(platformGroupId);
        }
        return new ArrayList<MallSelectDataVo>();
    }

    @Override
    public BaseJsonVo getItemDetail(String customerId, String itemId, int itemType, Integer vipLevel) {
        if (SalesTypeEnum.SALES_PROMOTION.getValue() == itemType) {
            return this.promotionInterface.buildIndexPromotionVo(itemId, customerId, vipLevel);
        }
        if (SalesTypeEnum.SALES_PRODUCT.getValue() == itemType || SalesTypeEnum.SALES_OFF_PRODUCT.getValue() == itemType) {
            BaseJsonVo<MallIndexProductVo> baseJsonVo = this.productInterface.buildIndexProductVo(itemId, customerId, false, vipLevel);
            if (baseJsonVo.isSuccess() && ((MallIndexProductVo)baseJsonVo.getValue()).getItemType() == SalesTypeEnum.SALES_OFF_PRODUCT.getValue()) {
                ((MallIndexProductVo)baseJsonVo.getValue()).setReserveCount(this.reserveInterface.getReserveCount(((MallIndexProductVo)baseJsonVo.getValue()).getProductId(), SalesTypeEnum.SALES_OFF_PRODUCT.getValue()));
                ((MallIndexProductVo)baseJsonVo.getValue()).setReserveStatus(this.reserveInterface.getReserve(customerId, ((MallIndexProductVo)baseJsonVo.getValue()).getProductId(), SalesTypeEnum.SALES_OFF_PRODUCT.getValue()));
            }
            return baseJsonVo;
        }
        if (SalesTypeEnum.SALES_GROUP.getValue() == itemType) {
            return this.groupInterface.buildIndexGroupVo(itemId, customerId);
        }
        if (SalesTypeEnum.SALES_ACTIVE.getValue() == itemType) {
            return this.activeInterface.buildIndexActiveVoByBindCode(itemId, customerId);
        }
        return BaseJsonVo.error((String)"\u7c7b\u578b\u9519\u8bef");
    }

    @Override
    public Integer getProductType(String itemId) {
        if (StringUtils.isEmpty((String)itemId)) {
            return null;
        }
        if (this.productInterface.getProduct(itemId) != null) {
            return 4;
        }
        if (this.promotionInterface.getPromotion(itemId) != null) {
            return 1;
        }
        if (this.groupInterface.getGroup(itemId) != null) {
            return 2;
        }
        if (this.activeInterface.getActiveEntityByActiveNo(itemId) != null) {
            return 5;
        }
        return null;
    }
}

