/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.item;

import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.item.IndexNavMapper;
import cc.lechun.mall.entity.item.IndexNavEntity;
import cc.lechun.mall.iservice.item.MallIndexNavInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallIndexNavService
extends BaseService
implements MallIndexNavInterface {
    @Autowired
    private IndexNavMapper indexNavMapper;

    @Override
    @ReadThroughSingleCache(namespace="IndexNavList", expiration=3600)
    public List<IndexNavEntity> getIndexNavList(@ParameterValueKeyProvider Integer platformId) {
        IndexNavEntity indexNavEntity = new IndexNavEntity();
        indexNavEntity.setPlatformId(platformId);
        List indexNavEntities = this.indexNavMapper.getList(indexNavEntity);
        if (indexNavEntities != null && indexNavEntities.size() > 0) {
            indexNavEntities.sort((f1, f2) -> f1.getNavSn().compareTo(f2.getNavSn()));
        }
        return indexNavEntities;
    }

    @Override
    @ReadThroughSingleCache(namespace="IndexNavEntity", expiration=3600)
    public IndexNavEntity getIndexNav(@ParameterValueKeyProvider String navId) {
        return (IndexNavEntity)this.indexNavMapper.selectByPrimaryKey((Serializable)((Object)navId));
    }

    @Override
    @ReadThroughSingleCache(namespace="IndexEnableNavList", expiration=3600)
    public List<IndexNavEntity> getEnableIndexNavList(@ParameterValueKeyProvider Integer platformId) {
        List<IndexNavEntity> indexItemEntities = this.getIndexNavList(platformId);
        if (CollectionUtils.isNotEmpty(indexItemEntities)) {
            return indexItemEntities.stream().filter(c -> c.getIsShow() == 1).collect(Collectors.toList());
        }
        return indexItemEntities;
    }
}

