/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.framework.common.jms.MessageQueueInterface;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.InteractionTypeEnum;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.InteractionInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="attentionNumber")
public class AttentionNumberListener
implements MessageQueueInterface {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private InteractionInterface interactionInterface;
    @Autowired
    private MallRedisLock mallRedisLock;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MessageInterface messageService;

    public boolean receive(Message message, ConsumeContext context) {
        this.log.info("\u7528\u6237\u5173\u6ce8\u6d88\u606f....");
        Map param = (Map)ObjectConvert.toObject((byte[])message.getBody());
        String customerId = param.get("userId").toString();
        String bindCode = param.get("bindCode").toString();
        Integer platformId = Integer.valueOf(param.get("platformId").toString());
        if (this.mallRedisLock.lock("SUBCRIPT:RECORD", customerId, 100L, TimeUnit.SECONDS)) {
            this.interactionInterface.saveCustomerInteractionAsync(customerId, 1, InteractionTypeEnum.SUBSCRIBE.getValue(), bindCode, platformId);
        }
        try {
            if (StringUtils.isEmpty((String)bindCode)) {
                BaseJsonVo result = this.messageService.sendWechatMessage("subscript", customerId, null);
                this.log.info("\u63a8\u9001\u7528\u6237{}\u5173\u6ce8\u6d88\u606f:{}", (Object)customerId, (Object)result.isSuccess());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

