/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.common.enums.sync.DataSyncTypeEnum;
import cc.lechun.framework.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.jms.MessageQueueInterface;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.customer.CustomerFreeInterface;
import cc.lechun.mall.iservice.point.CustomerPointInterface;
import cc.lechun.mall.iservice.sync.MallDataSyncInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.iservice.trade.MiniShopOrderInterface;
import cc.lechun.mall.service.youshu.OrderDataService;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="omsOrderCancel")
public class CancelOrderListener
implements MessageQueueInterface {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallDataSyncInterface syncInterface;
    @Autowired
    MallOrderSyncInfoInterface orderSyncInfoInterface;
    @Autowired
    MiniShopOrderInterface miniShopOrderInterface;
    @Autowired
    MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private OrderDataService orderDataService;
    @Autowired
    CustomerFreeInterface customerFreeService;
    @Autowired
    CustomerPointInterface customerPointInterface;

    public boolean receive(Message message, ConsumeContext context) {
        try {
            Map param = (Map)ObjectConvert.toObject((byte[])message.getBody());
            String orderMainNo = param.get("orderMainNo").toString();
            this.log.info("\u63a5\u6536\u8ba2\u5355\u6d88\u606f....{}", (Object)orderMainNo);
            MallOrderMainEntity orderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo);
            if (orderMainEntity == null) {
                this.log.error("\u8ba2\u5355:{}\u4e0d\u5b58\u5728", (Object)orderMainNo);
                return false;
            }
            this.customerFreeService.refundFree(orderMainEntity);
            BaseJsonVo syncResult = this.orderSyncInfoInterface.toDetailOrderStatus(orderMainNo, null, OrderStatusEnum.CANCEL);
            if (!syncResult.isSuccess()) {
                this.log.error("\u8ba2\u5355{}\u53d6\u6d88\u6210\u529f\u72b6\u6001\u540c\u6b65\u5230OMS\u5931\u8d25\uff1a{}", (Object)orderMainNo, (Object)syncResult.getError_msg());
            }
            this.miniShopOrderInterface.payOrderResult(this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo));
            this.customerPointInterface.cancelPoint(orderMainNo);
            this.syncInterface.producerData(orderMainNo, DataSyncTypeEnum.BI_MAIN_ORDER, "omsOrderCancel");
            this.orderDataService.updateOrder(orderMainNo);
        }
        catch (Exception e) {
            this.log.error("\u6d88\u8d39\u6d88\u606fomsOrderCancel\u5f02\u5e38\uff0c" + e.getMessage());
        }
        return true;
    }
}

