/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.framework.common.jms.MessageQueueInterface;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.mall.service.cashticket.CashticketCustomerService;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="sendCashLog")
public class CashSendLogListener
implements MessageQueueInterface {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CashticketCustomerService cashticketCustomerService;

    public boolean receive(Message message, ConsumeContext context) {
        try {
            Map messageBody = (Map)ObjectConvert.toObject((byte[])message.getBody());
            this.cashticketCustomerService.saveSendLog(messageBody.get("customerId").toString(), messageBody.get("ticketBatchId").toString(), messageBody.get("status").toString(), messageBody.get("bindCode").toString(), messageBody.get("versionDetailId").toString(), messageBody.get("message").toString(), messageBody.get("count").toString());
        }
        catch (Exception e) {
            this.log.error("\u4f18\u60e0\u52b5\u65e5\u5fd7\u6d88\u606f{}\u5904\u7406\u5931\u8d25", (Object)message.getMsgID(), (Object)e);
        }
        return true;
    }
}

