/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.framework.common.jms.MessageQueueInterface;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.orderPlan.MallOrderPlanDomainInterface;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="OrderPayMessage")
public class OrderPayMessageListener
implements MessageQueueInterface {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private MallOrderPlanDomainInterface orderPlanDomainInterface;

    public boolean receive(Message message, ConsumeContext consumeContext) {
        try {
            Map param = (Map)ObjectConvert.toObject((byte[])message.getBody());
            String orderMainNo = param.get("orderMainNo").toString();
            this.log.info("\u63a5\u6536\u8ba2\u5355\u6d88\u606f....{}", (Object)orderMainNo);
            MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
            if (orderMainEntity == null) {
                return false;
            }
            BaseJsonVo messagePushBaseJsonVo = this.orderPlanDomainInterface.pushCreatedOrderNotice(orderMainEntity);
            this.log.info("\u7528\u6237\uff1a{}\u4e0b\u5355\u6210\u529f\u540e\u901a\u77e5\u63a8\u9001{}", (Object)orderMainEntity.getCustomerId(), (Object)messagePushBaseJsonVo.isSuccess());
        }
        catch (Exception e) {
            this.log.error("\u6d88\u8d39\u6d88\u606ffinishVipTask\u5f02\u5e38\uff0c" + e.getMessage());
        }
        return true;
    }
}

