/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.framework.common.jms.MessageQueueInterface;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.accessLog.OrderAccessLogInterface;
import cc.lechun.mall.iservice.customer.CustomerFreeInterface;
import cc.lechun.mall.iservice.sync.MallDataSyncInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.service.youshu.OrderDataService;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="submitOrder")
public class OrderSubmitListener
implements MessageQueueInterface {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallDataSyncInterface syncInterface;
    @Autowired
    MallOrderSyncInfoInterface orderSyncInfoInterface;
    @Autowired
    private OrderDataService orderDataService;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private OrderAccessLogInterface orderAccessLogInterface;
    @Autowired
    CustomerFreeInterface customerFreeService;

    public boolean receive(Message message, ConsumeContext context) {
        Map param = (Map)ObjectConvert.toObject((byte[])message.getBody());
        String orderMainNo = param.get("orderMainNo").toString();
        this.log.info("OrderSubmit\u63a5\u6536\u8ba2\u5355\u6d88\u606f...." + orderMainNo);
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
        if (orderMainEntity == null) {
            return false;
        }
        try {
            this.customerFreeService.useFreeProdcutFromPool(orderMainEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.orderAccessLogInterface.writeAccessLog(orderMainEntity, "submitOrder", "\u63d0\u4ea4\u8ba2\u5355");
        }
        catch (Exception e) {
            this.log.error("\u6d88\u8d39\u6d88\u606fsubmitOrder\u5f02\u5e38\uff0c" + e.getMessage());
        }
        try {
            this.orderDataService.addOrder(orderMainEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

