/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.common.enums.sync.DataSyncTypeEnum;
import cc.lechun.framework.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.jms.MessageQueueInterface;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.mall.iservice.sync.MallDataSyncInterface;
import cc.lechun.mall.iservice.trade.MallMiniShopInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.service.youshu.OrderDataService;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="ecOrderTakeGood")
public class TakeGoodListener
implements MessageQueueInterface {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallDataSyncInterface syncInterface;
    @Autowired
    private MallOrderSyncInfoInterface orderSyncInfoInterface;
    @Autowired
    private MallMiniShopInterface mallMiniShopInterface;
    @Autowired
    private OrderDataService orderDataService;

    public boolean receive(Message message, ConsumeContext context) {
        try {
            Map param = (Map)ObjectConvert.toObject((byte[])message.getBody());
            String orderMainNo = param.get("orderMainNo").toString();
            String orderNo = param.get("orderNo").toString();
            this.orderSyncInfoInterface.toDetailOrderStatus(orderMainNo, orderNo, OrderStatusEnum.DELIVERED);
            this.mallMiniShopInterface.orderSendByOrderNo(orderNo);
            this.syncInterface.producerData(orderMainNo, DataSyncTypeEnum.BI_MAIN_ORDER, "ecOrderTakeGood");
        }
        catch (Exception e) {
            this.log.error("\u6d88\u8d39\u6d88\u606fecOrderTakeGood\u5f02\u5e38\uff0c" + e.getMessage());
        }
        return true;
    }
}

