/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.framework.common.jms.MessageQueueInterface;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="templeteMessageSend")
public class TempleteMessageSendListener
implements MessageQueueInterface {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MessageInterface messageInterface;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receive(Message message, ConsumeContext context) {
        ExecutorService pool = Executors.newFixedThreadPool(1);
        try {
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                Map param = (Map)ObjectConvert.toObject((byte[])message.getBody());
                this.messageInterface.sendNotice(param);
            }, pool);
        }
        catch (Exception e) {
            this.log.error("\u6d88\u606f\u63a8\u9001\u5931\u8d25", (Throwable)e);
        }
        finally {
            pool.shutdown();
        }
        return true;
    }
}

