/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.framework.common.jms.MessageQueueInterface;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.mall.iservice.weixin.WeiXinGroupUserInterface;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="uploadUsers")
public class UploadGroupCustomerListener
implements MessageQueueInterface {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WeiXinGroupUserInterface groupUserInterface;
    @Autowired
    private MallRedisLock mallRedisLock;
    @Value(value="${jms.uploadUserIps:172.17.16.4}")
    private String uploadUserIps;

    public boolean receive(Message message, ConsumeContext context) {
        Boolean result = false;
        if (this.mallRedisLock.lock("UploadGroupCustomerListener_receive1", "1", 10L, TimeUnit.SECONDS)) {
            this.log.info("\u5f00\u59cb\u4e0a\u4f20\u7528\u6237...");
            try {
                Map messageBody = (Map)ObjectConvert.toObject((byte[])message.getBody());
                int platformId = (Integer)messageBody.get("platformId");
                String groupId = (String)messageBody.get("groupId");
                Map maps = (Map)messageBody.get("maps");
                result = true;
                this.log.info("\u5f00\u59cb\u4e0a\u4f20\u7528\u6237\u6210\u529f..." + result);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error("\u4e0a\u4f20\u7528\u6237\u5931\u8d25,{}", (Object)e.getMessage());
            }
        }
        return result;
    }
}

