/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.minischeme;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.minischeme.MiniSchemeMapper;
import cc.lechun.mall.entity.minischeme.MiniSchemeEntity;
import cc.lechun.mall.entity.minischeme.SchemeExprieTypeEnum;
import cc.lechun.mall.iservice.minischeme.MiniSchemeInterface;
import cc.lechun.mall.service.weixin.WeiXinBaseService;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.URLSchemeAPI;
import weixin.popular.bean.URLScheme.SchemeResult;

@Service
public class MiniSchemeService
extends BaseService<MiniSchemeEntity, Integer>
implements MiniSchemeInterface {
    @Resource
    private MiniSchemeMapper miniSchemeMapper;
    @Autowired
    private WeiXinBaseService weiXinBaseService;

    @Override
    public BaseJsonVo getMiniSchemeEntity(String t) {
        this.logger.info("\u6839\u636e\u77ed\u8fdekey:{}\u67e5\u8be2\u8981\u8df3\u8f6c\u7684\u5c0f\u7a0b\u5e8f\u8def\u5f84scheme", (Object)t);
        MiniSchemeEntity query = new MiniSchemeEntity();
        query.setOpenLink("weixin://dl/business/?t=" + t);
        MiniSchemeEntity miniSchemeEntity = (MiniSchemeEntity)this.getSingle(query);
        if (miniSchemeEntity == null) {
            return null;
        }
        miniSchemeEntity.setExpireType(SchemeExprieTypeEnum.temp.getValue());
        if (miniSchemeEntity.getPlatformId() == null) {
            miniSchemeEntity.setPlatformId(4);
        }
        String accessToken = this.weiXinBaseService.getAccessTokenValueByPlatformId(miniSchemeEntity.getPlatformId());
        miniSchemeEntity.setExpiredTime(DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)30));
        miniSchemeEntity.setCreateTime(DateUtils.now());
        SchemeResult schemeResult = URLSchemeAPI.getURLScheme((String)accessToken, (boolean)true, (long)(miniSchemeEntity.getExpiredTime().getTime() / 1000L), (String)miniSchemeEntity.getMiniPath(), (String)miniSchemeEntity.getQueryPara());
        if (schemeResult.isSuccess()) {
            String openLink = schemeResult.getOpenlink();
            miniSchemeEntity.setOpenLink(openLink);
            this.logger.info("\u77ed\u8fde:{}\u5fae\u4fe1\u751f\u6210\u8fde\u63a5:{}", (Object)t, (Object)miniSchemeEntity.toString());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", openLink.split("&")[0].split("=")[1]);
            return BaseJsonVo.success(map);
        }
        return BaseJsonVo.error((String)("\u521b\u5efa\u5931\u8d25," + schemeResult.getErrmsg()));
    }
}

