/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.pay;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.pay.PaySubTypeEnum;
import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.enums.pay.PayStatusEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.dao.sales.MallProductMapper;
import cc.lechun.mall.dao.trade.MallOrderPayMapper;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.pay.AliPayNotifyEntity;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.entity.pay.PayOutputEntity;
import cc.lechun.mall.entity.pay.WechatNotifyEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderPayRecordEntity;
import cc.lechun.mall.entity.trade.MallPayTypeEntity;
import cc.lechun.mall.entity.trade.MallPlatformPayTypeEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.deliver.MallAreaInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.pay.PayInterface;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.sales.MallProductSalesInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayRecordInterface;
import cc.lechun.mall.iservice.trade.MallOrderStatusLogInterface;
import cc.lechun.mall.iservice.trade.MallPayTypeInterface;
import cc.lechun.mall.iservice.trade.MallPlatformPayTypeInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.mall.service.trade.defineFieldHandle.DefineFiledHandleInterface;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayOrderService
extends BaseService
implements PayOrderInterface {
    @Autowired
    private PayInterface payInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallOrderPayInterface mallOrderPayInterface;
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private MallOrderInterface mallOrderInterface;
    @Autowired
    private MallOrderGroupProductInterface mallOrderGroupProductService;
    @Autowired
    private MallPlatformPayTypeInterface mallPlatformPayTypeInterface;
    @Autowired
    private MallTradeInterface tradeInterface;
    @Autowired
    private MallPayTypeInterface payTypeInterface;
    @Autowired
    private DefineFiledHandleInterface defineFiledHandleInterface;
    @Autowired
    private MallOrderPayRecordInterface orderPayRecordInterface;
    @Autowired
    private MallOrderStatusLogInterface mallOrderStatusLogInterface;
    @Autowired
    private MallProductSalesInterface salesInterface;
    @Autowired
    private MallAreaInterface areaInterface;
    @Autowired
    private MallProductMapper mallProductMapper;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private MallOrderPayMapper payMapper;
    @Autowired
    private RedisService redisService;
    @Autowired
    private DictionaryInterface dictionaryInterface;

    @Override
    @Transactional
    public PayOutputEntity topay(String customerId, String orderMainNo, String ip) {
        return ((PayOrderService)SpringContextUtil.getBean(this.getClass())).topay(customerId, orderMainNo, ip, null);
    }

    @Override
    @Transactional
    public PayOutputEntity topay(String customerId, String orderMainNo, String ip, BigDecimal cardPayAmout) {
        this.defineFiledHandleInterface.orderPayBefore(orderMainNo);
        PayOutputEntity payOutputEntity = this.checkOrderPayComplate(orderMainNo, ip);
        String orderNo = payOutputEntity.getOrderNo();
        if (payOutputEntity.getStatus() == PayStatusEnum.ORDER_CHECK_SUCCESS.getValue()) {
            BaseJsonVo result = this.payInterface.pay(payOutputEntity.getPayInputEntitis());
            if (result.isSuccess() && result.getValue() != null) {
                List payOutputEntities = (List)result.getValue();
                this.logger.info("cardPayAmout={}, PayOrderService.topay:{}", (Object)cardPayAmout, (Object)JsonUtils.toJson((Object)payOutputEntities, (boolean)true));
                for (PayOutputEntity p : payOutputEntities) {
                    if (p.getStatus() == PayStatusEnum.PAY_SUCCESS.getValue()) {
                        MallOrderPayEntity orderPayEntity = new MallOrderPayEntity();
                        orderPayEntity.setPayId(p.getPayId());
                        orderPayEntity.setSuccessTime(DateUtils.now());
                        orderPayEntity.setIssuccess(1);
                        boolean pointCardOrderFlag = false;
                        if (cardPayAmout != null && cardPayAmout.compareTo(BigDecimal.ZERO) > 0 && p.getPayTypeId() == PayTypeEnum.BALANCE_PAY.getValue()) {
                            orderPayEntity.setPayamount(cardPayAmout);
                            pointCardOrderFlag = true;
                        }
                        if (this.mallOrderPayInterface.updateByPrimaryKey(orderPayEntity) && p.getPayTypeId() == PayTypeEnum.BALANCE_PAY.getValue() && !pointCardOrderFlag) {
                            orderPayEntity = this.mallOrderPayInterface.getSingle(p.getPayId());
                            this.mallOrderPayInterface.splitOrderPayForSubType(orderPayEntity, p.getWealth());
                        }
                    }
                    MallOrderPayRecordEntity orderPayRecordEntity = new MallOrderPayRecordEntity();
                    orderPayRecordEntity.setCreateTime(DateUtils.now());
                    orderPayRecordEntity.setIssuccess(p.getStatus() == PayStatusEnum.PAY_SUCCESS.getValue() ? 1 : 0);
                    orderPayRecordEntity.setPayId(p.getPayId());
                    orderPayRecordEntity.setPayrecordId(IDGenerate.getUniqueIdStr());
                    orderPayRecordEntity.setPaySubtypeId(p.getPayTypeSubId());
                    orderPayRecordEntity.setPaytypeId(p.getPayTypeId());
                    if (p.getPayTypeId() == PayTypeEnum.BANK_PAY.getValue()) {
                        MallOrderPayEntity mallOrderPayEntity = this.mallOrderPayInterface.getOrderPayInfoByTradeNo(p.getOrderMainNo());
                        if (mallOrderPayEntity != null) {
                            orderPayRecordEntity.setOrderMainNo(mallOrderPayEntity.getOrderMainNo());
                            p.setOrderMainNo(mallOrderPayEntity.getOrderMainNo());
                        }
                    } else {
                        orderPayRecordEntity.setOrderMainNo(p.getOrderMainNo());
                    }
                    orderPayRecordEntity.setReturnContent(p.getReturnContent());
                    orderPayRecordEntity.setSendContent(p.getSendContent());
                    orderPayRecordEntity.setSendUrl(p.getSendUrl());
                    this.orderPayRecordInterface.insertPayRecord(orderPayRecordEntity);
                }
                payOutputEntity = (PayOutputEntity)payOutputEntities.get(payOutputEntities.size() - 1);
                this.memcachedService.set("", "PayOrderService_againTopay_" + orderMainNo, (Object)payOutputEntity, 1800);
                this.redisService.save("PayOrderService_againTopay_" + orderMainNo, payOutputEntity, 1800L);
            } else {
                payOutputEntity.setStatus(PayStatusEnum.ORDER_CREATE_FAIL.getValue());
                payOutputEntity.setMessage(result.getError_msg());
            }
        }
        if (payOutputEntity.getStatus() == PayStatusEnum.PAY_SUCCESS.getValue()) {
            BaseJsonVo jsonVo = this.tradeInterface.updateOrderSuccess(orderMainNo, null);
            if (jsonVo.isSuccess()) {
                this.defineFiledHandleInterface.orderPaySuccessAfter(orderMainNo);
            } else {
                payOutputEntity.setStatus(0);
                payOutputEntity.setMessage(jsonVo.getMessage());
            }
            payOutputEntity.setSuccessOrderCount(this.mallOrderMainInterface.getOrderCount(customerId, OrderStatusEnum.PAYCONFIRM.getValue(), OrderStatusEnum.COMPLETION.getValue()));
        }
        payOutputEntity.setPayInputEntitis(null);
        payOutputEntity.setOrderNo(orderNo);
        this.defineFiledHandleInterface.orderPayAfter(orderMainNo);
        return payOutputEntity;
    }

    @Override
    public PayOutputEntity againTopay(String customerId, String orderMainNo, int payTypeSubId, String ip) {
        MallPayTypeEntity payTypeEntity = this.payTypeInterface.getPayType(payTypeSubId);
        if (payTypeEntity == null) {
            PayOutputEntity payOutputEntity = new PayOutputEntity();
            payOutputEntity.setStatus(PayStatusEnum.TO_PAY_FAIL.getValue());
            payOutputEntity.setMessage("\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5b58\u5728");
            return payOutputEntity;
        }
        BaseJsonVo result = this.mallOrderPayInterface.updatePayTypeByOrderMainNo(orderMainNo, payTypeEntity.getpPaytypeId(), payTypeSubId);
        if (result.isSuccess()) {
            if ("0".equals(result.getResult())) {
                PayOutputEntity payOutputEntity = this.checkOrderPayComplate(orderMainNo, ip);
                if (payOutputEntity.getStatus() == PayStatusEnum.ORDER_CHECK_SUCCESS.getValue()) {
                    payOutputEntity = (PayOutputEntity)this.memcachedService.get("", "PayOrderService_againTopay_" + orderMainNo);
                    if (payOutputEntity == null) {
                        payOutputEntity = (PayOutputEntity)this.redisService.get("PayOrderService_againTopay_" + orderMainNo);
                    }
                    this.logger.info("\u53ef\u4ee5\u6b63\u5e38\u652f\u4ed8\uff1a" + JsonUtils.toJson((Object)payOutputEntity, (boolean)true));
                    if (payOutputEntity != null && payOutputEntity.getStatus() == PayStatusEnum.TO_PAY_SUCCESS.getValue()) {
                        return payOutputEntity;
                    }
                } else {
                    payOutputEntity.setStatus(PayStatusEnum.TO_PAY_FAIL.getValue());
                    payOutputEntity.setMessage(result.getError_msg());
                    return payOutputEntity;
                }
            }
            return this.topay(customerId, orderMainNo, ip);
        }
        PayOutputEntity payOutputEntity = new PayOutputEntity();
        payOutputEntity.setStatus(PayStatusEnum.TO_PAY_FAIL.getValue());
        payOutputEntity.setMessage(result.getError_msg());
        return payOutputEntity;
    }

    public PayOutputEntity checkOrderPayComplate(String orderMainNo, String ip) {
        Date expiredTime;
        PayOutputEntity outputEntity = new PayOutputEntity();
        List<MallOrderEntity> orderList = this.mallOrderInterface.getOrderList(orderMainNo);
        if (orderList.size() > 0) {
            outputEntity.setOrderNo(orderList.get(0).getOrderNo());
        }
        outputEntity.setOrderMainNo(orderMainNo);
        outputEntity.setPayJsUrl("");
        outputEntity.setStatus(PayStatusEnum.ORDER_CREATE_SUCCESS.getValue());
        if (orderMainNo.isEmpty()) {
            outputEntity.setStatus(PayStatusEnum.ORDER_CREATE_FAIL.getValue());
            outputEntity.setMessage("\u8ba2\u5355\u53f7\u4e0d\u6b63\u786e");
            return outputEntity;
        }
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo);
        if (mallOrderMainEntity == null) {
            this.logger.error("\u8ba2\u5355\u53f7:{}\u67e5\u4e0d\u7740\u8ba2\u5355 \u4f30\u8bb0\u662f\u8bfb\u5199\u5ef6\u8fdf", (Object)orderMainNo);
            outputEntity.setStatus(PayStatusEnum.ORDER_CREATE_FAIL.getValue());
            outputEntity.setMessage("\u8ba2\u5355\u4e0d\u5b58\u5728");
            return outputEntity;
        }
        if (mallOrderMainEntity.getStatus().intValue() == OrderStatusEnum.CANCEL.getValue()) {
            outputEntity.setStatus(PayStatusEnum.ORDER_CHECK_FAIL.getValue());
            outputEntity.setMessage("\u8be5\u8ba2\u5355\u5df2\u53d6\u6d88");
            return outputEntity;
        }
        if (mallOrderMainEntity.getStatus().intValue() != OrderStatusEnum.UNPAY.getValue()) {
            outputEntity.setStatus(PayStatusEnum.ORDER_CHECK_FAIL.getValue());
            outputEntity.setMessage("\u8be5\u8ba2\u5355\u6682\u65f6\u4e0d\u80fd\u4ed8\u6b3e");
            return outputEntity;
        }
        List<PayInputEntity> payInputEntitis = this.getPayInputEntityList(orderMainNo, ip);
        if (payInputEntitis == null) {
            outputEntity.setStatus(PayStatusEnum.ORDER_CREATE_FAIL.getValue());
            outputEntity.setMessage("\u8be5\u8ba2\u5355\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return outputEntity;
        }
        if (!payInputEntitis.stream().anyMatch(p -> p.getPaySubType() == PaySubTypeEnum.BALANCE_SUB_CARDPLAN_PAY.getValue()) && DateUtils.dateTimeCompare((Date)(expiredTime = DateUtils.getAddDateBySecond((Date)mallOrderMainEntity.getCreateTime(), (int)600)), (Date)DateUtils.now()) >= 0L) {
            outputEntity.setStatus(PayStatusEnum.ORDER_CHECK_FAIL.getValue());
            outputEntity.setMessage("\u8be5\u8ba2\u5355\u5df2\u7ecf\u8d85\u8fc7\u4ed8\u6b3e\u671f\u9650");
            return outputEntity;
        }
        BigDecimal payAmount = payInputEntitis.stream().map(PayInputEntity::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (OrderSourceEnum.RECHANGE_CARD.getValue() != mallOrderMainEntity.getOrderSource().intValue() && mallOrderMainEntity.getTotalAmount().compareTo(payAmount) != 0) {
            this.logger.error("\u652f\u4ed8\u91d1\u989d\u5f02\u5e38[{}] [mallOrderMainEntity.getTotalAmount() : {}][payAmount: {}]\u3002payInputEntitis\u5bf9\u8c61\u4e3a\uff1a{}", new Object[]{orderMainNo, mallOrderMainEntity.getTotalAmount(), payAmount, JsonUtils.toJson(payInputEntitis, (boolean)false)});
            outputEntity.setStatus(PayStatusEnum.ORDER_CHECK_FAIL.getValue());
            outputEntity.setMessage("\u652f\u4ed8\u91d1\u989d\u5f02\u5e38");
            outputEntity.setDesc("orderMain:" + mallOrderMainEntity.getTotalAmount().floatValue() + "__orderPay:" + payAmount.floatValue());
            return outputEntity;
        }
        if (mallOrderMainEntity.getStatus() >= OrderStatusEnum.PAYCONFIRM.getValue() && payInputEntitis.stream().filter(e -> !e.isSuccess()).collect(Collectors.toList()).size() == 0) {
            outputEntity.setStatus(PayStatusEnum.PAY_SUCCESS.getValue());
            outputEntity.setMessage("\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8\u6210\u529f");
            return outputEntity;
        }
        outputEntity.setStatus(PayStatusEnum.ORDER_CHECK_SUCCESS.getValue());
        outputEntity.setPayInputEntitis(payInputEntitis);
        return outputEntity;
    }

    private List<PayInputEntity> getPayInputEntityList(String orderMainNo, String ip) {
        List<MallOrderPayEntity> mallOrderPayEntitis;
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo);
        if (mallOrderMainEntity == null) {
            return new ArrayList<PayInputEntity>();
        }
        CustomerDetailVo customerDetail = this.customerInterface.getCustomerDetail(mallOrderMainEntity.getCustomerId(), mallOrderMainEntity.getPlatformId());
        String openId = "";
        String customerId = mallOrderMainEntity.getCustomerId();
        if (customerDetail != null) {
            openId = customerDetail.getOpenId();
            customerId = customerDetail.getCustomerId();
        }
        if ((mallOrderPayEntitis = this.mallOrderPayInterface.getList(orderMainNo)) == null) {
            return new ArrayList<PayInputEntity>();
        }
        ArrayList<PayInputEntity> inputEntitis = new ArrayList<PayInputEntity>();
        for (MallOrderPayEntity e : mallOrderPayEntitis) {
            PayInputEntity pe = new PayInputEntity();
            pe.setPayId(e.getPayId());
            pe.setOrderMainNo(orderMainNo);
            pe.setPayType(e.getPaytypeId());
            pe.setPaySubType(e.getPaySubtypeId());
            pe.setPayAmount(e.getPayamount());
            pe.setSuccess(e.getIssuccess() == 1);
            pe.setOrderCreateTime(mallOrderMainEntity.getCreateTime());
            pe.setOpenId(openId);
            pe.setOrder(e.getSort());
            pe.setTradeNo(e.getTradeNo());
            pe.setThirdTradeNo(e.getThirdTradeNo());
            pe.setCustomerId(customerId);
            pe.setIp(ip);
            pe.setCashType(e.getCashType());
            pe.setCardType(e.getCardType());
            this.fillPayInputEntity(pe, mallOrderMainEntity.getPlatformId(), e.getPaySubtypeId());
            this.logger.info("\u8ba2\u5355:{},\u652f\u4ed8\u7c7b\u578b:{},\u652f\u4ed8\u91d1\u989d:{}", new Object[]{orderMainNo, e.getPaytypeId(), e.getPayamount()});
            inputEntitis.add(pe);
        }
        Comparator<PayInputEntity> orderSort = Comparator.comparingInt(PayInputEntity::getOrder);
        return inputEntitis.stream().sorted(orderSort).collect(Collectors.toList());
    }

    private PayInputEntity getPayInputEntity(String tradeNo) {
        MallOrderPayEntity mallOrderPayEntity = this.mallOrderPayInterface.getSingleOrderPayByTradeNo(tradeNo);
        if (mallOrderPayEntity == null && (mallOrderPayEntity = this.mallOrderPayInterface.getSingle(tradeNo)) == null) {
            return null;
        }
        String orderMainNo = mallOrderPayEntity.getOrderMainNo();
        PayInputEntity pe = null;
        List<PayInputEntity> payInputEntities = this.getPayInputEntityList(orderMainNo, "");
        if (payInputEntities != null && (payInputEntities = payInputEntities.stream().filter(c -> c.getTradeNo().equals(tradeNo) || c.getPayId().equals(tradeNo)).collect(Collectors.toList())) != null) {
            pe = payInputEntities.get(0);
        }
        return pe;
    }

    private PayInputEntity getPayInputEntity(String tradeNo, String orderMainNo) {
        MallOrderPayEntity mallOrderPayEntity = this.mallOrderPayInterface.getSingleOrderPayByTradeNo(tradeNo, orderMainNo);
        if (mallOrderPayEntity == null && (mallOrderPayEntity = this.mallOrderPayInterface.getSingle(tradeNo)) == null) {
            return null;
        }
        PayInputEntity pe = null;
        List<PayInputEntity> payInputEntities = this.getPayInputEntityList(mallOrderPayEntity.getOrderMainNo(), "");
        if (payInputEntities != null && (payInputEntities = payInputEntities.stream().filter(c -> c.getTradeNo().equals(tradeNo) || c.getPayId().equals(tradeNo)).collect(Collectors.toList())) != null) {
            pe = payInputEntities.get(0);
        }
        return pe;
    }

    private String getWechatPayKey(String tradeNo) {
        String key = "";
        int paySubId = 0;
        int platformId = 0;
        MallOrderPayEntity orderPayEntity = this.mallOrderPayInterface.getSingleOrderPayByTradeNo(tradeNo);
        if (orderPayEntity == null && (orderPayEntity = this.mallOrderPayInterface.getSingle(tradeNo)) == null) {
            return key;
        }
        paySubId = orderPayEntity.getPaySubtypeId();
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderPayEntity.getOrderMainNo());
        if (mallOrderMainEntity == null) {
            return key;
        }
        platformId = mallOrderMainEntity.getPlatformId();
        MallPlatformPayTypeEntity platformPayTypeEntity = this.mallPlatformPayTypeInterface.getEntityByPlatIdAndPayTypeSubId(platformId, paySubId);
        if (platformPayTypeEntity != null) {
            key = platformPayTypeEntity.getPayKey();
        }
        return key;
    }

    private String getWechatPayKey(String tradeNo, String orderMainNo) {
        String key = "";
        int paySubId = 0;
        int platformId = 0;
        MallOrderPayEntity orderPayEntity = this.mallOrderPayInterface.getSingleOrderPayByTradeNo(tradeNo, orderMainNo);
        if (orderPayEntity == null && (orderPayEntity = this.mallOrderPayInterface.getSingle(tradeNo)) == null) {
            return key;
        }
        paySubId = orderPayEntity.getPaySubtypeId();
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderPayEntity.getOrderMainNo());
        if (mallOrderMainEntity == null) {
            return key;
        }
        platformId = mallOrderMainEntity.getPlatformId();
        MallPlatformPayTypeEntity platformPayTypeEntity = this.mallPlatformPayTypeInterface.getEntityByPlatIdAndPayTypeSubId(platformId, paySubId);
        if (platformPayTypeEntity != null) {
            key = platformPayTypeEntity.getPayKey();
        }
        return key;
    }

    @Override
    public BaseJsonVo aliPayWapNotify(AliPayNotifyEntity notifyInputEntity) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        PayInputEntity inputEntity = this.getPayInputEntity(notifyInputEntity.getOutTradeNo());
        if (inputEntity == null) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        inputEntity.setEntity(notifyInputEntity);
        return this.payInterface.aliPayWapNotify(inputEntity);
    }

    @Override
    public BaseJsonVo wechatPayNotify(WechatNotifyEntity wechatNotifyEntity) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        this.logger.info(JsonUtils.toJson((Object)wechatNotifyEntity, (boolean)true));
        if (wechatNotifyEntity.getTradeNo() == null) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        String payKey = this.getWechatPayKey(wechatNotifyEntity.getTradeNo(), wechatNotifyEntity.getOrderMainNo());
        wechatNotifyEntity.setPayKey(payKey);
        PayInputEntity inputEntity = this.getPayInputEntity(wechatNotifyEntity.getTradeNo(), wechatNotifyEntity.getOrderMainNo());
        if (inputEntity == null) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        if (PriceUtils.multiply((BigDecimal)inputEntity.getPayAmount(), (Integer)100).compareTo(new BigDecimal(wechatNotifyEntity.getTotalFee())) != 0) {
            this.logger.error("wechat\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u652f\u4ed8\u652f\u4ed8\u91d1\u989d\u4e0d\u4e00\u81f4" + PriceUtils.multiply((BigDecimal)inputEntity.getPayAmount(), (Integer)100).doubleValue() + "--" + wechatNotifyEntity.getTotalFee());
            result.setError("wechat\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u652f\u4ed8\u91d1\u989d\u4e0d\u4e00\u81f4");
            return result;
        }
        if (!inputEntity.getTradeNo().equals(wechatNotifyEntity.getTradeNo())) {
            this.logger.error("wechat\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u4ea4\u6613\u5355\u53f7\u4e0d\u4e00\u81f4" + inputEntity.getTradeNo() + "--" + wechatNotifyEntity.getTradeNo());
            result.setError("wechat\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u4ea4\u6613\u5355\u53f7\u4e0d\u4e00\u81f4");
            return result;
        }
        if (!inputEntity.getAppId().equals(wechatNotifyEntity.getAppId())) {
            this.logger.error("wechat\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u4ea4\u6613\u5355\u53f7\u4e0d\u4e00\u81f4" + inputEntity.getAppId() + "--" + wechatNotifyEntity.getAppId());
            result.setError("wechat\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0cAppId\u4e0d\u4e00\u81f4");
            return result;
        }
        return this.payInterface.wechatPayNotify(wechatNotifyEntity);
    }

    private String getCMBPublicKey(String tradeNo) {
        String publicKey = "";
        int paySubId = 0;
        int platformId = 0;
        MallOrderPayEntity orderPayEntity = this.mallOrderPayInterface.getSingleOrderPayByTradeNo(tradeNo);
        if (orderPayEntity == null && (orderPayEntity = this.mallOrderPayInterface.getSingle(tradeNo)) == null) {
            return publicKey;
        }
        paySubId = orderPayEntity.getPaySubtypeId();
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderPayEntity.getOrderMainNo());
        if (mallOrderMainEntity == null) {
            return publicKey;
        }
        platformId = mallOrderMainEntity.getPlatformId();
        MallPlatformPayTypeEntity platformPayTypeEntity = this.mallPlatformPayTypeInterface.getEntityByPlatIdAndPayTypeSubId(platformId, paySubId);
        if (platformPayTypeEntity != null) {
            publicKey = platformPayTypeEntity.getPublicKey();
        }
        return publicKey;
    }

    @Override
    public BaseJsonVo cmbPayNotify(Map<String, Object> map) {
        this.logger.info("=====PayOrderService.cmbPayNotify=====param={}", (Object)JSON.toJSONString(map));
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        if (StringUtils.isEmpty((String)map.get("mhtOrderNo").toString())) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        String publicKey = this.getCMBPublicKey(map.get("mhtOrderNo").toString());
        map.put("publicKey", publicKey);
        PayInputEntity inputEntity = this.getPayInputEntity(map.get("mhtOrderNo").toString());
        if (inputEntity == null) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        if (PriceUtils.multiply((BigDecimal)inputEntity.getPayAmount(), (Integer)100).compareTo(new BigDecimal(map.get("mhtOrderAmt").toString())) != 0) {
            this.logger.error("cmbPayNotify\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u652f\u4ed8\u652f\u4ed8\u91d1\u989d\u4e0d\u4e00\u81f4" + PriceUtils.multiply((BigDecimal)inputEntity.getPayAmount(), (Integer)100).doubleValue() + "--" + map.get("mhtOrderAmt").toString());
            result.setError("cmbPayNotify \u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u652f\u4ed8\u91d1\u989d\u4e0d\u4e00\u81f4");
            return result;
        }
        if (!inputEntity.getTradeNo().equals(map.get("mhtOrderNo").toString())) {
            this.logger.error("cmbPayNotify\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u4ea4\u6613\u5355\u53f7\u4e0d\u4e00\u81f4" + inputEntity.getTradeNo() + "--" + map.get("mhtOrderNo").toString());
            result.setError("cmbPayNotify\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u4ea4\u6613\u5355\u53f7\u4e0d\u4e00\u81f4");
            return result;
        }
        return this.payInterface.cmbPayNotify(map);
    }

    private void fillPayInputEntity(PayInputEntity pe, int platformId, int payTypeSubId) {
        MallPlatformPayTypeEntity platformPayTypeEntity = this.mallPlatformPayTypeInterface.getEntityByPlatIdAndPayTypeSubId(platformId, payTypeSubId);
        if (platformPayTypeEntity != null) {
            pe.setPayKey(platformPayTypeEntity.getPayKey());
            pe.setAppId(platformPayTypeEntity.getAppid());
            pe.setBody(platformPayTypeEntity.getBody());
            pe.setMchId(platformPayTypeEntity.getMchId());
            pe.setTradeType(platformPayTypeEntity.getTradeType());
            pe.setDomain(platformPayTypeEntity.getDomain());
            pe.setAppName(platformPayTypeEntity.getAppName());
            pe.setPublicKey(platformPayTypeEntity.getPublicKey());
            pe.setRequestDomain(platformPayTypeEntity.getRequestDomain());
            pe.setCharset(platformPayTypeEntity.getCharset());
            pe.setSignType(platformPayTypeEntity.getSignType());
            pe.setReturnUrl(platformPayTypeEntity.getReturnUrl());
            pe.setNotifyUrl(platformPayTypeEntity.getNotifyUrl());
            pe.setSellerEmail(platformPayTypeEntity.getSellerEmail());
            pe.setDataFormat(platformPayTypeEntity.getDataFormat());
            pe.setTimeOut(platformPayTypeEntity.getTimeout());
            pe.setRefundCertFile(platformPayTypeEntity.getRefundCertFile());
            pe.setPlatformId(platformPayTypeEntity.getPlatformId());
            pe.setOrderCancelTime(DateUtils.getAddDateBySecond((Date)pe.getOrderCreateTime(), (int)platformPayTypeEntity.getTimeout()));
        }
    }

    @Override
    public BaseJsonVo paySearch(String orderMainNo) {
        PayInputEntity p;
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        List<PayInputEntity> payInputEntities = this.getPayInputEntityList(orderMainNo, "");
        if (payInputEntities == null || payInputEntities.size() == 0) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        Iterator<PayInputEntity> iterator = payInputEntities.iterator();
        while (iterator.hasNext() && (result = this.payInterface.paySearch(p = iterator.next())).isSuccess()) {
        }
        return result;
    }

    @Override
    public BaseJsonVo payClose(String userId, String tradeNo, String thirdTradeNo) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        PayInputEntity payInputEntity = this.getPayInputEntity(tradeNo);
        if (payInputEntity == null) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        if (!payInputEntity.isSuccess()) {
            result.setError("\u6ca1\u6709\u652f\u4ed8\u6210\u529f\u4e0d\u9700\u8981\u9000\u6b3e");
            return result;
        }
        return this.payInterface.payClose(payInputEntity);
    }

    @Override
    public BaseJsonVo payClose(String customerId, String orderMainNo) {
        PayInputEntity payInputEntity1;
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        List<PayInputEntity> payInputEntities = this.getPayInputEntityList(orderMainNo, "");
        if (payInputEntities == null || payInputEntities.size() == 0) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        this.logger.info("--------payClose--------payInputEntities={}", (Object)JSON.toJSONString(payInputEntities));
        if (payInputEntities.stream().filter(c -> c.getCashType() == 1).collect(Collectors.toList()) != null && payInputEntities.stream().filter(c -> c.getCashType() == 1).collect(Collectors.toList()).size() > 0) {
            PayInputEntity payInputEntity = (PayInputEntity)payInputEntities.stream().filter(c -> c.getCashType() == 1).collect(Collectors.toList()).get(0);
            this.logger.info("--------payClose--------payInputEntity={}", (Object)JSON.toJSONString((Object)payInputEntity));
            List<MallOrderPayRecordEntity> mallOrderPayRecordEntityList = this.orderPayRecordInterface.queryOrderPayRecordInfo(payInputEntity.getOrderMainNo(), payInputEntity.getTradeNo());
            if (mallOrderPayRecordEntityList != null && mallOrderPayRecordEntityList.size() > 0) {
                for (MallOrderPayRecordEntity mallOrderPayRecordEntity : mallOrderPayRecordEntityList) {
                    Date notifyTime;
                    this.logger.info("=========cc.lechun.mall.service.pay.PayOrderService.payClose==========mallOrderPayRecordEntity={}", (Object)JSON.toJSONString((Object)mallOrderPayRecordEntity));
                    if (!mallOrderPayRecordEntity.getPaytypeId().equals(payInputEntity.getPayType()) || (notifyTime = mallOrderPayRecordEntity.getNotifyTime()) == null) continue;
                    this.logger.info("=========cc.lechun.mall.service.pay.PayOrderService.payClose==========notifyTime={}", (Object)notifyTime);
                    result.setError("\u6682\u65f6\u65e0\u6cd5\u53d6\u6d88");
                    return result;
                }
            }
            result = this.payInterface.payClose(payInputEntity);
        }
        if (!result.isSuccess()) {
            return result;
        }
        payInputEntities = payInputEntities.stream().filter(c -> c.isSuccess() && c.getCashType() == 0).collect(Collectors.toList());
        Iterator<PayInputEntity> iterator = payInputEntities.iterator();
        while (iterator.hasNext() && (result = this.payInterface.payClose(payInputEntity1 = iterator.next())).isSuccess()) {
        }
        return result;
    }

    private void updateCustomerOrderNo(MallOrderMainEntity orderMain) {
        if (orderMain.getOrderClass().intValue() == OrderClassEnum.MALL_ORDER.getValue() || orderMain.getOrderClass().intValue() == OrderClassEnum.GIFTCARD_ORDER.getValue()) {
            try {
                Integer num = this.mallOrderInterface.getUserOrderCountPaid(orderMain.getCustomerId());
                boolean newUser = num == null ? true : num <= 1;
                CustomerEntity customerEntity = new CustomerEntity();
                customerEntity.setCustomerId(orderMain.getCustomerId());
                customerEntity.setCurrentOrderCount(num);
                if (newUser) {
                    customerEntity.setIsNew(1);
                    if (num == 0) {
                        customerEntity.setFirstOrderTime(null);
                    }
                }
                this.customerInterface.updateCustomerEntitySelective(customerEntity);
                this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.userInfo, MessageParam.messageParam((String)"", (Object)customerEntity.getCustomerId()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public BaseJsonVo fixBalancePay() {
        List<Map<String, Object>> errorOrderList = this.payMapper.getOrderPayTyesLast();
        errorOrderList.forEach(map -> {
            MallOrderPayEntity param = new MallOrderPayEntity();
            param.setOrderMainNo((String)map.get("ORDER_MAIN_NO"));
            List paysAll = this.payMapper.getList(param);
            param.setPaySubtypeId((int)((Integer)map.get("PAY_SUB_TYPE")));
            param.setPayId(String.valueOf(IDGenerate.getUniqueID()));
            param.setPaytypeId(8);
            param.setPaytypeName("\u4f59\u989d\u652f\u4ed8");
            if (paysAll != null && paysAll.size() > 0) {
                param.setCreateTime(((MallOrderPayEntity)paysAll.get(0)).getCreateTime());
                param.setIssuccess(((MallOrderPayEntity)paysAll.get(0)).getIssuccess());
            } else {
                MallOrderMainEntity orderMain = this.mallOrderMainInterface.selectByPrimaryKey(param.getOrderMainNo());
                if (orderMain == null) {
                    this.logger.info("\u8ba2\u5355\u4e0d\u5b58\u5728:" + param.getOrderMainNo());
                    return;
                }
                param.setCreateTime(orderMain.getCreateTime());
                param.setIssuccess(1);
            }
            param.setSort(2);
            param.setTradeNo(param.getPayId());
            param.setCashType(0);
            param.setIssuccess(0);
            param.setPayamount(new BigDecimal((Integer)map.get("PAY_MONEY")).divide(new BigDecimal(100)));
            param.setPrePayId("");
            param.setSuccessTime(null);
            param.setThirdTradeNo("");
            this.payMapper.insertTemp(param);
        });
        return BaseJsonVo.success((Object)"");
    }
}

