/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.pay.balancepay;

import cc.lechun.framework.common.enums.pay.PayStatusEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.entity.pay.PayOutputEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.service.pay.PayStrategyInterface;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="orderAmountPay.orderSubAmountPay")
public class OrderSubAmountPayService
extends BaseService
implements PayStrategyInterface {
    @Autowired
    private MallOrderPayInterface orderPayInterface;

    @Override
    public BaseJsonVo pay(PayInputEntity inputEntity) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        PayOutputEntity payOutputEntity = new PayOutputEntity();
        MallOrderPayEntity orderPayEntity = this.orderPayInterface.getSingleOrderPayByTradeNo(inputEntity.getTradeNo());
        if (orderPayEntity == null) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        if (result.isSuccess()) {
            payOutputEntity.setOrderMainNo(inputEntity.getOrderMainNo());
            payOutputEntity.setStatus(PayStatusEnum.PAY_SUCCESS.getValue());
            payOutputEntity.setPayTypeId(inputEntity.getPayType());
            payOutputEntity.setPayTypeSubId(inputEntity.getPaySubType());
            payOutputEntity.setPayId(orderPayEntity.getPayId());
            result.setValue((Object)payOutputEntity);
            this.logger.info("\u8ba2\u5355\u62b5\u6263\uff1a" + JsonUtils.toJson((Object)payOutputEntity, (boolean)true));
        }
        return result;
    }

    @Override
    public <T> BaseJsonVo payNotify(T notifyInputEntity) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        return result;
    }

    @Override
    public <T> BaseJsonVo payNotify(Map<String, Object> map) {
        return null;
    }

    @Override
    public BaseJsonVo paySearch(PayInputEntity inputEntity) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        return result;
    }

    @Override
    public BaseJsonVo payClose(PayInputEntity inputEntity) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        return result;
    }

    @Override
    public BaseJsonVo payRefund(PayInputEntity inputEntity) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        return result;
    }

    @Override
    public <T> BaseJsonVo refundNotify(T notifyInputEntity) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        return result;
    }
}

