/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.pay.bankpay;

import cc.lechun.framework.common.enums.pay.PayStatusEnum;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.entity.pay.PayOutputEntity;
import cc.lechun.mall.entity.pay.WechatRefundReturnEntity;
import cc.lechun.mall.service.pay.PayStrategyInterface;
import cc.lechun.mall.service.pay.bankpay.CMBBankPayComon;
import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="bankPay.bankSubCMBPay")
public class CMBBankPayService
extends BaseService
implements PayStrategyInterface {
    @Override
    public BaseJsonVo pay(PayInputEntity inputEntity) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        Map<String, Object> resultMap = CMBBankPayComon.createBankPayInfo(inputEntity);
        String bankPayInfoString = CMBBankPayComon.getNamValStr(resultMap);
        this.logger.info("------cc.lechun.mall.service.pay.bankpay.CMBBankPayService.pay-------bankPayInfoString={}", (Object)bankPayInfoString);
        try {
            PayOutputEntity payOutputEntity = null;
            String cmbResult = HttpRequest.httpsPost((String)inputEntity.getRequestDomain(), (String)bankPayInfoString);
            cmbResult = URLDecoder.decode(cmbResult, "UTF-8");
            String[] cmbResultList = cmbResult.split("&");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String s : cmbResultList) {
                int index = s.indexOf("=");
                String key = s.substring(0, index);
                String value = s.substring(index + 1);
                map.put(key, value);
            }
            if (map != null) {
                payOutputEntity = new PayOutputEntity();
                if ("A001".equals(map.get("responseCode").toString())) {
                    this.logger.info("------------cc.lechun.mall.service.pay.bankpay.CMBBankPayService.pay \u8fdb\u5165\u5230\u8bf7\u6c42\u6210\u529f---------map={}", (Object)JSON.toJSONString(map));
                    String tn = map.get("tn").toString();
                    payOutputEntity.setAppId(map.get("wxAppId").toString());
                    payOutputEntity.setSign(map.get("paySign").toString());
                    payOutputEntity.setNonceStr(map.get("nonceStr").toString());
                    payOutputEntity.setPackages("prepay_id=" + map.get("prepay_id").toString());
                    payOutputEntity.setPrepayId(map.get("prepay_id").toString());
                    payOutputEntity.setSignType(map.get("signType").toString());
                    payOutputEntity.setPartnerId(map.get("mhtSubMchId").toString());
                    payOutputEntity.setTimeStamp(tn.split("=")[1]);
                    payOutputEntity.setOrderMainNo(map.get("mhtOrderNo").toString());
                    payOutputEntity.setStatus(PayStatusEnum.TO_PAY_SUCCESS.getValue());
                    payOutputEntity.setStatus(5);
                } else {
                    this.logger.error("============request cmb bank  error" + map.get("responseMsg").toString());
                    result.setError("request cmb bank  error" + map.get("responseMsg").toString());
                    payOutputEntity.setOrderMainNo(map.get("mhtOrderNo").toString());
                    payOutputEntity.setAppId(map.get("wxAppId").toString());
                    payOutputEntity.setSign(map.get("paySign").toString());
                    payOutputEntity.setPrepayId(map.get("prepay_id").toString());
                    payOutputEntity.setSignType(map.get("signType").toString());
                    payOutputEntity.setStatus(4);
                }
                payOutputEntity.setPayId(inputEntity.getPayId());
                payOutputEntity.setPayTypeId(inputEntity.getPayType());
                payOutputEntity.setPayTypeSubId(inputEntity.getPaySubType());
                payOutputEntity.setMessage(map.get("responseMsg").toString());
                payOutputEntity.setSendContent(URLDecoder.decode(bankPayInfoString, "UTF-8"));
                payOutputEntity.setSendUrl(inputEntity.getRequestDomain());
                payOutputEntity.setReturnContent(cmbResult);
            }
            result.setValue(payOutputEntity);
            this.logger.info("=========cc.lechun.mall.service.pay.bankpay.CMBBankPayService.pay=======cmbResult={}", (Object)URLDecoder.decode(cmbResult, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public <T> BaseJsonVo payNotify(T notifyInputEntity) {
        return null;
    }

    @Override
    public <T> BaseJsonVo payNotify(Map<String, Object> map) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        String cmbSign = map.get("signature").toString();
        String publicKey = map.get("publicKey").toString();
        map.remove("signature");
        map.remove("publicKey");
        this.logger.info("======cmbPayNotify=======map={}", (Object)JSON.toJSONString(map));
        String mhtSignature = CMBBankPayComon.getFormDataParamMD5(map, publicKey, "UTF-8");
        if (cmbSign.equals(mhtSignature)) {
            return result;
        }
        result.setError("\u7b7e\u540d\u9519\u8bef");
        return result;
    }

    @Override
    public BaseJsonVo paySearch(PayInputEntity inputEntity) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        String paySearchUrl = "https://ipaynow.acquire.cmbchina.com/";
        Map<String, Object> resultMap = CMBBankPayComon.bankPaySearch(inputEntity);
        String bankPaySearchParam = CMBBankPayComon.getNamValStr(resultMap);
        this.logger.info("------cc.lechun.mall.service.pay.bankpay.CMBBankPayService.paySearch-------bankPaySearchParam={}", (Object)bankPaySearchParam);
        try {
            String bankPaySearchResult = HttpRequest.httpsPost((String)paySearchUrl, (String)bankPaySearchParam);
            bankPaySearchResult = URLDecoder.decode(bankPaySearchResult, "UTF-8");
            this.logger.info("=========cc.lechun.mall.service.pay.bankpay.CMBBankPayService.paySearch=======bankPaySearchResult={}", (Object)bankPaySearchResult);
            String[] bankPaySearchList = bankPaySearchResult.split("&");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String s : bankPaySearchList) {
                int index = s.indexOf("=");
                String key = s.substring(0, index);
                String value = s.substring(index + 1);
                map.put(key, value);
            }
            this.logger.info("-=-=-=-=-=-=-=-cc.lechun.mall.service.pay.bankpay.CMBBankPayService.paySearch.map-=-=-=-=-=-=-=map={}", (Object)JSON.toJSONString(map));
            if (map != null) {
                if ("A001".equals(map.get("responseCode").toString())) {
                    if ("A001".equals(map.get("transStatus").toString())) {
                        return result;
                    }
                    if ("A00I".equals(map.get("transStatus").toString())) {
                        result.setError("\u8ba2\u5355\u672a\u5904\u7406");
                        return result;
                    }
                    if ("A002".equals(map.get("transStatus").toString())) {
                        result.setError("\u8ba2\u5355\u652f\u4ed8\u5931\u8d25");
                        return result;
                    }
                    result.setError("\u4ea4\u6613\u5173\u95ed");
                    return result;
                }
                this.logger.info("-=-=-=-=-=-=-=-cc.lechun.mall.service.pay.bankpay.CMBBankPayService.paySearch.responseMsg-=-=-=-=-=-=-=responseMsg={}", (Object)map.get("responseMsg").toString());
                result.setError(map.get("responseMsg").toString());
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public BaseJsonVo payClose(PayInputEntity inputEntity) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        if (inputEntity.isSuccess()) {
            result.setError("\u6682\u65f6\u65e0\u6cd5\u53d6\u6d88");
        } else {
            result = this.paySearch(inputEntity);
            if (result.isSuccess()) {
                result.setError("\u6682\u65f6\u65e0\u6cd5\u53d6\u6d88");
            } else if (!result.isSuccess()) {
                inputEntity.setRefundBillNo(IDGenerate.getUniqueIdStr());
                if ("\u8ba2\u5355\u672a\u5904\u7406".equals(result.getError_msg()) || "\u8ba2\u5355\u652f\u4ed8\u5931\u8d25".equals(result.getError_msg()) || "\u4ea4\u6613\u5173\u95ed".equals(result.getError_msg())) {
                    result = BaseJsonVo.success((Object)"");
                }
            }
        }
        return result;
    }

    @Override
    public BaseJsonVo payRefund(PayInputEntity inputEntity) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        String payRefundUrl = "https://ipaynow.acquire.cmbchina.com/refund/refundOrder";
        Map<String, Object> resultMap = CMBBankPayComon.createBankRefundInfo(inputEntity);
        String refundParam = CMBBankPayComon.getNamValStr(resultMap);
        inputEntity.setEntity(refundParam);
        this.logger.info("------cc.lechun.mall.service.pay.bankpay.CMBBankPayService.payRefund-------refundParam={}", (Object)refundParam);
        try {
            String cmbRefundResult = HttpRequest.httpsPost((String)payRefundUrl, (String)refundParam);
            cmbRefundResult = URLDecoder.decode(cmbRefundResult, "UTF-8");
            this.logger.info("=========cc.lechun.mall.service.pay.bankpay.CMBBankPayService.payRefund=======cmbRefundResult={}", (Object)cmbRefundResult);
            String bankRefundQueryUrl = "https://ipaynow.acquire.cmbchina.com/refund/refundQuery";
            Map<String, Object> bankRefundQueryMap = CMBBankPayComon.bankRefundQuery(inputEntity);
            String bankRefundQueryParam = CMBBankPayComon.getNamValStr(bankRefundQueryMap);
            this.logger.info("------cc.lechun.mall.service.pay.bankpay.CMBBankPayService.bankRefundQuery-------bankRefundQueryParam={}", (Object)bankRefundQueryParam);
            String bankRefundQueryResult = HttpRequest.httpsPost((String)bankRefundQueryUrl, (String)bankRefundQueryParam);
            bankRefundQueryResult = URLDecoder.decode(bankRefundQueryResult, "UTF-8");
            this.logger.info("=========cc.lechun.mall.service.pay.bankpay.CMBBankPayService.bankRefundQuery=======bankRefundQueryResult={}", (Object)bankRefundQueryResult);
            String[] cmbResultList = cmbRefundResult.split("&");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String s : cmbResultList) {
                int index = s.indexOf("=");
                String key = s.substring(0, index);
                String value = s.substring(index + 1);
                map.put(key, value);
            }
            if (map != null) {
                if ("R000".equals(map.get("responseCode").toString())) {
                    WechatRefundReturnEntity refundReturnEntity = new WechatRefundReturnEntity();
                    refundReturnEntity.setRefunBillNo(map.get("mhtRefundNo").toString());
                    refundReturnEntity.setThirdRefundId(map.get("nowPayOrderNo").toString());
                    refundReturnEntity.setRefundFee(map.get("amount").toString());
                    refundReturnEntity.setCouuponRefundFee("0");
                    refundReturnEntity.setCouponRefundCount("0");
                    result.setValue((Object)refundReturnEntity);
                    return result;
                }
                this.logger.info("-=-=-=-=-=-=-=-cmbBankPay.payRefund.responseMsg-=-=-=-=-=-=-=responseMsg={}", (Object)map.get("responseMsg").toString());
                result.setError(map.get("responseMsg").toString());
                result.setValue(map);
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public <T> BaseJsonVo refundNotify(T notifyInputEntity) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        return null;
    }

    public BaseJsonVo refundOrder(PayInputEntity inputEntity) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        String refundOrderUrl = "https://ipaynow.acquire.cmbchina.com/refund/refundOrder";
        Map<String, Object> resultOrderMap = CMBBankPayComon.createBankRefundOrder(inputEntity);
        String resultOrderParam = CMBBankPayComon.getNamValStr(resultOrderMap);
        this.logger.info("------cc.lechun.mall.service.pay.bankpay.CMBBankPayService.refundOrder-------resultOrderParam={}", (Object)resultOrderParam);
        try {
            String refundOrderResult = HttpRequest.httpsPost((String)refundOrderUrl, (String)resultOrderParam);
            refundOrderResult = URLDecoder.decode(refundOrderResult, "UTF-8");
            this.logger.info("=========cc.lechun.mall.service.pay.bankpay.CMBBankPayService.refundOrder=======refundOrderResult={}", (Object)refundOrderResult);
            String[] refundOrderList = refundOrderResult.split("&");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String s : refundOrderList) {
                int index = s.indexOf("=");
                String key = s.substring(0, index);
                String value = s.substring(index + 1);
                map.put(key, value);
            }
            if (map != null) {
                if ("R000".equals(map.get("responseCode").toString()) && "A001".equals(map.get("tradeStatus").toString())) {
                    return result;
                }
                if ("A002".equals(map.get("tradeStatus").toString())) {
                    result.setError("\u6682\u65f6\u65e0\u6cd5\u53d6\u6d88");
                    return result;
                }
                if ("A003".equals(map.get("tradeStatus").toString()) || "A004".equals(map.get("tradeStatus").toString())) {
                    result = this.refundQuery(inputEntity);
                    this.logger.info("=========cc.lechun.mall.service.pay.bankpay.CMBBankPayService.refundOrder=======refundQueryResult={}", (Object)result);
                    return result;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public BaseJsonVo refundQuery(PayInputEntity inputEntity) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        String refundQueryUrl = "https://ipaynow.acquire.cmbchina.com/refund/refundQuery";
        Map<String, Object> refundQueryMap = CMBBankPayComon.refundQuery(inputEntity);
        String refundQueryParam = CMBBankPayComon.getNamValStr(refundQueryMap);
        this.logger.info("------cc.lechun.mall.service.pay.bankpay.CMBBankPayService.refundQuery-------refundQueryParam={}", (Object)refundQueryParam);
        try {
            String refundQueryResult = HttpRequest.httpsPost((String)refundQueryUrl, (String)refundQueryParam);
            refundQueryResult = URLDecoder.decode(refundQueryResult, "UTF-8");
            this.logger.info("=========cc.lechun.mall.service.pay.bankpay.CMBBankPayService.refundQuery=======refundQueryResult={}", (Object)refundQueryResult);
            String[] refundQueryList = refundQueryResult.split("&");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String s : refundQueryList) {
                int index = s.indexOf("=");
                String key = s.substring(0, index);
                String value = s.substring(index + 1);
                map.put(key, value);
            }
            if (map != null) {
                if ("R000".equals(map.get("responseCode").toString()) && "A001".equals(map.get("tradeStatus").toString())) {
                    return result;
                }
                result.setError("\u6682\u65f6\u65e0\u6cd5\u53d6\u6d88");
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private String createRefundSign(PayInputEntity inputEntity) {
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("amount", PriceUtils.multiply((BigDecimal)inputEntity.getRefundAmount(), (Integer)100).intValue());
        signMap.put("appId", inputEntity.getPayKey());
        signMap.put("funcode", "R001");
        signMap.put("mhtCharset", inputEntity.getCharset());
        signMap.put("mhtOrderNo", inputEntity.getTradeNo());
        signMap.put("mhtRefundNo", inputEntity.getRefundBillNo());
        String signStr = CMBBankPayComon.getFormDataParamMD5(signMap, inputEntity.getPublicKey(), inputEntity.getCharset());
        return signStr;
    }
}

