/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.point;

import cc.lechun.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.balance.dto.BalanceChangeDTO;
import cc.lechun.common.enums.common.StatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.point.CustomerPointMapper;
import cc.lechun.mall.dao.trade.MallOrderPayMapper;
import cc.lechun.mall.dao.vip.MallVipMapper;
import cc.lechun.mall.dao.vip.MallVipTimeMapper;
import cc.lechun.mall.entity.point.CustomerPointEntity;
import cc.lechun.mall.entity.point.CustomerPointVo;
import cc.lechun.mall.entity.point.PointStatusEnum;
import cc.lechun.mall.entity.point.SourceTypeEnum;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.vip.MallVipTimeEntity;
import cc.lechun.mall.entity.vip.SimpleVipVo;
import cc.lechun.mall.entity.vip.SupperVipTypeEnum;
import cc.lechun.mall.entity.vip.VipLevelTypeEnum;
import cc.lechun.mall.iservice.point.CustomerPointInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.service.point.event.PointChangeEvent;
import cc.lechun.utils.EventPublisher;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerPointService
extends BaseService<CustomerPointEntity, Integer>
implements CustomerPointInterface {
    @Resource
    private CustomerPointMapper customerPointMapper;
    @Autowired
    EventPublisher eventPublisher;
    @Resource
    private MallOrderPayMapper orderPayMapper;
    @Autowired
    RedissonClient redissonClient;
    @Autowired
    private BalanceAccountInvoke balanceAccountInvoke;
    @Autowired
    private MallVipMapper vipMapper;
    @Autowired
    private MallVipTimeMapper vipTimeMapper;
    @Autowired
    private MallVipInterface mallVipInterface;

    @Override
    public CustomerPointVo getCustomerPoint(String customerId) {
        CustomerPointEntity query = new CustomerPointEntity();
        query.setCustomerId(customerId);
        List list = this.customerPointMapper.getList(query);
        list = list.stream().sorted((p1, p2) -> {
            if (p1.getCreateTime().after(p2.getCreateTime())) {
                return -1;
            }
            if (p1.getCreateTime().before(p2.getCreateTime())) {
                return 1;
            }
            return 0;
        }).collect(Collectors.toList());
        CustomerPointVo result = new CustomerPointVo();
        result.setTotalPoint(BigDecimal.ZERO);
        result.setExchangePoint(BigDecimal.ZERO);
        result.setExpiryPoint(BigDecimal.ZERO);
        if (CollectionUtils.isNotEmpty(list)) {
            List tempPointList = list.stream().filter(p -> {
                Boolean flag = Objects.equals(p.getStatus(), PointStatusEnum.locked.getValue()) || Objects.equals(p.getStatus(), PointStatusEnum.not_redeemed.getValue());
                if (flag.booleanValue() && p.getEndTime() != null && p.getEndTime().before(new Date())) {
                    flag = false;
                }
                return flag;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(tempPointList)) {
                result.setTotalPoint(tempPointList.stream().map(CustomerPointEntity::getPoint).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            result.setExchangePoint(list.stream().filter(p -> Objects.equals(p.getStatus(), PointStatusEnum.redeemed.getValue())).map(CustomerPointEntity::getPoint).reduce(BigDecimal.ZERO, BigDecimal::add));
            result.setExpiryPoint(PriceUtils.divide((BigDecimal)result.getTotalPoint(), (BigDecimal)BigDecimal.valueOf(100L)));
            result.setExpiryPoint(list.stream().filter(p -> Objects.equals(p.getStatus(), PointStatusEnum.not_redeemed.getValue()) && p.getEndTime().before(new Date()) || Objects.equals(p.getStatus(), PointStatusEnum.expired.getValue())).map(CustomerPointEntity::getPoint).reduce(BigDecimal.ZERO, BigDecimal::add));
            List<CustomerPointVo.CustomerPointItem> tempList = list.stream().map(point -> {
                CustomerPointVo.CustomerPointItem customerPoint = new CustomerPointVo.CustomerPointItem();
                BeanUtils.copyProperties((Object)point, (Object)customerPoint);
                customerPoint.setSourceTypeName(SourceTypeEnum.getName(point.getSourceType()));
                customerPoint.setStatusName(PointStatusEnum.getName(point.getStatus()));
                if (Objects.equals(point.getStatus(), PointStatusEnum.locked.getValue()) || Objects.equals(point.getStatus(), PointStatusEnum.not_redeemed.getValue())) {
                    if (point.getEndTime() != null) {
                        if (point.getEndTime().before(new Date())) {
                            customerPoint.setStatus(PointStatusEnum.expired.getValue());
                            customerPoint.setPointDesc("-" + point);
                        } else {
                            customerPoint.setPointDesc("+" + point.getPoint());
                        }
                    } else {
                        customerPoint.setPointDesc("+" + point.getPoint());
                    }
                } else if (Objects.equals(point.getStatus(), PointStatusEnum.redeemed.getValue()) || Objects.equals(point.getStatus(), PointStatusEnum.expired.getValue())) {
                    customerPoint.setPointDesc("-" + point.getPoint());
                }
                return customerPoint;
            }).collect(Collectors.toList());
            result.setPointList(tempList);
        }
        return result;
    }

    @Override
    public void createPoint(MallOrderMainEntity mallOrderMainEntity) {
        boolean vipDay = this.mallVipInterface.isVipDayNow();
        String customerId = mallOrderMainEntity.getCustomerId();
        SimpleVipVo mallVipEntity = this.mallVipInterface.getSimpleVipVo(customerId, VipLevelTypeEnum.superVip.getValue());
        if (mallVipEntity == null) {
            this.logger.error("\u7528\u6237:{}\u6ca1\u6709\u4f1a\u5458\u4e0d\u79ef\u5206", (Object)mallOrderMainEntity.getCustomerId());
            return;
        }
        this.logger.info("\u7528\u6237:{} \u4f1a\u5458\u4fe1\u606f:{}", (Object)mallOrderMainEntity.getCustomerId(), (Object)JSON.toJSONString((Object)mallVipEntity));
        if (!Objects.equals(mallVipEntity.getVipType(), VipLevelTypeEnum.superVip.getValue())) {
            this.logger.info("\u7528\u6237:{}\u4e0d\u662f\u8d85\u7ea7\u4f1a\u5458\u4e0d\u79ef\u5206", (Object)mallOrderMainEntity.getCustomerId());
            return;
        }
        if (!Objects.equals(mallVipEntity.getStatus(), StatusEnum.STATUS_OK.getValue())) {
            this.logger.info("\u7528\u6237:{}\u8d85\u7ea7\u4f1a\u5458\u5df2\u5931\u6548 \u4e0d\u79ef\u5206", (Object)mallOrderMainEntity.getCustomerId());
            return;
        }
        if (Objects.equals(mallVipEntity.getVipType(), SupperVipTypeEnum.main.getValue()) || Objects.equals(mallVipEntity.getVipType(), SupperVipTypeEnum.auxiliary.getValue())) {
            if (mallVipEntity.getEndTime().before(new Date())) {
                this.logger.error("\u7528\u6237:{}\u4f1a\u5458\u5df2\u8fc7\u671f:{}", (Object)mallOrderMainEntity.getCustomerId(), (Object)mallVipEntity.getEndTime());
                return;
            }
            if (Objects.equals(mallVipEntity.getSuperVipType(), SupperVipTypeEnum.auxiliary.getValue())) {
                MallVipTimeEntity parentVipTime = (MallVipTimeEntity)this.vipTimeMapper.selectByPrimaryKey(mallVipEntity.getParentId());
                this.logger.info("\u526f\u5361\u7528\u6237:{}\u4e0b\u5355,\u79ef\u5206\u8ba1\u5230\u4e3b\u5361\u7528\u6237:{}\u4e0a", (Object)customerId, (Object)parentVipTime.getCustomerId());
                customerId = parentVipTime.getCustomerId();
            }
            CustomerPointEntity query = new CustomerPointEntity();
            query.setCustomerId(customerId);
            query.setSourceType(SourceTypeEnum.order.getValue());
            query.setSource(mallOrderMainEntity.getOrderMainNo());
            CustomerPointEntity customerPointEntity = (CustomerPointEntity)this.customerPointMapper.getSingle(query);
            if (customerPointEntity != null) {
                this.logger.info("\u7528\u6237:{}\u8ba2\u5355\u53f7:{} \u79ef\u5206\u5df2\u5b58\u5728", (Object)customerId, (Object)mallOrderMainEntity.getOrderMainNo());
                return;
            }
            MallOrderPayEntity payquery = new MallOrderPayEntity();
            payquery.setOrderMainNo(mallOrderMainEntity.getOrderMainNo());
            payquery.setIssuccess(1);
            List payList = this.orderPayMapper.getList(payquery);
            if (CollectionUtils.isEmpty((Collection)payList)) {
                this.logger.error("\u79ef\u5206\u521b\u5efa\u5931\u8d25,\u8ba2\u5355:{}\u652f\u4ed8\u8bb0\u5f55\u4e3a\u7a7a", (Object)mallOrderMainEntity.getOrderMainNo());
                return;
            }
            if (CollectionUtils.isEmpty(payList = payList.stream().filter(pay -> !Objects.equals(pay.getPaytypeId(), 3)).collect(Collectors.toList()))) {
                this.logger.error("\u79ef\u5206\u521b\u5efa\u5931\u8d25,\u8ba2\u5355:{}\u629b\u6389\u4f18\u60e0\u5238\u652f\u4ed8\u540e\uff0c\u8bb0\u5f55\u4e3a\u7a7a", (Object)mallOrderMainEntity.getOrderMainNo());
                return;
            }
            customerPointEntity = new CustomerPointEntity();
            customerPointEntity.setCustomerId(customerId);
            customerPointEntity.setSourceType(1);
            customerPointEntity.setPoint(payList.stream().map(MallOrderPayEntity::getPayamount).reduce(BigDecimal.ZERO, BigDecimal::add));
            if (vipDay) {
                customerPointEntity.setPoint(PriceUtils.multiply((BigDecimal)customerPointEntity.getPoint(), (Integer)2));
            }
            customerPointEntity.setSource(mallOrderMainEntity.getOrderMainNo());
            customerPointEntity.setRemark("");
            customerPointEntity.setCreateTime(new Date());
            customerPointEntity.setUpdateTime(new Date());
            customerPointEntity.setStatus(0);
            this.customerPointMapper.insert(customerPointEntity);
            ArrayList<CustomerPointEntity> list = new ArrayList<CustomerPointEntity>();
            list.add(customerPointEntity);
            this.eventPublisher.publish((Object)new PointChangeEvent(list));
        } else {
            this.logger.info("\u7528\u6237:{}\u4e0d\u662f\u8d85\u7ea7\u4f1a\u5458\uff0c\u4e0d\u7d2f\u8ba1\u79ef\u5206", (Object)customerId);
        }
    }

    @Override
    public void unLockPoint(MallOrderMainEntity mallOrderMainEntity) {
        CustomerPointEntity query = new CustomerPointEntity();
        query.setSourceType(SourceTypeEnum.order.getValue());
        query.setSource(mallOrderMainEntity.getOrderMainNo());
        CustomerPointEntity customerPointEntity = (CustomerPointEntity)this.customerPointMapper.getSingle(query);
        if (customerPointEntity != null && customerPointEntity.getStatus().intValue() == PointStatusEnum.locked.getValue()) {
            customerPointEntity.setStatus(PointStatusEnum.not_redeemed.getValue());
            customerPointEntity.setUpdateTime(new Date());
            customerPointEntity.setBeginTime(new Date());
            customerPointEntity.setRemark("\u5df2\u786e\u8ba4\u6536\u8d27");
            customerPointEntity.setEndTime(DateUtils.getAddDateByYear((Date)new Date(), (int)1));
            this.customerPointMapper.updateByPrimaryKeySelective(customerPointEntity);
            ArrayList<CustomerPointEntity> list = new ArrayList<CustomerPointEntity>();
            list.add(customerPointEntity);
            this.eventPublisher.publish((Object)new PointChangeEvent(list));
        }
    }

    @Override
    public void cancelPoint(String orderNo) {
        CustomerPointEntity query = new CustomerPointEntity();
        query.setSource(orderNo);
        query.setSourceType(SourceTypeEnum.order.getValue());
        CustomerPointEntity customerPointEntity = (CustomerPointEntity)this.customerPointMapper.getSingle(query);
        if (customerPointEntity.getStatus().intValue() == PointStatusEnum.locked.getValue()) {
            customerPointEntity.setStatus(PointStatusEnum.expired.getValue());
            customerPointEntity.setUpdateTime(new Date());
            customerPointEntity.setRemark("\u8ba2\u5355\u5df2\u53d6\u6d88");
            this.customerPointMapper.updateByPrimaryKeySelective(customerPointEntity);
            ArrayList<CustomerPointEntity> list = new ArrayList<CustomerPointEntity>();
            list.add(customerPointEntity);
            this.eventPublisher.publish((Object)new PointChangeEvent(list));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public BaseJsonVo exchangePoint(String customerId) throws InterruptedException {
        RLock rLock = this.redissonClient.getLock(customerId + "exchangePoint");
        boolean isLocked = rLock.tryLock(15L, TimeUnit.SECONDS);
        if (isLocked) {
            try {
                CustomerPointEntity query = new CustomerPointEntity();
                query.setCustomerId(customerId);
                query.setStatus(PointStatusEnum.not_redeemed.getValue());
                List list = this.customerPointMapper.getList(query);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"\u5151\u6362\u5931\u8d25,\u6ca1\u6709\u53ef\u5151\u6362\u7684\u79ef\u5206");
                    return baseJsonVo;
                }
                for (CustomerPointEntity customerPointEntity : list) {
                    BaseJsonVo<BalanceChangeDTO> baseJsonVo = this.balanceAccountInvoke.increaseManual(customerId, PriceUtils.divide((BigDecimal)customerPointEntity.getPoint(), (BigDecimal)new BigDecimal(100)), customerId, "\u79ef\u5206\u5151\u6362" + customerPointEntity.getPointId());
                    if (!baseJsonVo.isSuccess()) continue;
                    customerPointEntity.setUpdateTime(new Date());
                    customerPointEntity.setStatus(PointStatusEnum.redeemed.getValue());
                    customerPointEntity.setRemark("\u79ef\u5206\u5df2\u5151\u6362\u4f59\u989d");
                    this.customerPointMapper.updateByPrimaryKeySelective(customerPointEntity);
                }
                this.eventPublisher.publish((Object)new PointChangeEvent(list));
            }
            finally {
                rLock.unlock();
            }
            return BaseJsonVo.success((Object)"\u5151\u6362\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u5151\u6362\u5931\u8d25,\u8bf7\u7a0d\u5019\u518d\u8bd5");
    }
}

