/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.point.event;

import cc.lechun.mall.entity.point.CustomerPointEntity;
import cc.lechun.mall.entity.point.CustomerPointLogEntity;
import cc.lechun.mall.entity.point.PointStatusEnum;
import cc.lechun.mall.iservice.point.CustomerPointLogInterface;
import cc.lechun.mall.service.point.event.PointChangeEvent;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class PointChangeEventListener
implements ApplicationListener<PointChangeEvent> {
    @Autowired
    private CustomerPointLogInterface customerPointInterface;
    private CustomerPointEntity customerPointEntity;

    public void onApplicationEvent(PointChangeEvent pointChangeEvent) {
        try {
            List<CustomerPointEntity> list = pointChangeEvent.getList();
            for (CustomerPointEntity customerPointEntity : list) {
                CustomerPointLogEntity customerPointLogEntity = new CustomerPointLogEntity();
                customerPointLogEntity.setCustomerId(customerPointEntity.getCustomerId());
                customerPointLogEntity.setPoint(customerPointEntity.getPoint());
                customerPointLogEntity.setPointId(customerPointEntity.getPointId());
                customerPointLogEntity.setCreateTime(new Date());
                if (customerPointEntity.getStatus().intValue() == PointStatusEnum.locked.getValue()) {
                    customerPointLogEntity.setRemark("\u4e0b\u5355\u65b0\u589e\u79ef\u5206");
                } else if (customerPointEntity.getStatus().intValue() == PointStatusEnum.not_redeemed.getValue()) {
                    customerPointLogEntity.setRemark("\u786e\u8ba4\u6536\u8d27\u89e3\u9501\u79ef\u5206");
                } else if (customerPointEntity.getStatus().intValue() == PointStatusEnum.redeemed.getValue()) {
                    customerPointLogEntity.setRemark("\u79ef\u5206\u5151\u6362");
                } else if (customerPointEntity.getStatus().intValue() == PointStatusEnum.expired.getValue()) {
                    customerPointLogEntity.setRemark("\u79ef\u5206\u8fc7\u671f\u6216\u8ba2\u5355\u9000\u6b3e");
                }
                this.customerPointInterface.insertSelective(customerPointLogEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

