/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.prepay.PrepayCardMapper;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.prepay.PrepayCardDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDo;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardItemEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardItemInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import cc.lechun.mall.service.prepay.PrepayCardPlanHandle;
import cc.lechun.mall.service.prepay.PrepayPlanBaseService;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="card_5")
public class NormalCardPlanService
extends PrepayPlanBaseService
implements PrepayCardPlanHandle {
    @Autowired
    @Lazy
    private PrepayCardInterface prepayCardService;
    @Lazy
    @Autowired
    MallShoppingcartInterface cartService;
    @Lazy
    @Autowired
    CustomerAddressInterface addressService;
    @Autowired
    BalanceAccountInvoke balanceAccountInvoke;
    @Autowired
    private PrepayCardMapper prepayCardMapper;
    @Autowired
    private PrepayCardItemInterface prepayCardItemInterface;
    @Autowired
    @Lazy
    private PrepayCardPlanDetailInterface prepayCardPlanDetailService;
    @Autowired
    private MallShoppingcartInterface shoppingcartInterface;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public BaseJsonVo saveCardPlan(PrepayCardDo prepayCardDo) throws Exception {
        if (prepayCardDo.getDetailedId() == null) {
            BaseJsonVo baseJsonVo = this.prepayCardService.getSpecialTotal(prepayCardDo.getCustomerId(), prepayCardDo.getCardType());
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            BigDecimal remain = (BigDecimal)baseJsonVo.getValue();
            int num = 1;
            BaseJsonVo<List<Map<String, Object>>> cardBaseJsonVo = this.balanceAccountInvoke.getUsableSpecialList(prepayCardDo.getCustomerId(), prepayCardDo.getCardType());
            if (!cardBaseJsonVo.isSuccess()) {
                return BaseJsonVo.error((String)baseJsonVo.getMessage());
            }
            PrepayCardEntity cardQuery = new PrepayCardEntity();
            cardQuery.setRelateCardNo(((Map)((List)cardBaseJsonVo.getValue()).get(0)).get("cardNo").toString());
            PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardMapper.getSingle(cardQuery);
            PrepayCardItemEntity search = new PrepayCardItemEntity();
            search.setCardType(prepayCardDo.getCardType());
            search.setStatus(1);
            int[] transportType = new int[]{2, -1};
            CustomerAddressVo addressVo = this.addressService.getCustomerAddressVO(prepayCardDo.getAddrId(), transportType);
            BaseJsonVo cartSR = this.cartService.buildCart(prepayCardDo.getPlatformId(), prepayCardDo.getCustomerId(), addressVo, false, String.valueOf(prepayCardDo.getCardType()));
            if (!cartSR.isSuccess()) return BaseJsonVo.error((String)cartSR.getError_msg());
            Map cartSRValue = (Map)cartSR.getValue();
            Map nomalcart = (Map)cartSRValue.get("nomalTempCart");
            List productVOList = (List)nomalcart.get("products");
            BigDecimal total = BigDecimal.ZERO;
            for (Object productVO : productVOList) {
                PrepayCardItemEntity prepayCardItemEntity = this.prepayCardItemInterface.getPrepayCardItem(prepayCardEntity.getBatchId(), ((MallProductEntity)productVO).getProId(), (Integer)SalesTypeEnum.SALES_PRODUCT.getValue());
                total = PriceUtils.add((BigDecimal)total, (BigDecimal)PriceUtils.multiply((BigDecimal)prepayCardItemEntity.getSaleValue(), (Integer)((MallProductVO)productVO).getQuantity()));
            }
            List promotionVOList = (List)nomalcart.get("promotions");
            for (MallPromotionVO promotionVO : promotionVOList) {
                PrepayCardItemEntity prepayCardItemEntity = this.prepayCardItemInterface.getPrepayCardItem(prepayCardEntity.getBatchId(), promotionVO.getPromotionId(), (Integer)SalesTypeEnum.SALES_PROMOTION.getValue());
                total = PriceUtils.add((BigDecimal)total, (BigDecimal)PriceUtils.multiply((BigDecimal)prepayCardItemEntity.getSaleValue(), (Integer)promotionVO.getQuantity()));
            }
            if (Objects.equals((int)prepayCardDo.getPeriodType(), 1) || Objects.equals((int)prepayCardDo.getPeriodType(), 2)) {
                num = PriceUtils.divide((BigDecimal)remain, (BigDecimal)total).intValue();
            }
            if (num < 1) {
                return BaseJsonVo.error((String)"\u5976\u5361\u4f59\u989d\u4e0d\u8db3");
            }
            Date fistPickDate = this.getFirstDeliveryDate(prepayCardDo);
            baseJsonVo = this.createPlan(prepayCardDo, num, fistPickDate);
            if (!baseJsonVo.isSuccess()) {
                throw new RuntimeException(baseJsonVo.getMessage());
            }
            Integer remainNum = num - 1;
            ExecutorService pool = Executors.newFixedThreadPool(num);
            try {
                CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> this.createPlan(prepayCardDo, remainNum, this.LocalDateTodate(this.getNextDeliveryDate(this.getLocalDate(fistPickDate), prepayCardDo.getPeriodType(), prepayCardDo.getPeriod(), false))), pool);
                return BaseJsonVo.success((Object)"");
            }
            catch (Exception exception) {
                return BaseJsonVo.success((Object)"");
            }
            finally {
                pool.shutdown();
            }
        } else {
            PrepayCardDetailEntity prepayCardDetailEntity = (PrepayCardDetailEntity)this.prepayCardPlanDetailService.selectByPrimaryKey(prepayCardDo.getDetailedId());
            return this.editePland(prepayCardDo, prepayCardDetailEntity, this.prepayCardPlanDetailService);
        }
    }

    private BaseJsonVo createPlan(PrepayCardDo prepayCardDo, int num, Date pickDate) {
        Integer cardType = prepayCardDo.getCardType();
        for (int i = 0; i < num; ++i) {
            BaseJsonVo<MallOrderCacheVo> jsonVo = this.prepayCardPlanDetailService.setOrderCacheByShoppingcat(prepayCardDo);
            if (jsonVo.isSuccess()) {
                MallOrderCacheVo mallOrderCacheVo = (MallOrderCacheVo)jsonVo.getValue();
                mallOrderCacheVo.setAddressId(prepayCardDo.getAddrId());
                mallOrderCacheVo.setDeliverDate(this.LocalDateTodate(this.getNextDeliveryDate(this.getLocalDate(pickDate), prepayCardDo.getPeriodType(), prepayCardDo.getPeriod(), false)));
                mallOrderCacheVo.setDeliverDate2(mallOrderCacheVo.getDeliverDate());
                mallOrderCacheVo.setBindCode(String.valueOf(cardType));
                mallOrderCacheVo.setMildCardPay(1);
                BaseJsonVo createOrder = BaseJsonVo.error((String)"");
                this.logger.info("\u521b\u5efa\u8ba2\u5355\u53c2\u6570:{}", (Object)JsonUtils.toJson((Object)mallOrderCacheVo, (boolean)false));
                try {
                    createOrder = this.prepayCardPlanDetailService.createPlanOrder(mallOrderCacheVo, prepayCardDo.getCustomerId(), (int)prepayCardDo.getPlatformId());
                    this.logger.info("\u7528\u6237:{}\u5976\u5361\u8ba2\u5355\u521b\u5efa:{},\u6d88\u606f:{}", new Object[]{prepayCardDo.getCustomerId(), createOrder.isSuccess(), createOrder.getMessage()});
                }
                catch (InvalidKeySpecException e) {
                    e.printStackTrace();
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                if (createOrder.isSuccess()) continue;
                break;
            }
            this.logger.error("\u7528\u6237:{}\u521b\u5efa\u5468\u671f\u8ba2\u5355\u5931\u8d25:{}", (Object)prepayCardDo.getCustomerId(), (Object)jsonVo.getMessage());
            return jsonVo;
        }
        return BaseJsonVo.success((Object)"");
    }
}

