/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.prepay.PrepayCardFreeMapper;
import cc.lechun.mall.dao.sales.MallProductMapper;
import cc.lechun.mall.entity.customer.CustomerFreeEntity;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardFreeEntity;
import cc.lechun.mall.entity.sales.MallFreeEntity;
import cc.lechun.mall.entity.sales.MallFreeProductEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductPicEntity;
import cc.lechun.mall.entity.vip.MallVipEntity;
import cc.lechun.mall.entity.vip.MallVipTimeEntity;
import cc.lechun.mall.iservice.customer.CustomerFreeInterface;
import cc.lechun.mall.iservice.customer.CustomerFreeRecordInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardFreeInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.sales.MallFreeInterface;
import cc.lechun.mall.iservice.sales.MallFreeProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.iservice.vip.MallVipTimeInterface;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardFreeService
extends BaseService<PrepayCardFreeEntity, Integer>
implements PrepayCardFreeInterface {
    @Resource
    private PrepayCardFreeMapper prepayCardFreeMapper;
    @Autowired
    private MallFreeInterface mallFreeInterface;
    @Autowired
    private MallFreeProductInterface freeProductInterface;
    @Autowired
    private PrepayCardInterface prepayCardInterface;
    @Autowired
    private CustomerFreeRecordInterface freeRecordInterface;
    @Autowired
    @Lazy
    private CustomerFreeInterface customerFreeInterface;
    @Autowired
    MallProductPicInterface picService;
    @Resource
    private MallProductMapper productMapper;
    @Autowired
    private MallVipTimeInterface vipTimeInterface;
    @Lazy
    @Autowired
    private MallVipInterface vipInterface;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Map<String, Object>> getCardFreeProduct(String customerId, String card, Integer source, Integer customerFreeId) {
        if (source == null) {
            source = 0;
        }
        if (source != 1 && source != 2) {
            return new ArrayList<Map<String, Object>>();
        }
        Integer batchId = null;
        if (source == 1) {
            if (!StringUtils.isNotEmpty((String)card)) return new ArrayList<Map<String, Object>>();
            PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardInterface.selectByPrimaryKey((Serializable)((Object)card));
            if (prepayCardEntity == null) {
                return new ArrayList<Map<String, Object>>();
            }
            if (!customerId.equals(prepayCardEntity.getBelongCustomerId())) {
                return new ArrayList<Map<String, Object>>();
            }
            batchId = prepayCardEntity.getBatchId();
            return this.getCardFreeProduct(batchId, customerId, card, source, customerFreeId);
        } else {
            MallVipEntity vipEntity = this.vipInterface.getUserVipInfoByCustomerId(customerId);
            if (vipEntity == null) {
                return new ArrayList<Map<String, Object>>();
            }
            MallVipTimeEntity search = new MallVipTimeEntity();
            search.setStatus(1);
            search.setFreeStatus(0);
            search.setCustomerId(customerId);
            search.setLevel(vipEntity.getLevel());
            List vipTimeEntities = this.vipTimeInterface.getList(search);
            if (vipTimeEntities == null || vipTimeEntities.size() == 0) {
                return new ArrayList<Map<String, Object>>();
            }
            MallVipTimeEntity vipTimeEntity = (MallVipTimeEntity)vipTimeEntities.get(0);
            if (vipTimeEntity == null) {
                return new ArrayList<Map<String, Object>>();
            }
            if (!customerId.equals(vipTimeEntity.getCustomerId())) {
                return new ArrayList<Map<String, Object>>();
            }
            batchId = vipTimeEntity.getLevel();
            card = vipTimeEntity.getId().toString();
        }
        return this.getCardFreeProduct(batchId, customerId, card, source, customerFreeId);
    }

    @Override
    public boolean checkCustomerIsChooseFree(String customerId, Integer batchId, Integer addOrShow) {
        if (StringUtil.isEmpty((String)customerId)) {
            return false;
        }
        return this.freeRecordInterface.existsFreeRecord(customerId, batchId, addOrShow);
    }

    @Override
    public List<Map<String, Object>> getCardFreeProduct(Integer batchId, String customerId, String cardId, Integer source, Integer customerFreeId) {
        if (batchId == null || StringUtils.isEmpty((String)cardId)) {
            return new ArrayList<Map<String, Object>>();
        }
        if (source == null) {
            return new ArrayList<Map<String, Object>>();
        }
        BigDecimal rate = BigDecimal.ONE;
        boolean changeFlag = false;
        if (customerFreeId != null && customerFreeId > 0) {
            CustomerFreeEntity customerFreeEntity = (CustomerFreeEntity)this.customerFreeInterface.selectByPrimaryKey(customerFreeId);
            if (!Objects.equals(customerFreeEntity.getProductType(), SalesTypeEnum.SALES_PRODUCT.getValue())) {
                this.logger.error("{}\u975e\u5355\u54c1\uff0c\u4e0d\u652f\u6301\u66f4\u6362", (Object)customerFreeEntity.getProductName());
                throw new RuntimeException(customerFreeEntity.getProductName() + "\u4e0d\u652f\u6301\u66f4\u6362,\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            MallProductEntity productEntity = this.productMapper.getProductInfo(customerFreeEntity.getProductId());
            if (!Objects.equals(productEntity.getProState(), 1) && customerFreeEntity.getQuantity() - customerFreeEntity.getUseQuantity() > 0) {
                rate = PriceUtils.divide((BigDecimal)BigDecimal.valueOf(customerFreeEntity.getQuantity() - customerFreeEntity.getUseQuantity()), (BigDecimal)BigDecimal.valueOf(customerFreeEntity.getQuantity().intValue()));
                this.logger.info("\u7528\u6237:{} \u8d60\u54c1\u672a\u4f7f\u7528\u6bd4\u4f8b:{}", (Object)customerId, (Object)rate);
                changeFlag = true;
            }
        }
        PrepayCardFreeEntity prepayCardFreeEntity = new PrepayCardFreeEntity();
        prepayCardFreeEntity.setBatchId(batchId);
        prepayCardFreeEntity.setSource(source);
        prepayCardFreeEntity.setStatus(1);
        List lst = this.getList(prepayCardFreeEntity, 0L);
        if (!this.checkCustomerIsChooseFree(customerId, batchId, 0)) {
            lst = lst.stream().filter(c -> Integer.valueOf(1).equals(c.getFreeType())).collect(Collectors.toList());
        }
        lst = lst.stream().filter(c -> Integer.valueOf(2).equals(c.getCright()) || Integer.valueOf(3).equals(c.getCright())).collect(Collectors.toList());
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        HashMap<String, Integer> existsMap = new HashMap<String, Integer>();
        for (PrepayCardFreeEntity freeEntity : lst) {
            int total;
            CustomerFreeEntity search = new CustomerFreeEntity();
            search.setCustomerId(customerId);
            search.setCardBatchId(batchId);
            search.setFreeId(freeEntity.getFreeId());
            search.setCardId(cardId);
            List freeEntities = this.customerFreeInterface.getList(search, 0L);
            int count = freeEntities.stream().filter(c -> !Integer.valueOf(0).equals(c.getStatus())).mapToInt(c -> c.getQuantity()).sum();
            if (existsMap.get(freeEntity.getBatchId() + "_" + freeEntity.getFreeId()) != null) {
                count = (Integer)existsMap.get(freeEntity.getBatchId() + "_" + freeEntity.getFreeId());
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("id", freeEntity.getId());
            map.put("batchId", batchId);
            int n = total = freeEntity.getFreeQuantity() - count < 0 ? 0 : freeEntity.getFreeQuantity() - count;
            if (changeFlag) {
                total = PriceUtils.multiply((BigDecimal)rate, (Integer)total).setScale(0, 0).intValue();
            }
            map.put("quantity", total);
            if (count - freeEntity.getFreeQuantity() > 0) {
                existsMap.put(freeEntity.getBatchId() + "_" + freeEntity.getFreeId(), count - freeEntity.getFreeQuantity());
                count = freeEntity.getFreeQuantity();
            } else {
                existsMap.put(freeEntity.getBatchId() + "_" + freeEntity.getFreeId(), 0);
            }
            map.put("usedQuantity", count);
            map.put("freeType", freeEntity.getFreeType());
            map.put("freeMethod", freeEntity.getFreeMethod());
            map.put("freeId", freeEntity.getFreeId());
            map.put("cardId", cardId);
            MallFreeEntity mallFreeEntity = this.mallFreeInterface.selectByPrimaryKey(freeEntity.getFreeId());
            if (mallFreeEntity != null) {
                map.put("freeName", mallFreeEntity.getFreeName());
            }
            ArrayList freeProducts = new ArrayList();
            if (StringUtil.isNotEmpty((String)freeEntity.getFreeId())) {
                List<MallFreeProductEntity> frees = this.mallFreeInterface.getMallFreeProduct(freeEntity.getFreeId());
                for (MallFreeProductEntity freeProductEntity : frees) {
                    MallProductEntity productEntity;
                    if (Objects.equals(freeProductEntity.getProductType(), SalesTypeEnum.SALES_PRODUCT.getValue()) && !Objects.equals((productEntity = (MallProductEntity)this.productMapper.selectByPrimaryKey((Serializable)((Object)freeProductEntity.getProductId()))).getProState(), 1)) continue;
                    LinkedHashMap<String, Object> productMap = new LinkedHashMap<String, Object>();
                    productMap.put("productId", freeProductEntity.getProductId());
                    productMap.put("productName", freeProductEntity.getProductName());
                    productMap.put("productType", freeProductEntity.getProductType());
                    productMap.put("quantity", freeProductEntity.getProductCount());
                    List<MallProductPicEntity> picList1 = this.picService.getProductPics(freeProductEntity.getProductId(), ProductPicTypeEnum.PRO_SAMLL.getValue());
                    productMap.put("image", picList1 != null && picList1.size() > 0 ? picList1.get(0).getFullRelativeUrl() : "");
                    freeProducts.add(productMap);
                }
            }
            map.put("freeProducts", freeProducts);
            results.add(map);
        }
        return results;
    }
}

