/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.IndexActiveCardVo;
import cc.lechun.active.entity.active.IndexActiveVo;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.apiinvoke.refund.PrepayCardInvoke;
import cc.lechun.common.cache.MallRedisLock;
import cc.lechun.common.enums.common.EnvironmentEnum;
import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerAddressEntity;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.prepay.BuyPrepayCardDetailVo;
import cc.lechun.mall.entity.prepay.BuyPrepayCardVo;
import cc.lechun.mall.entity.prepay.MyPrepayCardVo;
import cc.lechun.mall.entity.prepay.PrepayCardBaseVo;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardBatchTypeEnum;
import cc.lechun.mall.entity.prepay.PrepayCardDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailProductItemVo;
import cc.lechun.mall.entity.prepay.PrepayCardDetailVo;
import cc.lechun.mall.entity.prepay.PrepayCardDo;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardInfoVo;
import cc.lechun.mall.entity.prepay.PrepayCardPlanDetailVo;
import cc.lechun.mall.entity.prepay.PrepayCardPlanRefundlVo;
import cc.lechun.mall.entity.prepay.PrepayCardPlanStatusEnum;
import cc.lechun.mall.entity.prepay.PrepayCardStatusEnum;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.sales.MallIndexPromotionVo;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.trade.orderPlan.MallOrderPlanProductEntity;
import cc.lechun.mall.entity.weixin.WeekEnum;
import cc.lechun.mall.form.customer.AddressForm;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.customer.CustomerFreeInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardLogInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardOrderPlanInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanLogInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.trade.orderPlan.MallOrderPlanInterface;
import cc.lechun.mall.iservice.trade.orderPlan.MallOrderPlanProductInterface;
import cc.lechun.mallapi.dto.prepay.DouDianPrepayPlanDTO;
import cc.lechun.mallapi.dto.prepay.DouDianPrepayPlanProductDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class PrepayCardOrderPlanService
implements PrepayCardOrderPlanInterface {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    @Lazy
    private PrepayCardPlanDetailInterface prepayCardPlanDetailService;
    @Autowired
    private PrepayCardInterface prepayCardService;
    @Autowired
    private PrepayCardLogInterface prepayCardLogService;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchService;
    @Autowired
    private CustomerAddressInterface customerAddressService;
    @Autowired
    private MallPromotionInterface promotionService;
    @Autowired
    private PrepayCardPlanLogInterface prepayCardPlanLogService;
    @Autowired
    private AccountBalanceInterface accountBalanceInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private MallOrderGroupProductInterface orderGroupProductInterface;
    @Lazy
    @Autowired
    private MallOrderProductInterface orderProductInterface;
    @Autowired
    MallProductPicInterface picService;
    @Autowired
    private PrepayCardOrderPlanInterface prepayCardOrderPlanService;
    @Autowired
    private ActiveInterface activeInterface;
    @Value(value="${lechun.environment}")
    private String environment;
    @Autowired
    private MallShoppingcartInterface shoppingcartInterface;
    @Lazy
    @Autowired
    private MallOrderPlanProductInterface orderPlanProductInterface;
    @Autowired
    private MallOrderPlanInterface orderPlanInterface;
    @Autowired
    PrepayCardInvoke prepayCardInvoke;
    @Lazy
    @Autowired
    CustomerFreeInterface customerFreeInterface;
    @Autowired
    private MallRedisLock mallRedisLock;
    @Autowired
    RedissonClient redissonClient;

    @Override
    public BaseJsonVo getCardInfo(String orderNo) {
        PrepayCardInfoVo prepayCardInfo = new PrepayCardInfoVo();
        PrepayCardEntity query = new PrepayCardEntity();
        query.setOrderMainNo(orderNo);
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardService.getSingle(query, 0L);
        if (prepayCardEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5976\u5361\u8ba2\u5355!");
        }
        if (prepayCardEntity.getRemainCount() < 1) {
            return BaseJsonVo.error((String)"\u5361\u8ba2\u5355\u65e0\u53ef\u9000\u91d1\u989d!");
        }
        BeanUtils.copyProperties((Object)prepayCardEntity, (Object)prepayCardInfo);
        PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchService.selectByPrimaryKey(prepayCardEntity.getBatchId(), 0L);
        prepayCardInfo.setPerPrice(prepayCardBatchEntity.getPerPrice());
        return BaseJsonVo.success((Object)prepayCardInfo);
    }

    @Override
    public BaseJsonVo saveOrderPlan(PrepayCardDo prepayCardDo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveOrderPlan(PrepayCardDo prepayCardDo, String customerId) {
        this.logger.info("\u8ba1\u5212\u4fee\u6539\u53c2\u6570:{}", (Object)prepayCardDo.toString());
        PrepayCardDetailEntity prepayCardDetailEntity = (PrepayCardDetailEntity)this.prepayCardPlanDetailService.selectByPrimaryKey(prepayCardDo.getDetailedId(), 0L);
        BaseJsonVo x = this.checkOrderPlan(prepayCardDetailEntity, customerId, "\u65e0\u6cd5\u4fee\u6539", false);
        if (!x.isSuccess()) {
            return x;
        }
        if (prepayCardDo.getMonth() == -1) {
            return BaseJsonVo.error((String)"\u4fee\u6539\u8ba1\u5212\u8bf7\u9009\u62e9\u53d1\u8d27\u65e5\u671f!");
        }
        prepayCardDetailEntity.setPickTime(this.getFirstDeliveryDate(prepayCardDo));
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)prepayCardDetailEntity.getCardId()));
        if (prepayCardEntity.getEndTime() != null && prepayCardEntity.getEndTime().compareTo(prepayCardDetailEntity.getPickTime()) < 0) {
            return BaseJsonVo.error((String)"\u63d0\u8d27\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u6709\u6548\u671f");
        }
        prepayCardDetailEntity.setAddrId(prepayCardDo.getAddrId());
        PrepayCardDetailEntity update = new PrepayCardDetailEntity();
        update.setDetailedId(prepayCardDetailEntity.getDetailedId());
        update.setAddrId(prepayCardDo.getAddrId());
        update.setPickTime(prepayCardDetailEntity.getPickTime());
        if (prepayCardDetailEntity.getStatus().intValue() == PrepayCardPlanStatusEnum.SUSPEND.getValue()) {
            update.setStatus(PrepayCardPlanStatusEnum.DELIVERY.getValue());
        }
        prepayCardDetailEntity.setStatus(PrepayCardPlanStatusEnum.DELIVERY.getValue());
        if (this.prepayCardPlanDetailService.updateByPrimaryKeySelective(update) > 0) {
            x = this.prepayCardPlanDetailService.editPlanOrder(prepayCardDetailEntity);
            this.logger.info("\u8ba1\u5212:{},\u4fee\u6539\u7ed3\u679c:{}", (Object)JsonUtils.toJson((Object)prepayCardDetailEntity, (boolean)false), (Object)JsonUtils.toJson((Object)x, (boolean)false));
            if (!x.isSuccess()) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return x;
            }
        }
        return BaseJsonVo.success((Object)"\u8ba1\u5212\u4fee\u6539\u6210\u529f");
    }

    private BaseJsonVo checkOrderPlan(PrepayCardDetailEntity prepayCardDetailEntity, String customerId, String message, boolean checkCard) {
        if (!Objects.equals(prepayCardDetailEntity.getCustomerId(), customerId)) {
            this.logger.error("\u4fee\u6539\u8ba1\u5212\u7528\u6237ID\u4e0d\u4e00\u81f4\uff0c\u5361\u7528\u6237ID[{}]\uff0c\u5f53\u524d\u7528\u6237ID[{}]", (Object)prepayCardDetailEntity.getCustomerId(), (Object)customerId);
            return BaseJsonVo.error((String)"\u8bf7\u5148\u6e05\u9664\u7f13\u5b58");
        }
        if (prepayCardDetailEntity == null) {
            return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u8ba1\u5212");
        }
        if (prepayCardDetailEntity.getStatus().intValue() != PrepayCardPlanStatusEnum.DELIVERY.getValue() || prepayCardDetailEntity.getPickTime() == null || prepayCardDetailEntity.getPickTime().before(DateUtils.currentDate()) || prepayCardDetailEntity.getPickTime().equals(DateUtils.currentDate())) {
            // empty if block
        }
        if (prepayCardDetailEntity.getStatus().intValue() == PrepayCardPlanStatusEnum.NOEFFECT.getValue()) {
            return BaseJsonVo.error((String)("\u8ba1\u5212\u5df2\u9000\u6b3e," + message));
        }
        if (prepayCardDetailEntity.getStatus().intValue() == PrepayCardPlanStatusEnum.FINISH.getValue()) {
            return BaseJsonVo.error((String)("\u8ba1\u5212\u5df2\u5b8c\u6210," + message));
        }
        if (!prepayCardDetailEntity.getCustomerId().equals(customerId)) {
            return BaseJsonVo.error((String)("\u672a\u77e5\u7684\u8ba1\u5212," + message));
        }
        if (StringUtils.isNotEmpty((String)prepayCardDetailEntity.getCardId())) {
            PrepayCardEntity result = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)prepayCardDetailEntity.getCardId()));
            if (result == null) {
                return BaseJsonVo.error((String)"\u9884\u4ed8\u5361\u4e0d\u5b58\u5728");
            }
            if (result.getStatus().intValue() == PrepayCardStatusEnum.FINISH.getValue()) {
                return BaseJsonVo.error((String)("\u8ba1\u5212\u5df2\u5b8c\u6210," + message));
            }
            if (checkCard) {
                if (result.getStatus().intValue() == PrepayCardStatusEnum.NOEFFECT.getValue()) {
                    return BaseJsonVo.error((String)("\u5361\u5df2\u9000\u6b3e," + message));
                }
                if (result.getEndTime() != null && result.getEndTime().before(DateUtils.now())) {
                    return BaseJsonVo.error((String)("\u5361\u5df2\u8fc7\u671f," + message));
                }
            }
            if (prepayCardDetailEntity.getStatus().intValue() == PrepayCardPlanStatusEnum.ACTIVE.getValue()) {
                return BaseJsonVo.error((String)("\u8ba1\u5212\u672a\u5b8c\u6210," + message));
            }
            if (result.getBatchId() != null && (result.getBatchId() == 117 || result.getBatchId() == 114) && prepayCardDetailEntity != null && prepayCardDetailEntity.getPickTime() == null) {
                return BaseJsonVo.error((String)"\u6296\u97f3/\u5929\u732b\u5bc4\u5b58\u5361\u9996\u5355\u4e0d\u53ef\u66f4\u6539\u65e5\u671f");
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo getOrderPlanDetail(Integer planId) {
        PrepayCardDetailEntity prepayCardDetailEntity = (PrepayCardDetailEntity)this.prepayCardPlanDetailService.selectByPrimaryKey(planId);
        return BaseJsonVo.success((Object)(prepayCardDetailEntity == null ? BaseJsonVo.error((String)"\u65e0\u6548\u7684\u914d\u9001\u8ba1\u5212") : prepayCardDetailEntity.getPerPrice()));
    }

    @Override
    public BaseJsonVo refundOrderPlan(String orderMainNo, BigDecimal amount, List<PrepayCardDetailProductItemVo> list, String operator) {
        this.logger.info("\u5f00\u59cb\u8c03\u7528\u9884\u4ed8\u5361\u9000\u6b21\u6570:\u8ba2\u5355\u53f7{},\u91d1\u989d:{},\u64cd\u4f5c\u4eba:{},\u5546\u54c1:{},\u6570\u91cf:{}", new Object[]{orderMainNo, amount, list, operator});
        if (StringUtils.isEmpty((String)orderMainNo)) {
            return BaseJsonVo.error((String)"\u4e3b\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PrepayCardEntity query = new PrepayCardEntity();
        query.setOrderMainNo(orderMainNo);
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardService.getSingle(query, 0L);
        if (prepayCardEntity != null) {
            this.logger.info("\u8ba2\u5355:{}\u5361\u5976\u5361\u8ba2\u5355", (Object)orderMainNo);
            this.prepayCardLogService.saveCardPlanLog(prepayCardEntity.getCardId(), prepayCardEntity.getStatus(), PrepayCardStatusEnum.NOEFFECT.getValue(), operator + ":\u6267\u884c\u9000\u6b3e,\u91d1\u989d:" + amount + ",\u7981\u7528\u5361");
            prepayCardEntity.setStatus(PrepayCardStatusEnum.NOEFFECT.getValue());
            this.prepayCardService.updateByPrimaryKeySelective(prepayCardEntity);
            List<PrepayCardDetailEntity> prepayCardDetailEntityList = this.prepayCardPlanDetailService.getPlanDetailList(prepayCardEntity.getCardId());
            if (CollectionUtils.isNotEmpty(prepayCardDetailEntityList)) {
                for (PrepayCardDetailEntity prepayCardDetailEntity : prepayCardDetailEntityList) {
                    BaseJsonVo baseJsonVo;
                    List<MallOrderEntity> orderEntityList;
                    if (!StringUtils.isNotEmpty((String)prepayCardDetailEntity.getOrderMainNo()) || !Objects.equals((orderEntityList = this.orderInterface.getOrderList(prepayCardDetailEntity.getOrderMainNo())).get(0).getStatus(), OrderStatusEnum.PAYCONFIRM.getValue()) || (baseJsonVo = this.refundPrepayCardOrder(prepayCardDetailEntity.getOrderMainNo(), orderEntityList.get(0).getOrderNo(), prepayCardDetailEntity.getCustomerId())).isSuccess()) continue;
                    throw new RuntimeException(baseJsonVo.getMessage());
                }
            }
            this.customerFreeInterface.disableFree(prepayCardEntity.getCardId());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo refundOrderPlan(String orderMainNo, BigDecimal amount, String operator) {
        this.logger.info("\u5f00\u59cb\u8c03\u7528\u9884\u4ed8\u5361\u9000\u6b21\u6570:\u8ba2\u5355\u53f7{},\u91d1\u989d:{},\u64cd\u4f5c\u4eba:{},\u6570\u91cf:{}", new Object[]{orderMainNo, amount, operator});
        if (StringUtils.isEmpty((String)orderMainNo)) {
            return BaseJsonVo.error((String)"\u4e3b\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return this.refundOrderPlan(orderMainNo, amount, null, operator);
    }

    @Override
    public BaseJsonVo refundOrderPlanNum(String orderMainNo, String operator) {
        PrepayCardDetailEntity queryDetail = new PrepayCardDetailEntity();
        queryDetail.setOrderMainNo(orderMainNo);
        List prepayCardDetailEntityList = this.prepayCardPlanDetailService.getList(queryDetail, 0L);
        if (CollectionUtils.isEmpty((Collection)prepayCardDetailEntityList)) {
            return BaseJsonVo.success((String)"\u4e0d\u662f\u9884\u4ed8\u5361\u8ba2\u5355", null);
        }
        for (PrepayCardDetailEntity prepayCardDetailEntity : prepayCardDetailEntityList) {
            PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)prepayCardDetailEntity.getCardId()), 0L);
            if (prepayCardEntity == null) {
                this.logger.error("\u8ba2\u5355:{}\u5173\u8054\u7684\u5361\u4e0d\u5b58\u5728", (Object)orderMainNo);
                continue;
            }
            if (prepayCardDetailEntity.getStatus().intValue() == PrepayCardPlanStatusEnum.NOEFFECT.getValue()) {
                this.logger.info("\u8ba1\u5212{}\u5df2\u53d6\u6d88", (Object)prepayCardDetailEntity.getDetailedId());
                continue;
            }
            prepayCardDetailEntity.setStatus(5);
            this.prepayCardPlanDetailService.updateByPrimaryKeySelective(prepayCardDetailEntity);
            if (!Objects.equals(prepayCardEntity.getBatchType(), PrepayCardBatchTypeEnum.NUM_CARD.getValue())) continue;
            this.logger.info("\u5361:{},\u9000\u6b21\u6570:{},\u5361\u5269\u4f59\u6b21\u6570:{}", new Object[]{prepayCardEntity.getCardId(), prepayCardDetailEntity.getQuantity(), prepayCardEntity.getRemainCount()});
            this.prepayCardService.refundOrderPlanNum(prepayCardDetailEntity.getCardId(), prepayCardDetailEntity.getQuantity(), prepayCardEntity.getRemainCount());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo getOrderPlanList(String orderMainNo) {
        PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
        prepayCardDetailEntity.setCardOrderMainNo(orderMainNo);
        ArrayList refundlVoList = new ArrayList();
        List list = this.prepayCardPlanDetailService.getList(prepayCardDetailEntity, 0L);
        if (list.size() > 0) {
            list.forEach(p -> {
                if (StringUtils.isEmpty((String)p.getOrderMainNo()) && p.getStatus().intValue() != PrepayCardPlanStatusEnum.NOEFFECT.getValue()) {
                    PrepayCardPlanRefundlVo prepayCardPlanRefundlVo = new PrepayCardPlanRefundlVo();
                    BeanUtils.copyProperties((Object)p, (Object)prepayCardPlanRefundlVo);
                    refundlVoList.add(prepayCardPlanRefundlVo);
                }
            });
        }
        return BaseJsonVo.success(refundlVoList);
    }

    @Override
    public List<PrepayCardBaseVo> getMyCardList(String customerId) {
        return this.getMyCardList(customerId, PrepayCardTypeEnum.milk_card.getValue(), 1);
    }

    private List<PrepayCardBaseVo> getMyCardList(String customerId, Integer cardType, int cardStatus) {
        PrepayCardEntity prepayCardEntity = new PrepayCardEntity();
        prepayCardEntity.setBelongCustomerId(customerId);
        prepayCardEntity.setCardType(cardType);
        List list = this.prepayCardService.getList(prepayCardEntity, 0L);
        ArrayList<PrepayCardBaseVo> result = new ArrayList<PrepayCardBaseVo>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(c -> {
                boolean flag = false;
                if (cardStatus == PrepayCardStatusEnum.NOEFFECT.getValue() || cardStatus == PrepayCardStatusEnum.FINISH.getValue()) {
                    if (c.getStatus() == cardStatus) {
                        flag = true;
                    }
                } else if (c.getStatus() < PrepayCardStatusEnum.NOEFFECT.getValue()) {
                    flag = true;
                }
                if (flag) {
                    Map<String, BigDecimal> remain;
                    PrepayCardBaseVo prepayCardBaseVo = new PrepayCardBaseVo();
                    BeanUtils.copyProperties((Object)c, (Object)prepayCardBaseVo);
                    PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchService.selectByPrimaryKey(c.getBatchId());
                    prepayCardBaseVo.setBatchName(prepayCardBatchEntity.getBatchName());
                    prepayCardBaseVo.setTitle(prepayCardBatchEntity.getTitle());
                    prepayCardBaseVo.setUnit(StringUtils.isEmpty((String)c.getUnit()) ? "\u7bb1" : c.getUnit());
                    prepayCardBaseVo.setBatchType(prepayCardBatchEntity.getBatchType());
                    prepayCardBaseVo.setBatchTypeName(PrepayCardBatchTypeEnum.getName(prepayCardBatchEntity.getBatchType()));
                    prepayCardBaseVo.setSaleValue(prepayCardBatchEntity.getSaleValue());
                    prepayCardBaseVo.setBindCode(prepayCardBatchEntity.getBindCode());
                    if (c.getRemainCount() > 0 && c.getEndTime() != null && c.getEndTime().before(DateUtils.now())) {
                        prepayCardBaseVo.setStatus(PrepayCardPlanStatusEnum.NOEFFECT.getValue());
                    }
                    prepayCardBaseVo.setStatusName(PrepayCardStatusEnum.getName(prepayCardBaseVo.getStatus()));
                    PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
                    prepayCardDetailEntity.setCardId(c.getCardId());
                    List detailList = this.prepayCardPlanDetailService.getList(prepayCardDetailEntity, 0L);
                    Integer noDeliveryNum = 0;
                    if (detailList.size() > 0) {
                        for (int j = 0; j < detailList.size(); ++j) {
                            if (((PrepayCardDetailEntity)detailList.get(j)).getStatus().intValue() != PrepayCardPlanStatusEnum.DELIVERY.getValue() && ((PrepayCardDetailEntity)detailList.get(j)).getStatus().intValue() != PrepayCardPlanStatusEnum.ACTIVE.getValue() || !((PrepayCardDetailEntity)detailList.get(j)).getPickTime().after(DateUtils.currentDate())) continue;
                            noDeliveryNum = noDeliveryNum + ((PrepayCardDetailEntity)detailList.get(j)).getQuantity();
                        }
                        prepayCardBaseVo.setNoDeliveryNum(noDeliveryNum);
                    } else {
                        prepayCardBaseVo.setNoDeliveryNum(noDeliveryNum);
                    }
                    prepayCardBaseVo.setRemainCount(c.getRemainCount());
                    Map<String, List<String>> pics = this.picService.getProductPicUrlMap(String.valueOf(c.getBatchId()), SalesTypeEnum.SALES_PRODUCT.getValue());
                    if (pics != null && pics.containsKey("picProductHead") && pics.get("picProductHead") != null && pics.get("picProductHead").size() > 0) {
                        prepayCardBaseVo.setPic(pics.get("picProductHead").get(0));
                    }
                    if (c.getBatchType() == 2 && (remain = this.accountBalanceInterface.getSpecialCardRemain(c.getRelateCardNo())).containsKey("usableAccount")) {
                        prepayCardBaseVo.setUsableValue(remain.get("usableAccount"));
                    }
                    result.add(prepayCardBaseVo);
                }
            });
            result.sort(new Comparator<PrepayCardBaseVo>(){

                @Override
                public int compare(PrepayCardBaseVo o1, PrepayCardBaseVo o2) {
                    int num = 0;
                    if (o1.getStatus() < PrepayCardStatusEnum.NOEFFECT.getValue() && o2.getStatus() < PrepayCardStatusEnum.NOEFFECT.getValue()) {
                        num = o1.getStatus() - o2.getStatus();
                    } else {
                        if (o2.getStatus().intValue() == PrepayCardStatusEnum.NOEFFECT.getValue()) {
                            num = -1;
                        }
                        if (o1.getStatus().intValue() == PrepayCardStatusEnum.NOEFFECT.getValue()) {
                            num = 1;
                        }
                    }
                    if (num == 0) {
                        num = o2.getCreateTime().compareTo(o1.getCreateTime());
                    }
                    return num;
                }
            });
        }
        return result;
    }

    @Override
    public BaseJsonVo getCardList(String customerId) {
        ArrayList<MyPrepayCardVo> list = new ArrayList<MyPrepayCardVo>();
        List<PrepayCardStatusEnum> cardStatusEnumList = PrepayCardStatusEnum.getList();
        for (PrepayCardStatusEnum statusEnum : cardStatusEnumList) {
            list.addAll(this.prepayCardOrderPlanService.getCardList(customerId, statusEnum.getValue()));
        }
        return BaseJsonVo.success(list);
    }

    @Override
    public List<MyPrepayCardVo> getCardList(String customerId, Integer cardUseStatus) {
        List<PrepayCardTypeEnum> prepayCardList = PrepayCardTypeEnum.getList();
        ArrayList<MyPrepayCardVo> list = new ArrayList<MyPrepayCardVo>();
        for (PrepayCardTypeEnum typeEnum : prepayCardList) {
            MyPrepayCardVo myPrepayCardVo = new MyPrepayCardVo();
            myPrepayCardVo.setName("\u6211\u7684" + PrepayCardTypeEnum.getName(typeEnum.getValue()));
            myPrepayCardVo.setList(this.getMyCardList(customerId, typeEnum.getValue(), cardUseStatus));
            myPrepayCardVo.setNum(myPrepayCardVo.getList().size());
            list.add(myPrepayCardVo);
        }
        return list;
    }

    @Override
    public List<PrepayCardBaseVo> getMyCardList(String customerId, Integer cardStatus) {
        PrepayCardEntity prepayCardEntity = new PrepayCardEntity();
        prepayCardEntity.setBelongCustomerId(customerId);
        List<PrepayCardEntity> list = this.prepayCardService.getList(prepayCardEntity, 0L);
        if (Objects.equals(cardStatus, PrepayCardStatusEnum.TAKED.getValue()) && CollectionUtils.isNotEmpty((Collection)list)) {
            list = list.stream().filter(card -> Objects.equals(card.getStatus(), PrepayCardStatusEnum.TAKED.getValue()) || Objects.equals(card.getStatus(), PrepayCardStatusEnum.ACTIVE.getValue())).collect(Collectors.toList());
        }
        ArrayList<PrepayCardBaseVo> result = new ArrayList<PrepayCardBaseVo>();
        if (list.size() > 0) {
            list.forEach(c -> {
                boolean flag = false;
                if (cardStatus.intValue() == PrepayCardStatusEnum.NOEFFECT.getValue() || cardStatus.intValue() == PrepayCardStatusEnum.FINISH.getValue()) {
                    if (c.getStatus().intValue() == cardStatus.intValue()) {
                        flag = true;
                    }
                } else if (c.getStatus() < PrepayCardStatusEnum.NOEFFECT.getValue()) {
                    flag = true;
                }
                if (flag) {
                    Map<String, List<String>> pics;
                    PrepayCardBaseVo prepayCardBaseVo = new PrepayCardBaseVo();
                    BeanUtils.copyProperties((Object)c, (Object)prepayCardBaseVo);
                    PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchService.selectByPrimaryKey(c.getBatchId());
                    prepayCardBaseVo.setBatchName(prepayCardBatchEntity.getBatchName());
                    prepayCardBaseVo.setTitle(prepayCardBatchEntity.getTitle());
                    prepayCardBaseVo.setBatchType(prepayCardBatchEntity.getBatchType());
                    prepayCardBaseVo.setCardOrderSource(prepayCardBatchEntity.getOrderSource());
                    prepayCardBaseVo.setBindCode(prepayCardBatchEntity.getBindCode());
                    if (Objects.equals(c.getBatchType(), PrepayCardBatchTypeEnum.NUM_CARD.getValue()) && c.getRemainCount() > 0 && c.getEndTime() != null && c.getEndTime().before(DateUtils.now())) {
                        prepayCardBaseVo.setStatus(PrepayCardPlanStatusEnum.NOEFFECT.getValue());
                    }
                    if (Objects.equals(prepayCardBatchEntity.getBatchType(), PrepayCardBatchTypeEnum.NUM_CARD.getValue())) {
                        PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
                        prepayCardDetailEntity.setCardId(c.getCardId());
                        if (prepayCardEntity.getRemainCount() != null && prepayCardEntity.getRemainCount() <= 0) {
                            prepayCardBaseVo.setStatus(PrepayCardPlanStatusEnum.FINISH.getValue());
                        }
                        List detailList = this.prepayCardPlanDetailService.getList(prepayCardDetailEntity, 0L);
                        prepayCardBaseVo.setNoDeliveryNum(c.getTotalCount() - c.getRemainCount());
                        if (prepayCardBaseVo.getNoDeliveryNum() < 0) {
                            prepayCardBaseVo.setNoDeliveryNum(0);
                        }
                        Integer noDeliveryNum = 0;
                        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                            for (int j = 0; j < detailList.size(); ++j) {
                                List<MallOrderEntity> orderEntityList = this.orderInterface.getOrderList(((PrepayCardDetailEntity)detailList.get(j)).getOrderMainNo());
                                if (!CollectionUtils.isNotEmpty(orderEntityList) || orderEntityList.get(0).getStatus().intValue() != OrderStatusEnum.PAYCONFIRM.getValue()) continue;
                                noDeliveryNum = noDeliveryNum + ((PrepayCardDetailEntity)detailList.get(j)).getQuantity();
                            }
                        }
                        prepayCardBaseVo.setRemainCount(c.getRemainCount());
                    }
                    if ((pics = this.picService.getProductPicUrlMap(String.valueOf(c.getBatchId()), SalesTypeEnum.SALES_PRODUCT.getValue())) != null && pics.containsKey(ProductPicTypeEnum.PRO_HEAD.getName()) && pics.get(ProductPicTypeEnum.PRO_HEAD.getName()) != null && pics.get(ProductPicTypeEnum.PRO_HEAD.getName()).size() > 0) {
                        prepayCardBaseVo.setPic(pics.get(ProductPicTypeEnum.PRO_HEAD.getName()).get(0));
                    }
                    if (c.getCardType().intValue() == PrepayCardTypeEnum.yogurt_card.getValue() || c.getCardType().intValue() == PrepayCardTypeEnum.new_card_Cold.getValue() || c.getCardType().intValue() == PrepayCardTypeEnum.new_card_Nomal.getValue()) {
                        Map<String, BigDecimal> remain = this.accountBalanceInterface.getSpecialCardRemain(c.getRelateCardNo());
                        this.logger.info("\u5361\u53f7:{},\u5e10\u6237:{}", (Object)c.getRelateCardNo(), (Object)JsonUtils.toJson(remain, (boolean)false));
                        if (remain.containsKey("usableAccount")) {
                            prepayCardBaseVo.setUsableValue(remain.get("usableAccount"));
                            prepayCardBaseVo.setSaleValue(remain.get("totalAccount"));
                            if (remain.get("usableAccount").compareTo(BigDecimal.ZERO) <= 0) {
                                prepayCardBaseVo.setStatus(PrepayCardPlanStatusEnum.FINISH.getValue());
                            }
                        }
                    }
                    prepayCardBaseVo.setStatusName(PrepayCardStatusEnum.getName(prepayCardBaseVo.getStatus()));
                    prepayCardBaseVo.setCardTypeName(PrepayCardTypeEnum.getName(c.getCardType()));
                    result.add(prepayCardBaseVo);
                }
            });
            result.sort(new Comparator<PrepayCardBaseVo>(){

                @Override
                public int compare(PrepayCardBaseVo o1, PrepayCardBaseVo o2) {
                    int num = 0;
                    if (o1.getStatus() < PrepayCardStatusEnum.NOEFFECT.getValue() && o2.getStatus() < PrepayCardStatusEnum.NOEFFECT.getValue()) {
                        num = o1.getStatus() - o2.getStatus();
                    } else {
                        if (o2.getStatus().intValue() == PrepayCardStatusEnum.NOEFFECT.getValue()) {
                            num = -1;
                        }
                        if (o1.getStatus().intValue() == PrepayCardStatusEnum.NOEFFECT.getValue()) {
                            num = 1;
                        }
                    }
                    if (num == 0) {
                        num = o2.getCreateTime().compareTo(o1.getCreateTime());
                    }
                    return num;
                }
            });
        }
        return result;
    }

    @Override
    public List<PrepayCardBaseVo> getHistoryCardList(String customerId, Integer cardUseStatus) {
        List<PrepayCardTypeEnum> prepayCardList = PrepayCardTypeEnum.getList();
        ArrayList<PrepayCardBaseVo> list = new ArrayList<PrepayCardBaseVo>();
        for (PrepayCardTypeEnum typeEnum : prepayCardList) {
            list.addAll(this.getMyCardList(customerId, typeEnum.getValue(), cardUseStatus));
        }
        return list;
    }

    @Override
    public List<IndexActiveCardVo> getBuyCardList(String customerId, int cardType) {
        this.logger.info("\u67e5\u8be2\u7528\u6237:{} \u5e73\u53f0:{},\u5361\u7c7b\u578b:{}", (Object)customerId, (Object)cardType);
        List<ActiveEntity> activeList = this.activeInterface.getPrepayActiveList(cardType == 1 ? 27 : 36);
        ArrayList<IndexActiveCardVo> list = new ArrayList<IndexActiveCardVo>();
        HashSet activeSet = new HashSet();
        if (activeList != null && activeList.size() > 0) {
            activeList.forEach(active -> {
                if (active.getStatus() == 1 && active.getBeginTime().before(DateUtils.now()) && active.getEndTime().after(DateUtils.now())) {
                    if (activeSet.add(active)) {
                        BaseJsonVo<IndexActiveVo> baseJsonVo = this.activeInterface.buildIndexActiveVo(active.getActiveNo(), customerId);
                        if (baseJsonVo.isSuccess()) {
                            MallIndexPromotionVo promotionVo;
                            BaseJsonVo promotionVoBaseJsonVo = this.promotionService.getPromotionByBindCode(((IndexActiveVo)baseJsonVo.getValue()).getBindCode());
                            if (promotionVoBaseJsonVo.isSuccess() && (promotionVo = (MallIndexPromotionVo)promotionVoBaseJsonVo.getValue()) != null && promotionVo.getIsShow() == 0) {
                                return;
                            }
                            IndexActiveVo indexActiveVo = (IndexActiveVo)baseJsonVo.getValue();
                            IndexActiveCardVo indexActiveCardVo = new IndexActiveCardVo();
                            Integer tempCardType = this.activeInterface.getPrepayType(active.getActiveNo());
                            indexActiveVo.setWebFlag(tempCardType == null ? String.valueOf(PrepayCardTypeEnum.milk_card.getValue()) : tempCardType.toString());
                            BeanUtils.copyProperties((Object)indexActiveVo, (Object)indexActiveCardVo);
                            indexActiveCardVo.setMiniUrl(EnvironmentEnum.PRODUCT.getValue().equals(this.environment) ? "https://wechat.lechun.cc/limit_sale?bindCode=" + indexActiveVo.getBindCode() + "&orderSource=19" : "http://wxcheck1.lechun.cc/limit_sale?bindCode=" + indexActiveVo.getBindCode() + "&orderSource=19");
                            list.add(indexActiveCardVo);
                        } else {
                            this.logger.info("\u4fc3\u9500{},\u4e0d\u80fd\u8d2d\u4e70", (Object)baseJsonVo.getError());
                        }
                    }
                } else {
                    this.logger.info("\u6d3b\u52a8{}\u672a\u542f\u7528 \u672a\u5f00\u59cb\u5df2\u7ed3\u675f", active);
                }
            });
        }
        return list;
    }

    @Override
    public BaseJsonVo<BuyPrepayCardVo> getBuyCardList(String customerId, String bindCode) {
        this.logger.info("\u67e5\u8be2\u7528\u6237:{} bindCode:{}", (Object)customerId, (Object)bindCode);
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        BaseJsonVo<IndexActiveVo> baseJsonVo = this.activeInterface.buildIndexActiveVo(activeEntity.getActiveNo(), customerId);
        BuyPrepayCardVo buyPrepayCardVo = new BuyPrepayCardVo();
        if (baseJsonVo.isSuccess()) {
            buyPrepayCardVo.setActiveVo((IndexActiveVo)baseJsonVo.getValue());
            ArrayList<BuyPrepayCardDetailVo> cardDetailVoList = new ArrayList<BuyPrepayCardDetailVo>();
            if (activeEntity.getStatus() == 1 && activeEntity.getBeginTime().before(DateUtils.now()) && activeEntity.getEndTime().after(DateUtils.now())) {
                BuyPrepayCardDetailVo buyPrepayCardDetailVo = new BuyPrepayCardDetailVo();
                buyPrepayCardDetailVo.setBindCode(activeEntity.getBindCode());
                BaseJsonVo promotionVoBaseJsonVo = this.promotionService.getPromotionByBindCode(activeEntity.getBindCode());
                if (promotionVoBaseJsonVo.isSuccess()) {
                    MallIndexPromotionVo promotionVo = (MallIndexPromotionVo)promotionVoBaseJsonVo.getValue();
                    if (promotionVo.getValid() != null && promotionVo.getValid().booleanValue()) {
                        buyPrepayCardDetailVo.setOriginPrice(promotionVo.getPrice());
                        buyPrepayCardDetailVo.setPromotionPrice(promotionVo.getSalePrice());
                        buyPrepayCardDetailVo.setProductName(promotionVo.getProductName());
                        PrepayCardBatchEntity param = new PrepayCardBatchEntity();
                        param.setBindCode(activeEntity.getBindCode());
                        PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchService.getSingle(param, 0L);
                        if (prepayCardBatchEntity != null) {
                            buyPrepayCardDetailVo.setQuantity(prepayCardBatchEntity.getDeliverCount());
                            buyPrepayCardDetailVo.setPromotionId(promotionVo.getPromotionId());
                            buyPrepayCardDetailVo.setUnit(promotionVo.getProductUnit());
                            buyPrepayCardDetailVo.setOrderSource(this.activeInterface.getOrderSourceByActiveType(activeEntity.getActiveType()));
                            cardDetailVoList.add(buyPrepayCardDetailVo);
                        }
                    } else {
                        this.logger.info("\u4fc3\u9500:{}\u5df2\u7ed3\u675f", (Object)promotionVo.getPromotionId());
                    }
                } else {
                    this.logger.info("\u6d3b\u52a8{}\u672a\u542f\u7528 \u672a\u5f00\u59cb\u5df2\u7ed3\u675f", (Object)activeEntity);
                }
            } else {
                this.logger.info("\u6d3b\u52a8\u5bf9\u5e94\u4fc3\u9500{}\u672a\u542f\u7528 \u672a\u5f00\u59cb\u5df2\u7ed3\u675f", (Object)activeEntity);
            }
            buyPrepayCardVo.setCardDetailVoList(cardDetailVoList);
        }
        return BaseJsonVo.success((Object)buyPrepayCardVo);
    }

    @Override
    @Transactional
    public BaseJsonVo saveDeliverRule(PrepayCardDo prepayCardDo, int platFormId) {
        PrepayCardEntity prepayCardEntity = new PrepayCardEntity();
        BeanUtils.copyProperties((Object)prepayCardDo, (Object)prepayCardEntity);
        PrepayCardEntity result = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)prepayCardEntity.getCardId()), 0L);
        BaseJsonVo x = this.checkCard(prepayCardDo, prepayCardEntity, result);
        if (!x.isSuccess()) {
            return x;
        }
        String message = "\u521b\u5efa\u6210\u529f";
        ArrayList<PrepayCardDetailEntity> list = new ArrayList<PrepayCardDetailEntity>();
        if (result.getStatus().intValue() == PrepayCardStatusEnum.TAKED.getValue()) {
            prepayCardEntity.setEndTime(this.LocalDateTodate(this.getLocalDate(DateUtils.now()).plusMonths(result.getTotalCount() * 2)));
            prepayCardEntity.setStatus(PrepayCardStatusEnum.ACTIVE.getValue());
        }
        if (this.mallRedisLock.lock(prepayCardDo.getCardId() + ":createPlan", "1", 20L, TimeUnit.SECONDS)) {
            prepayCardEntity.setFirstDate(this.getFirstDeliveryDate(prepayCardDo));
            prepayCardEntity.setUpdateTime(DateUtils.now());
            this.logger.info("\u9996\u6b21\u914d\u9001\u65e5\u671f:{}", (Object)prepayCardEntity.getFirstDate());
            if (prepayCardDo.getPeriodType() == 1 || prepayCardDo.getPeriodType() == 2) {
                prepayCardEntity.setRemainCount(prepayCardDo.getRemainCount() == null ? result.getRemainCount() : prepayCardDo.getRemainCount());
            } else {
                prepayCardEntity.setRemainCount(prepayCardDo.getNumber());
            }
            int resultNum = this.prepayCardService.updateCardCount(prepayCardEntity);
            if (resultNum == 0) {
                throw new RuntimeException("\u5361\u53ef\u7528\u6b21\u6570\u4e0d\u8db3");
            }
            if (result.getStatus().intValue() == PrepayCardStatusEnum.TAKED.getValue() || result.getStatus().intValue() == PrepayCardStatusEnum.ACTIVE.getValue()) {
                if (result.getRemainCount() > 0) {
                    int resultNum2;
                    list = new ArrayList();
                    PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchService.selectByPrimaryKey(result.getBatchId());
                    PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
                    BeanUtils.copyProperties((Object)result, (Object)prepayCardDetailEntity);
                    prepayCardDetailEntity.setOrderMainNo("");
                    prepayCardDetailEntity.setCardOrderMainNo(result.getOrderMainNo());
                    prepayCardDetailEntity.setCreateTime(DateUtils.now());
                    prepayCardDetailEntity.setStatus(PrepayCardPlanStatusEnum.ACTIVE.getValue());
                    prepayCardDetailEntity.setCustomerId(result.getBelongCustomerId());
                    prepayCardDetailEntity.setOrderSource(result.getOrderSource());
                    prepayCardDetailEntity.setAddrId(prepayCardEntity.getAddrId());
                    prepayCardDetailEntity.setPromotionId(prepayCardBatchEntity.getProductPromotionId());
                    prepayCardDetailEntity.setPickTime(prepayCardEntity.getFirstDate());
                    prepayCardDetailEntity.setQuantity(prepayCardDo.getNumber());
                    prepayCardDetailEntity.setPerPrice(prepayCardBatchEntity.getPerPrice().multiply(new BigDecimal(prepayCardDo.getNumber())));
                    list.add(prepayCardDetailEntity);
                    if (prepayCardDo.getPeriodType() == 1 || prepayCardDo.getPeriodType() == 2) {
                        boolean isSameDeliveryNum = result.getRemainCount() % prepayCardDo.getNumber() == 0;
                        Integer deliveryNum = isSameDeliveryNum ? result.getRemainCount() / prepayCardDo.getNumber() : result.getRemainCount() / prepayCardDo.getNumber() + 1;
                        this.getPrepayCardDetailEntity(list, prepayCardDetailEntity, prepayCardDo.getPeriodType(), prepayCardDo.getPeriod(), deliveryNum - 1);
                        list.forEach(d -> {
                            d.setQuantity((int)prepayCardDo.getNumber());
                            d.setPerPrice(prepayCardBatchEntity.getPerPrice().multiply(new BigDecimal(d.getQuantity())));
                        });
                        if (!isSameDeliveryNum) {
                            ((PrepayCardDetailEntity)list.get(list.size() - 1)).setQuantity(result.getRemainCount() % prepayCardDo.getNumber());
                            ((PrepayCardDetailEntity)list.get(list.size() - 1)).setPerPrice(prepayCardBatchEntity.getPerPrice().multiply(new BigDecimal(((PrepayCardDetailEntity)list.get(list.size() - 1)).getQuantity())));
                        }
                    }
                    if ((resultNum2 = this.prepayCardPlanDetailService.batchInsert(list)) == 0) {
                        throw new RuntimeException("\u8ba1\u5212\u521b\u5efa\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    }
                    PrepayCardDetailEntity queryTemp = new PrepayCardDetailEntity();
                    queryTemp.setStatus(PrepayCardPlanStatusEnum.ACTIVE.getValue());
                    queryTemp.setCardId(result.getCardId());
                    List tempList = this.prepayCardPlanDetailService.getList(queryTemp);
                    BaseJsonVo baseJsonVo = this.prepayCardPlanDetailService.createPlanOrder((PrepayCardDetailEntity)tempList.get(0), platFormId);
                    this.logger.info("\u8ba1\u5212:{},\u521b\u5efa\u8ba2\u5355:{},{},\u5e73\u53f0:{}", new Object[]{list.get(0), baseJsonVo.isSuccess(), baseJsonVo.getMessage(), platFormId});
                    if (!baseJsonVo.isSuccess()) {
                        message = "\u521b\u5efa\u5931\u8d25!" + baseJsonVo.getMessage();
                        this.logger.error("\u8ba1\u5212:{},\u7528\u6237:{} \u8ba1\u5212\u521b\u5efa\u5931\u8d25,\u539f\u56e0:{}", new Object[]{prepayCardDo.getCardId(), result.getBelongCustomerId(), baseJsonVo.getError_msg()});
                        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                        throw new RuntimeException(baseJsonVo.getMessage());
                    }
                    return BaseJsonVo.success((Object)message);
                }
                throw new RuntimeException("\u53ef\u7528\u6b21\u6570\u4e0d\u8db3,\u521b\u5efa\u5931\u8d25!");
            }
            return BaseJsonVo.success((Object)message);
        }
        return BaseJsonVo.error((String)"\u6b63\u5728\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    @Override
    @Transactional
    public BaseJsonVo saveCustomDeliverRule(PrepayCardEntity card, List<DouDianPrepayPlanDTO> plans) {
        BaseJsonVo saveAddrRst;
        StringBuilder sb = new StringBuilder();
        ArrayList list = new ArrayList();
        card.setFirstDate(plans.get(0).getDeliverDate());
        card.setEndTime(this.LocalDateTodate(this.getLocalDate(DateUtils.now()).plusMonths(12L)));
        this.prepayCardService.updateByPrimaryKeySelective(card);
        AddressForm addressForm = new AddressForm();
        addressForm.setCustomerId(card.getBelongCustomerId());
        addressForm.setConsigneename(plans.get(0).getConsigneeName());
        addressForm.setConsingeephone(plans.get(0).getConsigneePhone());
        addressForm.setAddress(plans.get(0).getConsigneeAddress());
        addressForm.setAreaid(Integer.valueOf(plans.get(0).getConsigneeAreaId()));
        addressForm.setAddresstype(2);
        if (plans.get(0).getConsigneePhone().contains("*") || plans.get(0).getConsigneePhone().length() == 16) {
            addressForm.setIsDelete(1);
        }
        if (!(saveAddrRst = this.customerAddressService.saveCustomerAddress(addressForm)).isSuccess()) {
            return BaseJsonVo.error((String)(card.getOrderMainNo() + "\u5730\u5740\u4fdd\u5b58\u5931\u8d25\uff1a" + saveAddrRst.getMessage()));
        }
        plans.forEach(plan -> {
            PrepayCardBatchEntity batch = (PrepayCardBatchEntity)this.prepayCardBatchService.selectByPrimaryKey(card.getBatchId());
            PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
            BeanUtils.copyProperties((Object)card, (Object)prepayCardDetailEntity);
            prepayCardDetailEntity.setOrderMainNo("");
            prepayCardDetailEntity.setCardOrderMainNo(card.getOrderMainNo());
            prepayCardDetailEntity.setCreateTime(DateUtils.now());
            prepayCardDetailEntity.setStatus(PrepayCardPlanStatusEnum.ACTIVE.getValue());
            prepayCardDetailEntity.setCustomerId(card.getBelongCustomerId());
            prepayCardDetailEntity.setOrderSource(card.getOrderSource());
            prepayCardDetailEntity.setAddrId(((CustomerAddressEntity)saveAddrRst.getValue()).getAddrId());
            prepayCardDetailEntity.setPromotionId("");
            prepayCardDetailEntity.setOid(plan.getOid());
            prepayCardDetailEntity.setPickTime(plan.getPickupDate());
            int planCount = plan.getProducts().stream().mapToInt(DouDianPrepayPlanProductDTO::getProductNum).sum();
            prepayCardDetailEntity.setQuantity(planCount);
            prepayCardDetailEntity.setPerPrice(plan.getPayAmount());
            list.add(prepayCardDetailEntity);
            this.prepayCardPlanDetailService.insert(prepayCardDetailEntity);
            BaseJsonVo baseJsonVo = this.prepayCardPlanDetailService.createCustomPlanOrder(prepayCardDetailEntity, (DouDianPrepayPlanDTO)plan);
            if (!baseJsonVo.isSuccess()) {
                sb.append(baseJsonVo.getMessage());
            }
        });
        if (sb.length() > 0) {
            return BaseJsonVo.error((String)sb.toString());
        }
        return BaseJsonVo.success(list);
    }

    private BaseJsonVo checkCard(PrepayCardDo prepayCardDo, PrepayCardEntity prepayCardEntity, PrepayCardEntity result) {
        if (prepayCardEntity.getPeriod() == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u914d\u9001\u54ea\u4e00\u5929\u914d\u9001!");
        }
        if (prepayCardEntity.getPeriod() < 1 || prepayCardEntity.getPeriod() > 31) {
            return BaseJsonVo.error((String)"\u914d\u9001\u5929\u5fc5\u987b\u57281\u53f7\u523031\u53f7\u4e4b\u95f4!");
        }
        if (StringUtils.isEmpty((String)prepayCardEntity.getAddrId())) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u914d\u9001\u5730\u5740!");
        }
        if (result == null) {
            return BaseJsonVo.error((String)"\u9884\u4ed8\u5361\u4e0d\u5b58\u5728");
        }
        if (result.getStatus().intValue() == PrepayCardStatusEnum.FINISH.getValue()) {
            return BaseJsonVo.error((String)"\u914d\u9001\u8ba1\u5212\u5df2\u5b8c\u6210,\u65e0\u6cd5\u5b9a\u5236\u8ba1\u5212!");
        }
        if (result.getStatus().intValue() == PrepayCardStatusEnum.NOEFFECT.getValue()) {
            return BaseJsonVo.error((String)"\u9884\u4ed8\u5361\u5df2\u9000\u6b3e,\u65e0\u6cd5\u5b9a\u5236\u8ba1\u5212!");
        }
        if (result.getEndTime() != null && result.getEndTime().before(DateUtils.now())) {
            return BaseJsonVo.error((String)"\u9884\u4ed8\u5361\u5df2\u8fc7\u671f,\u65e0\u6cd5\u5b9a\u5236\u8ba1\u5212!");
        }
        if (result.getRemainCount() == 0) {
            return BaseJsonVo.error((String)"\u5269\u4f59\u6570\u4e3a0\uff0c\u65e0\u6cd5\u5b9a\u5236\u8ba1\u5212!");
        }
        if (result.getRemainCount() < prepayCardDo.getNumber()) {
            return BaseJsonVo.error((String)("\u5269\u4f59\u6570" + result.getRemainCount() + "\u5c0f\u4e8e\u914d\u7f6e\u6570" + prepayCardDo.getNumber() + ",\u65e0\u6cd5\u5b9a\u5236\u8ba1\u5212!"));
        }
        return BaseJsonVo.success((Object)"");
    }

    private List<PrepayCardDetailEntity> getPrepayCardDetailEntity(List<PrepayCardDetailEntity> list, PrepayCardDetailEntity prepayCardDetailEntity, int periodType, Integer period, Integer remainCount) {
        if (list.size() > remainCount) {
            return list;
        }
        PrepayCardDetailEntity result = new PrepayCardDetailEntity();
        BeanUtils.copyProperties((Object)prepayCardDetailEntity, (Object)result);
        Date nextDeliverDate = this.LocalDateTodate(this.getNextDeliveryDate(this.getLocalDate(prepayCardDetailEntity.getPickTime()), periodType, period, false));
        this.logger.info("\u7b2c{}\u6b21\u914d\u9001\u65f6\u95f4:{}", (Object)list.size(), (Object)nextDeliverDate);
        result.setPickTime(nextDeliverDate);
        list.add(result);
        return this.getPrepayCardDetailEntity(list, result, periodType, period, remainCount);
    }

    private Date LocalDateTodate(LocalDate localDate) {
        if (localDate != null) {
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
            Date date = Date.from(instant);
            return date;
        }
        return null;
    }

    private LocalDate getLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate localDate = localDateTime.toLocalDate();
        return localDate;
    }

    @Override
    public Date getFirstDeliveryDate(int periodType, Integer period) {
        this.logger.info("\u914d\u9001\u7c7b\u578b:{},\u914d\u9001\u65f6\u95f4\u70b9:{}", (Object)periodType, (Object)period);
        return this.LocalDateTodate(this.getNextDeliveryDate(LocalDate.now(), periodType, period, true));
    }

    @Override
    public Date getFirstDeliveryDate(int month, int periodType, Integer period) {
        LocalDate localDate = LocalDate.of(LocalDate.now().getYear(), month, (int)period);
        if (LocalDate.now().getMonth().getValue() > month || LocalDate.now().getMonth().getValue() == month && LocalDate.now().getDayOfMonth() >= period) {
            localDate = localDate.plusYears(1L);
        }
        return this.LocalDateTodate(localDate);
    }

    @Override
    public Date getFirstDeliveryDate(PrepayCardDo prepayCardDo) {
        if (prepayCardDo.getMonth() == 0) {
            prepayCardDo.setPeriodType(1);
        } else if (prepayCardDo.getMonth() == -1) {
            prepayCardDo.setPeriodType(2);
        } else {
            prepayCardDo.setPeriodType(0);
        }
        if (prepayCardDo.getPeriodType() == 1 || prepayCardDo.getPeriodType() == 2) {
            this.logger.info("\u914d\u9001\u7c7b\u578b:{},\u914d\u9001\u65f6\u95f4\u70b9:{}", (Object)prepayCardDo.getPeriodType(), (Object)prepayCardDo.getPeriod());
            return this.getFirstDeliveryDate(prepayCardDo.getPeriodType(), prepayCardDo.getPeriod());
        }
        return this.getFirstDeliveryDate(prepayCardDo.getMonth(), prepayCardDo.getPeriodType(), prepayCardDo.getPeriod());
    }

    private LocalDate getNextDeliveryDate(LocalDate deliverDate, int periodType, Integer period, boolean isFirstTime) {
        this.logger.info("\u4e0a\u4e00\u6b21\u914d\u9001\u65e5\u671f{},\u914d\u9001\u7c7b\u578b:{},\u914d\u9001\u65f6\u95f4\u70b9:{}", new Object[]{deliverDate, periodType, period});
        if (periodType == 1) {
            if (isFirstTime) {
                if (deliverDate.getYear() > LocalDate.now().getYear()) {
                    if (period < deliverDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) {
                        return LocalDate.of(deliverDate.getYear(), deliverDate.getMonth(), (int)period);
                    }
                    return deliverDate.with(TemporalAdjusters.lastDayOfMonth());
                }
                if (period > LocalDate.now().getDayOfMonth() && LocalDate.now().getDayOfMonth() < deliverDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) {
                    if (period < deliverDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) {
                        return LocalDate.of(deliverDate.getYear(), deliverDate.getMonth(), (int)period);
                    }
                    return deliverDate.with(TemporalAdjusters.lastDayOfMonth());
                }
                LocalDate nextMonthDay = deliverDate.plusMonths(1L);
                if (period > nextMonthDay.getDayOfMonth()) {
                    if (period > nextMonthDay.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) {
                        return nextMonthDay.with(TemporalAdjusters.lastDayOfMonth());
                    }
                    return LocalDate.of(nextMonthDay.getYear(), deliverDate.getMonth(), (int)period);
                }
                return LocalDate.of(nextMonthDay.getYear(), nextMonthDay.getMonth(), (int)period);
            }
            LocalDate nextMonthDay = deliverDate.plusMonths(1L);
            if (period > nextMonthDay.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) {
                return nextMonthDay.with(TemporalAdjusters.lastDayOfMonth());
            }
            return LocalDate.of(nextMonthDay.getYear(), nextMonthDay.getMonth(), (int)period);
        }
        if (periodType == 2) {
            if (isFirstTime) {
                if (period <= deliverDate.getDayOfWeek().getValue()) {
                    return deliverDate.plusDays(7 - (deliverDate.getDayOfWeek().getValue() - period));
                }
                return deliverDate.plusDays(period - deliverDate.getDayOfWeek().getValue());
            }
            return deliverDate.plusDays(7L);
        }
        return null;
    }

    @Override
    @Transactional
    public BaseJsonVo suspendDeliveryPlan(String cardId) {
        PrepayCardEntity result = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)cardId));
        if (result == null) {
            return BaseJsonVo.error((String)"\u672a\u77e5\u7684\u9884\u4ed8\u5361");
        }
        if (result.getStatus().intValue() == PrepayCardPlanStatusEnum.FINISH.getValue()) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u5df2\u5b8c\u6210,\u65e0\u6cd5\u6682\u505c");
        }
        if (result.getStatus().intValue() == PrepayCardPlanStatusEnum.NOEFFECT.getValue()) {
            return BaseJsonVo.error((String)"\u9884\u4ed8\u5361\u5df2\u9000\u6b3e,\u65e0\u6cd5\u6682\u505c");
        }
        if (result.getEndTime() != null && result.getEndTime().before(DateUtils.now())) {
            return BaseJsonVo.error((String)"\u9884\u4ed8\u5361\u5df2\u5931\u6548\uff0c\u65e0\u6cd5\u6682\u505c");
        }
        PrepayCardDetailEntity query = new PrepayCardDetailEntity();
        query.setCardId(cardId);
        List list = this.prepayCardPlanDetailService.getList(query, 0L);
        if (list.stream().anyMatch(p -> p.getStatus().intValue() == PrepayCardPlanStatusEnum.ACTIVE.getValue())) {
            return BaseJsonVo.error((String)"\u521a\u751f\u6210\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u6682\u505c\u8ba1\u5212\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5");
        }
        if (result.getStatus().intValue() == PrepayCardStatusEnum.ACTIVE.getValue()) {
            try {
                BaseJsonVo baseJsonVo = this.prepayCardPlanDetailService.suspendPrepayCardPlan(cardId);
                this.prepayCardLogService.saveCardPlanLog(cardId, result.getStatus(), PrepayCardPlanStatusEnum.SUSPEND.getValue(), "\u7528\u6237\u6682\u505c\u914d\u9001\u8ba1\u5212");
                if (baseJsonVo.isSuccess()) {
                    query = new PrepayCardDetailEntity();
                    query.setCardId(cardId);
                    query.setStatus(PrepayCardPlanStatusEnum.SUSPEND.getValue());
                    list = new ArrayList();
                    list = this.prepayCardPlanDetailService.getList(query, 0L);
                    for (int i = 0; i < list.size(); ++i) {
                        BaseJsonVo tempBaseJsonVo;
                        if (!StringUtils.isNotEmpty((String)((PrepayCardDetailEntity)list.get(i)).getOrderMainNo()) || (tempBaseJsonVo = this.prepayCardPlanDetailService.editPlanOrder((PrepayCardDetailEntity)list.get(i))).isSuccess()) continue;
                        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                        return BaseJsonVo.error((String)("\u8ba1\u5212\u6682\u505c\u5931\u8d25\uff0c" + tempBaseJsonVo.getMessage()));
                    }
                    return BaseJsonVo.success((Object)"\u8ba1\u5212\u6682\u505c\u6210\u529f");
                }
            }
            catch (Exception e) {
                this.logger.error("\u6682\u505c\u8ba1\u5212\u5931\u8d25", (Throwable)e);
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        } else {
            return BaseJsonVo.error((String)"\u9884\u4ed8\u5361\u672a\u6fc0\u6d3b\uff0c\u65e0\u6cd5\u6682\u505c");
        }
        return BaseJsonVo.error((String)"\u914d\u9001\u8ba1\u5212\u6682\u505c\u5931\u8d25");
    }

    @Override
    public BaseJsonVo<PrepayCardDetailVo> getCardPlanDetail(String cardId) {
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)cardId), 0L);
        return this.getCardPlanDetail(prepayCardEntity, "127.0.0.1");
    }

    public BaseJsonVo getCardPlanDetail(String customerId, String cardId, Integer platformId, String ip, Integer cardType) {
        if (StringUtils.isEmpty((String)cardId) && (Objects.equals(cardType, 4) || Objects.equals(cardType, 5))) {
            return this.getDetailPlanList(customerId, cardType, "127.0.0.1");
        }
        PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)cardId), 0L);
        if (prepayCardEntity == null) {
            return BaseJsonVo.error((String)"\u5361\u65e0\u6548\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return this.getCardPlanDetail(prepayCardEntity, ip);
    }

    private BaseJsonVo getDetailPlanList(String customerId, Integer cardType, String ip) {
        PrepayCardDetailVo prepayCardDetailVo = new PrepayCardDetailVo();
        prepayCardDetailVo.setCardTypeName(PrepayCardTypeEnum.getName(cardType));
        prepayCardDetailVo.setBatchName("");
        prepayCardDetailVo.setCanSuspend(false);
        prepayCardDetailVo.setCardType(cardType);
        prepayCardDetailVo.setCardOrderSource(OrderSourceEnum.RECHANGE_CARD.getValue());
        prepayCardDetailVo.setRemainCount(1);
        int noDeliveryNum = 0;
        Map<String, BigDecimal> specialAccountBaseJson = this.accountBalanceInterface.getSpecialAccount(customerId, cardType);
        this.logger.info("\u7528\u6237:{},\u603b\u91d1\u989d:{},\u53ef\u7528\u91d1\u989d:{}", new Object[]{customerId, specialAccountBaseJson.get("totalAccount"), specialAccountBaseJson.get("usableAccount")});
        prepayCardDetailVo.setUsableValue(specialAccountBaseJson.get("usableAccount"));
        prepayCardDetailVo.setSaleValue(specialAccountBaseJson.get("totalAccount"));
        if (prepayCardDetailVo.getUsableValue().compareTo(BigDecimal.ZERO) <= 0) {
            prepayCardDetailVo.setStatus(PrepayCardStatusEnum.FINISH.getValue());
        } else {
            prepayCardDetailVo.setStatus(PrepayCardStatusEnum.ACTIVE.getValue());
            prepayCardDetailVo.setStatusName(PrepayCardStatusEnum.ACTIVE.getName());
        }
        prepayCardDetailVo.setTitle("");
        HashSet<String> orderNoSet = new HashSet<String>();
        ArrayList<PrepayCardPlanDetailVo> result = new ArrayList<PrepayCardPlanDetailVo>();
        PrepayCardEntity query = new PrepayCardEntity();
        query.setCardType(cardType);
        query.setBelongCustomerId(customerId);
        List cardList = this.prepayCardService.getList(query, 0L);
        for (PrepayCardEntity prepayCardEntity : cardList) {
            PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
            prepayCardDetailEntity.setCardId(prepayCardEntity.getCardId());
            List list = this.prepayCardPlanDetailService.getList(prepayCardDetailEntity, 0L);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                String productName = "";
                int length = list.size();
                List<WeekEnum> weekEnumList = WeekEnum.getList();
                for (int j = 0; j < length; ++j) {
                    if (!orderNoSet.add(((PrepayCardDetailEntity)list.get(j)).getOrderMainNo())) continue;
                    PrepayCardPlanDetailVo prepayCardPlanDetailVo = new PrepayCardPlanDetailVo();
                    BeanUtils.copyProperties(list.get(j), (Object)prepayCardPlanDetailVo);
                    if (prepayCardEntity.getCardType() != null) {
                        prepayCardPlanDetailVo.setCardType(prepayCardEntity.getCardType());
                    }
                    if (StringUtils.isNotEmpty((String)((PrepayCardDetailEntity)list.get(j)).getOrderMainNo())) {
                        List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(((PrepayCardDetailEntity)list.get(j)).getOrderMainNo());
                        if (CollectionUtils.isNotEmpty(orderEntities)) {
                            MallOrderEntity orderEntity = orderEntities.get(0);
                            prepayCardPlanDetailVo.setConsigneePhone(orderEntity.getConsigneePhone());
                            prepayCardPlanDetailVo.setAddress(orderEntity.getConsigneeProvincename() + orderEntity.getConsigneeCityname() + orderEntity.getConsigneeAreaname() + orderEntity.getConsigneeAddr());
                            prepayCardPlanDetailVo.setConsigneeName(orderEntity.getConsigneeName());
                            if (orderEntity.getPickupTime() != null) {
                                ((PrepayCardDetailEntity)list.get(j)).setPickTime(orderEntity.getPickupTime());
                            }
                            prepayCardPlanDetailVo.setOrderNo(orderEntity.getOrderNo());
                            prepayCardPlanDetailVo.setPickupDate(orderEntity.getPickupTime());
                            prepayCardPlanDetailVo.setCanCancel(false);
                            if (orderEntity.getStatus() == 3) {
                                if (prepayCardDetailVo.getCardOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_DOUDIAN_CUSTOM.getValue()) {
                                    prepayCardPlanDetailVo.setCanCancel(true);
                                }
                                noDeliveryNum += ((PrepayCardDetailEntity)list.get(j)).getQuantity().intValue();
                                ((PrepayCardDetailEntity)list.get(j)).setStatus(PrepayCardPlanStatusEnum.ACTIVE.getValue());
                            } else if (orderEntity.getStatus() > 3 && orderEntity.getStatus() < 16) {
                                ((PrepayCardDetailEntity)list.get(j)).setStatus(PrepayCardPlanStatusEnum.DELIVERY.getValue());
                            } else if (orderEntity.getStatus() >= 16 && orderEntity.getStatus() < 20) {
                                ((PrepayCardDetailEntity)list.get(j)).setStatus(PrepayCardPlanStatusEnum.FINISH.getValue());
                            } else if (orderEntity.getStatus() >= 20 || orderEntity.getStatus() < 2) {
                                ((PrepayCardDetailEntity)list.get(j)).setStatus(PrepayCardPlanStatusEnum.NOEFFECT.getValue());
                            }
                            List<MallOrderProductEntity> orderPlanProductEntityList = this.orderProductInterface.getOrderProductInfoByOrderMianNo(((PrepayCardDetailEntity)list.get(j)).getOrderMainNo());
                            StringBuilder productBuilder = new StringBuilder();
                            for (MallOrderProductEntity planProductEntity : orderPlanProductEntityList) {
                                productBuilder.append(planProductEntity.getProductName() + "[" + planProductEntity.getQuantity() + "],");
                            }
                            productName = productBuilder.toString().substring(0, productBuilder.length() - 1);
                            prepayCardPlanDetailVo.setQuantity(orderPlanProductEntityList.stream().map(MallOrderProductEntity::getQuantity).reduce(0, (a, b) -> a + b));
                        }
                        prepayCardPlanDetailVo.setPricePoint(((PrepayCardDetailEntity)list.get(j)).getPerPrice());
                    }
                    prepayCardPlanDetailVo.setStatusName(PrepayCardPlanStatusEnum.getName(((PrepayCardDetailEntity)list.get(j)).getStatus()));
                    prepayCardPlanDetailVo.setNum(j + 1);
                    if (((PrepayCardDetailEntity)list.get(j)).getPickTime() != null) {
                        prepayCardPlanDetailVo.setWeek(weekEnumList.get(this.getLocalDate(((PrepayCardDetailEntity)list.get(j)).getPickTime()).getDayOfWeek().getValue() - 1).getName());
                    } else {
                        prepayCardPlanDetailVo.setWeek(null);
                    }
                    prepayCardPlanDetailVo.setProductName(productName);
                    prepayCardPlanDetailVo.setStatus(((PrepayCardDetailEntity)list.get(j)).getStatus());
                    result.add(prepayCardPlanDetailVo);
                }
                continue;
            }
            prepayCardDetailVo.setNoDeliveryNum(0);
        }
        prepayCardDetailVo.setPlanDetailList(result);
        prepayCardDetailVo.setCanSuspend(result.stream().anyMatch(d -> d.getStatus().intValue() == PrepayCardPlanStatusEnum.ACTIVE.getValue()));
        try {
            CustomerAddressVo addressVo = this.customerAddressService.getCustomerDefaultAddress(customerId, "", "", ip, null);
            prepayCardDetailVo.setConsigneePhone(addressVo.getConsigneePhone());
            prepayCardDetailVo.setAddress(addressVo.getProvinceName() + addressVo.getCityName() + addressVo.getAreaName() + addressVo.getAddress());
            prepayCardDetailVo.setConsigneeName(addressVo.getConsigneeName());
            prepayCardDetailVo.setAddrId(addressVo.getAddrId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result.sort(new Comparator<PrepayCardPlanDetailVo>(){

            @Override
            public int compare(PrepayCardPlanDetailVo o1, PrepayCardPlanDetailVo o2) {
                return o1.getDetailedId() - o2.getDetailedId();
            }
        });
        prepayCardDetailVo.setNoDeliveryNum(noDeliveryNum);
        return BaseJsonVo.success((Object)prepayCardDetailVo);
    }

    private BaseJsonVo<PrepayCardDetailVo> getCardPlanDetail(PrepayCardEntity prepayCardEntity, String ip) {
        PrepayCardDetailVo prepayCardDetailVo = new PrepayCardDetailVo();
        BeanUtils.copyProperties((Object)prepayCardEntity, (Object)prepayCardDetailVo);
        prepayCardDetailVo.setCardTypeName(PrepayCardTypeEnum.getName(prepayCardEntity.getCardType()));
        PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchService.selectByPrimaryKey(prepayCardEntity.getBatchId());
        prepayCardDetailVo.setBatchName(prepayCardBatchEntity.getBatchName());
        prepayCardDetailVo.setCanSuspend(prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.ACTIVE.getValue());
        prepayCardDetailVo.setBatchType(prepayCardBatchEntity.getBatchType());
        prepayCardDetailVo.setBatchTypeName(PrepayCardBatchTypeEnum.getName(prepayCardBatchEntity.getBatchType()));
        prepayCardDetailVo.setCardOrderSource(prepayCardBatchEntity.getOrderSource());
        prepayCardDetailVo.setBindCode(prepayCardBatchEntity.getBindCode());
        if (StringUtils.isNotEmpty((String)prepayCardBatchEntity.getProductPromotionId())) {
            prepayCardDetailVo.setTransportType(this.promotionService.getPromotionDeliveryType(prepayCardBatchEntity.getProductPromotionId()));
            prepayCardDetailVo.setUnit(this.promotionService.getPromotionUnit(prepayCardBatchEntity.getProductPromotionId()));
        }
        prepayCardDetailVo.setStatusName(PrepayCardStatusEnum.getName(prepayCardEntity.getStatus()));
        if (prepayCardEntity.getEndTime() != null && prepayCardEntity.getEndTime().before(DateUtils.now()) && prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.ACTIVE.getValue()) {
            prepayCardDetailVo.setStatus(PrepayCardStatusEnum.NOEFFECT.getValue());
        }
        if (Objects.equals(prepayCardEntity.getBatchType(), PrepayCardBatchTypeEnum.NUM_CARD.getValue())) {
            if (prepayCardEntity.getRemainCount() == 0 && prepayCardEntity.getStatus().intValue() == PrepayCardStatusEnum.ACTIVE.getValue()) {
                prepayCardDetailVo.setStatus(PrepayCardStatusEnum.FINISH.getValue());
            }
            prepayCardDetailVo.setNoDeliveryNum(prepayCardEntity.getTotalCount() - prepayCardEntity.getRemainCount());
        }
        PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
        prepayCardDetailEntity.setCardId(prepayCardEntity.getCardId());
        List list = this.prepayCardPlanDetailService.getList(prepayCardDetailEntity, 0L);
        if (prepayCardBatchEntity.getBatchType().intValue() == PrepayCardBatchTypeEnum.POINT_CARD.getValue()) {
            Map<String, BigDecimal> remain = this.accountBalanceInterface.getSpecialCardRemain(prepayCardEntity.getRelateCardNo());
            if (remain.containsKey("usableAccount")) {
                prepayCardDetailVo.setUsableValue(remain.get("usableAccount"));
                prepayCardDetailVo.setSaleValue(remain.get("totalAccount"));
            }
            prepayCardDetailVo.setSaleValue(prepayCardEntity.getSaleValue());
            if (prepayCardDetailVo.getUsableValue().compareTo(BigDecimal.ZERO) <= 0) {
                prepayCardDetailVo.setStatus(PrepayCardStatusEnum.FINISH.getValue());
            }
            prepayCardDetailVo.setTitle("");
            prepayCardDetailVo.setRemainCount(1);
        }
        prepayCardDetailVo.setStatusName(PrepayCardStatusEnum.getName(prepayCardDetailVo.getStatus()));
        int noDeliveryNum = 0;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ArrayList<PrepayCardPlanDetailVo> result = new ArrayList<PrepayCardPlanDetailVo>();
            String productName = "";
            int length = list.size();
            List<WeekEnum> weekEnumList = WeekEnum.getList();
            for (int j = 0; j < length; ++j) {
                PrepayCardPlanDetailVo prepayCardPlanDetailVo = new PrepayCardPlanDetailVo();
                BeanUtils.copyProperties(list.get(j), (Object)prepayCardPlanDetailVo);
                prepayCardPlanDetailVo.setBatchType(prepayCardBatchEntity.getBatchType());
                prepayCardPlanDetailVo.setBatchTypeName(PrepayCardBatchTypeEnum.getName(prepayCardBatchEntity.getBatchType()));
                if (prepayCardEntity.getCardType() != null) {
                    prepayCardPlanDetailVo.setCardType(prepayCardEntity.getCardType());
                }
                prepayCardPlanDetailVo.setBox(StringUtils.isEmpty((String)prepayCardEntity.getUnit()) ? "" : prepayCardEntity.getUnit());
                if (StringUtils.isNotEmpty((String)((PrepayCardDetailEntity)list.get(j)).getOrderMainNo())) {
                    String balaceDesc;
                    MallOrderMainEntity orderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(((PrepayCardDetailEntity)list.get(j)).getOrderMainNo());
                    String string = balaceDesc = Objects.equals(prepayCardEntity.getCardType(), PrepayCardTypeEnum.yogurt_card.getValue()) ? orderMainEntity.getPoints() + "\u70b9" : "";
                    if (prepayCardEntity.getCardType().intValue() == PrepayCardTypeEnum.new_card_Nomal.getValue() || prepayCardEntity.getCardType().intValue() == PrepayCardTypeEnum.new_card_Cold.getValue()) {
                        balaceDesc = String.valueOf(orderMainEntity.getPoints());
                    }
                    if (prepayCardEntity.getCardType().intValue() == PrepayCardTypeEnum.milk_card.getValue()) {
                        balaceDesc = String.valueOf(orderMainEntity.getOrderAmount());
                    }
                    String wechatPayDesc = orderMainEntity.getPayAmount().compareTo(BigDecimal.ZERO) > 0 ? "\u5fae\u4fe1\u652f\u4ed8:" + orderMainEntity.getPayAmount() : "";
                    prepayCardPlanDetailVo.setOrderAmountDesc(wechatPayDesc + balaceDesc);
                    List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(((PrepayCardDetailEntity)list.get(j)).getOrderMainNo());
                    if (CollectionUtils.isNotEmpty(orderEntities)) {
                        MallOrderEntity orderEntity = orderEntities.get(0);
                        prepayCardPlanDetailVo.setCanCancel(false);
                        if (orderEntity.getStatus() == 3 && prepayCardDetailVo.getCardOrderSource().intValue() != OrderSourceEnum.CARD_PREPAY_DOUDIAN_CUSTOM.getValue()) {
                            prepayCardPlanDetailVo.setCanCancel(true);
                        }
                        prepayCardPlanDetailVo.setConsigneePhone(orderEntity.getConsigneePhone());
                        prepayCardPlanDetailVo.setAddress(orderEntity.getConsigneeProvincename() + orderEntity.getConsigneeCityname() + orderEntity.getConsigneeAreaname() + orderEntity.getConsigneeAddr());
                        prepayCardPlanDetailVo.setConsigneeName(orderEntity.getConsigneeName());
                        if (orderEntity.getPickupTime() != null) {
                            ((PrepayCardDetailEntity)list.get(j)).setPickTime(orderEntity.getPickupTime());
                        }
                        prepayCardPlanDetailVo.setOrderNo(orderEntity.getOrderNo());
                        prepayCardPlanDetailVo.setPickupDate(orderEntity.getPickupTime());
                        if (orderEntity.getStatus() == 3) {
                            noDeliveryNum += ((PrepayCardDetailEntity)list.get(j)).getQuantity().intValue();
                            ((PrepayCardDetailEntity)list.get(j)).setStatus(PrepayCardPlanStatusEnum.ACTIVE.getValue());
                        } else if (orderEntity.getStatus() > 3 && orderEntity.getStatus() < 16) {
                            noDeliveryNum += ((PrepayCardDetailEntity)list.get(j)).getQuantity().intValue();
                            ((PrepayCardDetailEntity)list.get(j)).setStatus(PrepayCardPlanStatusEnum.DELIVERY.getValue());
                        } else if (orderEntity.getStatus() >= 16 && orderEntity.getStatus() < 20) {
                            noDeliveryNum += ((PrepayCardDetailEntity)list.get(j)).getQuantity().intValue();
                            ((PrepayCardDetailEntity)list.get(j)).setStatus(PrepayCardPlanStatusEnum.FINISH.getValue());
                        } else if (orderEntity.getStatus() >= 20 || orderEntity.getStatus() <= 0) {
                            ((PrepayCardDetailEntity)list.get(j)).setStatus(PrepayCardPlanStatusEnum.NOEFFECT.getValue());
                        }
                    }
                    if (StringUtils.isEmpty((String)((PrepayCardDetailEntity)list.get(j)).getPromotionId())) {
                        List<MallOrderGroupProductEntity> mallOrderGroupProductEntityList = this.orderGroupProductInterface.getOrderGroupProductListByMianOrderNo(((PrepayCardDetailEntity)list.get(j)).getOrderMainNo());
                        StringBuilder productBuilder = new StringBuilder();
                        for (MallOrderGroupProductEntity orderGroupProductEntity : mallOrderGroupProductEntityList) {
                            if (orderGroupProductEntity.getProductName().contains("\u5305\u88f9\u5361")) continue;
                            productBuilder.append(orderGroupProductEntity.getProductName() + ",");
                        }
                        productName = productBuilder.toString().substring(0, productBuilder.length() - 1);
                        if (Objects.equals(prepayCardBatchEntity.getBatchType(), PrepayCardBatchTypeEnum.POINT_CARD.getValue())) {
                            prepayCardPlanDetailVo.setBox("\u76d2");
                            prepayCardPlanDetailVo.setQuantity(mallOrderGroupProductEntityList.stream().map(MallOrderGroupProductEntity::getQuantity).reduce(0, (a, b) -> a + b));
                        }
                    } else {
                        prepayCardPlanDetailVo.setPricePoint(((PrepayCardDetailEntity)list.get(j)).getPerPrice());
                        if (StringUtils.isEmpty((String)productName)) {
                            MallPromotionEntity promotionEntity = this.promotionService.getPromotion(prepayCardBatchEntity.getProductPromotionId());
                            productName = promotionEntity == null ? "\u5976\u5361" : promotionEntity.getPromotionName();
                        }
                    }
                } else {
                    prepayCardPlanDetailVo.setOrderNo("");
                    prepayCardPlanDetailVo.setConsigneeName("");
                    prepayCardPlanDetailVo.setPickupDate(((PrepayCardDetailEntity)list.get(j)).getPickTime());
                    if (StringUtils.isNotEmpty((String)((PrepayCardDetailEntity)list.get(j)).getOrderPlanId())) {
                        prepayCardPlanDetailVo.setBox("");
                        CustomerAddressEntity customerAddressEntity = this.customerAddressService.getCustomerAddress(((PrepayCardDetailEntity)list.get(j)).getAddrId());
                        if (customerAddressEntity != null) {
                            prepayCardPlanDetailVo.setConsigneePhone(customerAddressEntity.getConsigneePhone());
                            prepayCardPlanDetailVo.setAddress(customerAddressEntity.getProvinceName() + customerAddressEntity.getCityName() + customerAddressEntity.getAreaName() + customerAddressEntity.getAddress());
                            prepayCardPlanDetailVo.setConsigneeName(customerAddressEntity.getConsigneeName());
                        }
                    }
                    prepayCardPlanDetailVo.setOrderMainNo("\u8ba2\u5355\u5f85\u751f\u6210");
                }
                if (StringUtils.isEmpty((String)productName) && StringUtils.isNotEmpty((String)((PrepayCardDetailEntity)list.get(j)).getOrderPlanId())) {
                    MallOrderPlanProductEntity orderPlanProductEntity = new MallOrderPlanProductEntity();
                    orderPlanProductEntity.setOrderPlanId(String.valueOf(((PrepayCardDetailEntity)list.get(j)).getDetailedId()));
                    List orderPlanProductEntityList = this.orderPlanProductInterface.getList(orderPlanProductEntity);
                    StringBuilder productBuilder = new StringBuilder();
                    for (MallOrderPlanProductEntity planProductEntity : orderPlanProductEntityList) {
                        productBuilder.append(planProductEntity.getProductName() + "[" + planProductEntity.getQuantity() + "],");
                    }
                    productName = productBuilder.toString().substring(0, productBuilder.length() - 1);
                    prepayCardPlanDetailVo.setBox("");
                    prepayCardPlanDetailVo.setQuantity(orderPlanProductEntityList.stream().map(MallOrderPlanProductEntity::getQuantity).reduce(0, (a, b) -> a + b));
                }
                prepayCardPlanDetailVo.setStatusName(PrepayCardPlanStatusEnum.getName(((PrepayCardDetailEntity)list.get(j)).getStatus()));
                prepayCardPlanDetailVo.setNum(j + 1);
                if (((PrepayCardDetailEntity)list.get(j)).getPickTime() != null) {
                    prepayCardPlanDetailVo.setWeek(weekEnumList.get(this.getLocalDate(((PrepayCardDetailEntity)list.get(j)).getPickTime()).getDayOfWeek().getValue() - 1).getName());
                }
                prepayCardPlanDetailVo.setProductName(productName);
                prepayCardPlanDetailVo.setStatus(((PrepayCardDetailEntity)list.get(j)).getStatus());
                result.add(prepayCardPlanDetailVo);
            }
            result.sort(new Comparator<PrepayCardPlanDetailVo>(){

                @Override
                public int compare(PrepayCardPlanDetailVo o1, PrepayCardPlanDetailVo o2) {
                    if (o1.getPickupDate() != null && o2.getPickupDate() != null) {
                        return o1.getPickupDate().compareTo(o2.getPickupDate());
                    }
                    return 1;
                }
            });
            prepayCardDetailVo.setPlanDetailList(result);
            prepayCardDetailVo.setCanSuspend(result.stream().anyMatch(d -> d.getStatus().intValue() == PrepayCardPlanStatusEnum.ACTIVE.getValue()));
            prepayCardDetailVo.setNoDeliveryNum(noDeliveryNum);
            try {
                CustomerAddressVo addressVo = this.customerAddressService.getCustomerDefaultAddress(prepayCardEntity.getBelongCustomerId(), "", "", ip, null);
                prepayCardDetailVo.setConsigneePhone(addressVo.getConsigneePhone());
                prepayCardDetailVo.setAddress(addressVo.getProvinceName() + addressVo.getCityName() + addressVo.getAreaName() + addressVo.getAddress());
                prepayCardDetailVo.setConsigneeName(addressVo.getConsigneeName());
                prepayCardDetailVo.setAddrId(addressVo.getAddrId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            prepayCardDetailVo.setNoDeliveryNum(0);
            prepayCardDetailVo.setAddrId("");
            prepayCardDetailVo.setAddress("");
        }
        Map<String, List<String>> pics = this.picService.getProductPicUrlMap(String.valueOf(prepayCardEntity.getBatchId()), SalesTypeEnum.SALES_PRODUCT.getValue());
        if (pics != null && pics.containsKey("picProductHead") && pics.get("picProductHead") != null && pics.get("picProductHead").size() > 0) {
            prepayCardDetailVo.setPic(pics.get("picProductHead").get(0));
        }
        return BaseJsonVo.success((Object)prepayCardDetailVo);
    }

    @Override
    public BaseJsonVo refundPrepayCardOrderForSaleAfter(String orderMainNo, String orderNo, String customerId) {
        MallOrderMainEntity orderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo);
        if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_DOUDIAN_CUSTOM.getValue()) {
            return BaseJsonVo.error((String)"\u6296\u97f3/\u5929\u732b\u5bc4\u5b58\u8ba2\u5355\u4e0d\u53ef\u53d6\u6d88");
        }
        PrepayCardDetailEntity query = new PrepayCardDetailEntity();
        query.setOrderMainNo(orderMainNo);
        List detailEntityList = this.prepayCardPlanDetailService.getList(query, 0L);
        if (CollectionUtils.isEmpty((Collection)detailEntityList)) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        if (detailEntityList.stream().allMatch(d -> Objects.equals(PrepayCardPlanStatusEnum.NOEFFECT.getValue(), d.getStatus()))) {
            return BaseJsonVo.success((Object)"\u8ba1\u5212\u5df2\u53d6\u6d88");
        }
        boolean lock = this.mallRedisLock.lock(orderMainNo + ":cancelPlan", "1", 8L, TimeUnit.SECONDS);
        if (lock) {
            return this.prepayCardInvoke.refundPrepayCardForMall(orderNo, null, customerId);
        }
        return BaseJsonVo.error((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    @Override
    public BaseJsonVo refundPrepayCardOrder(String orderMainNo, String orderNo, String customerId) {
        MallOrderMainEntity orderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo);
        if (orderMainEntity.getOrderSource().intValue() == OrderSourceEnum.CARD_PREPAY_DOUDIAN_CUSTOM.getValue()) {
            return BaseJsonVo.error((String)"\u6296\u97f3/\u5929\u732b\u5bc4\u5b58\u8ba2\u5355\u4e0d\u53ef\u53d6\u6d88");
        }
        PrepayCardDetailEntity query = new PrepayCardDetailEntity();
        query.setOrderMainNo(orderMainNo);
        List detailEntityList = this.prepayCardPlanDetailService.getList(query, 0L);
        if (CollectionUtils.isEmpty((Collection)detailEntityList)) {
            return BaseJsonVo.error((String)"\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        if (detailEntityList.stream().allMatch(d -> Objects.equals(PrepayCardPlanStatusEnum.NOEFFECT.getValue(), d.getStatus()))) {
            return BaseJsonVo.success((Object)"\u8ba1\u5212\u5df2\u53d6\u6d88");
        }
        List<MallOrderEntity> orderList = this.orderInterface.getOrderList(orderMainNo);
        boolean lock = this.mallRedisLock.lock(orderMainNo + ":cancelPlan", "1", 8L, TimeUnit.SECONDS);
        if (lock) {
            BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
            for (MallOrderEntity mallOrderEntity : orderList) {
                baseJsonVo = this.prepayCardInvoke.refundPrepayCardForMall(mallOrderEntity.getOrderNo(), null, customerId);
                if (baseJsonVo.isSuccess()) continue;
                this.logger.error("refundPrepayCardOrder\u53d6\u6d88\u5976\u5361\u8c03\u7528\u552e\u540e:orderNo:{},customerId:{}\u9000\u6b3e\u7ed3\u679c:{}", new Object[]{mallOrderEntity.getOrderNo(), customerId, JsonUtils.toJson((Object)baseJsonVo, (boolean)false)});
            }
            if (baseJsonVo.isSuccess()) {
                this.customerFreeInterface.refundFree(orderMainNo);
                for (PrepayCardDetailEntity detailEntity : detailEntityList) {
                    detailEntity.setStatus(PrepayCardPlanStatusEnum.NOEFFECT.getValue());
                    this.prepayCardPlanDetailService.updateByPrimaryKeySelective(detailEntity);
                }
                PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardService.selectByPrimaryKey((Serializable)((Object)((PrepayCardDetailEntity)detailEntityList.get(0)).getCardId()), 0L);
                if (Objects.equals(prepayCardEntity.getCardType(), PrepayCardTypeEnum.milk_card.getValue())) {
                    this.logger.info("\u7528\u6237:{},\u5976\u5361:{}\u9000\u6b21\u6570:{}", new Object[]{customerId, prepayCardEntity.getCardId(), ((PrepayCardDetailEntity)detailEntityList.get(0)).getQuantity()});
                    return this.refundOrderPlanNum(orderMainNo, customerId);
                }
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    @Override
    public BaseJsonVo createPlanDetail(PrepayCardEntity card, String orderMainNo, BigDecimal preAmount) {
        PrepayCardBatchEntity batch = (PrepayCardBatchEntity)this.prepayCardBatchService.selectByPrimaryKey(card.getBatchId());
        PrepayCardDetailEntity prepayCardDetailEntity = new PrepayCardDetailEntity();
        BeanUtils.copyProperties((Object)card, (Object)prepayCardDetailEntity);
        prepayCardDetailEntity.setOrderMainNo(orderMainNo);
        prepayCardDetailEntity.setCardOrderMainNo(card.getOrderMainNo());
        prepayCardDetailEntity.setCreateTime(DateUtils.now());
        prepayCardDetailEntity.setStatus(PrepayCardPlanStatusEnum.FINISH.getValue());
        prepayCardDetailEntity.setCustomerId(card.getBelongCustomerId());
        prepayCardDetailEntity.setOrderSource(card.getOrderSource());
        prepayCardDetailEntity.setAddrId("");
        prepayCardDetailEntity.setPromotionId("");
        prepayCardDetailEntity.setOid(null);
        prepayCardDetailEntity.setPickTime(null);
        prepayCardDetailEntity.setQuantity(1);
        prepayCardDetailEntity.setPerPrice(preAmount);
        return BaseJsonVo.success((Object)"");
    }
}

