/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.prepay.PrepayCardRecommendDetailMapper;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardRecommendDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardRecommendDetailVO;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardRecommendDetailInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardRecommendDetailService
extends BaseService<PrepayCardRecommendDetailEntity, Integer>
implements PrepayCardRecommendDetailInterface {
    @Resource
    private PrepayCardRecommendDetailMapper prepayCardRecommendDetailMapper;
    @Autowired
    MallProductPicInterface picService;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    private MallPromotionInterface mallPromotionInterface;

    @Override
    public List<PrepayCardRecommendDetailVO> getCardRecommendDetailVos(Integer reCommendId) {
        PrepayCardRecommendDetailEntity search = new PrepayCardRecommendDetailEntity();
        search.setRecommendId(reCommendId);
        List lst = this.getList(search);
        ArrayList<PrepayCardRecommendDetailVO> results = new ArrayList<PrepayCardRecommendDetailVO>();
        for (PrepayCardRecommendDetailEntity d : lst) {
            PrepayCardRecommendDetailVO detailVO = new PrepayCardRecommendDetailVO();
            detailVO.setBindCode(d.getBindCode());
            detailVO.setCardBatchId(d.getCardBatchId());
            detailVO.setCardAmount(d.getCardAmount());
            detailVO.setCardPromotionId(d.getCardPromotionId());
            Map<String, List<String>> pics = this.picService.getProductPicUrlMap(String.valueOf(d.getCardBatchId()), SalesTypeEnum.SALES_PRODUCT.getValue());
            if (pics != null && pics.containsKey("picProductHead") && pics.get("picProductHead") != null && pics.get("picProductHead").size() > 0) {
                detailVO.setPicUrl(pics.get("picProductHead").get(0));
            }
            PrepayCardBatchEntity batchEntity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(d.getCardBatchId());
            detailVO.setCardBatchName(batchEntity.getBatchName());
            detailVO.setCardType(batchEntity.getCardType());
            MallPromotionEntity promotion = this.mallPromotionInterface.getPromotion(d.getCardPromotionId());
            detailVO.setCardPromotionName(promotion.getPromotionName());
            detailVO.setPayAmount(d.getPayAmount());
            detailVO.setDirectUrl(detailVO.getDirectUrl() + detailVO.getBindCode());
            detailVO.setSaveAmount(d.getOrderAmount().subtract(d.getFactAmount()));
            results.add(detailVO);
        }
        return results;
    }
}

