/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.apiinvoke.bi.BIOrderDetailInvoke;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.prepay.PrepayCardRecommendMapper;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardRecommendDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardRecommendDetailVO;
import cc.lechun.mall.entity.prepay.PrepayCardRecommendEntity;
import cc.lechun.mall.entity.prepay.PrepayCardRecommendVO;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardItemInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardRecommendDetailInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardRecommendInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.omsv2.entity.order.origin.vo.OriginOrderProductVO;
import cc.lechun.omsv2.entity.order.origin.vo.OriginOrderVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class PrepayCardRecommendService
extends BaseService<PrepayCardRecommendEntity, Integer>
implements PrepayCardRecommendInterface {
    @Resource
    private PrepayCardRecommendMapper prepayCardRecommendMapper;
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    private MallPromotionInterface mallPromotionInterface;
    @Autowired
    private MallOrderGroupProductInterface mallOrderGroupProductInterface;
    @Autowired
    MallProductPicInterface picService;
    @Autowired
    private MallProductInterface mallProductInterface;
    @Autowired
    private PrepayCardItemInterface prepayCardItemInterface;
    @Autowired
    private PrepayCardRecommendDetailInterface recommendDetailInterface;
    @Autowired
    private BIOrderDetailInvoke biOrderDetailInvoke;

    @Override
    public List<PrepayCardRecommendVO> getLastRecommendList(String customerId) {
        ArrayList<PrepayCardRecommendVO> vos = new ArrayList<PrepayCardRecommendVO>();
        List<PrepayCardRecommendEntity> list = this.prepayCardRecommendMapper.getRecomendList(customerId);
        list.forEach(entity -> {
            PrepayCardRecommendVO vo = new PrepayCardRecommendVO();
            vo.setOrderMainNo(entity.getOrderMainNo());
            vo.setCustomerId(customerId);
            MallOrderMainEntity orderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(entity.getOrderMainNo());
            StringBuilder sb = new StringBuilder();
            if (orderMainEntity != null) {
                vo.setOrderCreateTime(orderMainEntity.getCreateTime());
                List<MallOrderGroupProductEntity> orderGroupProductListByMianOrderNo = this.mallOrderGroupProductInterface.getOrderGroupProductListByMianOrderNo(entity.getOrderMainNo());
                orderGroupProductListByMianOrderNo.forEach(pro -> sb.append(pro.getProductName()).append(" x ").append(pro.getQuantity()));
            } else {
                BaseJsonVo<List<OriginOrderProductVO>> jsonVo = this.mallOrderMainInterface.getOriginOrderProduct(entity.getOrderMainNo());
                if (jsonVo.isSuccess()) {
                    if (((List)jsonVo.getValue()).size() > 0) {
                        vo.setOrderCreateTime(((OriginOrderProductVO)((List)jsonVo.getValue()).get(0)).getPayTime());
                    }
                    ((List)jsonVo.getValue()).forEach(pro -> sb.append(pro.getProductName()).append(" x ").append(pro.getProductNum().intValue()));
                }
            }
            vo.setProducts(sb.toString());
            List<PrepayCardRecommendDetailVO> detailVOS = this.recommendDetailInterface.getCardRecommendDetailVos(entity.getId());
            if (detailVOS.size() > 0) {
                vo.setDetailVOS(detailVOS);
                vos.add(vo);
            }
        });
        return vos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Transactional
    public BaseJsonVo recommendCards(String orderMainNo) {
        Integer[] cardTypeArr;
        ArrayList<Map<String, Object>> productList;
        PrepayCardRecommendEntity recommend;
        block22: {
            BaseJsonVo js;
            LinkedHashMap<String, Object> productMap;
            block24: {
                Iterator iterator;
                block23: {
                    MallOrderMainEntity mallOrderMainEntity;
                    block20: {
                        BaseJsonVo<OriginOrderVO> jsonVo;
                        block21: {
                            recommend = new PrepayCardRecommendEntity();
                            recommend.setOrderMainNo(orderMainNo);
                            PrepayCardRecommendEntity search = (PrepayCardRecommendEntity)this.getSingle(recommend, 0L);
                            if (search != null) {
                                if (Integer.valueOf(1).equals(search.getSucc())) {
                                    return BaseJsonVo.error((String)"\u7528\u6237\u5df2\u7ecf\u8865\u5dee\u4ef7\u6210\u529f\uff0c\u4e0d\u80fd\u518d\u6b21\u8bbe\u7f6e");
                                }
                                this.deleteByPrimaryKey(search.getId());
                                PrepayCardRecommendDetailEntity detailEntity = new PrepayCardRecommendDetailEntity();
                                detailEntity.setRecommendId(search.getId());
                                List details = this.recommendDetailInterface.getList(detailEntity);
                                for (PrepayCardRecommendDetailEntity d : details) {
                                    this.recommendDetailInterface.deleteByPrimaryKey(d.getId());
                                }
                            }
                            recommend.setCreateTime(new Date());
                            recommend.setSucc(0);
                            productList = new ArrayList<Map<String, Object>>();
                            productMap = new LinkedHashMap<String, Object>();
                            mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderMainNo);
                            cardTypeArr = new Integer[2];
                            if (mallOrderMainEntity != null) break block20;
                            jsonVo = this.mallOrderMainInterface.getOriginOrder(orderMainNo);
                            this.logger.info("\u8ba2\u5355\u6362\u5976\u5361{},\u975e\u5fae\u4fe1\u8ba2\u5355\uff0c\u67e5\u8be2erp\uff1a{},{}", new Object[]{orderMainNo, jsonVo.isSuccess(), jsonVo.getError()});
                            if (!jsonVo.isSuccess()) {
                                return jsonVo;
                            }
                            if (((OriginOrderVO)jsonVo.getValue()).getOrderStatus() < 10 || ((OriginOrderVO)jsonVo.getValue()).getOrderStatus() > 40 || !Integer.valueOf(1).equals(((OriginOrderVO)jsonVo.getValue()).getOrderType())) break block21;
                            recommend.setOrderAmount(((OriginOrderVO)jsonVo.getValue()).getPayAmount());
                            js = this.biOrderDetailInvoke.getBIOrderCustomerId(((OriginOrderVO)jsonVo.getValue()).getExternalOrderNo());
                            if (!js.isSuccess()) {
                                this.logger.error("\u63a8\u8350\u5976\u5361\u51fa\u9519,\u8ba2\u5355:{}\u9519\u8bef\u6d88\u606f:{}", (Object)orderMainNo, (Object)js.getError_msg());
                                return js;
                            }
                            if (js.getValue() == null || StringUtils.isEmpty((String)js.getValue().toString())) {
                                this.logger.error("\u8ba2\u5355:{}\u672a\u5728\u5fae\u4fe1\u5546\u57ce\u672a\u7ed1\u5b9a", (Object)orderMainNo);
                                return BaseJsonVo.error((String)("\u8ba2\u5355:" + orderMainNo + "\u672a\u5728\u5fae\u4fe1\u5546\u57ce\u672a\u7ed1\u5b9a"));
                            }
                            recommend.setCustomerId(js.getValue().toString());
                            BaseJsonVo<List<OriginOrderProductVO>> jsonVoOrigin = this.mallOrderMainInterface.getOriginOrderProduct(orderMainNo);
                            if (!jsonVoOrigin.isSuccess()) break block22;
                            iterator = ((List)jsonVoOrigin.getValue()).iterator();
                            break block23;
                        }
                        this.logger.info("\u8ba2\u5355\u6362\u5976\u5361{},\u975e\u5fae\u4fe1\u8ba2\u5355\uff0c\u72b6\u6001\u4e0d\u7b26status:{},orderType:{}", (Object)((OriginOrderVO)jsonVo.getValue()).getOrderStatus(), (Object)((OriginOrderVO)jsonVo.getValue()).getOrderType());
                        return BaseJsonVo.error((String)"\u8ba2\u5355\u72b6\u6001\u4e0d\u6b63\u786e");
                    }
                    if (mallOrderMainEntity.getStatus() < 3) return BaseJsonVo.error((String)"\u8ba2\u5355\u72b6\u6001\u4e0d\u6b63\u786e\u6216\u8ba2\u5355\u6765\u6e90\u4e0d\u652f\u6301\u8865\u5dee\u4ef7");
                    if (mallOrderMainEntity.getStatus() > 16) return BaseJsonVo.error((String)"\u8ba2\u5355\u72b6\u6001\u4e0d\u6b63\u786e\u6216\u8ba2\u5355\u6765\u6e90\u4e0d\u652f\u6301\u8865\u5dee\u4ef7");
                    if (mallOrderMainEntity.getOrderSource() != 0) {
                        if (mallOrderMainEntity.getOrderSource() != 7) return BaseJsonVo.error((String)"\u8ba2\u5355\u72b6\u6001\u4e0d\u6b63\u786e\u6216\u8ba2\u5355\u6765\u6e90\u4e0d\u652f\u6301\u8865\u5dee\u4ef7");
                    }
                    recommend.setOrderAmount(mallOrderMainEntity.getOrderAmount());
                    recommend.setCustomerId(mallOrderMainEntity.getCustomerId());
                    List<MallOrderGroupProductEntity> productEntities = this.mallOrderGroupProductInterface.getOrderGroupProductListByMianOrderNo(orderMainNo);
                    js = productEntities.iterator();
                    break block24;
                }
                while (iterator.hasNext()) {
                    MallProductEntity productEntity;
                    OriginOrderProductVO p = (OriginOrderProductVO)iterator.next();
                    if (!Integer.valueOf(2).equals(p.getProductIsGift()) || BigDecimal.valueOf(0L).equals(p.getProductSellAmount()) || !StringUtils.isNotEmpty((String)p.getProductCbarcode()) || p.getProductSellAmount().equals(BigDecimal.ZERO) || (productEntity = this.mallProductInterface.getProductByBarcode(p.getProductCbarcode())) == null) continue;
                    productMap = new LinkedHashMap();
                    productMap.put("barCode", p.getProductCbarcode());
                    productMap.put("quantity", p.getProductNum().intValue());
                    if (Integer.valueOf(1).equals(productEntity.getTransportType())) {
                        cardTypeArr[0] = 4;
                        cardTypeArr[1] = 5;
                    } else {
                        cardTypeArr[0] = 5;
                        cardTypeArr[1] = 4;
                    }
                    productList.add(productMap);
                }
                break block22;
            }
            while (js.hasNext()) {
                MallProductEntity productEntity;
                MallOrderGroupProductEntity p = js.next();
                if (BigDecimal.ZERO.equals(p.getUnitPrice()) || !StringUtils.isNotEmpty((String)p.getProductId()) || p.getUnitPrice().equals(BigDecimal.ZERO) || (productEntity = this.mallProductInterface.getProduct(p.getProductId())) == null || !StringUtils.isNotEmpty((String)productEntity.getBarCode())) continue;
                productMap = new LinkedHashMap();
                productMap.put("barCode", productEntity.getBarCode());
                productMap.put("quantity", p.getQuantity());
                if (Integer.valueOf(1).equals(productEntity.getTransportType())) {
                    cardTypeArr[0] = 4;
                    cardTypeArr[1] = 5;
                } else {
                    cardTypeArr[0] = 5;
                    cardTypeArr[1] = 4;
                }
                productList.add(productMap);
            }
        }
        this.logger.info("\u8ba2\u5355\u6362\u5976\u5361{},productList:{}", (Object)orderMainNo, (Object)JsonUtils.toJson(productList, (boolean)true));
        if (productList.size() == 0) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u53ef\u8865\u5dee\u4ef7\u7684\u5546\u54c1");
        }
        try {
            boolean findSuccess = false;
            BaseJsonVo<List<PrepayCardRecommendDetailEntity>> baseJsonVo = new BaseJsonVo<List<PrepayCardRecommendDetailEntity>>();
            List<PrepayCardBatchEntity> batchEntities = this.prepayCardBatchInterface.getPrepayCardBatchEntityList(recommend.getOrderAmount(), 3);
            this.logger.info("\u8ba2\u5355\u6362\u5976\u5361{},\u53d6\u51fa\u7b26\u5408\u7684\u5976\u5361:{}", (Object)orderMainNo, (Object)JsonUtils.toJson(batchEntities, (boolean)true));
            int i = this.insert(recommend);
            Integer[] integerArray = cardTypeArr;
            int n = integerArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    if (findSuccess) return BaseJsonVo.success((Object)"");
                    return baseJsonVo;
                }
                Integer cardType = integerArray[n2];
                this.logger.info("\u8ba2\u5355\u6362\u5976\u5361{},\u5904\u7406cardType\u5e38\u6e295\u51b7\u94fe4:{}", (Object)orderMainNo, (Object)cardType);
                baseJsonVo = this.prepayCardItemInterface.getConvertPrepayCards(recommend.getOrderAmount(), productList, batchEntities.stream().filter(c -> c.getCardType().equals(cardType)).collect(Collectors.toList()));
                this.logger.info("\u8ba2\u5355\u6362\u5976\u5361{},\u63a8\u8350\u7ed3\u679c:{},{}", new Object[]{orderMainNo, baseJsonVo.isSuccess(), baseJsonVo.getError()});
                if (baseJsonVo.isSuccess() && i == 1) {
                    for (PrepayCardRecommendDetailEntity p : (List)baseJsonVo.getValue()) {
                        p.setRecommendId(recommend.getId());
                        this.recommendDetailInterface.insert(p);
                        findSuccess = true;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            this.logger.error(e.getMessage());
            return BaseJsonVo.error((String)"\u63a8\u8350\u5f02\u5e38");
        }
    }

    @Override
    public PrepayCardRecommendEntity getEnableRecommendByOrderMainNo(String orderMainNo) {
        PrepayCardRecommendEntity search = new PrepayCardRecommendEntity();
        search.setOrderMainNo(orderMainNo);
        search.setSucc(0);
        return (PrepayCardRecommendEntity)this.getSingle(search, 0L);
    }

    @Override
    public boolean updateRecommendBatchIdByOrderMainNo(String orderMainNo, Integer batchId) {
        if (batchId == null) {
            return false;
        }
        PrepayCardRecommendEntity search = this.getEnableRecommendByOrderMainNo(orderMainNo);
        if (search == null) {
            return false;
        }
        search.setCardBatchId(batchId);
        this.updateByPrimaryKeySelective(search);
        return true;
    }

    @Override
    public boolean updateRecommendSuccessByOrderMainNo(String orderMainNo) {
        PrepayCardRecommendEntity c = this.getEnableRecommendByOrderMainNo(orderMainNo);
        if (c == null) {
            return false;
        }
        if (c.getCardBatchId() == null) {
            return false;
        }
        PrepayCardBatchEntity batchEntity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(c.getCardBatchId());
        if (batchEntity == null) {
            return false;
        }
        c.setSucc(1);
        c.setCardPromotionId(batchEntity.getCardPromotionId());
        this.updateByPrimaryKeySelective(c);
        return true;
    }

    @Override
    public PrepayCardRecommendDetailEntity getEnableRecommendDetail(String orderMainNo, Integer batchId) {
        PrepayCardRecommendEntity recommendEntity = this.getEnableRecommendByOrderMainNo(orderMainNo);
        if (recommendEntity == null) {
            return null;
        }
        if (batchId == null) {
            return null;
        }
        PrepayCardRecommendDetailEntity search = new PrepayCardRecommendDetailEntity();
        search.setRecommendId(recommendEntity.getId());
        search.setCardBatchId(batchId);
        return (PrepayCardRecommendDetailEntity)this.recommendDetailInterface.getSingle(search, 0L);
    }

    @Override
    public PrepayCardRecommendDetailEntity getRecommendDetail(String orderMainNo) {
        PrepayCardRecommendEntity recommendEntity = new PrepayCardRecommendEntity();
        recommendEntity.setOrderMainNo(orderMainNo);
        recommendEntity = (PrepayCardRecommendEntity)this.getSingle(recommendEntity, 0L);
        if (recommendEntity == null) {
            return null;
        }
        if (recommendEntity.getCardBatchId() == null) {
            return null;
        }
        PrepayCardRecommendDetailEntity search = new PrepayCardRecommendDetailEntity();
        search.setRecommendId(recommendEntity.getId());
        search.setCardBatchId(recommendEntity.getCardBatchId());
        return (PrepayCardRecommendDetailEntity)this.recommendDetailInterface.getSingle(search, 0L);
    }
}

