/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.prepay.PrepayCardDetailEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDo;
import cc.lechun.mall.entity.prepay.PrepayCardPlanStatusEnum;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

public class PrepayPlanBaseService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public LocalDate getNextDeliveryDate(LocalDate deliverDate, int periodType, Integer period, boolean isFirstTime) {
        this.logger.info("\u4e0a\u4e00\u6b21\u914d\u9001\u65e5\u671f{},\u914d\u9001\u7c7b\u578b:{},\u914d\u9001\u65f6\u95f4\u70b9:{}", new Object[]{deliverDate, periodType, period});
        if (periodType == 1) {
            if (isFirstTime) {
                if (deliverDate.getYear() > LocalDate.now().getYear()) {
                    if (period < deliverDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) {
                        return LocalDate.of(deliverDate.getYear(), deliverDate.getMonth(), (int)period);
                    }
                    return deliverDate.with(TemporalAdjusters.lastDayOfMonth());
                }
                if (period > LocalDate.now().getDayOfMonth() && LocalDate.now().getDayOfMonth() < deliverDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) {
                    if (period < deliverDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) {
                        return LocalDate.of(deliverDate.getYear(), deliverDate.getMonth(), (int)period);
                    }
                    return deliverDate.with(TemporalAdjusters.lastDayOfMonth());
                }
                LocalDate nextMonthDay = deliverDate.plusMonths(1L);
                if (period > nextMonthDay.getDayOfMonth()) {
                    if (period > nextMonthDay.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) {
                        return nextMonthDay.with(TemporalAdjusters.lastDayOfMonth());
                    }
                    return LocalDate.of(nextMonthDay.getYear(), deliverDate.getMonth(), (int)period);
                }
                return LocalDate.of(nextMonthDay.getYear(), nextMonthDay.getMonth(), (int)period);
            }
            LocalDate nextMonthDay = deliverDate.plusMonths(1L);
            if (period > nextMonthDay.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) {
                return nextMonthDay.with(TemporalAdjusters.lastDayOfMonth());
            }
            return LocalDate.of(nextMonthDay.getYear(), nextMonthDay.getMonth(), (int)period);
        }
        if (periodType == 2) {
            if (isFirstTime) {
                if (period <= deliverDate.getDayOfWeek().getValue()) {
                    return deliverDate.plusDays(7 - (deliverDate.getDayOfWeek().getValue() - period));
                }
                return deliverDate.plusDays(period - deliverDate.getDayOfWeek().getValue());
            }
            return deliverDate.plusDays(7L);
        }
        return null;
    }

    public Date LocalDateTodate(LocalDate localDate) {
        if (localDate != null) {
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
            Date date = Date.from(instant);
            return date;
        }
        return null;
    }

    public LocalDate getLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
        LocalDate localDate = localDateTime.toLocalDate();
        return localDate;
    }

    public List<PrepayCardDetailEntity> getPrepayCardDetailEntity(List<PrepayCardDetailEntity> list, PrepayCardDetailEntity prepayCardDetailEntity, int periodType, Integer period, Integer num) {
        if (list.size() >= num) {
            return list;
        }
        PrepayCardDetailEntity result = new PrepayCardDetailEntity();
        BeanUtils.copyProperties((Object)prepayCardDetailEntity, (Object)result);
        Date nextDeliverDate = this.LocalDateTodate(this.getNextDeliveryDate(this.getLocalDate(prepayCardDetailEntity.getPickTime()), periodType, period, false));
        this.logger.info("\u7b2c{}\u6b21\u914d\u9001\u65f6\u95f4:{}", (Object)list.size(), (Object)nextDeliverDate);
        result.setPickTime(nextDeliverDate);
        list.add(result);
        return this.getPrepayCardDetailEntity(list, result, periodType, period, num);
    }

    public Date getFirstDeliveryDate(PrepayCardDo prepayCardDo) {
        if (prepayCardDo.getMonth() == 0) {
            prepayCardDo.setPeriodType(1);
        } else if (prepayCardDo.getMonth() == -1) {
            prepayCardDo.setPeriodType(2);
        } else {
            prepayCardDo.setPeriodType(0);
        }
        if (prepayCardDo.getPeriodType() == 1 || prepayCardDo.getPeriodType() == 2) {
            this.logger.info("\u914d\u9001\u7c7b\u578b:{},\u914d\u9001\u65f6\u95f4\u70b9:{}", (Object)prepayCardDo.getPeriodType(), (Object)prepayCardDo.getPeriod());
            return this.getFirstDeliveryDate(prepayCardDo.getPeriodType(), prepayCardDo.getPeriod());
        }
        return this.getFirstDeliveryDate(prepayCardDo.getMonth(), prepayCardDo.getPeriod());
    }

    public Date getFirstDeliveryDate(int month, Integer period) {
        LocalDate localDate = LocalDate.of(LocalDate.now().getYear(), month, (int)period);
        if (LocalDate.now().getMonth().getValue() > month || LocalDate.now().getMonth().getValue() == month && LocalDate.now().getDayOfMonth() >= period) {
            localDate = localDate.plusYears(1L);
        }
        return this.LocalDateTodate(localDate);
    }

    public BaseJsonVo editePland(PrepayCardDo prepayCardDo, PrepayCardDetailEntity prepayCardDetailEntity, PrepayCardPlanDetailInterface prepayCardPlanDetailService) {
        this.logger.info("\u8ba1\u5212\u4fee\u6539\u53c2\u6570:{}", (Object)prepayCardDo.toString());
        prepayCardDetailEntity.setPickTime(this.getFirstDeliveryDate(prepayCardDo));
        prepayCardDetailEntity.setAddrId(prepayCardDo.getAddrId());
        PrepayCardDetailEntity update = new PrepayCardDetailEntity();
        update.setDetailedId(prepayCardDetailEntity.getDetailedId());
        update.setAddrId(prepayCardDo.getAddrId());
        update.setPickTime(prepayCardDetailEntity.getPickTime());
        if (prepayCardDetailEntity.getStatus().intValue() == PrepayCardPlanStatusEnum.SUSPEND.getValue()) {
            update.setStatus(PrepayCardPlanStatusEnum.DELIVERY.getValue());
        }
        prepayCardDetailEntity.setStatus(PrepayCardPlanStatusEnum.DELIVERY.getValue());
        BaseJsonVo x = prepayCardPlanDetailService.editPlanOrder(prepayCardDetailEntity);
        if (x.isSuccess()) {
            prepayCardPlanDetailService.updateByPrimaryKeySelective(update);
            this.logger.info("\u8ba1\u5212:{},\u4fee\u6539\u7ed3\u679c:{}", (Object)JsonUtils.toJson((Object)prepayCardDetailEntity, (boolean)false), (Object)JsonUtils.toJson((Object)x, (boolean)false));
            if (!x.isSuccess()) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return x;
            }
        }
        return BaseJsonVo.error((String)"\u8ba1\u7b97\u4fee\u6539\u5931\u8d25");
    }
}

