/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.reunion;

import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.reunion.ReunionCustomerLoveMapper;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.reunion.ReunionCustomerLoveEntity;
import cc.lechun.mall.entity.reunion.ReunionCustomerLoveHistoryEntity;
import cc.lechun.mall.entity.reunion.ReunionInfoVo;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.reunion.ReunionCustomerLoveHistoryInterface;
import cc.lechun.mall.iservice.reunion.ReunionCustomerLoveInterface;
import cc.lechun.mall.iservice.reunion.ReunionInterface;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReunionCustomerLoveService
extends BaseService<ReunionCustomerLoveEntity, String>
implements ReunionCustomerLoveInterface {
    @Resource
    private ReunionCustomerLoveMapper reunionCustomerLoveMapper;
    @Autowired
    private ReunionCustomerLoveHistoryInterface reunionCustomerLoveHistoryInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private ReunionInterface reunionInterface;
    @Autowired
    private ActiveInviteInterface activeInviteInterface;

    @Override
    public BaseJsonVo customerLove(String customerId) {
        ReunionCustomerLoveEntity reunionCustomerLoveEntity = (ReunionCustomerLoveEntity)this.reunionCustomerLoveMapper.selectByPrimaryKey((Serializable)((Object)customerId));
        if (reunionCustomerLoveEntity == null) {
            reunionCustomerLoveEntity = new ReunionCustomerLoveEntity();
            reunionCustomerLoveEntity.setCustomerId(customerId);
            reunionCustomerLoveEntity.setLoveRemain(BigDecimal.ZERO);
            reunionCustomerLoveEntity.setLoveShare(BigDecimal.ZERO);
            this.reunionCustomerLoveMapper.insert(reunionCustomerLoveEntity);
        }
        return BaseJsonVo.success((Object)reunionCustomerLoveEntity);
    }

    @Override
    public BigDecimal getCustomerLoveAmount(String customerId) {
        ReunionCustomerLoveEntity reunionCustomerLoveEntity = (ReunionCustomerLoveEntity)this.reunionCustomerLoveMapper.selectByPrimaryKey((Serializable)((Object)customerId));
        if (reunionCustomerLoveEntity == null) {
            return BigDecimal.ZERO;
        }
        return reunionCustomerLoveEntity.getLoveRemain().add(reunionCustomerLoveEntity.getLoveShare());
    }

    @Override
    public BaseJsonVo shareData(String customerId, String bindCode) {
        ReunionInfoVo reunionInfoVo = this.reunionInterface.getReunionInfoVo(bindCode);
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        Map<String, BigDecimal> loveCount = this.reunionCustomerLoveHistoryInterface.countShareLove(customerId, bindCode);
        rtnMap.put("shareCount", loveCount.get("shareCount"));
        rtnMap.put("shareLoveSum", loveCount.get("shareLoveSum") == null ? (Number)0 : (Number)loveCount.get("shareLoveSum"));
        rtnMap.put("maxInviteNum", reunionInfoVo.getInviteNum());
        rtnMap.put("midStr", loveCount.get("shareCount") + "/" + reunionInfoVo.getInviteNum());
        rtnMap.put("lovePrice", reunionInfoVo.getSharePrice());
        rtnMap.put("inviteList", this.activeInviteInterface.getInviteCustomerNickVoList(customerId, bindCode));
        rtnMap.put("inviteTitle", reunionInfoVo.getInviteTitle());
        rtnMap.put("inviteDesc", reunionInfoVo.getInviteDesc());
        rtnMap.put("exchangeScoreLevel", reunionInfoVo.getExchangeRewardInfoVo());
        return BaseJsonVo.success(rtnMap);
    }

    @Override
    public BaseJsonVo progressBarInfo(String bindCode) {
        DictionaryEntity share_price = this.dictionaryInterface.getDictionary(1000, 60, "PROGRESS_BAR_INFO");
        String json = share_price.getDictionaryName();
        HashMap hashMap = null;
        try {
            hashMap = (HashMap)JsonUtils.fromJson((String)json, HashMap.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)hashMap);
    }

    @Override
    @Transactional(propagation=Propagation.MANDATORY)
    public BaseJsonVo increaseByShare(String increaseCustomerId, String bindCode, Integer orderId, String invitedCustomerId) {
        ReunionInfoVo reunionInfoVo = this.reunionInterface.getReunionInfoVo(bindCode);
        this.logger.info("reeeeeeeeeee0-1,reunionInfoVo={}", (Object)JsonUtils.toJson((Object)reunionInfoVo, (boolean)false));
        ReunionCustomerLoveHistoryEntity queryHistory = new ReunionCustomerLoveHistoryEntity();
        queryHistory.setCustomerId(increaseCustomerId);
        queryHistory.setShareCustomerId(invitedCustomerId);
        queryHistory.setBindCode(bindCode);
        this.logger.info("reeeeeeeeeee0-2,queryHistory={}", (Object)JsonUtils.toJson((Object)queryHistory, (boolean)false));
        if (this.reunionCustomerLoveHistoryInterface.existsByEntity(queryHistory, 0L) < 1) {
            this.logger.info("reeeeeeeeeee0-3");
            ReunionCustomerLoveHistoryEntity history = new ReunionCustomerLoveHistoryEntity();
            history.setCustomerId(increaseCustomerId);
            history.setBindCode(bindCode);
            history.setHitstoryType(4);
            history.setOrderId(orderId);
            history.setShareCustomerId(invitedCustomerId);
            history.setCreateTime(DateUtils.now());
            history.setLovePrice(reunionInfoVo.getSharePrice());
            this.reunionCustomerLoveHistoryInterface.insert(history);
            this.logger.info("reeeeeeeeeee0-4");
        }
        this.customerLove(increaseCustomerId);
        this.logger.info("reeeeeeeeeee0-5");
        ReunionCustomerLoveEntity reunionCustomerLoveEntity = new ReunionCustomerLoveEntity();
        reunionCustomerLoveEntity.setCustomerId(increaseCustomerId);
        this.logger.info("reeeeeeeeeee0-6");
        if (this.reunionCustomerLoveMapper.existsByEntity(reunionCustomerLoveEntity) >= 1) {
            this.logger.info("reeeeeeeeeee0-7");
            reunionCustomerLoveEntity.setLoveShare(reunionInfoVo.getSharePrice());
            this.reunionCustomerLoveMapper.increaseShareLove(reunionCustomerLoveEntity);
        } else {
            this.logger.info("reeeeeeeeeee0-8");
            reunionCustomerLoveEntity.setLoveShare(reunionInfoVo.getSharePrice());
            reunionCustomerLoveEntity.setLoveRemain(new BigDecimal(0));
            this.reunionCustomerLoveMapper.insertOrUpdate(reunionCustomerLoveEntity);
        }
        return BaseJsonVo.success((Object)"\u8d26\u6237\u589e\u52a0\u6210\u529f");
    }

    @Override
    public BaseJsonVo tempIncreaseByShare(String increaseCustomerId, String bindCode, Integer orderId, String invitedCustomerId) {
        return this.increaseByShare(increaseCustomerId, bindCode, orderId, invitedCustomerId);
    }
}

