/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.reunion;

import cc.lechun.active.entity.active.ActiveInviteLogEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveInviteLogInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.reunion.ReunionOrderProductSwapMapper;
import cc.lechun.mall.entity.reunion.ReunionOrderEntity;
import cc.lechun.mall.entity.reunion.ReunionOrderProductSwapEntity;
import cc.lechun.mall.entity.reunion.ReunionProductEntity;
import cc.lechun.mall.entity.reunion.ReunionProductVO;
import cc.lechun.mall.entity.reunion.ReunionStockEntity;
import cc.lechun.mall.entity.reunion.SwapReunionProductTypeVO;
import cc.lechun.mall.entity.reunion.SwapReunionProductVO;
import cc.lechun.mall.iservice.reunion.ReunionInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderProductSwapInterface;
import cc.lechun.mall.iservice.reunion.ReunionProductInterface;
import cc.lechun.mall.iservice.reunion.ReunionStockInterface;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class ReunionOrderProductSwapService
extends BaseService<ReunionOrderProductSwapEntity, Integer>
implements ReunionOrderProductSwapInterface {
    @Resource
    private ReunionOrderProductSwapMapper reunionOrderProductSwapMapper;
    @Autowired
    private ReunionProductInterface reunionProductInterface;
    @Autowired
    private ReunionOrderInterface reunionOrderInterface;
    @Autowired
    private ReunionInterface reunionInterface;
    @Autowired
    private ReunionStockInterface reunionStockInterface;
    @Autowired
    private ActiveInviteLogInterface activeInviteLogInterface;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;

    @Override
    public List<ReunionOrderProductSwapEntity> getSwapProducts(String customerId, String bindCode) {
        List<ReunionOrderProductSwapEntity> list = this.reunionOrderProductSwapMapper.getSwapProducts(customerId, bindCode);
        return list;
    }

    @Override
    public List<Map<String, Integer>> getSwapProductsSimple(String customerId, String bindCode) {
        List<Map<String, Integer>> list = this.reunionOrderProductSwapMapper.getSwapProductsSimple(customerId, bindCode);
        return list;
    }

    @Override
    public List<Map<String, Integer>> getSwapPrizeProductsSimple(String customerId, String bindCode) {
        List<Map<String, Integer>> list = this.reunionOrderProductSwapMapper.getSwapPrizeProductsSimple(customerId, bindCode);
        return list;
    }

    @Override
    @Transactional
    public BaseJsonVo saveSwapList(String customerId, String bindCode, List<ReunionProductVO> products) {
        BaseJsonVo canJoin = this.reunionProductInterface.activeIsCanJoin(bindCode);
        if (!canJoin.isSuccess()) {
            return canJoin;
        }
        ReunionOrderEntity reunionOrder = this.reunionOrderInterface.getReunionOrder(bindCode, customerId);
        if (reunionOrder.getOrderStatus() == 3) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u8ba1\u5212\u5df2\u5173\u95ed\uff0c\u8bf7\u5230[\u4e2a\u4eba\u4e2d\u5fc3-\u5168\u90e8\u8ba1\u5212]\u9875\u9762\u91cd\u65b0\u5f00\u542f\uff01");
        }
        if (reunionOrder == null) {
            return BaseJsonVo.error((String)"\u8bf7\u5148\u9009\u62e9\u5151\u6362\u5730\u70b9");
        }
        int i = this.reunionOrderProductSwapMapper.deleteOrderSwapProduct(reunionOrder.getOrderId());
        BigDecimal[] swapAmount = new BigDecimal[]{BigDecimal.ZERO};
        StringBuilder errorMessage = new StringBuilder();
        products.forEach(product -> {
            if (product.getProductId() != null && product.getOrderCount() > 0) {
                ReunionProductEntity productDefine = (ReunionProductEntity)this.reunionProductInterface.selectByPrimaryKey(product.getProductId());
                if (productDefine.getMaxLimit() < product.getOrderCount()) {
                    errorMessage.append(product.getProductName()).append(product.getOrderCount()).append("\u4e2a\uff0c\u8d85\u8fc7\u9650\u5236").append(productDefine.getMaxLimit()).append("\u4e2a;");
                } else if (errorMessage.length() == 0) {
                    ReunionOrderProductSwapEntity entity = new ReunionOrderProductSwapEntity();
                    entity.setOrderId(reunionOrder.getOrderId());
                    entity.setSwapProductId(product.getProductId());
                    entity.setSwapProductQuantity(reunionOrder.getReunionSiteId() == 0 ? 0 : product.getOrderCount());
                    entity.setSwapProductUnitPrice(productDefine.getLovePrice());
                    entity.setSwapProductAmount(entity.getSwapProductUnitPrice().multiply(new BigDecimal(entity.getSwapProductQuantity().toString())));
                    this.reunionOrderProductSwapMapper.insert(entity);
                    swapAmount[0] = swapAmount[0].add(entity.getSwapProductAmount());
                }
            }
        });
        if (errorMessage.length() > 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)errorMessage.toString());
        }
        reunionOrder.setLoveSwapAmount(swapAmount[0]);
        reunionOrder.setUpdateTime(DateUtils.now());
        int result = this.reunionOrderInterface.updateByPrimaryKeySelective(reunionOrder);
        if (result == 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    @Transactional
    public BaseJsonVo saveSelectSwapList(String customerId, String bindCode, List<SwapReunionProductTypeVO> products) {
        ReunionOrderEntity reunionOrder = this.reunionOrderInterface.getReunionOrder(bindCode, customerId);
        if (reunionOrder.getOrderStatus() == 3) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u8ba1\u5212\u5df2\u5173\u95ed\uff0c\u8bf7\u5230[\u4e2a\u4eba\u4e2d\u5fc3-\u5168\u90e8\u8ba1\u5212]\u9875\u9762\u91cd\u65b0\u5f00\u542f\uff01");
        }
        if (reunionOrder == null) {
            return BaseJsonVo.error((String)"\u8bf7\u5148\u9009\u62e9\u5151\u6362\u5730\u70b9");
        }
        ActiveInviteLogEntity activeInviteLogEntity = new ActiveInviteLogEntity();
        activeInviteLogEntity.setBindCode(bindCode);
        activeInviteLogEntity.setInviteId("");
        activeInviteLogEntity.setCustomerId(customerId);
        activeInviteLogEntity.setCreateTime(DateUtils.now());
        activeInviteLogEntity.setFromStatus(reunionOrder.getOrderStatus());
        activeInviteLogEntity.setOrderMainNo(reunionOrder.getOrderId().toString());
        this.logger.info("\u7528\u6237{}\u4fdd\u5b58\u5151\u6362\u54c1:{}", (Object)customerId, (Object)products.toString());
        activeInviteLogEntity.setMessage("\u4fdd\u5b58\u5151\u6362\u54c1:");
        this.activeInviteLogInterface.saveInviteLog(activeInviteLogEntity);
        List<ReunionOrderProductSwapEntity> swapProducts = this.reunionOrderProductSwapMapper.getSwapProducts(customerId, bindCode);
        this.logger.info("[{}]\u8fd8\u5e93\u5b58:{}", (Object)reunionOrder.getOrderId(), (Object)JsonUtils.toJson(swapProducts, (boolean)false));
        for (ReunionOrderProductSwapEntity delSwap : swapProducts) {
            ReunionStockEntity reunionStockEntity = new ReunionStockEntity();
            reunionStockEntity.setBindCode(bindCode);
            ReunionProductEntity reunionProductEntity = (ReunionProductEntity)this.reunionProductInterface.selectByPrimaryKey(delSwap.getSwapProductId());
            reunionStockEntity.setProductId(reunionProductEntity.getProductId());
            reunionStockEntity.setRemain(delSwap.getSwapProductQuantity());
            int result = this.reunionStockInterface.retunrStock(reunionStockEntity);
            if (result != 0) continue;
            this.logger.error("\u4fdd\u5b58\u8ba1\u5212{}\u5931\u8d25\uff0c\u5151\u6362\u54c1{}\u8fd8\u5e93\u5b58\u65f6\u5931\u8d25", (Object)delSwap.getOrderId(), (Object)reunionProductEntity.getProductId());
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u8ba1\u5212\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        }
        int i = this.reunionOrderProductSwapMapper.deleteOrderSwapProduct(reunionOrder.getOrderId());
        BigDecimal[] swapAmount = new BigDecimal[]{BigDecimal.ZERO};
        StringBuilder errorMessage = new StringBuilder();
        boolean selectFlag = false;
        for (SwapReunionProductTypeVO product : products) {
            List<SwapReunionProductVO> resultProductList = product.getList();
            for (SwapReunionProductVO productItem : resultProductList) {
                if (productItem.getProductId() == null || productItem.getOrderCount() <= 0) continue;
                selectFlag = true;
                ReunionProductEntity productDefine = (ReunionProductEntity)this.reunionProductInterface.selectByPrimaryKey(productItem.getProductId());
                if (productDefine.getMaxLimit() < productItem.getOrderCount()) {
                    errorMessage.append(productItem.getProductName()).append(productItem.getOrderCount()).append("\u4e2a\uff0c\u8d85\u8fc7\u9650\u5236").append(productDefine.getMaxLimit()).append("\u4e2a;");
                    continue;
                }
                if (errorMessage.length() != 0) continue;
                ReunionOrderProductSwapEntity entity = new ReunionOrderProductSwapEntity();
                entity.setOrderId(reunionOrder.getOrderId());
                entity.setSwapProductId(productItem.getProductId());
                entity.setSwapProductQuantity(productItem.getOrderCount());
                entity.setSwapProductUnitPrice(productDefine.getLovePrice());
                entity.setSwapProductAmount(entity.getSwapProductUnitPrice().multiply(new BigDecimal(entity.getSwapProductQuantity().toString())));
                this.reunionOrderProductSwapMapper.insert(entity);
                swapAmount[0] = swapAmount[0].add(entity.getSwapProductAmount());
                ReunionStockEntity reunionStockEntity = new ReunionStockEntity();
                reunionStockEntity.setBindCode(bindCode);
                reunionStockEntity.setProductId(productDefine.getProductId());
                reunionStockEntity.setRemain(entity.getSwapProductQuantity());
                int result = this.reunionStockInterface.reduceStock(reunionStockEntity);
                if (result != 0) continue;
                this.logger.error("\u4fdd\u5b58\u8ba1\u5212{}\u5931\u8d25\uff0c\u5151\u6362\u54c1{}\u51cf\u5e93\u5b58\u65f6\u5931\u8d25", (Object)entity.getOrderId(), (Object)productDefine.getProductId());
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseJsonVo.error((String)"\u4fdd\u5b58\u8ba1\u5212\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            }
        }
        if (!selectFlag) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4ef6\u5151\u6362\u7279\u4ea7!");
        }
        if (errorMessage.length() > 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)errorMessage.toString());
        }
        reunionOrder.setLoveSwapAmount(swapAmount[0]);
        reunionOrder.setUpdateTime(DateUtils.now());
        reunionOrder.setOrderSubStatus(15);
        int result = this.reunionOrderInterface.updateByPrimaryKeySelective(reunionOrder);
        if (result == 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public Integer getOrderSwapCount(Integer orderId) {
        return this.reunionOrderProductSwapMapper.getOrderSwapCount(orderId);
    }

    @Override
    public List<Map<String, Object>> getOrderProductVO(Integer orderId) {
        return this.reunionOrderProductSwapMapper.getOrderProductVO(orderId);
    }

    @Override
    public int deleteOrderSwapProduct(Integer orderId) {
        return this.reunionOrderProductSwapMapper.deleteOrderSwapProduct(orderId);
    }

    @Override
    public int resetSwapProduct(Integer orderId) {
        ReunionOrderProductSwapEntity update = new ReunionOrderProductSwapEntity();
        update.setOrderId(orderId);
        update.setSwapProductAmount(BigDecimal.ZERO);
        update.setSwapProductQuantity(0);
        return this.reunionOrderProductSwapMapper.resetSwapProduct(update);
    }
}

