/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.reunion;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.MallSelectDataVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.reunion.ReunionProductMapper;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.reunion.ReunionOrderEntity;
import cc.lechun.mall.entity.reunion.ReunionOrderProductRecoveryEntity;
import cc.lechun.mall.entity.reunion.ReunionOrderProductSwapEntity;
import cc.lechun.mall.entity.reunion.ReunionProductEntity;
import cc.lechun.mall.entity.reunion.ReunionProductVO;
import cc.lechun.mall.entity.reunion.ReunionStatusInfoVo;
import cc.lechun.mall.entity.reunion.ReunionStockEntity;
import cc.lechun.mall.entity.reunion.SwapReunionProductTypeVO;
import cc.lechun.mall.entity.reunion.SwapReunionProductVO;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.reunion.ReunionInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderProductRecoveryInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderProductSwapInterface;
import cc.lechun.mall.iservice.reunion.ReunionProductInterface;
import cc.lechun.mall.iservice.reunion.ReunionStockInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReunionProductService
extends BaseService<ReunionProductEntity, Integer>
implements ReunionProductInterface {
    @Resource
    private ReunionProductMapper reunionProductMapper;
    @Autowired
    private ReunionInterface reunionInterface;
    @Autowired
    private MallProductPicInterface picService;
    @Autowired
    private ReunionOrderProductRecoveryInterface reunionOrderProductRecoveryInterface;
    @Autowired
    private ReunionOrderProductSwapInterface reunionOrderProductSwapInterface;
    @Autowired
    private RedisService redisService;
    @Autowired
    private ReunionStockInterface reunionStockInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;

    @Override
    public BaseJsonVo<List<ReunionProductVO>> recoveryList(String bindCode, String customerId) {
        List<ReunionProductVO> recoveries;
        this.redisService.delete("REUNION_PRODUCTS_R");
        if (this.redisService.get("REUNION_PRODUCTS_R") != null) {
            recoveries = (List<ReunionProductVO>)this.redisService.get("REUNION_PRODUCTS_R");
        } else {
            recoveries = this.reunionProductMapper.getReunionProductList(bindCode, 1);
            if (recoveries == null || recoveries.size() == 0) {
                return BaseJsonVo.error((String)"\u6d3b\u52a8\u5c1a\u672a\u914d\u7f6e\u56de\u6536\u54c1\u7c7b\uff0c\u8bf7\u7a0d\u540e\uff01");
            }
            this.redisService.save("REUNION_PRODUCTS_R", recoveries);
        }
        List<ReunionOrderProductRecoveryEntity> products = this.reunionOrderProductRecoveryInterface.getRecoveryProducts(customerId, bindCode);
        recoveries.forEach(recovery -> {
            Optional<ReunionOrderProductRecoveryEntity> any;
            if (StringUtils.isNotEmpty((String)recovery.getUnit())) {
                recovery.setDesc(recovery.getUnit());
            }
            Map<String, List<String>> productPicUrlMap = this.picService.getProductPicUrlMap(recovery.getProPicId(), SalesTypeEnum.SALES_PRODUCT.getValue());
            this.logger.info(JsonUtils.toJson(productPicUrlMap, (boolean)false));
            List<String> picProductSmall = productPicUrlMap.get("picProductSmall");
            if (picProductSmall != null && !picProductSmall.isEmpty()) {
                recovery.setProductPic(picProductSmall.get(0));
            }
            if ((any = products.stream().filter(product -> recovery.getProductId().equals(product.getRecoveryProductId())).findAny()).isPresent()) {
                recovery.setOrderCount(any.get().getRecoveryProductQuantity());
            } else {
                recovery.setOrderCount(0);
            }
        });
        return BaseJsonVo.success(recoveries);
    }

    @Override
    @NotNull
    public BaseJsonVo activeIsCanJoin(String bindCode) {
        ReunionStatusInfoVo reunionStatusInfoVo = this.reunionInterface.getReunionStatusInfoVo(bindCode);
        if (reunionStatusInfoVo == null) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u65f6\u95f4\u4e0d\u53ef\u521b\u5efa\u6216\u4fee\u6539\u8ba1\u5212");
        }
        if (!reunionStatusInfoVo.isCanEdit()) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u65f6\u95f4\u4e0d\u53ef\u4fee\u6539\u8ba1\u5212");
        }
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo checkCreatePlan(String bindCode) {
        ReunionStatusInfoVo reunionStatusInfoVo = this.reunionInterface.getReunionStatusInfoVo(bindCode);
        if (reunionStatusInfoVo == null) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u65f6\u95f4\u4e0d\u53ef\u521b\u5efa\u8ba1\u5212");
        }
        if (!reunionStatusInfoVo.isCanReserve()) {
            return BaseJsonVo.error((String)"\u6d3b\u52a8\u9884\u7ea6\u671f\u5df2\u8fc7\uff0c\u4e0d\u80fd\u521b\u5efa\u8ba1\u5212\uff01");
        }
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo checkEditPlan(String bindCode) {
        ReunionStatusInfoVo reunionStatusInfoVo = this.reunionInterface.getReunionStatusInfoVo(bindCode);
        if (reunionStatusInfoVo == null) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u65f6\u95f4\u4e0d\u53ef\u521b\u5efa\u6216\u4fee\u6539\u8ba1\u5212");
        }
        if (!reunionStatusInfoVo.isCanEdit()) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u65f6\u95f4\u4e0d\u53ef\u4ee5\u4fee\u6539\u8ba1\u5212");
        }
        return BaseJsonVo.success(null);
    }

    @Override
    public List<ReunionProductVO> swapList(String bindCode, String customerId, ReunionOrderEntity reunionOrderEntity) {
        List<Object> swaps = new ArrayList();
        if (this.redisService.get("REUNION_PRODUCTS_S") != null) {
            swaps = (List)this.redisService.get("REUNION_PRODUCTS_S");
        } else {
            swaps = this.reunionProductMapper.getReunionProductList(bindCode, 2);
            if (swaps == null || swaps.size() == 0) {
                return Collections.emptyList();
            }
            this.redisService.save("REUNION_PRODUCTS_S", swaps);
        }
        ReunionStockEntity reunionStockEntity = new ReunionStockEntity();
        reunionOrderEntity.setBindCode(bindCode);
        List stockEntityList = this.reunionStockInterface.getList(reunionStockEntity, 0L);
        if (stockEntityList == null || stockEntityList.size() == 0) {
            this.logger.info("\u6d3b\u52a8{}\u672a\u914d\u7f6e\u5151\u6362\u5546\u54c1\u5e93\u5b58", (Object)reunionOrderEntity.getBindCode());
            return Collections.emptyList();
        }
        ArrayList<ReunionProductVO> result = new ArrayList<ReunionProductVO>();
        List<ReunionOrderProductSwapEntity> products = this.reunionOrderProductSwapInterface.getSwapProducts(customerId, bindCode);
        swaps.forEach(swap -> {
            Optional<ReunionOrderProductSwapEntity> any;
            List tempList = stockEntityList.stream().filter(item -> swap.getSwapProductId().equals(item.getProductId()) && item.getRemain() > 0).collect(Collectors.toList());
            if (tempList == null || tempList.size() == 0) {
                return;
            }
            if (((ReunionStockEntity)tempList.get(0)).getRemain() < 100 || swap.getMaxLimit() < 100) {
                int max = swap.getMaxLimit();
                if (((ReunionStockEntity)tempList.get(0)).getRemain() <= swap.getMaxLimit()) {
                    max = ((ReunionStockEntity)tempList.get(0)).getRemain();
                }
                swap.setDesc("\u9650\u5151" + max + swap.getUnit());
            } else {
                swap.setDesc(swap.getUnit());
            }
            Map<String, List<String>> productPicUrlMap = this.picService.getProductPicUrlMap(swap.getProPicId(), SalesTypeEnum.SALES_PRODUCT.getValue());
            this.logger.info(JsonUtils.toJson(productPicUrlMap, (boolean)false));
            List<String> picProductSmall = productPicUrlMap.get("picProductSmall");
            if (picProductSmall != null && !picProductSmall.isEmpty()) {
                swap.setProductPic(picProductSmall.get(0));
            }
            if ((any = products.stream().filter(product -> swap.getProductId().equals(product.getSwapProductId())).findAny()).isPresent()) {
                swap.setOrderCount(any.get().getSwapProductQuantity());
            } else {
                swap.setOrderCount(0);
            }
            result.add((ReunionProductVO)swap);
        });
        return result;
    }

    @Override
    public List<SwapReunionProductTypeVO> getSwapList(String bindCode, String customerId, ReunionOrderEntity reunionOrderEntity) {
        List<Object> swaps = new ArrayList();
        this.redisService.delete("REUNION_PRODUCTS_S");
        if (this.redisService.get("REUNION_PRODUCTS_S") != null) {
            swaps = (List)this.redisService.get("REUNION_PRODUCTS_S");
        } else {
            swaps = this.reunionProductMapper.getSwapReunionProductList(bindCode, 2);
            this.logger.info("\u67e5\u770b\u5151\u6362\u54c1\u7ed3\u679cinner\uff0clist={}", (Object)JsonUtils.toJson(swaps, (boolean)false));
            if (swaps == null || swaps.size() == 0) {
                return Collections.emptyList();
            }
            this.redisService.save("REUNION_PRODUCTS_S", swaps);
        }
        DictionaryEntity queryDic = new DictionaryEntity();
        queryDic.setDictionaryTypeId(60);
        queryDic.setDictionaryKey("3");
        DictionaryEntity dictionaryEntity = this.dictionaryInterface.getDictionary(1000, 60, "3");
        if (dictionaryEntity == null && StringUtils.isEmpty((String)dictionaryEntity.getDictionaryName())) {
            this.logger.error("\u5151\u6362\u5546\u54c1\u54c1\u7c7b\u914d\u7f6e\u9519\u8bef");
            return Collections.emptyList();
        }
        List<ReunionStockEntity> stockEntityList = this.reunionStockInterface.getStocksByBindCode(bindCode);
        this.logger.info("\u56de\u6536\u6d3b\u52a8\u5151\u6362\u54c1BUG-0:stockEntityList:{}", (Object)JsonUtils.toJson(stockEntityList, (boolean)false));
        if (stockEntityList == null || stockEntityList.size() == 0) {
            this.logger.info("\u6d3b\u52a8{}\u672a\u914d\u7f6e\u5151\u6362\u5546\u54c1\u5e93\u5b58", (Object)reunionOrderEntity.getBindCode());
            return Collections.emptyList();
        }
        ArrayList<SwapReunionProductTypeVO> resultList = new ArrayList<SwapReunionProductTypeVO>();
        List<ReunionOrderProductSwapEntity> products = this.reunionOrderProductSwapInterface.getSwapProducts(customerId, bindCode);
        List productTypeList = JsonUtils.getListByArray(MallSelectDataVo.class, (String)dictionaryEntity.getDictionaryName());
        for (MallSelectDataVo itemType : productTypeList) {
            SwapReunionProductTypeVO mapItem = new SwapReunionProductTypeVO();
            mapItem.setProductTypeName(itemType.getName());
            mapItem.setSwapProductType(Integer.valueOf(itemType.getId()));
            ArrayList<SwapReunionProductVO> result = new ArrayList<SwapReunionProductVO>();
            this.logger.info("\u56de\u6536\u6d3b\u52a8\u5151\u6362\u54c1BUG-1:swaps:{}", (Object)JsonUtils.toJson(swaps, (boolean)false));
            swaps.stream().filter(swap -> String.valueOf(swap.getSwapProductType()).equals(itemType.getId())).forEach(swap -> {
                Optional<ReunionOrderProductSwapEntity> any;
                this.logger.info("\u56de\u6536\u6d3b\u52a8\u5151\u6362\u54c1BUG-2:\u5f53\u524dswap:{}", (Object)JsonUtils.toJson((Object)swap, (boolean)false));
                swap.setProductTypeName(itemType.getName());
                List tempList = stockEntityList.stream().filter(item -> swap.getSwapProductId().equals(item.getProductId()) && item.getRemain() > 0).collect(Collectors.toList());
                if (tempList == null || tempList.size() == 0) {
                    return;
                }
                this.logger.info("\u56de\u6536\u6d3b\u52a8\u5151\u6362\u54c1BUG-2-2");
                if (((ReunionStockEntity)tempList.get(0)).getRemain() < 100 || swap.getMaxLimit() < 100) {
                    int max = swap.getMaxLimit();
                    if (((ReunionStockEntity)tempList.get(0)).getRemain() <= swap.getMaxLimit()) {
                        max = ((ReunionStockEntity)tempList.get(0)).getRemain();
                    }
                    swap.setDesc("\u9650\u5151" + max + swap.getUnit());
                    swap.setMaxLimit(max);
                } else {
                    swap.setDesc(swap.getUnit());
                }
                Map<String, List<String>> productPicUrlMap = this.picService.getProductPicUrlMap(swap.getProPicId(), SalesTypeEnum.SALES_PRODUCT.getValue());
                this.logger.info(JsonUtils.toJson(productPicUrlMap, (boolean)false));
                List<String> picProductSmall = productPicUrlMap.get("picProductHead");
                if (picProductSmall != null && !picProductSmall.isEmpty()) {
                    swap.setProductPic(picProductSmall.get(0));
                }
                if ((any = products.stream().filter(product -> swap.getProductId().equals(product.getSwapProductId())).findAny()).isPresent()) {
                    swap.setOrderCount(any.get().getSwapProductQuantity());
                } else {
                    swap.setOrderCount(0);
                }
                this.logger.info("\u56de\u6536\u6d3b\u52a8\u5151\u6362\u54c1BUG-3:\u8fd9\u4e2aswap\u653e\u5230list\u4e86:{}", (Object)JsonUtils.toJson((Object)swap, (boolean)false));
                result.add((SwapReunionProductVO)swap);
            });
            mapItem.setList(result);
            resultList.add(mapItem);
        }
        return resultList;
    }

    @Override
    public List<ReunionProductVO> getOrderProductVO(Integer orderId) {
        return this.reunionProductMapper.getOrderProductVO(orderId);
    }
}

