/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.reunion;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.entity.invite.ActiveInviteDetailEntity;
import cc.lechun.active.iservice.active.ActiveCommonInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.reunion.ReunionOrderMapper;
import cc.lechun.mall.entity.customer.CustomerAddressEntity;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.reunion.ExchangeRewardInfoVo;
import cc.lechun.mall.entity.reunion.ReunionActiveStatusEnum;
import cc.lechun.mall.entity.reunion.ReunionIndexVo;
import cc.lechun.mall.entity.reunion.ReunionInfoVo;
import cc.lechun.mall.entity.reunion.ReunionOrderEntity;
import cc.lechun.mall.entity.reunion.ReunionStatusInfoVo;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.reunion.ReunionCustomerLoveInterface;
import cc.lechun.mall.iservice.reunion.ReunionInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReunionService
implements ReunionInterface {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private ActivePropertyInterface activePropertyInterface;
    @Autowired
    private MallProductPicInterface picInterface;
    @Autowired
    ActiveCommonInterface activeCommonInterface;
    @Autowired
    private TemplateMessageInterface templateMessageInterface;
    @Autowired
    private MessageInterface messageService;
    @Autowired
    CustomerInterface customerInterface;
    @Resource
    private ReunionOrderMapper reunionOrderMapper;
    @Autowired
    CustomerAddressInterface customerAddressInterface;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendSureMessage(final String bindCode, final Map<String, String> variableMap, final String customerId) {
        ExecutorService pool = Executors.newFixedThreadPool(1);
        try {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    ActiveEntity activeEntity = ReunionService.this.activeInterface.getActiveEntityByQrcode(bindCode);
                    if (activeEntity == null) {
                        return;
                    }
                    variableMap.put("activeName", activeEntity.getActiveName());
                    ReunionService.this.messageService.sendWechatMessage("reserve_succ", customerId, variableMap);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
        finally {
            pool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendInviteMessage(final Map<String, String> variableMap, final String customerId) {
        ExecutorService pool = Executors.newFixedThreadPool(1);
        try {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    ReunionService.this.messageService.sendWechatMessage("recover_invite_message", customerId, variableMap);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
        finally {
            pool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendInviteMessage(final Map<String, String> variableMap, String customerId, final String bindCode, final String inviteId, final Integer platformId, final ActiveInviteInterface activeInviteInterface, final ReunionCustomerLoveInterface reunionCustomerLoveInterface) {
        ExecutorService pool = Executors.newFixedThreadPool(1);
        try {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    ReunionService.this.setShareInviteSuccess(inviteId, bindCode, platformId, activeInviteInterface, reunionCustomerLoveInterface);
                    ReunionService.this.messageService.sendWechatMessage("recover_invite_message", inviteId, variableMap);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
        finally {
            pool.shutdown();
        }
    }

    private void setShareInviteSuccess(String inviteId, String bindCode, Integer platformId, ActiveInviteInterface activeInviteInterface, ReunionCustomerLoveInterface reunionCustomerLoveInterface) {
        List<ActiveInviteDetailEntity> queryList = activeInviteInterface.getInviteDetailList(inviteId, bindCode);
        if (queryList != null || queryList.size() > 0) {
            List list = queryList.stream().filter(item -> item.getStatus() == 1).collect(Collectors.toList());
            if (list.size() > 0) {
                this.logger.info("\u7528\u6237{}\u5df2\u7ecf\u63a5\u53d7\u8fc7\u7528\u6237:{}\u9080\u8bf7\uff0c\u4e14\u4e3a\u6709\u6548\u9080\u8bf7", (Object)((ActiveInviteDetailEntity)list.get(0)).getAcceptCustomerId(), (Object)((ActiveInviteDetailEntity)list.get(0)).getCustomerId());
            } else {
                ActiveInviteDetailEntity activeInviteDetailEntity = queryList.get(queryList.size() - 1);
                ReunionOrderEntity param = new ReunionOrderEntity();
                param.setBindCode(bindCode);
                param.setCustomerId(activeInviteDetailEntity.getCustomerId());
                List tempOrderList = this.reunionOrderMapper.getList(param);
                if (tempOrderList != null && tempOrderList.size() > 0) {
                    ReunionOrderEntity reunionOrderEntity = (ReunionOrderEntity)tempOrderList.get(0);
                    if (reunionOrderEntity.getReunionSiteId() == 0 && reunionOrderEntity.getOrderStatus() == 0) {
                        CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetail(activeInviteDetailEntity.getAcceptCustomerId(), platformId);
                        BaseJsonVo inviteRst = activeInviteInterface.setActiveInviteSuccess(activeInviteDetailEntity.getCustomerId(), bindCode, customerDetailVo);
                        if (inviteRst.isSuccess()) {
                            BaseJsonVo increaseRst = reunionCustomerLoveInterface.increaseByShare(reunionOrderEntity.getCustomerId(), bindCode, reunionOrderEntity.getOrderId(), activeInviteDetailEntity.getAcceptCustomerId());
                            if (!increaseRst.isSuccess()) {
                                return;
                            }
                            this.setShareInviteSuccess(activeInviteDetailEntity.getCustomerId(), bindCode, platformId, activeInviteInterface, reunionCustomerLoveInterface);
                        }
                    } else {
                        this.logger.info("\u4e0d\u7b26\u5408\u6761\u4ef6 \u8ba2\u5355:{},\u8ba2\u5355\u72b6\u6001:{},\u5730\u5740\u7c7b\u578b:{}", new Object[]{reunionOrderEntity.getOrderId(), reunionOrderEntity.getOrderStatus(), reunionOrderEntity.getAdressType()});
                    }
                } else {
                    this.logger.info("\u7528\u6237:{},\u8ba2\u5355\u4e0d\u5b58\u5728", (Object)activeInviteDetailEntity.getAcceptCustomerId());
                    CustomerDetailVo customerDetailVo = this.customerInterface.getCustomerDetail(activeInviteDetailEntity.getAcceptCustomerId(), platformId);
                    BaseJsonVo inviteRst = activeInviteInterface.setActiveInviteSuccess(activeInviteDetailEntity.getCustomerId(), bindCode, customerDetailVo);
                    if (inviteRst.isSuccess()) {
                        BaseJsonVo increaseRst = reunionCustomerLoveInterface.tempIncreaseByShare(activeInviteDetailEntity.getCustomerId(), bindCode, null, activeInviteDetailEntity.getAcceptCustomerId());
                        if (!increaseRst.isSuccess()) {
                            return;
                        }
                        this.setShareInviteSuccess(activeInviteDetailEntity.getCustomerId(), bindCode, platformId, activeInviteInterface, reunionCustomerLoveInterface);
                    }
                }
            }
        }
    }

    @Override
    @ReadThroughSingleCache(namespace="ReunionService.getReunionInfoVoList", expiration=300)
    public List<ReunionInfoVo> getReunionInfoVoList(@ParameterValueKeyProvider Integer platformGroupId) {
        List<ActiveEntity> activeList = this.activeInterface.getActiveList4ActiveType(platformGroupId, 30);
        ArrayList<ReunionInfoVo> result = new ArrayList<ReunionInfoVo>();
        if (activeList != null && activeList.size() > 0) {
            for (ActiveEntity activeEntity : activeList) {
                result.add(this.getReunionInfoVo(activeEntity.getBindCode()));
            }
            return result;
        }
        return new ArrayList<ReunionInfoVo>();
    }

    @Override
    @ReadThroughSingleCache(namespace="ReunionService.getReunionInfoVoList", expiration=60)
    public List<ReunionInfoVo> getEnableReunionInfoVoList(@ParameterValueKeyProvider Integer platformGroupId) {
        List<ReunionInfoVo> reunionInfoVoList = this.getReunionInfoVoList(platformGroupId);
        if (reunionInfoVoList != null && reunionInfoVoList.size() > 0) {
            return reunionInfoVoList.stream().filter(reunionInfoVo -> reunionInfoVo.getReunionStatusInfoVo().getStatus() > 0).collect(Collectors.toList());
        }
        return reunionInfoVoList;
    }

    @Override
    @ReadThroughSingleCache(namespace="ReunionService.getReunionIndexVo", expiration=300)
    public ReunionIndexVo getReunionIndexVo(@ParameterValueKeyProvider(order=0) String bindCode, @ParameterValueKeyProvider(order=1) Integer platformId) {
        ReunionIndexVo reunionIndexVo = new ReunionIndexVo();
        reunionIndexVo.setReunionInfoVo(this.getReunionInfoVo(bindCode));
        int status = reunionIndexVo.getReunionInfoVo().getReunionStatusInfoVo().getStatus();
        int sence = 4;
        if (status > 0) {
            sence = status + 3;
        } else {
            this.logger.info("\u6d3b\u52a8bindCode{},\u4e0d\u5728\u6709\u6548\u671f\u5185", (Object)bindCode);
        }
        reunionIndexVo.setTemplateMessageList(this.templateMessageInterface.getTempMessageListBySence(sence, platformId));
        return reunionIndexVo;
    }

    @Override
    @ReadThroughSingleCache(namespace="ReunionService.getReunionInfoVo", expiration=300)
    public ReunionInfoVo getReunionInfoVo(@ParameterValueKeyProvider String bindCode) {
        List<ActivePropertyEntity> reunionPropertyList = this.activePropertyInterface.getActivePropertyList(bindCode);
        if (reunionPropertyList.size() == 0) {
            this.logger.error("\u6d3b\u52a8bindCode={}\u5c5e\u6027\u672a\u914d\u7f6e:\u8bf7\u68c0\u67e5", (Object)bindCode);
            throw new RuntimeException("\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            this.logger.error("bindCode:{}\u53c2\u6570\u6709\u8bef", (Object)bindCode);
            throw new RuntimeException("\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        ReunionInfoVo reunionInfoVo = new ReunionInfoVo();
        reunionInfoVo.setBindCode(bindCode);
        reunionInfoVo.setInviteNum(activeEntity.getInviteNum());
        reunionInfoVo.setPiclist(this.activeCommonInterface.getActivePicListByBindCode(bindCode));
        Optional<ActivePropertyEntity> activeTitleOption = reunionPropertyList.stream().filter(activePropertyEntity -> "activeTitle".equals(activePropertyEntity.getPropertyName())).findFirst();
        reunionInfoVo.setActiveTitle(activeTitleOption.isPresent() ? activeTitleOption.get().getPropertyValue() : "");
        this.setRecoertyProperty(reunionPropertyList, reunionInfoVo);
        this.setExchangeProperty(reunionPropertyList, reunionInfoVo);
        this.setInviteProperty(reunionPropertyList, reunionInfoVo);
        this.setPeriodProperty(reunionPropertyList, reunionInfoVo);
        this.setSiteNameProperty(reunionPropertyList, reunionInfoVo);
        this.setInviteScoreProperty(reunionPropertyList, reunionInfoVo);
        ExchangeRewardInfoVo exchangeRewardInfoVo = new ExchangeRewardInfoVo();
        exchangeRewardInfoVo.setMax(reunionInfoVo.getInviteNum());
        this.setExchangeScoreListProperty(reunionPropertyList, reunionInfoVo, exchangeRewardInfoVo);
        this.setActiveNotice(reunionPropertyList, reunionInfoVo);
        ReunionStatusInfoVo reunionStatusInfoVo = this.getReunionStatusInfoVo(reunionPropertyList, reunionInfoVo);
        reunionInfoVo.setReunionStatusInfoVo(reunionStatusInfoVo);
        return reunionInfoVo;
    }

    @Override
    @ReadThroughSingleCache(namespace="ReunionService.getReunionStatusInfoVo", expiration=300)
    public ReunionStatusInfoVo getReunionStatusInfoVo(@ParameterValueKeyProvider String bindCode) {
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        if (activeEntity == null) {
            this.logger.info("bindCode:{}\u53c2\u6570\u6709\u8bef", (Object)bindCode);
            throw new RuntimeException("\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        List<ActivePropertyEntity> reunionPropertyList = this.activePropertyInterface.getActivePropertyList(bindCode);
        if (reunionPropertyList.size() == 0) {
            this.logger.info("\u6d3b\u52a8bindCode={},\u5c5e\u6027\u672a\u914d\u7f6e:\u8bf7\u68c0\u67e5", (Object)bindCode);
            throw new RuntimeException("\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        BaseJsonVo baseJsonVo = this.activeInterface.checkActiveEnable(activeEntity);
        ReunionStatusInfoVo reunionStatusInfoVo = this.getReunionStatusInfoVo(reunionPropertyList, new ReunionInfoVo());
        if (!baseJsonVo.isSuccess()) {
            this.logger.info("\u6d3b\u52a8{},\u6d88\u606f:{} ", (Object)activeEntity.getActiveName(), (Object)baseJsonVo.getMessage());
            reunionStatusInfoVo.setCanSubscribe(false);
            reunionStatusInfoVo.setCanShare(false);
            reunionStatusInfoVo.setCanReserve(false);
            reunionStatusInfoVo.setCanExchange(false);
            reunionStatusInfoVo.setCanEdit(false);
        }
        return reunionStatusInfoVo;
    }

    @Override
    public BaseJsonVo getDateAndFee(String addrId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CustomerAddressEntity customerAddress = this.customerAddressInterface.getCustomerAddress(addrId);
        Map<String, List<String>> arriveTimes = this.getSFarriveTime();
        Object dcID = null;
        BigDecimal freight = BigDecimal.TEN;
        map.put("arriveTimes", arriveTimes);
        map.put("freight", freight);
        return BaseJsonVo.success(map);
    }

    @Override
    public Map<String, List<String>> getSFarriveTime() {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        SimpleDateFormat sdf = new SimpleDateFormat("HH");
        ArrayList<String> today = new ArrayList<String>();
        ArrayList<String> tomorrow = new ArrayList<String>();
        ArrayList<String> thedayaftertomorrow = new ArrayList<String>();
        Integer hour = Integer.valueOf(sdf.format(DateUtils.now()));
        if (hour > 8 && hour < 22) {
            today.add("\u4e00\u5c0f\u65f6\u4ee5\u5185");
        }
        for (int i = 8; i < 21; ++i) {
            String s = (i < 10 ? "0" + i : Integer.valueOf(i)) + ":00-" + (i + 1 < 10 ? "0" + (i + 1) : Integer.valueOf(i + 1)) + ":00";
            if (hour < i) {
                today.add(s);
            }
            tomorrow.add(s);
            thedayaftertomorrow.add(s);
        }
        if (today.size() > 0) {
            map.put("\u4eca\u5929", today);
        }
        map.put("\u660e\u5929", tomorrow);
        map.put("\u540e\u5929", thedayaftertomorrow);
        return map;
    }

    @NotNull
    private ReunionStatusInfoVo getReunionStatusInfoVo(List<ActivePropertyEntity> reunionPropertyList, ReunionInfoVo reunionInfoVo) {
        this.getSubsubscribeDate(reunionPropertyList, reunionInfoVo);
        this.getPlanDateProperty(reunionPropertyList, reunionInfoVo);
        this.getExchangeDateProperty(reunionPropertyList, reunionInfoVo);
        ReunionStatusInfoVo reunionStatusInfoVo = new ReunionStatusInfoVo();
        reunionStatusInfoVo.setCanSubscribe(reunionInfoVo.getSubscribeStartTime() != null && reunionInfoVo.getSubscribeEndTime() != null && DateUtils.now().after(reunionInfoVo.getSubscribeStartTime()) && DateUtils.now().before(reunionInfoVo.getSubscribeEndTime()));
        reunionStatusInfoVo.setCanReserve(reunionInfoVo.getPlanStartTime() != null && reunionInfoVo.getPlanEndTime() != null && DateUtils.now().after(reunionInfoVo.getPlanStartTime()) && DateUtils.now().before(reunionInfoVo.getPlanEndTime()));
        reunionStatusInfoVo.setCanEdit(reunionStatusInfoVo.isCanReserve());
        reunionStatusInfoVo.setCanShare(reunionStatusInfoVo.isCanSubscribe() || reunionStatusInfoVo.isCanReserve());
        reunionStatusInfoVo.setCanExchange(reunionInfoVo.getExchangeStartTime() != null && reunionInfoVo.getExchangeEndTime() != null && DateUtils.now().after(reunionInfoVo.getExchangeStartTime()) && DateUtils.now().before(reunionInfoVo.getExchangeEndTime()));
        if (reunionStatusInfoVo.isCanSubscribe()) {
            reunionStatusInfoVo.setStatus(ReunionActiveStatusEnum.subscribe.getValue());
            reunionStatusInfoVo.setStatusName(ReunionActiveStatusEnum.subscribe.getName());
        } else if (reunionStatusInfoVo.isCanReserve()) {
            reunionStatusInfoVo.setStatus(ReunionActiveStatusEnum.resver.getValue());
            reunionStatusInfoVo.setStatusName(ReunionActiveStatusEnum.resver.getName());
        } else if (reunionStatusInfoVo.isCanExchange()) {
            reunionStatusInfoVo.setStatus(ReunionActiveStatusEnum.exchange.getValue());
            reunionStatusInfoVo.setStatusName(ReunionActiveStatusEnum.exchange.getName());
        }
        return reunionStatusInfoVo;
    }

    private void setActiveNotice(List<ActivePropertyEntity> reunionPropertyList, ReunionInfoVo reunionInfoVo) {
        Optional<ActivePropertyEntity> inviteScoreScoreOption = reunionPropertyList.stream().filter(activePropertyEntity -> "activeNotice".equals(activePropertyEntity.getPropertyName())).findFirst();
        if (inviteScoreScoreOption.isPresent()) {
            reunionInfoVo.setActiveNotice(inviteScoreScoreOption.get().getPropertyValue());
        }
    }

    private void setInviteScoreProperty(List<ActivePropertyEntity> reunionPropertyList, ReunionInfoVo reunionInfoVo) {
        Optional<ActivePropertyEntity> inviteScoreScoreOption = reunionPropertyList.stream().filter(activePropertyEntity -> "sharePrice".equals(activePropertyEntity.getPropertyName())).findFirst();
        if (inviteScoreScoreOption.isPresent()) {
            reunionInfoVo.setSharePrice(new BigDecimal(inviteScoreScoreOption.get().getPropertyValue()));
        }
    }

    private void setExchangeScoreListProperty(List<ActivePropertyEntity> reunionPropertyList, ReunionInfoVo reunionInfoVo, ExchangeRewardInfoVo exchangeRewardInfoVo) {
        Optional<ActivePropertyEntity> exchangeScoreOption = reunionPropertyList.stream().filter(activePropertyEntity -> "exchangeScoreDesc".equals(activePropertyEntity.getPropertyName())).findFirst();
        if (exchangeScoreOption.isPresent()) {
            try {
                this.logger.info("list:{}", (Object)exchangeScoreOption.get().getPropertyValue());
                exchangeRewardInfoVo.setList(exchangeScoreOption.get().getPropertyValue());
                reunionInfoVo.setExchangeRewardInfoVo(exchangeRewardInfoVo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setSiteNameProperty(List<ActivePropertyEntity> reunionPropertyList, ReunionInfoVo reunionInfoVo) {
        Optional<ActivePropertyEntity> siteNameOption = reunionPropertyList.stream().filter(activePropertyEntity -> "siteName".equals(activePropertyEntity.getPropertyName())).findFirst();
        if (siteNameOption.isPresent()) {
            reunionInfoVo.setSiteName(siteNameOption.get().getPropertyValue());
        }
    }

    private void setPeriodProperty(List<ActivePropertyEntity> reunionPropertyList, ReunionInfoVo reunionInfoVo) {
        Optional<ActivePropertyEntity> periodOption = reunionPropertyList.stream().filter(activePropertyEntity -> "period".equals(activePropertyEntity.getPropertyName())).findFirst();
        if (periodOption.isPresent()) {
            reunionInfoVo.setActivePeriodName(periodOption.get().getPropertyRemark());
            reunionInfoVo.setPeriod(periodOption.get().getPropertyValue());
        }
    }

    private void setInviteProperty(List<ActivePropertyEntity> reunionPropertyList, ReunionInfoVo reunionInfoVo) {
        Optional<ActivePropertyEntity> inviteOption = reunionPropertyList.stream().filter(activePropertyEntity -> "inviteDesc".equals(activePropertyEntity.getPropertyName())).findFirst();
        if (inviteOption.isPresent()) {
            reunionInfoVo.setInviteDesc(inviteOption.get().getPropertyRemark());
            reunionInfoVo.setInviteTitle(inviteOption.get().getPropertyValue());
        }
    }

    private void setExchangeProperty(List<ActivePropertyEntity> reunionPropertyList, ReunionInfoVo reunionInfoVo) {
        Optional<ActivePropertyEntity> exchangeOption = reunionPropertyList.stream().filter(activePropertyEntity -> "exchangeDesc".equals(activePropertyEntity.getPropertyName())).findFirst();
        if (exchangeOption.isPresent()) {
            reunionInfoVo.setExchangeDesc(exchangeOption.get().getPropertyRemark());
            reunionInfoVo.setExchangeTitle(exchangeOption.get().getPropertyValue());
        }
    }

    private void setRecoertyProperty(List<ActivePropertyEntity> reunionPropertyList, ReunionInfoVo reunionInfoVo) {
        Optional<ActivePropertyEntity> recoveryDescOption = reunionPropertyList.stream().filter(activePropertyEntity -> "recoveryDesc".equals(activePropertyEntity.getPropertyName())).findFirst();
        if (recoveryDescOption.isPresent()) {
            reunionInfoVo.setRecoveryDesc(recoveryDescOption.get().getPropertyRemark());
            reunionInfoVo.setRecoveryTitle(recoveryDescOption.get().getPropertyValue());
        }
    }

    private void getExchangeDateProperty(List<ActivePropertyEntity> reunionPropertyList, ReunionInfoVo reunionInfoVo) {
        Date exchangeStartTime = null;
        Date exchangeEndTime = null;
        Optional<ActivePropertyEntity> exchangeStartTimeOption = reunionPropertyList.stream().filter(activePropertyEntity -> "exchangeStartTime".equals(activePropertyEntity.getPropertyName())).findFirst();
        Optional<ActivePropertyEntity> exchangeEndTimeOption = reunionPropertyList.stream().filter(activePropertyEntity -> "exchangeEndTime".equals(activePropertyEntity.getPropertyName())).findFirst();
        if (exchangeStartTimeOption.isPresent() && exchangeEndTimeOption.isPresent()) {
            exchangeStartTime = DateUtils.getDateFromString((String)exchangeStartTimeOption.get().getPropertyValue(), (String)"yyyy-MM-dd");
            reunionInfoVo.setExchangeStartTime(exchangeStartTime);
            exchangeEndTime = DateUtils.getDateFromString((String)exchangeEndTimeOption.get().getPropertyValue(), (String)"yyyy-MM-dd");
            reunionInfoVo.setExchangeEndTime(exchangeEndTime);
            reunionInfoVo.setExchangeDate("\u7b2c\u56db\u5b63Care Reunion\u6b63\u5f0f\u5f00\u59cb\u5566\uff01");
        }
    }

    private void getPlanDateProperty(List<ActivePropertyEntity> reunionPropertyList, ReunionInfoVo reunionInfoVo) {
        Date planStartTime = null;
        Date planEndTime = null;
        Optional<ActivePropertyEntity> planStartTimeOption = reunionPropertyList.stream().filter(activePropertyEntity -> "planStartTime".equals(activePropertyEntity.getPropertyName())).findFirst();
        Optional<ActivePropertyEntity> planEndTimeOption = reunionPropertyList.stream().filter(activePropertyEntity -> "planEndTime".equals(activePropertyEntity.getPropertyName())).findFirst();
        if (planStartTimeOption.isPresent() && planEndTimeOption.isPresent()) {
            planStartTime = DateUtils.getDateFromString((String)planStartTimeOption.get().getPropertyValue(), (String)"yyyy-MM-dd");
            reunionInfoVo.setPlanStartTime(planStartTime);
            planEndTime = DateUtils.getDateFromString((String)planEndTimeOption.get().getPropertyValue(), (String)"yyyy-MM-dd");
            reunionInfoVo.setPlanEndTime(planEndTime);
            reunionInfoVo.setPlanDate("\u4f60\u6536\u5230\u7684\u6bcf\u4e2a\u4e50\u7eaf\u676f\u5b50\uff0c\u90fd\u53ef\u4ee5\u53d8\u4e3a\u7528\u5fc3\u8bbe\u8ba1\u7684\u827a\u672f\u5468\u8fb9\u54c1\u3002");
        }
    }

    @NotNull
    private Optional<ActivePropertyEntity> getSubsubscribeDate(List<ActivePropertyEntity> reunionPropertyList, ReunionInfoVo reunionInfoVo) {
        Date subscribeStartTime = null;
        Date subscribeEndTime = null;
        Optional<ActivePropertyEntity> subscribeStartTimeOption = reunionPropertyList.stream().filter(activePropertyEntity -> "subscribeStartTime".equals(activePropertyEntity.getPropertyName())).findFirst();
        Optional<ActivePropertyEntity> subscribeEndTimeOption = reunionPropertyList.stream().filter(activePropertyEntity -> "subscribeEndTime".equals(activePropertyEntity.getPropertyName())).findFirst();
        if (subscribeStartTimeOption.isPresent() && subscribeEndTimeOption.isPresent()) {
            reunionInfoVo.setSubscribeDate(subscribeStartTimeOption.get().getPropertyValue() + subscribeStartTimeOption.get().getPropertyRemark() + "-" + subscribeEndTimeOption.get().getPropertyValue() + subscribeEndTimeOption.get().getPropertyRemark());
            subscribeStartTime = DateUtils.getDateFromString((String)subscribeStartTimeOption.get().getPropertyValue(), (String)"yyyy-MM-dd");
            reunionInfoVo.setSubscribeStartTime(subscribeStartTime);
            subscribeEndTime = DateUtils.getDateFromString((String)subscribeEndTimeOption.get().getPropertyValue(), (String)"yyyy-MM-dd");
            reunionInfoVo.setSubscribeEndTime(subscribeEndTime);
        }
        return subscribeStartTimeOption;
    }
}

