/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.reunion;

import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.reunion.ReunionSiteMapper;
import cc.lechun.mall.entity.reunion.ReunionSiteEntity;
import cc.lechun.mall.entity.reunion.ReunionSiteVO;
import cc.lechun.mall.iservice.reunion.ReunionSiteInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.utils.LocationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReunionSiteService
extends BaseService<ReunionSiteEntity, Integer>
implements ReunionSiteInterface {
    @Resource
    private ReunionSiteMapper reunionSiteMapper;
    @Autowired
    private MallProductPicInterface productPicInterface;

    @Override
    public List<ReunionSiteVO> getReunionSiteSortList(String province, String city, double log, double lat) {
        List<ReunionSiteVO> lst = this.reunionSiteMapper.getReunionSiteSortList(province, city, log, lat);
        for (ReunionSiteVO siteEntity : lst) {
            siteEntity.setPicList(this.productPicInterface.getProductPicUrl(String.valueOf(siteEntity.getSiteId()), 151));
        }
        ReunionSiteVO r = new ReunionSiteVO();
        r.setSiteId(0);
        r.setSiteName("\u8fd9\u6b21\u7684\u57ce\u5e02\u548c\u5730\u5740\u6ca1\u6709\u8986\u76d6\u5230\u6211...");
        r.setProvinceName("\u6ca1\u5173\u7cfb\uff01\u6211\u53ef\u4ee5\u4f20\u64ad\u5411\u5584\u884c\u52a8\u79ef\u7d2fCARE\u79cd\u5b50");
        r.setCityName("");
        r.setAreaName("");
        r.setAddress("\u8fd9\u6b21\u6240\u6709\u7684\u79cd\u5b50\u90fd.\u5c4a\u65f6\u6211\u4eec\u5c06\u5f00\u653e\u66f4\u591a\u56de\u6536\u5c0f\u5c9b\uff0c\u8986\u76d6\u5230\u5c3d\u53ef\u80fd\u591a\u7684\u4f19\u4f34\u4eec\u3002");
        r.setPicList(new ArrayList<String>());
        lst.add(r);
        return lst;
    }

    @Override
    public BaseJsonVo getUserLoaction(double longitude, double latitude) {
        Map map = LocationUtils.getLocationAddress(longitude, latitude);
        Object province = map.get("province");
        Object city = map.get("city");
        map.put("siteList", this.getReunionSiteSortList(province == null ? "" : province.toString(), city == null ? "" : city.toString(), longitude, latitude));
        return BaseJsonVo.success((Object)map);
    }

    @Override
    public BaseJsonVo getUserLoaction(String address, String area, String city, String province) {
        Map map = LocationUtils.getLocationLngLat(address, area, city, province);
        double longitude = 0.0;
        double latitude = 0.0;
        if (map != null && map.containsKey("lng")) {
            longitude = Double.valueOf(map.get("lng").toString());
            latitude = Double.valueOf(map.get("lat").toString());
        }
        map.put("siteList", this.getReunionSiteSortList(province == null ? "" : province, city == null ? "" : city, longitude, latitude));
        return BaseJsonVo.success((Object)map);
    }

    @Override
    public int getAddressType(String address, String area, String city, String province, int siteId) {
        if (siteId == 0) {
            return 2;
        }
        ReunionSiteEntity reunionSiteEntity = (ReunionSiteEntity)this.selectByPrimaryKey(Integer.valueOf(siteId), 0L);
        if (StringUtils.isEmpty((String)province) || StringUtils.isEmpty((String)city)) {
            this.logger.error("\u8f93\u5165\u53c2\u6570\u6709\u8bef \u7701\u5e02\u4e3a\u7a7a siteId={},province={},city={}", new Object[]{siteId, province, city});
            return 1;
        }
        this.logger.info("\u7ad9\u70b9:{},\u53c2\u6570:{}", (Object)reunionSiteEntity.getCityName(), (Object)city);
        boolean flag = reunionSiteEntity.getCityName().replace("\u5e02", "").contains(city.replace("\u5e02", ""));
        return flag ? 1 : 2;
    }
}

