/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.common.enums.sales.FreeRuleTypeEnum;
import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallFreeMapper;
import cc.lechun.mall.dao.sales.MallFreeProductMapper;
import cc.lechun.mall.dao.sales.MallFreeRuleMapper;
import cc.lechun.mall.entity.cashticket.CashticketVo;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.sales.FreeTypeEnum;
import cc.lechun.mall.entity.sales.MallExchangeProductVO;
import cc.lechun.mall.entity.sales.MallExchangeVO;
import cc.lechun.mall.entity.sales.MallFreeEntity;
import cc.lechun.mall.entity.sales.MallFreeProductEntity;
import cc.lechun.mall.entity.sales.MallFreeRuleEntity;
import cc.lechun.mall.entity.sales.MallFreeVO;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductCategoryEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.sales.MallSelectFreeVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerFreeInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.sales.MallFreeInterface;
import cc.lechun.mall.iservice.sales.MallProductCategoryInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.service.sales.MallGroupService;
import cc.lechun.mall.service.sales.MallPromotionService;
import cc.lechun.mall.service.vip.MallVipService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class MallFreeService
extends BaseService
implements MallFreeInterface {
    @Autowired
    MallFreeMapper freeMapper;
    @Autowired
    MallFreeProductMapper freeProductMapper;
    @Autowired
    MallFreeRuleMapper freeRuleMapper;
    @Autowired
    MallProductInterface productService;
    @Autowired
    private MallPromotionService mallPromotionService;
    @Autowired
    private MallGroupService mallGroupService;
    @Autowired
    private MallVipService mallVipService;
    @Autowired
    CashticketCustomerInterface cashticketCustomerService;
    @Lazy
    @Autowired
    MallOrderMainInterface orderMainInterface;
    @Lazy
    @Autowired
    PrepayCardInterface prepayCardInterface;
    @Lazy
    @Autowired
    PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    private MallFreeInterface mallFreeInterface;
    @Autowired
    private MallProductCategoryInterface productCategoryInterface;
    @Lazy
    @Autowired
    private MallOrderInterface mallOrderInterface;
    @Lazy
    @Autowired
    CustomerFreeInterface customerFreeInterface;

    @Override
    @ReadThroughSingleCache(namespace="MallFreeService.getEnnableExchangeList", expiration=300)
    public List<MallFreeEntity> getEnnableExchangeList(@ParameterValueKeyProvider int platformGroupId) {
        return this.freeMapper.getEnnableExchangeList(platformGroupId);
    }

    @Override
    @ReadThroughSingleCache(namespace="MallFreeService.getEnnableFrees", expiration=300)
    public List<MallFreeEntity> getEnnableFrees(@ParameterValueKeyProvider Integer platformGroupId) {
        return this.freeMapper.getEnnableFrees(platformGroupId);
    }

    @Override
    public BaseJsonVo buildFreeVOFromCart(MallMainOrderVo mallMainOrderVo) {
        if (CollectionUtils.isNotEmpty(mallMainOrderVo.getMallOrderVos())) {
            String key;
            List itemVoList;
            boolean coldProductBoolean = false;
            boolean nomalProductBoolean = false;
            ArrayList<MallShoppingcartVO> mallShoppingcartVOList = new ArrayList<MallShoppingcartVO>();
            int i = 0;
            ArrayList<MallFreeVO> freeProductList = new ArrayList<MallFreeVO>();
            for (MallOrderVo o : mallMainOrderVo.getMallOrderVos()) {
                if (o.getDeliverType() != 1) {
                    if (i == 0) {
                        mallShoppingcartVOList.add(o);
                    }
                } else {
                    o.setFreePools(this.customerFreeInterface.getSelectCustomerFreePool(mallMainOrderVo.getCustomerId(), mallMainOrderVo.getCardType(), mallMainOrderVo.getCardType() == null ? 2 : 1, o.getTransportType()));
                    if (o.getTransportType() == 1) {
                        coldProductBoolean = true;
                    } else if (o.getTransportType() == 2) {
                        nomalProductBoolean = true;
                    }
                    mallShoppingcartVOList.add(o);
                }
                ++i;
            }
            if (mallMainOrderVo.getOrderCacheVo().getOrderSource() != OrderSourceEnum.RECHANGE_CARD.getValue() && CollectionUtils.isNotEmpty((Collection)(itemVoList = (List)this.redisCacheUtil.get(key = MD5.sign((String)(mallMainOrderVo.getCustomerId() + ":FreePool:FreeList")))))) {
                freeProductList.addAll(this.newBuildFree4Cart(itemVoList));
            }
            ArrayList<CashticketVo> selectCashticketVOs = new ArrayList<CashticketVo>();
            if (mallMainOrderVo.getCashticketVos() != null) {
                mallMainOrderVo.getCashticketVos().forEach(cashticketVo -> {
                    if (mallMainOrderVo.getSelectCashVo().getSelectCashList().stream().filter(selectCashticket -> selectCashticket.compareTo(cashticketVo.getTicketCustomerId()) == 0).findAny().isPresent()) {
                        selectCashticketVOs.add((CashticketVo)cashticketVo);
                    }
                });
            }
            freeProductList.addAll((List)this.newBuildFree4Cart(mallShoppingcartVOList, selectCashticketVOs, mallMainOrderVo.getOrderCacheVo()).getValue());
            if (StringUtils.isNotEmpty((String)mallMainOrderVo.getOrderCacheVo().getBindCode()) && mallMainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.RECHANGE_CARD.getValue()) {
                Integer cardType = this.prepayCardBatchInterface.getPrepayCardType(mallMainOrderVo.getOrderCacheVo().getBindCode());
                if (cardType == null) {
                    this.logger.error("\u5361\u6279\u6b21\u4e0d\u5b58\u5728,\u7528\u6237:{},bindCode:{}", (Object)mallMainOrderVo.getCustomerId(), (Object)mallMainOrderVo.getOrderCacheVo().getBindCode());
                } else {
                    String key2 = MD5.sign((String)(mallMainOrderVo.getCustomerId() + ":" + cardType + ":FreeList"));
                    List itemVoList2 = (List)this.redisCacheUtil.get(key2);
                    if (CollectionUtils.isNotEmpty((Collection)itemVoList2)) {
                        freeProductList.addAll(this.newBuildFree4Cart(itemVoList2));
                    }
                }
            }
            if (coldProductBoolean || nomalProductBoolean) {
                this.logger.info("\u7528\u6237:{}\u6709\u8d60\u54c1\u5df2\u52a0\u8f7d\u8d60\u54c1", (Object)mallMainOrderVo.getCustomerId());
            }
            if (coldProductBoolean && nomalProductBoolean) {
                ArrayList<MallFreeVO> coldFreeList = new ArrayList<MallFreeVO>();
                ArrayList<MallFreeVO> normalFreeList = new ArrayList<MallFreeVO>();
                if (CollectionUtils.isNotEmpty(freeProductList)) {
                    for (MallFreeVO freeVO : freeProductList) {
                        ArrayList<MallProductVO> coldFreeProduct = new ArrayList<MallProductVO>();
                        ArrayList<MallProductVO> normalFreeProduct = new ArrayList<MallProductVO>();
                        for (MallProductVO productVO : freeVO.getProductList()) {
                            if (Objects.equals(productVO.getTransportType(), TransportTypeEnum.COLD_CHAIN.getValue())) {
                                if (coldFreeProduct.contains(productVO)) continue;
                                coldFreeProduct.add(productVO);
                                continue;
                            }
                            if (!Objects.equals(productVO.getTransportType(), TransportTypeEnum.NORMAL_CHAIN.getValue()) || normalFreeProduct.contains(productVO)) continue;
                            normalFreeProduct.add(productVO);
                        }
                        if (coldFreeProduct.size() > 0) {
                            MallFreeVO coldFreeVO = new MallFreeVO();
                            BeanUtils.copyProperties((Object)freeVO, (Object)coldFreeVO);
                            coldFreeVO.setProductList(coldFreeProduct);
                            coldFreeList.add(coldFreeVO);
                        }
                        if (normalFreeProduct.size() <= 0) continue;
                        MallFreeVO normalFreeVO = new MallFreeVO();
                        BeanUtils.copyProperties((Object)freeVO, (Object)normalFreeVO);
                        normalFreeVO.setProductList(normalFreeProduct);
                        normalFreeList.add(normalFreeVO);
                    }
                }
                mallMainOrderVo.getMallOrderVos().stream().forEach(orderVo -> {
                    if (orderVo.getTransportType() == TransportTypeEnum.COLD_CHAIN.getValue()) {
                        orderVo.setFrees(coldFreeList);
                    } else if (orderVo.getTransportType() == TransportTypeEnum.NORMAL_CHAIN.getValue()) {
                        orderVo.setFrees(normalFreeList);
                    }
                });
            } else if (coldProductBoolean) {
                mallMainOrderVo.getMallOrderVos().stream().forEach(orderVo -> {
                    if (orderVo.getTransportType() == 1) {
                        orderVo.setFrees(freeProductList);
                    }
                });
            } else if (nomalProductBoolean) {
                mallMainOrderVo.getMallOrderVos().stream().forEach(orderVo -> {
                    if (orderVo.getTransportType() == 2) {
                        orderVo.setFrees(freeProductList);
                    }
                });
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo buildFreeVOFromCart(MallShoppingcartVO coldChainCart, MallShoppingcartVO nomalCart) {
        ArrayList<MallShoppingcartVO> cartProductList = new ArrayList<MallShoppingcartVO>();
        cartProductList.add(coldChainCart);
        cartProductList.add(nomalCart);
        if (nomalCart != null) {
            if (nomalCart.getProducts() != null && nomalCart.getProducts().size() >= 1 || nomalCart.getGroups() != null && nomalCart.getGroups().size() >= 1 || nomalCart.getPromotions() != null && nomalCart.getPromotions().size() >= 1) {
                List<MallFreeVO> productFrees = new ArrayList<MallFreeVO>();
                if (cartProductList != null && cartProductList.size() > 0) {
                    productFrees = (List)this.newBuildFree4Cart(cartProductList, null, null).getValue();
                }
                nomalCart.setFrees(productFrees);
            } else {
                nomalCart.setFrees(new ArrayList<MallFreeVO>());
                if (coldChainCart != null) {
                    coldChainCart.setFrees(new ArrayList<MallFreeVO>());
                    if (coldChainCart.getProducts() != null && coldChainCart.getProducts().size() >= 1 || coldChainCart.getGroups() != null && coldChainCart.getGroups().size() >= 1 || coldChainCart.getPromotions() != null && coldChainCart.getPromotions().size() >= 1) {
                        List productFreesList = (List)this.newBuildFree4Cart(cartProductList, null, null).getValue();
                        coldChainCart.setFrees(productFreesList);
                    } else {
                        coldChainCart.setFrees(new ArrayList<MallFreeVO>());
                    }
                }
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @ReadThroughSingleCache(namespace="MallFreeService.newBuildFree4Cart", expiration=30)
    public BaseJsonVo<List<MallFreeVO>> newBuildFree4Cart(@ParameterValueKeyProvider(order=0) Integer platFormGroupId, @ParameterValueKeyProvider(order=1) String orderMainNo) {
        ArrayList<MallFreeVO> productFreesList = new ArrayList<MallFreeVO>();
        List<MallFreeEntity> frees = this.mallFreeInterface.getEnnableFrees(platFormGroupId);
        if (CollectionUtils.isNotEmpty(frees)) {
            for (MallFreeEntity free : frees) {
                List<MallFreeProductEntity> products;
                MallFreeVO vo;
                boolean hasFree = true;
                if (free.getFreePrice().compareTo(BigDecimal.ZERO) != 0) continue;
                List<MallFreeRuleEntity> rules = this.mallFreeInterface.getMallFreeRule(free.getFreeId());
                if (CollectionUtils.isNotEmpty(rules)) {
                    for (MallFreeRuleEntity mallFreeRuleEntity : rules) {
                        if (Objects.equals(mallFreeRuleEntity.getFreeRuleType(), FreeRuleTypeEnum.new_user_first_order.getValue())) continue;
                        hasFree = false;
                    }
                } else {
                    hasFree = false;
                }
                if (!hasFree || (vo = this.buildFreeVO(free, rules, products = this.mallFreeInterface.getMallFreeProduct(free.getFreeId()), 0)) == null) continue;
                productFreesList.add(vo);
            }
        }
        return BaseJsonVo.success(productFreesList);
    }

    @Override
    public BaseJsonVo<List<MallExchangeVO>> buildExchangeProductList(List<MallOrderVo> mallOrderVos, Integer platFormGroupId, BigDecimal orderAmount) {
        this.logger.info("\u5f00\u59cb\u67e5\u8be2\u6362\u8d2d");
        ArrayList<MallExchangeVO> rs = new ArrayList<MallExchangeVO>();
        List<MallFreeEntity> frees = this.mallFreeInterface.getEnnableExchangeList(platFormGroupId);
        if (CollectionUtils.isNotEmpty(frees)) {
            HashSet<List<MallExchangeProductVO>> productSet = new HashSet<List<MallExchangeProductVO>>();
            ArrayList productList = new ArrayList();
            ArrayList promotionList = new ArrayList();
            mallOrderVos.forEach(mallOrderVo -> {
                productList.addAll(mallOrderVo.getProducts());
                promotionList.addAll(mallOrderVo.getPromotions());
            });
            for (MallFreeEntity free : frees) {
                List<MallFreeRuleEntity> rules = this.mallFreeInterface.getMallFreeRule(free.getFreeId());
                if (CollectionUtils.isNotEmpty(rules)) {
                    List<MallFreeProductEntity> products;
                    MallExchangeVO vo2;
                    int size = 0;
                    int addMaxCount = 0;
                    boolean hasExchange = true;
                    this.logger.info("\u6362\u8d2d:{}", (Object)free.getFreeName());
                    for (MallFreeRuleEntity mallFreeRuleEntity : rules) {
                        this.logger.info("\u6309\u89c4\u5219:{}\u6362\u8d2d,\u89c4\u5219:{}", (Object)FreeRuleTypeEnum.getName(mallFreeRuleEntity.getFreeRuleType()), (Object)mallFreeRuleEntity.getFreeRuleData());
                        if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.amount_type.getValue()) {
                            if (orderAmount.doubleValue() < Double.parseDouble(mallFreeRuleEntity.getFreeRuleData())) {
                                hasExchange = false;
                                break;
                            }
                            BigDecimal[] results = orderAmount.divideAndRemainder(BigDecimal.valueOf(Double.parseDouble(mallFreeRuleEntity.getFreeRuleData())));
                            size = 1;
                            addMaxCount = results[0].intValue();
                            hasExchange = true;
                            this.logger.info("\u8ba2\u5355\u91d1\u989d{},\u6309\u91d1\u989d\u53ef\u6362\u8d2d\u6570\u91cf:{}", (Object)orderAmount, (Object)addMaxCount);
                            continue;
                        }
                        if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.product_type.getValue()) {
                            List size_ls;
                            if (String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()).equals(mallFreeRuleEntity.getFreeRuleData())) {
                                if (productList == null || productList.size() == 0) {
                                    hasExchange = false;
                                    break;
                                }
                                size_ls = productList.stream().filter(mallProductVO -> mallProductVO.getProId().equals(mallFreeRuleEntity.getFreeRuleDataExtend())).collect(Collectors.toList());
                                if (size_ls != null && size_ls.size() > 0) {
                                    size = size == 0 ? ((MallProductVO)size_ls.get(0)).getCount() : (((MallProductVO)size_ls.get(0)).getCount() <= size ? ((MallProductVO)size_ls.get(0)).getCount() : size);
                                    addMaxCount = size;
                                    hasExchange = true;
                                    this.logger.info("\u6307\u5b9a\u5546\u54c1{},\u6309\u5546\u54c1\u53ef\u6362\u8d2d\u6570\u91cf:{}", (Object)mallFreeRuleEntity.getFreeRuleDataExtend(), (Object)addMaxCount);
                                    continue;
                                }
                                hasExchange = false;
                                break;
                            }
                            if (!String.valueOf(SalesTypeEnum.SALES_PROMOTION.getValue()).equals(mallFreeRuleEntity.getFreeRuleData())) continue;
                            if (promotionList == null || promotionList.size() == 0) {
                                hasExchange = false;
                                break;
                            }
                            size_ls = promotionList.stream().filter(vo -> vo.getPromotionId().equals(mallFreeRuleEntity.getFreeRuleDataExtend())).collect(Collectors.toList());
                            if (size_ls != null && size_ls.size() > 0) {
                                size = size == 0 ? ((MallPromotionVO)size_ls.get(0)).getCount() : (((MallPromotionVO)size_ls.get(0)).getCount() <= size ? ((MallPromotionVO)size_ls.get(0)).getCount() : size);
                                addMaxCount = size;
                                continue;
                            }
                            hasExchange = false;
                            break;
                        }
                        if (mallFreeRuleEntity.getFreeRuleType().intValue() != FreeRuleTypeEnum.category.getValue()) continue;
                        List<MallProductCategoryEntity> list = this.productCategoryInterface.getCategoryList();
                        hasExchange = false;
                        List<MallProductCategoryEntity> resultList = new ArrayList<MallProductCategoryEntity>();
                        resultList = this.getCategoryChildrenList(mallFreeRuleEntity.getFreeRuleData(), resultList, list);
                        if (CollectionUtils.isNotEmpty(productList)) {
                            HashSet<String> categoryList = new HashSet<String>();
                            for (MallProductVO mallProductVO2 : productList) {
                                this.logger.info("\u5546\u54c1:{},\u54c1\u7c7b:{}", (Object)mallProductVO2.getProName(), (Object)mallProductVO2.getProductCategoryId());
                                categoryList.add(mallProductVO2.getProductCategoryId());
                            }
                            if (CollectionUtils.isNotEmpty(resultList)) {
                                for (String categoryId : categoryList) {
                                    List size_ls = resultList.stream().filter(categoryEntity -> Objects.equals(categoryEntity.getCategoryId(), categoryId)).collect(Collectors.toList());
                                    if (!CollectionUtils.isNotEmpty(size_ls)) continue;
                                    hasExchange = true;
                                    addMaxCount = 1;
                                    size = 1;
                                    this.logger.info("\u6307\u5b9a\u5546\u54c1\u54c1\u7c7b{},\u6309\u5546\u54c1\u53ef\u6362\u8d2d\u6570\u91cf:{}", (Object)mallFreeRuleEntity.getFreeRuleData(), (Object)addMaxCount);
                                    break;
                                }
                            }
                        }
                        if (!hasExchange && CollectionUtils.isNotEmpty(promotionList)) {
                            for (MallPromotionVO mallPromotionVO : promotionList) {
                                if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(mallPromotionVO.getProductType()).intValue()) {
                                    List size_ls;
                                    if (!CollectionUtils.isNotEmpty(resultList) || !CollectionUtils.isNotEmpty(size_ls = resultList.stream().filter(categoryEntity -> Objects.equals(categoryEntity.getCategoryId(), mallPromotionVO.getProduct().getProductCategoryId())).collect(Collectors.toList()))) continue;
                                    hasExchange = true;
                                    addMaxCount = 1;
                                    size = 1;
                                    this.logger.info("\u4fc3\u9500\u5355\u6307\u5b9a\u5546\u54c1\u54c1\u7c7b{},\u6309\u5546\u54c1\u53ef\u6362\u8d2d\u6570\u91cf:{}", (Object)mallFreeRuleEntity.getFreeRuleData(), (Object)addMaxCount);
                                    break;
                                }
                                if (SalesTypeEnum.SALES_GROUP.getValue() != Integer.valueOf(mallPromotionVO.getProductType()).intValue()) continue;
                                HashSet<String> categoryList = new HashSet<String>();
                                for (MallProductVO mallProductVO2 : mallPromotionVO.getGroup().getProductList()) {
                                    this.logger.info("\u5546\u54c1:{},\u54c1\u7c7b:{}", (Object)mallProductVO2.getProName(), (Object)mallProductVO2.getProductCategoryId());
                                    categoryList.add(mallProductVO2.getProductCategoryId());
                                }
                                HashSet<MallProductCategoryEntity> categoryEntitySet = new HashSet<MallProductCategoryEntity>(resultList);
                                if (CollectionUtils.isNotEmpty(categoryEntitySet)) {
                                    hasExchange = false;
                                    for (String categoryId : categoryList) {
                                        List size_ls = resultList.stream().filter(categoryEntity -> Objects.equals(categoryEntity.getCategoryId(), categoryId)).collect(Collectors.toList());
                                        if (!CollectionUtils.isNotEmpty(size_ls)) continue;
                                        hasExchange = true;
                                        addMaxCount = 1;
                                        size = 1;
                                        this.logger.info("\u4fc3\u9500\u5957\u88c5\u6307\u5b9a\u5546\u54c1\u54c1\u7c7b{},\u6309\u5546\u54c1\u53ef\u6362\u8d2d\u6570\u91cf:{}", (Object)mallFreeRuleEntity.getFreeRuleData(), (Object)addMaxCount);
                                        break;
                                    }
                                }
                                if (!hasExchange) continue;
                                break;
                            }
                        }
                        if (hasExchange) continue;
                        break;
                    }
                    if (!hasExchange || (vo2 = this.buildExchangeVO(free, rules, products = this.mallFreeInterface.getMallFreeProduct(free.getFreeId()), size, FreeTypeEnum.exchange.getValue(), addMaxCount)) == null) continue;
                    boolean merge = false;
                    String productName = "";
                    for (List list : productSet) {
                        for (MallExchangeProductVO productVO : vo2.getProductList()) {
                            List list2 = list.stream().filter(mallProductVO -> Objects.equals(mallProductVO.getProId(), productVO.getProId()) && Objects.equals(mallProductVO.getProductType(), productVO.getProductType()) && free.getFreePrice().compareTo(mallProductVO.getFactPrice()) == 0).collect(Collectors.toList());
                            if (!CollectionUtils.isNotEmpty(list2)) continue;
                            merge = true;
                            productName = productVO.getProName();
                            break;
                        }
                        if (!merge) continue;
                        this.logger.info("\u6362\u8d2d\u5546\u54c1{}\u5b58\u5728\u91cd\u590d,\u89c4\u5219:{}\u4e0d\u53c2\u4e0e\u6362\u8d2d", (Object)productName, (Object)free.getFreeName());
                        this.logger.info("\u6362\u8d2d\u5bf9\u8c61:{}", (Object)JsonUtils.toJson(vo2.getProductList(), (boolean)false));
                        this.logger.info("\u5df2\u6709\u6362\u8d2d\u5bf9\u8c61:{}", (Object)JsonUtils.toJson(productSet, (boolean)false));
                        break;
                    }
                    if (merge) {
                        this.logger.info("\u6362\u8d2d{} \u5546\u54c1:{}\u914d\u7f6e\u6709\u91cd\u590d,\u4e0d\u663e\u793a\u91cd\u590d", (Object)free.getFreeName(), (Object)productName);
                        continue;
                    }
                    rs.add(vo2);
                    productSet.add(vo2.getProductList());
                    continue;
                }
                this.logger.info("\u6362\u8d2d:{}\u6ca1\u6709\u914d\u7f6e\u89c4\u5219", (Object)free.getFreeName());
            }
        }
        return BaseJsonVo.success(rs);
    }

    private List<MallProductCategoryEntity> getCategoryChildrenList(String categoryId, List<MallProductCategoryEntity> resultList, List<MallProductCategoryEntity> list) {
        Optional<MallProductCategoryEntity> selfOptional;
        List tempList = list.stream().filter(mallProductCategoryEntity -> Objects.equals(mallProductCategoryEntity.getParentId(), categoryId)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(tempList)) {
            resultList.addAll(tempList);
            Iterator iterator = tempList.iterator();
            if (iterator.hasNext()) {
                MallProductCategoryEntity categoryEntity = (MallProductCategoryEntity)iterator.next();
                return this.getCategoryChildrenList(categoryEntity.getCategoryId(), resultList, list);
            }
        }
        if ((selfOptional = list.stream().filter(mallProductCategoryEntity -> Objects.equals(mallProductCategoryEntity.getCategoryId(), categoryId)).findFirst()).isPresent()) {
            resultList.add(selfOptional.get());
        }
        return resultList;
    }

    private BaseJsonVo newBuildFree4Cart(List<MallShoppingcartVO> cartProductList, List<CashticketVo> cashticketVos, MallOrderCacheVo orderCacheVo) {
        ArrayList rs = new ArrayList();
        List<MallFreeEntity> frees = this.mallFreeInterface.getEnnableFrees(cartProductList.get(0).getPlatFormGroupId());
        if (CollectionUtils.isNotEmpty(frees)) {
            this.logger.info("\u662f\u5426\u6709\u4f18\u60e0\u5238\uff1a{}", (Object)(CollectionUtils.isEmpty(cashticketVos) ? "\u65e0" : cashticketVos.toString()));
            BigDecimal[] factPriceSum = new BigDecimal[]{BigDecimal.ZERO};
            ArrayList<MallProductVO> productList = new ArrayList<MallProductVO>();
            ArrayList<MallGroupVO> groupList = new ArrayList<MallGroupVO>();
            ArrayList<MallPromotionVO> promotionList = new ArrayList<MallPromotionVO>();
            for (MallShoppingcartVO mallShoppingcartVO : cartProductList) {
                if (mallShoppingcartVO == null) continue;
                factPriceSum[0] = PriceUtils.add((BigDecimal)mallShoppingcartVO.getFactPrice(), (BigDecimal)factPriceSum[0]);
                productList.addAll(mallShoppingcartVO.getProducts());
                groupList.addAll(mallShoppingcartVO.getGroups());
                promotionList.addAll(mallShoppingcartVO.getPromotions());
            }
            this.logger.info("\u8d60\u54c1\u6307\u5b9a\u91d1\u989d\u5b9e\u9645\u552e\u4ef7:{}", (Object)factPriceSum[0]);
            frees.forEach(free -> {
                int size = 0;
                boolean hasFree = true;
                ArrayList<MallFreeRuleEntity> couponRules = new ArrayList<MallFreeRuleEntity>();
                if (free.getFreePrice().compareTo(BigDecimal.ZERO) == 0) {
                    List<MallFreeProductEntity> products;
                    MallFreeVO vo2;
                    List<MallFreeRuleEntity> rules = this.mallFreeInterface.getMallFreeRule(free.getFreeId());
                    if (CollectionUtils.isEmpty(rules)) {
                        hasFree = false;
                        return;
                    }
                    block0: for (MallFreeRuleEntity mallFreeRuleEntity : rules) {
                        if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.amount_type.getValue()) {
                            if (factPriceSum[0].doubleValue() < Double.parseDouble(mallFreeRuleEntity.getFreeRuleData())) {
                                hasFree = false;
                                break;
                            }
                            size = 1;
                            continue;
                        }
                        if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.product_type.getValue()) {
                            List size_ls;
                            if (String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()).equals(mallFreeRuleEntity.getFreeRuleData())) {
                                if (productList == null || productList.size() == 0) {
                                    hasFree = false;
                                    break;
                                }
                                size_ls = productList.stream().filter(mallProductVO -> mallProductVO.getProId().equals(mallFreeRuleEntity.getFreeRuleDataExtend())).collect(Collectors.toList());
                                if (size_ls != null && size_ls.size() > 0) {
                                    size = size == 0 ? ((MallProductVO)size_ls.get(0)).getCount() : (((MallProductVO)size_ls.get(0)).getCount() <= size ? ((MallProductVO)size_ls.get(0)).getCount() : size);
                                    continue;
                                }
                                hasFree = false;
                                break;
                            }
                            if (String.valueOf(SalesTypeEnum.SALES_GROUP.getValue()).equals(mallFreeRuleEntity.getFreeRuleData())) {
                                if (groupList == null || groupList.size() == 0) {
                                    hasFree = false;
                                    break;
                                }
                                size_ls = groupList.stream().filter(mallGroupVO -> mallGroupVO.getGroupId().equals(mallFreeRuleEntity.getFreeRuleDataExtend())).collect(Collectors.toList());
                                if (size_ls != null && size_ls.size() > 0) {
                                    size = size == 0 ? ((MallGroupVO)size_ls.get(0)).getCount() : (((MallGroupVO)size_ls.get(0)).getCount() <= size ? ((MallGroupVO)size_ls.get(0)).getCount() : size);
                                    continue;
                                }
                                hasFree = false;
                                break;
                            }
                            if (!String.valueOf(SalesTypeEnum.SALES_PROMOTION.getValue()).equals(mallFreeRuleEntity.getFreeRuleData())) continue;
                            if (promotionList == null || promotionList.size() == 0) {
                                hasFree = false;
                                break;
                            }
                            size_ls = promotionList.stream().filter(vo -> vo.getPromotionId().equals(mallFreeRuleEntity.getFreeRuleDataExtend())).collect(Collectors.toList());
                            if (size_ls != null && size_ls.size() > 0) {
                                size = size == 0 ? ((MallPromotionVO)size_ls.get(0)).getCount() : (((MallPromotionVO)size_ls.get(0)).getCount() <= size ? ((MallPromotionVO)size_ls.get(0)).getCount() : size);
                                continue;
                            }
                            hasFree = false;
                            break;
                        }
                        if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.city_type.getValue()) {
                            hasFree = false;
                            break;
                        }
                        if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.vip_type.getValue()) {
                            this.logger.info("\u6ee1\u8d60\u5f00\u59cb\u6267\u884c....\u901a\u8fc7\u6307\u5b9a\u4f1a\u5458\u6743\u76ca\u6ee1\u8d60...");
                            if (!this.mallVipService.getCustomerRight(((MallShoppingcartVO)cartProductList.get(0)).getCustomerId(), mallFreeRuleEntity.getFreeRuleData()).isSuccess()) {
                                hasFree = false;
                                break;
                            }
                            size = 1;
                            continue;
                        }
                        if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.coupon_type.getValue() && cashticketVos != null && cashticketVos.size() > 0 && cashticketVos.get(0) != null) {
                            hasFree = false;
                            couponRules.add(mallFreeRuleEntity);
                            for (CashticketVo cashticketVo : cashticketVos) {
                                this.logger.info("\u6ee1\u8d60:{}\u4f18\u60e0\u5238\uff1a{},\u6279\u6b21ID:{},\u89c4\u5219ID:{}", new Object[]{free.getFreeName(), cashticketVo.getTicketBatchName(), cashticketVo.getTicketBatchId(), mallFreeRuleEntity.getFreeRuleData()});
                                if (!mallFreeRuleEntity.getFreeRuleData().equals(cashticketVo.getTicketBatchId())) continue;
                                size = 1;
                                hasFree = true;
                                continue block0;
                            }
                            continue;
                        }
                        if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.prepaycard_type.getValue() && orderCacheVo != null && !StringUtils.isEmpty((String)orderCacheVo.getPrepayCardId())) {
                            PrepayCardBatchEntity prepayCardBatchEntity;
                            PrepayCardEntity prepayCardEntity = (PrepayCardEntity)this.prepayCardInterface.selectByPrimaryKey((Serializable)((Object)orderCacheVo.getPrepayCardId()));
                            if (prepayCardEntity == null || prepayCardEntity.getBatchId() == null || (prepayCardBatchEntity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.selectByPrimaryKey(prepayCardEntity.getBatchId())) == null || !mallFreeRuleEntity.getFreeRuleData().equals(prepayCardBatchEntity.getCardPromotionId())) continue;
                            hasFree = false;
                            this.logger.info("\u8ba1\u7b97\u8d60\u54c1\u5f00\u59cb\u6267\u884c....\u901a\u8fc7\u6307\u5b9a\u9884\u4ed8\u5361\u8d60\u9001...");
                            if (this.orderMainInterface.hasFreePrepayCard(orderCacheVo.getPrepayCardId(), mallFreeRuleEntity.getFreeId())) continue;
                            size = 1;
                            hasFree = true;
                            continue;
                        }
                        if (mallFreeRuleEntity.getFreeRuleType().intValue() != FreeRuleTypeEnum.active_type.getValue() || orderCacheVo == null || !StringUtils.isNotEmpty((String)orderCacheVo.getBindCode())) continue;
                        hasFree = false;
                        break;
                    }
                    if (hasFree && size > 0 && (vo2 = this.buildFreeVO((MallFreeEntity)free, rules, products = this.mallFreeInterface.getMallFreeProduct(free.getFreeId()), size)) != null) {
                        rs.add(vo2);
                    }
                }
            });
        }
        return BaseJsonVo.success(rs);
    }

    private List<MallFreeVO> newBuildFree4Cart(List<MallSelectFreeVO> list) {
        ArrayList<MallFreeVO> rs = new ArrayList<MallFreeVO>();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(selectFreeVO -> {
                MallFreeEntity free = (MallFreeEntity)this.freeMapper.selectByPrimaryKey((Serializable)((Object)selectFreeVO.getFreeId()));
                MallFreeVO vo = this.buildFreeVO(free, selectFreeVO.getItemId(), selectFreeVO.getQuantity());
                if (vo != null) {
                    rs.add(vo);
                }
            });
        }
        return rs;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallFreeService.getMallFreeRule", expiration=300)
    public List<MallFreeRuleEntity> getMallFreeRule(@ParameterValueKeyProvider String freeId) {
        MallFreeRuleEntity searchParam = new MallFreeRuleEntity();
        searchParam.setFreeId(freeId);
        return this.freeRuleMapper.getList(searchParam);
    }

    @Override
    @ReadThroughSingleCache(namespace="MallFreeService.getMallFreeProduct", expiration=300)
    public List<MallFreeProductEntity> getMallFreeProduct(@ParameterValueKeyProvider String freeId) {
        MallFreeProductEntity searchParam0 = new MallFreeProductEntity();
        searchParam0.setFreeId(freeId);
        return this.freeProductMapper.getList(searchParam0);
    }

    private MallFreeVO buildFreeVO(MallFreeEntity free, List<MallFreeRuleEntity> rules, List<MallFreeProductEntity> freeProducts, int size) {
        if (freeProducts == null || freeProducts.size() == 0 || CollectionUtils.isEmpty(rules)) {
            return null;
        }
        MallFreeVO freeVO = new MallFreeVO();
        freeVO.setFreeId(free.getFreeId());
        freeVO.setFreeName(free.getFreeName());
        freeVO.setFreePrice(free.getFreePrice());
        freeVO.setStatus(free.getStatus());
        freeVO.setBeginTime(free.getBeginTime());
        freeVO.setEndTime(free.getEndTime());
        freeVO.setCreateTime(free.getCreateTime());
        freeVO.setPlatformGroupId(free.getPlatformGroupId());
        freeVO.setRuleOperator(free.getRuleOperator());
        List<MallProductVO> productVOList = freeProducts.stream().map(freeProduct -> this.productService.buildProductVO(freeProduct.getProductId(), freeProduct.getProductCount(), freeProduct.getFreeId(), false, true)).filter(sr -> sr.isSuccess() && ((MallProductVO)sr.getValue()).getValid() != false).map(sr -> {
            MallProductVO productVO = (MallProductVO)sr.getValue();
            if (size == 0) {
                productVO.setQuantity(0);
            } else {
                productVO.setQuantity(productVO.getCount() * size);
            }
            productVO.setOriginPrice(productVO.getFactPrice());
            this.logger.info("\u8d60\u54c1:{}\u539f\u4ef7:{}", (Object)productVO.getProName(), (Object)productVO.getOriginPrice());
            productVO.setFactPrice(free.getFreePrice());
            return productVO;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(productVOList)) {
            this.logger.info("buildProductVo\u4ee5\u540e\u8fd4\u56de\u7684\u662f\u5565" + productVOList.size());
            return null;
        }
        freeVO.setProductList(productVOList);
        freeVO.setRuleType(0);
        rules.forEach(mallFreeRuleEntity -> {
            if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.product_type.getValue()) {
                freeVO.setRuleType(mallFreeRuleEntity.getFreeRuleType());
                freeVO.setSalesType(Integer.parseInt(mallFreeRuleEntity.getFreeRuleData()));
                freeVO.setRuleData(mallFreeRuleEntity.getFreeRuleDataExtend());
            } else if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.coupon_type.getValue()) {
                freeVO.setRuleType(mallFreeRuleEntity.getFreeRuleType());
            }
        });
        return freeVO;
    }

    private MallFreeVO buildFreeVO(MallFreeEntity free, String productId, int size) {
        if (size == 0 || StringUtils.isEmpty((String)productId)) {
            return null;
        }
        MallFreeVO freeVO = new MallFreeVO();
        freeVO.setFreeId(free.getFreeId());
        freeVO.setFreeName(free.getFreeName());
        freeVO.setFreePrice(free.getFreePrice());
        freeVO.setStatus(free.getStatus());
        freeVO.setBeginTime(free.getBeginTime());
        freeVO.setEndTime(free.getEndTime());
        freeVO.setCreateTime(free.getCreateTime());
        freeVO.setPlatformGroupId(free.getPlatformGroupId());
        freeVO.setRuleOperator(free.getRuleOperator());
        ArrayList<MallProductVO> productVOList = new ArrayList<MallProductVO>();
        BaseJsonVo<MallProductVO> sr = this.productService.buildProductVO(productId, size, free.getFreeId(), false, true);
        if (sr.isSuccess() && ((MallProductVO)sr.getValue()).getValid().booleanValue()) {
            MallProductVO productVO = (MallProductVO)sr.getValue();
            productVO.setOriginPrice(productVO.getFactPrice());
            this.logger.info("\u8d60\u54c1:{}\u539f\u4ef7:{}", (Object)productVO.getProName(), (Object)productVO.getOriginPrice());
            productVO.setFactPrice(free.getFreePrice());
            if (free.getFreePrice().compareTo(BigDecimal.ZERO) == 0) {
                productVO.setCardFactPrice(BigDecimal.ZERO);
            }
            productVOList.add(productVO);
        }
        if (productVOList.size() == 0) {
            this.logger.info("buildProductVo\u4ee5\u540e\u8fd4\u56de\u7684\u662f\u5565" + productVOList.size());
            return null;
        }
        freeVO.setProductList(productVOList);
        freeVO.setRuleType(0);
        return freeVO;
    }

    private MallExchangeVO buildExchangeVO(MallFreeEntity free, List<MallFreeRuleEntity> rules, List<MallFreeProductEntity> freeProducts, int size, int freeType, int addMaxCount) {
        if (size == 0 || freeProducts == null || freeProducts.size() == 0) {
            return null;
        }
        MallExchangeVO freeVO = new MallExchangeVO();
        freeVO.setFreeId(free.getFreeId());
        freeVO.setFreeName(free.getFreeName());
        freeVO.setFreePrice(free.getFreePrice());
        freeVO.setStatus(free.getStatus());
        freeVO.setBeginTime(free.getBeginTime());
        freeVO.setEndTime(free.getEndTime());
        freeVO.setCreateTime(free.getCreateTime());
        freeVO.setPlatformGroupId(free.getPlatformGroupId());
        freeVO.setRuleOperator(free.getRuleOperator());
        freeVO.setFreeType(freeType);
        freeVO.setFreeTypeName(FreeTypeEnum.getName(freeType));
        ArrayList<MallExchangeProductVO> productVOList = new ArrayList<MallExchangeProductVO>();
        freeProducts.forEach(freeProduct -> {
            BaseJsonVo<MallGroupVO> sr;
            if (freeProduct.getProductType().intValue() == SalesTypeEnum.SALES_PRODUCT.getValue()) {
                BaseJsonVo<MallProductVO> sr2 = this.productService.buildProductVO(freeProduct.getProductId(), 1, freeProduct.getFreeId(), false, true);
                if (sr2.isSuccess() && ((MallProductVO)sr2.getValue()).getValid().booleanValue()) {
                    MallProductVO productVO = (MallProductVO)sr2.getValue();
                    MallExchangeProductVO exchangeProductVO = new MallExchangeProductVO();
                    BeanUtils.copyProperties((Object)productVO, (Object)exchangeProductVO);
                    exchangeProductVO.setUseCoupon(0);
                    exchangeProductVO.setFreeId(free.getFreeId());
                    exchangeProductVO.setProductType(freeProduct.getProductType());
                    this.logger.info("\u6362\u8d2d\u5546\u54c1\u9650\u5236\u8d2d\u4e70\u6570:{},\u6309\u6761\u4ef6\u8d60\u9001\u4e2a\u6570:{}", (Object)freeProduct.getProductCount(), (Object)addMaxCount);
                    if (addMaxCount > 0) {
                        exchangeProductVO.setAddMaxCount(addMaxCount > freeProduct.getProductCount() ? freeProduct.getProductCount() : addMaxCount);
                    } else {
                        exchangeProductVO.setAddMaxCount(freeProduct.getProductCount());
                    }
                    exchangeProductVO.setFactPrice(free.getFreePrice());
                    exchangeProductVO.setOriginPrice(productVO.getVipPrice());
                    exchangeProductVO.setTransportType(productVO.getTransportType());
                    exchangeProductVO.setQuantity(0);
                    productVOList.add(exchangeProductVO);
                }
            } else if (freeProduct.getProductType().intValue() == SalesTypeEnum.SALES_PROMOTION.getValue()) {
                BaseJsonVo<MallPromotionVO> sr3 = this.mallPromotionService.buildPromotionVO(freeProduct.getProductId(), (Integer)1, (Boolean)true);
                if (sr3.isSuccess() && ((MallPromotionVO)sr3.getValue()).getValid().booleanValue()) {
                    MallPromotionVO promotionVO = (MallPromotionVO)sr3.getValue();
                    MallExchangeProductVO exchangeProductVO = new MallExchangeProductVO();
                    BeanUtils.copyProperties((Object)promotionVO, (Object)exchangeProductVO);
                    exchangeProductVO.setProductType(freeProduct.getProductType());
                    exchangeProductVO.setFreeId(free.getFreeId());
                    exchangeProductVO.setProId(promotionVO.getPromotionId());
                    exchangeProductVO.setProName(promotionVO.getPromotionName());
                    exchangeProductVO.setProductPic(promotionVO.getPromotionPic());
                    exchangeProductVO.setQuantity(0);
                    this.logger.info("\u6362\u8d2d\u4fc3\u9500\u9650\u5236\u8d2d\u4e70\u6570:{},\u6309\u6761\u4ef6\u53ef\u6362\u8d2d\u6570:{}", (Object)freeProduct.getProductCount(), (Object)addMaxCount);
                    if (addMaxCount > 0) {
                        exchangeProductVO.setAddMaxCount(addMaxCount > freeProduct.getProductCount() ? freeProduct.getProductCount() : addMaxCount);
                    } else {
                        exchangeProductVO.setAddMaxCount(freeProduct.getProductCount());
                    }
                    exchangeProductVO.setFactPrice(free.getFreePrice());
                    exchangeProductVO.setTransportType(this.mallPromotionService.getPromotionDeliveryType(promotionVO.getPromotionId()));
                    productVOList.add(exchangeProductVO);
                }
            } else if (freeProduct.getProductType().intValue() == SalesTypeEnum.SALES_GROUP.getValue() && (sr = this.mallGroupService.buildGroupVO(freeProduct.getProductId(), 1, true)).isSuccess() && ((MallGroupVO)sr.getValue()).getValid().booleanValue()) {
                MallGroupVO groupVO = (MallGroupVO)sr.getValue();
                MallExchangeProductVO exchangeProductVO = new MallExchangeProductVO();
                BeanUtils.copyProperties((Object)groupVO, (Object)exchangeProductVO);
                exchangeProductVO.setFreeId(free.getFreeId());
                exchangeProductVO.setProductType(freeProduct.getProductType());
                exchangeProductVO.setProId(groupVO.getGroupId());
                exchangeProductVO.setProName(groupVO.getGroupName());
                exchangeProductVO.setProductPic(groupVO.getGroupPic());
                if (addMaxCount > 0) {
                    exchangeProductVO.setAddMaxCount(addMaxCount > freeProduct.getProductCount() ? freeProduct.getProductCount() : addMaxCount);
                } else {
                    exchangeProductVO.setAddMaxCount(freeProduct.getProductCount());
                }
                exchangeProductVO.setFactPrice(free.getFreePrice());
                exchangeProductVO.setOriginPrice(groupVO.getPrice());
                exchangeProductVO.setTransportType(this.mallGroupService.getGroupDeliveryType(freeProduct.getProductId()));
                exchangeProductVO.setQuantity(0);
                productVOList.add(exchangeProductVO);
            }
        });
        if (productVOList.size() == 0) {
            return null;
        }
        freeVO.setProductList(productVOList);
        freeVO.setRuleType(0);
        if (CollectionUtils.isNotEmpty(rules)) {
            rules.forEach(mallFreeRuleEntity -> {
                if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.product_type.getValue()) {
                    freeVO.setRuleType(mallFreeRuleEntity.getFreeRuleType());
                    freeVO.setSalesType(Integer.parseInt(mallFreeRuleEntity.getFreeRuleData()));
                    freeVO.setRuleData(mallFreeRuleEntity.getFreeRuleDataExtend());
                } else if (mallFreeRuleEntity.getFreeRuleType().intValue() == FreeRuleTypeEnum.coupon_type.getValue()) {
                    freeVO.setRuleType(mallFreeRuleEntity.getFreeRuleType());
                }
            });
        }
        return freeVO;
    }

    @Override
    public MallFreeEntity selectByPrimaryKey(String freeId) {
        return (MallFreeEntity)this.freeMapper.selectByPrimaryKey((Serializable)((Object)freeId));
    }
}

