/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallFullcutMapper;
import cc.lechun.mall.entity.sales.FullCutTypeEnum;
import cc.lechun.mall.entity.sales.MallFreeVO;
import cc.lechun.mall.entity.sales.MallFullCutNumberVo;
import cc.lechun.mall.entity.sales.MallFullcutDetailEntity;
import cc.lechun.mall.entity.sales.MallFullcutEntity;
import cc.lechun.mall.entity.sales.MallFullcutVo;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.iservice.sales.MallFullcutInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.service.sales.MallFullcutDetailService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughAssignCache;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallFullcutService
extends BaseService
implements MallFullcutInterface {
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallFullcutMapper fullcutMapper;
    @Autowired
    private MallFullcutDetailService mallFullcutDetailService;
    @Autowired
    private MallProductInterface productService;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    MallFullcutInterface mallFullcutService;

    public MallFullcutEntity getFullcutEntity(String fullcutId) {
        return (MallFullcutEntity)this.fullcutMapper.selectByPrimaryKey((Serializable)((Object)fullcutId));
    }

    @Override
    @ReadThroughSingleCache(namespace="MallFreeService.getEnableFullcut", expiration=300)
    public BaseJsonVo<MallFullcutVo> getEnableFullcut(@ParameterValueKeyProvider String bindCode) {
        if (bindCode == null || bindCode.isEmpty()) {
            return BaseJsonVo.paramError((String)"\u7ed1\u5b9a\u7801\u4e0d\u5b58\u5728");
        }
        String activeNo = this.activeInterface.getActiveNoByBindCode(bindCode);
        if (!this.activeInterface.checkActiveEnable(activeNo).isSuccess()) {
            return BaseJsonVo.paramError((String)"\u6d3b\u52a8\u5df2\u8fc7\u671f");
        }
        MallFullcutVo fullcutVo = this.fullcutMapper.getSingleEntityByTime(activeNo, DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"));
        if (fullcutVo == null && (fullcutVo = this.fullcutMapper.getSingleEntityByTime(bindCode, DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"))) == null) {
            return BaseJsonVo.paramError((String)"\u6d3b\u52a8\u6682\u65f6\u65e0\u6cd5\u53c2\u4e0e\uff1a\u5c1a\u672a\u5f00\u59cb\u6216\u5df2\u8fc7\u671f");
        }
        fullcutVo.setTypeName(FullCutTypeEnum.getName(fullcutVo.getType()));
        long seconds = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)fullcutVo.getEndTime());
        fullcutVo.setSeconds(seconds);
        fullcutVo.setSecond(seconds / 3600L);
        fullcutVo.setMinute(seconds % 3600L / 60L);
        fullcutVo.setHour(seconds % 3600L % 60L);
        return BaseJsonVo.success((Object)fullcutVo);
    }

    @Override
    public boolean checkFullcut(MallFullcutVo fullcutVo, List<MallFullcutDetailEntity> detailEntities, List<MallShoppingcartVO> shoppingcartVOS) {
        BigDecimal[] count = new BigDecimal[]{BigDecimal.ZERO};
        for (MallShoppingcartVO shoppingcartVO : shoppingcartVOS) {
            List<Object> productVOs = new ArrayList();
            List<Object> groups = new ArrayList();
            if (fullcutVo.getFullClass() == 1) {
                productVOs = shoppingcartVO.getProductsPool();
            } else {
                productVOs = shoppingcartVO.getProducts();
                groups = shoppingcartVO.getGroups();
            }
            for (MallProductVO mallProductVO : productVOs) {
                if (detailEntities.stream().filter(c -> c.getGroupType() == 4 && c.getProductId().equals(productVO.getProId())).count() <= 0L) continue;
                mallProductVO.setFullCutId(fullcutVo.getFullCutId());
                mallProductVO.setUseCoupon(fullcutVo.getEnableUseCoupon());
                if (fullcutVo.getType().intValue() == FullCutTypeEnum.product_num_discount.getValue() || fullcutVo.getType().intValue() == FullCutTypeEnum.product_num.getValue() || fullcutVo.getType().intValue() == FullCutTypeEnum.amount_and_num.getValue()) {
                    count[0] = PriceUtils.add((BigDecimal)count[0], (BigDecimal)BigDecimal.valueOf(mallProductVO.getCount().intValue()));
                    continue;
                }
                count[0] = PriceUtils.add((BigDecimal)count[0], (BigDecimal)mallProductVO.getShareAmount());
            }
            if (fullcutVo.getFullClass() == 1 && shoppingcartVO.getPromotions() != null && shoppingcartVO.getPromotions().size() > 0) {
                block2: for (MallPromotionVO mallPromotionVO : shoppingcartVO.getPromotions()) {
                    if (mallPromotionVO.getProductType().equals("4") && detailEntities.stream().filter(c -> c.getGroupType() == 4 && c.getProductId().equals(v.getProduct().getProId())).count() > 0L) {
                        mallPromotionVO.setUseCoupon(fullcutVo.getEnableUseCoupon());
                        break;
                    }
                    if (!mallPromotionVO.getProductType().equals("2")) continue;
                    for (MallProductEntity mallProductEntity : mallPromotionVO.getGroup().getProductList()) {
                        if (detailEntities.stream().filter(c -> c.getGroupType() == 4 && c.getProductId().equals(p.getProId())).count() <= 0L) continue;
                        mallPromotionVO.setUseCoupon(fullcutVo.getEnableUseCoupon());
                        continue block2;
                    }
                }
            }
            for (MallGroupVO mallGroupVO : groups) {
                if (detailEntities.stream().filter(c -> c.getGroupType() == 2 && c.getGroupId().equals(groupVO.getGroupId())).count() <= 0L) continue;
                mallGroupVO.setFullCutId(fullcutVo.getFullCutId());
                mallGroupVO.setUseCoupon(fullcutVo.getEnableUseCoupon());
                if (fullcutVo.getType().intValue() == FullCutTypeEnum.product_num.getValue() || fullcutVo.getType().intValue() == FullCutTypeEnum.amount_and_num.getValue()) {
                    count[0] = PriceUtils.add((BigDecimal)count[0], (BigDecimal)BigDecimal.valueOf(mallGroupVO.getCount().intValue()));
                    continue;
                }
                count[0] = PriceUtils.add((BigDecimal)count[0], (BigDecimal)mallGroupVO.getShareAmount());
            }
        }
        this.logger.info("\u67e5\u8be2\u6ee1\u51cf\u4fe1\u606f:{},\u91d1\u989d:{},\u6570\u91cf:{}", new Object[]{fullcutVo.toString(), count[0], count[0].intValue()});
        MallFullCutNumberVo cutNumberVo = this.calculateFullCutAmount(fullcutVo, count[0], count[0].intValue());
        if (fullcutVo.getType().intValue() == FullCutTypeEnum.product_num.getValue() || fullcutVo.getType().intValue() == FullCutTypeEnum.order_amount.getValue() || fullcutVo.getType().intValue() == FullCutTypeEnum.product_num_discount.getValue() || fullcutVo.getType().intValue() == FullCutTypeEnum.order_amount_discount.getValue()) {
            if (cutNumberVo.getFullNumber().compareTo(BigDecimal.ZERO) > 0 && cutNumberVo.getCutNumber() > 0) {
                return true;
            }
        } else if (fullcutVo.getType().intValue() == FullCutTypeEnum.amount_and_num.getValue()) {
            return count[0].intValue() == fullcutVo.getLimitCount().intValue();
        }
        return false;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallFreeService.getEnableFullcutDetail", expiration=120)
    public BaseJsonVo getEnableFullcutDetail(@ParameterValueKeyProvider String bindCode) {
        BaseJsonVo rs = this.getEnableFullcut(bindCode);
        if (rs.isSuccess()) {
            MallFullcutVo vo = (MallFullcutVo)rs.getValue();
            vo.setTypeName(FullCutTypeEnum.getName(vo.getType()));
            List<MallFullcutDetailEntity> ls = this.mallFullcutDetailService.getFullcutDetails(vo.getFullCutId());
            if (CollectionUtils.isNotEmpty(ls)) {
                ArrayList<MallProductVO> productVOs = new ArrayList();
                ArrayList<MallGroupVO> groupVOS = new ArrayList();
                for (MallFullcutDetailEntity mallFullcutDetailEntity : ls) {
                    BaseJsonVo<MallProductVO> sr;
                    if (mallFullcutDetailEntity.getGroupType().intValue() == SalesTypeEnum.SALES_PRODUCT.getValue()) {
                        sr = this.productService.buildProductVO(mallFullcutDetailEntity.getProductId(), 1, null, null, null, null, true, true, null, null, "C");
                        if (!sr.isSuccess()) continue;
                        if (((MallProductVO)sr.getValue()).getFactPrice().compareTo(BigDecimal.ZERO) > 0) {
                            ((MallProductVO)sr.getValue()).setFactPrice(((MallProductVO)sr.getValue()).getFactPrice().setScale(1, RoundingMode.HALF_UP));
                            productVOs.add((MallProductVO)sr.getValue());
                            continue;
                        }
                        this.logger.info("\u8d60\u54c1:{},\u91d1\u989d:{},\u4e0d\u6dfb\u52a0", (Object)((MallProductVO)sr.getValue()).getProName(), (Object)((MallProductVO)sr.getValue()).getFactPrice());
                        continue;
                    }
                    if (mallFullcutDetailEntity.getGroupType().intValue() != SalesTypeEnum.SALES_GROUP.getValue() || !(sr = this.groupInterface.buildGroupVO(mallFullcutDetailEntity.getGroupId(), 1, null, null)).isSuccess()) continue;
                    ((MallGroupVO)sr.getValue()).setFactPrice(((MallGroupVO)sr.getValue()).getFactPrice().setScale(1, RoundingMode.HALF_UP));
                    groupVOS.add((MallGroupVO)sr.getValue());
                }
                productVOs = productVOs.stream().filter(c -> c.getValid() == true).collect(Collectors.toList());
                groupVOS = groupVOS.stream().filter(c -> c.getValid() == true || c.getFactPrice().compareTo(BigDecimal.ZERO) == 0).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(productVOs) && CollectionUtils.isEmpty(groupVOS)) {
                    rs = BaseJsonVo.error((String)"\u6ca1\u6709\u6dfb\u52a0\u4ea7\u54c1\u6216\u5957\u88c5");
                } else {
                    vo.setProducts(productVOs);
                    vo.setGroups(groupVOS);
                }
            }
        }
        return rs;
    }

    @Override
    public BaseJsonVo checkShoppingcatIsEnableFullCut(MallShoppingcartVO coldChainCart, MallShoppingcartVO nomalTempCart) {
        if (coldChainCart.getOrderSource() != OrderSourceEnum.CART.getValue()) {
            return BaseJsonVo.error((String)"\u975e\u8d2d\u7269\u8f66\u8d2d\u4e70\uff0c\u4e0d\u53c2\u4e0e\u5168\u5c40\u6ee1\u51cf");
        }
        List<MallFullcutEntity> fullcutEntities = this.mallFullcutService.getShoppingcatEnableFullcut();
        if (CollectionUtils.isNotEmpty(fullcutEntities)) {
            ArrayList<MallProductVO> coldProductVOS = new ArrayList<MallProductVO>();
            ArrayList<MallProductVO> normalProductVOS = new ArrayList<MallProductVO>();
            BigDecimal coldFullCutAmount = BigDecimal.ZERO;
            BigDecimal normalFullCutAmount = BigDecimal.ZERO;
            if (coldChainCart.getProductsPool() != null && coldChainCart.getProductsPool().size() > 0) {
                coldProductVOS.addAll(coldChainCart.getProductsPool().stream().filter(c -> c.getShareAmount().doubleValue() > 0.0).collect(Collectors.toList()));
            }
            if (nomalTempCart.getProductsPool() != null && nomalTempCart.getProductsPool().size() > 0) {
                normalProductVOS.addAll(nomalTempCart.getProductsPool().stream().filter(c -> c.getShareAmount().doubleValue() > 0.0).collect(Collectors.toList()));
            }
            MallFullCutNumberVo cutNumberVo = new MallFullCutNumberVo();
            cutNumberVo.setCutNumber(0);
            cutNumberVo.setFullNumber(BigDecimal.ZERO);
            for (MallFullcutEntity fullcut : fullcutEntities) {
                List<MallFullcutDetailEntity> fullcutDetails = this.mallFullcutDetailService.getFullcutDetails(fullcut.getFullCutId());
                if (coldFullCutAmount.compareTo(BigDecimal.ZERO) == 0 && StringUtils.isEmpty((String)coldChainCart.getBindCode()) && fullcut.getType() == 2) {
                    cutNumberVo = this.calculateFullCutAmount(fullcut, fullcutDetails, coldProductVOS);
                    coldFullCutAmount = cutNumberVo.getFullNumber();
                    coldChainCart.setBindCode(cutNumberVo.getBindCode());
                    String coldTitle = "\u4e0b\u5355\u514d\u90ae\u8d39";
                    if (cutNumberVo.getCurrCutNumber() > 0) {
                        coldChainCart.setFullcutName(cutNumberVo.getFullcutName());
                        coldChainCart.setFullcutRuleName(cutNumberVo.getFullcutRuleName());
                        coldChainCart.setFullcutAmount(BigDecimal.valueOf(cutNumberVo.getCurrCutNumber().intValue()));
                        coldTitle = "\u5df2\u51cf" + cutNumberVo.getCurrCutNumber() + "\u5143";
                        coldChainCart.setFullCutNotice(coldTitle);
                        if (fullcut.getDoubleFreeGift() == 0) {
                            this.logger.info("\u6ee1\u51cf\uff1a{},\u4e0d\u53e0\u52a0\u8d60\u54c1,\u8d2d\u7269\u8f66\u8d60\u54c1\u6e05\u7a7a", (Object)fullcut.getFullCutName());
                            coldChainCart.setFrees(new ArrayList<MallFreeVO>());
                        }
                    }
                    if (coldFullCutAmount.compareTo(BigDecimal.ZERO) > 0) {
                        coldChainCart.setFullCutNotice(coldTitle + "\uff0c\u518d\u8d2d" + cutNumberVo.getFullNumber() + "\u5143\u53ef\u51cf" + cutNumberVo.getCutNumber() + "\u5143");
                        continue;
                    }
                }
                if (normalFullCutAmount.compareTo(BigDecimal.ZERO) != 0 || !StringUtils.isEmpty((String)nomalTempCart.getBindCode()) || fullcut.getType() != 2) continue;
                cutNumberVo = this.calculateFullCutAmount(fullcut, fullcutDetails, normalProductVOS);
                normalFullCutAmount = cutNumberVo.getFullNumber();
                nomalTempCart.setBindCode(cutNumberVo.getBindCode());
                String normalTitle = "\u4e0b\u5355\u514d\u90ae\u8d39";
                if (cutNumberVo.getCurrCutNumber() > 0) {
                    nomalTempCart.setFullcutName(cutNumberVo.getFullcutName());
                    nomalTempCart.setFullcutRuleName(cutNumberVo.getFullcutRuleName());
                    nomalTempCart.setFullcutAmount(BigDecimal.valueOf(cutNumberVo.getCurrCutNumber().intValue()));
                    normalTitle = "\u5df2\u51cf" + cutNumberVo.getCurrCutNumber() + "\u5143";
                    nomalTempCart.setFullCutNotice(normalTitle);
                    if (fullcut.getDoubleFreeGift() == 0) {
                        this.logger.info("\u6ee1\u51cf\uff1a{},\u4e0d\u53e0\u52a0\u8d60\u54c1,\u8d2d\u7269\u8f66\u8d60\u54c1\u6e05\u7a7a", (Object)fullcut.getFullCutName());
                        nomalTempCart.setFrees(new ArrayList<MallFreeVO>());
                    }
                }
                if (normalFullCutAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                nomalTempCart.setFullCutNotice(normalTitle + "\uff0c\u518d\u8d2d" + cutNumberVo.getFullNumber() + "\u5143\u53ef\u51cf" + cutNumberVo.getCutNumber() + "\u5143");
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private MallFullCutNumberVo calculateFullCutAmount(MallFullcutEntity fullcut, List<MallFullcutDetailEntity> fullcutDetails, List<MallProductVO> productVOS) {
        List fullCutNumberVos;
        BigDecimal fullCutAmount = BigDecimal.ZERO;
        if (fullcut.getDoublePromotion() == 0) {
            productVOS = productVOS.stream().filter(c -> StringUtils.isEmpty((String)c.getPromotionId())).collect(Collectors.toList());
        }
        for (MallProductVO productVO : productVOS) {
            if (fullcutDetails.stream().filter(c -> c.getGroupType() == 4 && c.getProductId().equals(productVO.getProId())).count() <= 0L) continue;
            fullCutAmount = fullCutAmount.add(productVO.getShareAmount());
        }
        BigDecimal fullCutAmountTmp = fullCutAmount;
        String bindCode = "";
        if (fullCutAmount.doubleValue() > 0.0 && StringUtils.isNotEmpty((String)fullcut.getFullCutNumbers()) && (fullCutNumberVos = JsonUtils.getListByArray(MallFullCutNumberVo.class, (String)fullcut.getFullCutNumbers())).size() > 0) {
            fullCutNumberVos = fullCutNumberVos.stream().sorted(Comparator.comparing(MallFullCutNumberVo::getFullNumber)).collect(Collectors.toList());
            Optional<MallFullCutNumberVo> bal = fullCutNumberVos.stream().filter(c -> c.getFullNumber().compareTo(fullCutAmountTmp) > 0).findFirst();
            List curbal = fullCutNumberVos.stream().filter(c -> c.getFullNumber().compareTo(fullCutAmountTmp) <= 0).collect(Collectors.toList());
            if (curbal.size() > 0) {
                bindCode = fullcut.getActiveNo();
                if (bal.isPresent()) {
                    bal.get().setCurrCutNumber(((MallFullCutNumberVo)curbal.get(curbal.size() - 1)).getCutNumber());
                    bal.get().setFullcutName(fullcut.getFullCutName());
                    bal.get().setFullcutRuleName(fullcut.getCutRuleName());
                } else {
                    MallFullCutNumberVo cutNumberVo = new MallFullCutNumberVo();
                    cutNumberVo.setCutNumber(0);
                    cutNumberVo.setFullNumber(BigDecimal.ZERO);
                    cutNumberVo.setBindCode(bindCode);
                    cutNumberVo.setCurrCutNumber(((MallFullCutNumberVo)curbal.get(curbal.size() - 1)).getCutNumber());
                    return cutNumberVo;
                }
            }
            if (bal.isPresent()) {
                bal.get().setFullNumber(PriceUtils.format((BigDecimal)bal.get().getFullNumber().subtract(fullCutAmount)));
                bal.get().setBindCode(bindCode);
                return bal.get();
            }
        }
        MallFullCutNumberVo cutNumberVo = new MallFullCutNumberVo();
        cutNumberVo.setCutNumber(0);
        cutNumberVo.setFullNumber(BigDecimal.ZERO);
        cutNumberVo.setBindCode(bindCode);
        return cutNumberVo;
    }

    @Override
    @ReadThroughAssignCache(assignedKey="list", namespace="MallFullcutService.getShoppingcatEnableFullcut", expiration=600)
    public List<MallFullcutEntity> getShoppingcatEnableFullcut() {
        List<MallFullcutEntity> fullcuts = this.fullcutMapper.getGlobalSingleEntityByTime(DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"));
        if (fullcuts.size() == 0) {
            return new ArrayList<MallFullcutEntity>();
        }
        ArrayList<MallFullcutEntity> removeList = new ArrayList<MallFullcutEntity>();
        for (MallFullcutEntity fullcut : fullcuts) {
            String activeNo = this.activeInterface.getActiveNoByBindCode(fullcut.getActiveNo());
            if (this.activeInterface.checkActiveEnable(activeNo).isSuccess()) continue;
            removeList.add(fullcut);
        }
        if (removeList.size() > 0) {
            fullcuts.removeAll(removeList);
        }
        return fullcuts;
    }

    @Override
    public MallFullCutNumberVo calculateFullCutAmount(MallFullcutVo fullcut, BigDecimal amount, Integer quantity) {
        if (StringUtils.isNotEmpty((String)fullcut.getFullCutNumbers())) {
            Optional<MallFullCutNumberVo> curbal;
            BigDecimal fullCutAmountTmp = fullcut.getType().intValue() == FullCutTypeEnum.product_num.getValue() || fullcut.getType().intValue() == FullCutTypeEnum.product_num_discount.getValue() ? BigDecimal.valueOf(quantity.intValue()) : amount;
            List fullCutNumberVos = JsonUtils.getListByArray(MallFullCutNumberVo.class, (String)fullcut.getFullCutNumbers());
            if (fullCutNumberVos.size() > 0 && (curbal = (fullCutNumberVos = fullCutNumberVos.stream().sorted(Comparator.comparing(MallFullCutNumberVo::getFullNumber).reversed()).collect(Collectors.toList())).stream().filter(c -> c.getFullNumber().compareTo(fullCutAmountTmp) <= 0).findFirst()).isPresent()) {
                return curbal.get();
            }
        }
        MallFullCutNumberVo cutNumberVo = new MallFullCutNumberVo();
        cutNumberVo.setCutNumber(0);
        cutNumberVo.setFullNumber(BigDecimal.ZERO);
        return cutNumberVo;
    }
}

