/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallGroupProductMapper;
import cc.lechun.mall.dao.sales.MallProductGroupMapper;
import cc.lechun.mall.dao.sales.MallSaleRecommendMapper;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.sales.MallGroupProductEntity;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallIndexGroupVo;
import cc.lechun.mall.entity.sales.MallPriceVO;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallSaleRecommendEntity;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallGroupService
extends BaseService
implements MallGroupInterface {
    @Autowired
    MallProductGroupMapper groupMapper;
    @Autowired
    MallGroupProductMapper groupProductMapper;
    @Autowired
    MallProductInterface productService;
    @Autowired
    MallProductPicInterface picService;
    @Autowired
    MallSaleRecommendMapper saleRecommendMapper;
    @Autowired
    MallVipInterface vipInterface;
    @Autowired
    MallPriceCalcInterface priceCalcInterface;

    @Override
    public int getGroupDeliveryType(String groupId) {
        List<MallGroupProductEntity> list = this.getGroupProducts(groupId);
        for (int i = 0; i < list.size(); ++i) {
            MallProductEntity productEntity = this.productService.getProduct(list.get(i).getProId());
            if (productEntity == null) {
                this.logger.info("\u5957\u88c5{}\u5546\u54c1id{}\u4e0d\u5b58\u5728,groupId:{}", (Object)groupId, (Object)list.get(i).getProId());
                continue;
            }
            if (productEntity.getTransportType() != 2 && productEntity.getTransportType() != 3) continue;
            return productEntity.getTransportType();
        }
        return 1;
    }

    @Override
    public List<MallProductGroupEntity> findEnnableGroup(Integer platformGroupId) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        MallProductGroupEntity searchParam = new MallProductGroupEntity();
        searchParam.setPlatformGroupId(platformGroupId);
        searchParam.setStatus(1);
        return this.groupMapper.getList(searchParam);
    }

    @ReadThroughSingleCache(namespace="MallGroupService.buildGroupVO", expiration=120)
    public BaseJsonVo<MallGroupVO> buildGroupVO(@ParameterValueKeyProvider(order=0) String groupId, @ParameterValueKeyProvider(order=1) Integer quantity, String promotionId, Boolean checked) {
        BaseJsonVo sr = BaseJsonVo.success((Object)"");
        MallGroupVO vo = new MallGroupVO();
        MallProductGroupEntity entity = (MallProductGroupEntity)this.groupMapper.selectByPrimaryKey((Serializable)((Object)groupId));
        if (entity == null) {
            sr.setError("\u4e0d\u5b58\u5728\u7684\u5957\u88c5ID");
            return sr;
        }
        try {
            ObjectConvert.fatherConvertToChild((Object)entity, (Object)vo);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            sr.setError("\u5546\u54c1\u4fe1\u606f\u9519\u8bef");
            return sr;
        }
        vo.setGroupPic(this.picService.getProductPicUrlMap(entity.getGroupId(), SalesTypeEnum.SALES_GROUP.getValue()));
        vo.setCount(quantity);
        vo.setShort(false);
        vo.setSoldOut(false);
        vo.setGroupId(groupId);
        vo.setPromotionId(promotionId);
        vo.setShoppingcartCheck(checked);
        vo.setFactPrice(PriceUtils.format((BigDecimal)entity.getSalePrice()));
        vo.setUseCoupon(0);
        ArrayList<MallProductVO> proList = new ArrayList<MallProductVO>();
        List<MallGroupProductEntity> entities = this.groupProductMapper.getGroupProduct(groupId);
        if (entities == null || entities.size() == 0) {
            return BaseJsonVo.error((String)("\u5957\u88c5" + entity.getGroupName() + "\u6ca1\u6709\u914d\u7f6e\u5546\u54c1"));
        }
        for (MallGroupProductEntity mallGroupProductEntity : entities) {
            BaseJsonVo<MallProductVO> buildProductVOsr = this.productService.buildProductVO(mallGroupProductEntity.getProId(), mallGroupProductEntity.getProCount(), groupId, null, null, null, false, checked, null, null);
            if (buildProductVOsr.isSuccess()) {
                MallProductVO proVo = (MallProductVO)buildProductVOsr.getValue();
                if (vo.getSplitPriceMode() == 1) {
                    proVo.setProPrice(PriceUtils.format((BigDecimal)mallGroupProductEntity.getProPrice()).toString());
                }
                if (!proVo.getValid().booleanValue()) {
                    vo.setValid(false);
                    vo.setInvalidReason(proVo.getProName() + proVo.getInvalidReason());
                    vo.setShoppingcartCheck(false);
                }
                proList.add(proVo);
                continue;
            }
            return buildProductVOsr;
        }
        vo.setProductList(proList);
        vo.setSelfModeType(this.productService.getProductSelfMode(proList));
        BaseJsonVo checkResult = this.checkGroup(vo);
        if (checkResult.isSuccess()) {
            vo.setValid(true);
        } else {
            vo.setValid(false);
            vo.setInvalidReason(checkResult.getError_msg());
            vo.setShoppingcartCheck(false);
        }
        sr.setValue((Object)vo);
        return sr;
    }

    @Override
    public Map<String, List<String>> getGroupPicUrlMap(String groupId) {
        return this.picService.getProductPicUrlMap(groupId, SalesTypeEnum.SALES_GROUP.getValue());
    }

    @Override
    @ReadThroughSingleCache(namespace="MallGroupService.buildGroupVO", expiration=120)
    public BaseJsonVo<MallGroupVO> buildGroupVO(@ParameterValueKeyProvider(order=0) String groupId, @ParameterValueKeyProvider(order=1) Integer quantity, @ParameterValueKeyProvider(order=2) Boolean checked) {
        return this.buildGroupVO(groupId, quantity, null, checked);
    }

    @Override
    public BaseJsonVo checkGroup(MallGroupVO groupVO) {
        return this.checkGroup(groupVO, groupVO.getCount(), groupVO.getProductList());
    }

    private BaseJsonVo checkGroup(MallProductGroupEntity groupEntity, int buyCount, List<MallProductVO> productVOs) {
        if (groupEntity == null) {
            return BaseJsonVo.error((String)String.format("\u5957\u88c5\u4e0d\u5b58\u5728", new Object[0]));
        }
        if (groupEntity.getStatus() != 1) {
            this.logger.error("\u5957\u88c5:{} \u5df2\u4e0b\u67b6", (Object)groupEntity.getGroupName());
            return BaseJsonVo.error((String)"\u7ec4\u5408\u5546\u54c1\u5df2\u4e0b\u67b6");
        }
        if (groupEntity.getDeleteTime() != null) {
            return BaseJsonVo.error((String)String.format("\u5957\u88c5%s,\u5df2\u5220\u9664", groupEntity.getGroupName()).toString());
        }
        if (groupEntity.getLimitBuyCount() != 0 && buyCount > groupEntity.getLimitBuyCount()) {
            return BaseJsonVo.error((String)String.format("\u4eb2\u7231\u54d2\uff0c%s\u592a\u706b\u7206\u88ab\u62a2\u8d2d\u7a7a\u5566\uff0c\u522b\u7740\u6025\uff5e\u6211\u4eec\u5546\u57ce\u8fd8\u6709\u66f4\u591a\u5b9a\u5236\u4f18\u60e0\u4f9b\u4f60\u6311\u9009\u54e6\uff01", groupEntity.getGroupName()).toString());
        }
        if (groupEntity.getBalanceCount() < buyCount) {
            return BaseJsonVo.error((String)String.format("\u4eb2\u7231\u54d2\uff0c%s\u592a\u706b\u7206\u88ab\u62a2\u8d2d\u7a7a\u5566\uff0c\u522b\u7740\u6025\uff5e\u6211\u4eec\u5546\u57ce\u8fd8\u6709\u66f4\u591a\u5b9a\u5236\u4f18\u60e0\u4f9b\u4f60\u6311\u9009\u54e6\uff01", groupEntity.getGroupName()).toString());
        }
        if (productVOs != null) {
            for (MallProductVO proVo : productVOs) {
                if (proVo.getValid().booleanValue()) continue;
                return BaseJsonVo.error((String)String.format("\u5957\u88c5%s,%s", groupEntity.getGroupName(), proVo.getInvalidReason()));
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public int updateLimitCountByPrimaryKey(String groupId, int count) {
        Integer i = this.groupMapper.updateLimitCountByPrimaryKey(groupId, count);
        return i == null ? 0 : i;
    }

    @Override
    public List<Map> findRecommendGroups(Integer platformGroupId) {
        ArrayList<Map> rtnList = new ArrayList<Map>();
        MallSaleRecommendEntity searchParam = new MallSaleRecommendEntity();
        searchParam.setPlatformGroupId(platformGroupId);
        searchParam.setStatus(1);
        searchParam.setSaleType(SalesTypeEnum.SALES_GROUP.getValue());
        List sales = this.saleRecommendMapper.getList(searchParam);
        sales.forEach(entity -> {
            BaseJsonVo<MallGroupVO> result = this.buildGroupVO(entity.getSaleId(), 1, null, false);
            if (result.isSuccess() && ((MallGroupVO)result.getValue()).getValid().booleanValue()) {
                Map group = ObjectConvert.objectWithSuperConvertToObjectMap((Object)result.getValue());
                group.put("recommendReason", entity.getRecommendReason());
                rtnList.add(group);
            }
        });
        return rtnList;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallGroupService.getGroup", expiration=120)
    public MallProductGroupEntity getGroup(@ParameterValueKeyProvider String groupId) {
        return (MallProductGroupEntity)this.groupMapper.selectByPrimaryKey((Serializable)((Object)groupId));
    }

    @Override
    public BaseJsonVo buildIndexGroupVo(String groupId, String customerId) {
        MallProductGroupEntity groupEntity = this.getGroup(groupId);
        BaseJsonVo baseJsonVo = this.checkGroup(groupEntity, 1, null);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        MallIndexGroupVo groupVo = new MallIndexGroupVo();
        groupVo.setGroupId(groupEntity.getGroupId());
        groupVo.setGroupName(groupEntity.getGroupName());
        groupVo.setGroupTagsName(groupEntity.getGroupOtherName());
        groupVo.setGroupUnit(groupEntity.getGroupUnit());
        groupVo.setPrice(groupEntity.getPrice());
        groupVo.setSalePrice(groupEntity.getSalePrice());
        groupVo.setSummary(groupEntity.getSummary());
        groupVo.setUseCoupon(groupEntity.getUseCoupon());
        groupVo.setIsvipday(this.vipInterface.isVipDayNow() != false ? "isvipday" : "notvipday");
        groupVo.setProSpec(groupEntity.getSpec());
        MallPriceVO priceVO = this.priceCalcInterface.getPrice(OrderSourceEnum.CART, SalesTypeEnum.SALES_GROUP, groupVo.getGroupId(), customerId, 0);
        if (priceVO != null && priceVO.getFactPrice() != null) {
            groupVo.setSalePrice(priceVO.getFactPrice());
            groupVo.setPrice(priceVO.getOriginPrice());
        }
        groupVo.setItemType(SalesTypeEnum.SALES_GROUP.getValue());
        groupVo.setPicMap(this.picService.getProductPicUrlMap(groupId, SalesTypeEnum.SALES_GROUP.getValue()));
        return BaseJsonVo.success((Object)groupVo);
    }

    @Override
    @ReadThroughSingleCache(namespace="MallGroupService.getGroupProducts", expiration=80)
    public List<MallGroupProductEntity> getGroupProducts(@ParameterValueKeyProvider String groupId) {
        return this.groupProductMapper.getListByParam(groupId);
    }

    @Override
    public List<MallSelectDataVo> getOptionGroupList(Integer platformGroupId) {
        return this.groupMapper.getOptionGroupList(platformGroupId);
    }
}

