/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.dao.sales.MallProductCategoryMapper;
import cc.lechun.mall.entity.sales.MallProductCategoryEntity;
import cc.lechun.mall.iservice.sales.MallProductCategoryInterface;
import cc.lechun.mall.service.youshu.ProductService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughAssignCache;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import weixin.popular.bean.youshu.product.ProductCategoryInfo;

@Service
public class MallProductCategoryService
implements MallProductCategoryInterface {
    @Autowired
    private MallProductCategoryMapper categoryMapper;
    @Lazy
    @Autowired
    ProductService productService;

    @Override
    @ReadThroughSingleCache(namespace="MallProductCategoryService.getProductCategory", expiration=3600)
    public MallProductCategoryEntity getProductCategory(@ParameterValueKeyProvider String categoryId) {
        return (MallProductCategoryEntity)this.categoryMapper.selectByPrimaryKey((Serializable)((Object)categoryId));
    }

    @Override
    public List<String> getProductCategoryList(String categoryId, List<String> categoryList, List<MallProductCategoryEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            list = ((MallProductCategoryService)SpringContextUtil.getBean(this.getClass())).getCategoryList();
        }
        for (MallProductCategoryEntity item : list) {
            if (!Objects.equals(item.getCategoryId(), categoryId)) continue;
            categoryList.add(item.getCategoryId());
        }
        MallProductCategoryEntity mallProductCategoryEntity = (MallProductCategoryEntity)this.categoryMapper.selectByPrimaryKey((Serializable)((Object)categoryId));
        if (mallProductCategoryEntity == null || Objects.equals(mallProductCategoryEntity.getParentId(), "0")) {
            return categoryList;
        }
        categoryList.add(mallProductCategoryEntity.getCategoryId());
        return this.getProductCategoryList(mallProductCategoryEntity.getParentId(), categoryList, list);
    }

    @Override
    public BaseJsonVo findAllCategory(String token) {
        BaseJsonVo serviceResult = BaseJsonVo.success((Object)"");
        List<MallProductCategoryEntity> list = this.categoryMapper.findAllCategory(token);
        if (list != null && list.size() > 0) {
            serviceResult.setValue(list);
        } else {
            serviceResult.setError("\u67e5\u65e0\u7ed3\u679c");
        }
        return serviceResult;
    }

    @Override
    @ReadThroughAssignCache(assignedKey="List", namespace="MallProductCategoryService.getCategoryList", expiration=7200)
    public List<MallProductCategoryEntity> getCategoryList() {
        MallProductCategoryEntity categoryEntity = new MallProductCategoryEntity();
        return this.categoryMapper.getCategoryList(categoryEntity);
    }

    @Override
    public boolean canContail(String categoryId, List<String> categoryList) {
        if (categoryList.stream().allMatch(item -> item.equals(categoryId))) {
            return true;
        }
        List<MallProductCategoryEntity> list = this.getCategoryList();
        List<String> children = this.getChildRen(categoryId, list);
        for (String item2 : categoryList) {
            if (children.size() <= 0 || !children.stream().allMatch(category -> category.equals(item2))) continue;
            return true;
        }
        return false;
    }

    private List<String> getChildRen(String categoryId, List<MallProductCategoryEntity> list) {
        List resultList = list.stream().filter(category -> category.getParentId().equals(categoryId)).collect(Collectors.toList());
        if (resultList != null && resultList.size() > 0) {
            return resultList.stream().map(MallProductCategoryEntity::getCategoryId).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public BaseJsonVo importYouShu(Integer platformGroupId) {
        List<MallProductCategoryEntity> list = this.getCategoryList();
        if (list.size() > 0) {
            list.forEach(productCategory -> {
                ProductCategoryInfo productCategoryInfo = new ProductCategoryInfo();
                ProductCategoryInfo.ProductCategory category = new ProductCategoryInfo.ProductCategory();
                category.setCategory_name(productCategory.getCategoryName());
                category.setCategory_type(Integer.valueOf(2));
                category.setExternal_category_id(productCategory.getCategoryId());
                category.setExternal_parent_category_id(productCategory.getParentId());
                category.setIs_root(productCategory.getParentId().equals("0"));
                category.setCategory_level(Integer.valueOf(productCategory.getParentId().equals("0") ? 1 : 2));
                ArrayList<ProductCategoryInfo.ProductCategory> result = new ArrayList<ProductCategoryInfo.ProductCategory>();
                result.add(category);
                productCategoryInfo.setCategories(result);
                this.productService.addCategory(productCategoryInfo);
            });
        }
        return BaseJsonVo.success((Object)"");
    }
}

