/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.shoppingcart;

import cc.lechun.common.enums.common.StatusEnum;
import cc.lechun.common.enums.customer.VipRightTypeEnum;
import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.enums.platform.PlatFormGroupEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.prepay.PrepayCardItemEntity;
import cc.lechun.mall.entity.prepay.PrepayCardTypeEnum;
import cc.lechun.mall.entity.sales.FullCutTypeEnum;
import cc.lechun.mall.entity.sales.MallExchangeProductVO;
import cc.lechun.mall.entity.sales.MallExchangeVO;
import cc.lechun.mall.entity.sales.MallFreeVO;
import cc.lechun.mall.entity.sales.MallFullCutNumberVo;
import cc.lechun.mall.entity.sales.MallFullcutDetailEntity;
import cc.lechun.mall.entity.sales.MallFullcutVo;
import cc.lechun.mall.entity.sales.MallGroupProductEntity;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallPriceVO;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallProductPriceEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.sales.MallRecommendCardVO;
import cc.lechun.mall.entity.sales.MallRegularEntity;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.entity.vip.MallVipRightsEntity;
import cc.lechun.mall.entity.vip.SimpleVipVo;
import cc.lechun.mall.entity.vip.VipLevelTypeEnum;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardItemInterface;
import cc.lechun.mall.iservice.sales.MallFullcutDetailInterface;
import cc.lechun.mall.iservice.sales.MallFullcutInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPriceInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.sales.MallRegularInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class MallPriceCalcService
extends BaseService
implements MallPriceCalcInterface {
    @Autowired
    private MallGroupInterface groupService;
    @Autowired
    private MallFullcutInterface fullcutService;
    @Autowired
    private MallFullcutDetailInterface fullcutDetailService;
    @Autowired
    private MallProductInterface productService;
    @Autowired
    private MallRegularInterface regularService;
    @Autowired
    private MallVipInterface vipService;
    @Autowired
    private MallPromotionInterface promotionService;
    @Autowired
    private MallPromotionProductInterface promotionProductService;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    @Lazy
    private PrepayCardItemInterface prepayCardItemInterface;
    @Autowired
    private MallProductPriceInterface productPriceInterface;

    @Override
    public void calcShoppingcartVO(List<MallShoppingcartVO> mallShoppingcartVOS) {
        Integer orderSource = mallShoppingcartVOS.get(0).getOrderSource();
        SimpleVipVo customerVip = this.getMallCustomerVip(orderSource, mallShoppingcartVOS.get(0).getCustomerId());
        this.logger.info("\u7528\u6237:{},\u8ba1\u7b97\u5546\u54c1\u4ef7\u683c:{}", (Object)mallShoppingcartVOS.get(0).getCustomerId(), (Object)customerVip.toString());
        for (MallShoppingcartVO cartVO : mallShoppingcartVOS) {
            this.calcProduct(cartVO, mallShoppingcartVOS.size() == 1 ? mallShoppingcartVOS.get(0).getDeliverCount().intValue() : mallShoppingcartVOS.size(), customerVip);
            this.calcGroup(cartVO);
            this.calcPromotion(cartVO, orderSource, customerVip);
            this.totalCartVo(cartVO);
            if (OrderSourceEnum.CART.getValue() != orderSource.intValue() || !StringUtils.isNotEmpty((String)cartVO.getBindCode())) continue;
            ArrayList<MallShoppingcartVO> fullCart = new ArrayList<MallShoppingcartVO>();
            fullCart.add(cartVO);
            this.calcFullCut(fullCart);
        }
        if (OrderSourceEnum.FULLCUT.getValue() == orderSource.intValue()) {
            this.calcFullCut(mallShoppingcartVOS);
        }
    }

    private void calcProduct(MallShoppingcartVO cartVO, int deliverCount, SimpleVipVo customerVip) {
        if (cartVO == null || cartVO.getProducts() == null || cartVO.getProducts().size() == 0) {
            return;
        }
        this.logger.info("bindCode:{},orderSource={}", (Object)cartVO.getBindCode(), (Object)cartVO.getOrderSource());
        for (MallProductVO vo : cartVO.getProducts()) {
            MallPriceVO priceVO;
            if (Objects.equals(OrderSourceEnum.CART.getValue(), cartVO.getOrderSource()) || Objects.equals(OrderSourceEnum.Supper_Member.getValue(), cartVO.getOrderSource())) {
                if (StringUtils.isEmpty((String)vo.getFreeId())) {
                    priceVO = this.getPrice(Objects.equals(OrderSourceEnum.CART.getValue(), cartVO.getOrderSource()) ? OrderSourceEnum.CART : OrderSourceEnum.Supper_Member, SalesTypeEnum.SALES_PRODUCT, vo.getProId(), customerVip, 0);
                    if (priceVO != null && priceVO.getOriginPrice() != null) {
                        vo.setProPrice(String.valueOf(priceVO.getOriginPrice()));
                    }
                    if (priceVO != null && priceVO.getFactPrice() != null) {
                        vo.setFactPrice(priceVO.getFactPrice());
                    }
                    if (priceVO != null && priceVO.getVipPrice() != null) {
                        vo.setVipPrice(priceVO.getVipPrice());
                    }
                    if (priceVO != null && priceVO.getVipDiff() != null) {
                        vo.setVipDiff(priceVO.getVipDiff());
                    }
                } else {
                    if (vo.getOriginPrice().compareTo(vo.getFactPrice()) > 0) {
                        vo.setExchangeCutAmount(PriceUtils.subtract((BigDecimal)vo.getOriginPrice(), (BigDecimal)vo.getFactPrice()));
                    }
                    vo.setShareAmount(new BigDecimal(0));
                    vo.setShareCount(0);
                }
            } else if (OrderSourceEnum.LONGPERIOD_BUY.getValue() == cartVO.getOrderSource()) {
                priceVO = this.getPrice(OrderSourceEnum.LONGPERIOD_BUY, SalesTypeEnum.SALES_PRODUCT, vo.getProId(), cartVO.getCustomerId(), deliverCount);
                if (priceVO != null && priceVO.getOriginPrice() != null) {
                    vo.setProPrice(String.valueOf(priceVO.getOriginPrice()));
                }
                if (priceVO != null && priceVO.getFactPrice() != null) {
                    vo.setFactPrice(priceVO.getFactPrice());
                }
            } else if (OrderSourceEnum.RECHANGE_CARD.getValue() == cartVO.getOrderSource()) {
                this.logger.info("bindCode:{},\u5546\u54c1:{},proId:{}", new Object[]{cartVO.getBindCode(), vo.getProName(), vo.getProId()});
                PrepayCardItemEntity prepayCardItemEntity = this.prepayCardItemInterface.getCardItemEntityByBindCode(cartVO.getCustomerId(), cartVO.getBindCode(), SalesTypeEnum.SALES_PRODUCT.getValue(), vo.getProId());
                if (prepayCardItemEntity != null && prepayCardItemEntity.getCardProductId() != null) {
                    vo.setCardFactPrice(prepayCardItemEntity.getSaleValue());
                    vo.setCardOriginPrice(prepayCardItemEntity.getOriginPrice());
                    if (Objects.equals(cartVO.getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Cold.getValue())) || Objects.equals(cartVO.getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Nomal.getValue()))) {
                        vo.setFactPrice(prepayCardItemEntity.getSaleValue());
                        vo.setOriginPrice(prepayCardItemEntity.getOriginPrice());
                    }
                } else {
                    this.logger.error("\u70b9\u5361\u5546\u54c1:{}\u914d\u7f6e\u4e3a\u7a7a", (Object)vo.getProName());
                    throw new RuntimeException("\u5546\u54c1" + vo.getProName() + "\u5df2\u4e0b\u67b6");
                }
                this.logger.info("bindCode:{},\u5546\u54c1:{},\u5361\u5546\u54c1\u539f\u4ef7:{},\u5361\u5546\u54c1\u9500\u552e\u4ef7:{}", new Object[]{cartVO.getBindCode(), vo.getProName(), vo.getCardFactPrice(), vo.getCardOriginPrice()});
            } else if (Objects.equals(OrderSourceEnum.PERIODIC_PURCHASE.getValue(), cartVO.getOrderSource())) {
                this.logger.info("bindCode:{},\u5546\u54c1:{},proId:{}", new Object[]{cartVO.getBindCode(), vo.getProName(), vo.getProId()});
            }
            if (StringUtils.isNotEmpty((String)vo.getGroupId())) {
                List<MallGroupProductEntity> groupProducts = this.groupService.getGroupProducts(vo.getGroupId());
                vo.setFactPrice(groupProducts.stream().filter(pro -> pro.getProId().equals(vo.getProId())).findFirst().get().getProPrice());
            }
            vo.setShareAmount(PriceUtils.multiply((BigDecimal)vo.getFactPrice(), (Integer)vo.getCount()));
            vo.setShareCount(vo.getCount());
        }
    }

    private void calcGroup(MallShoppingcartVO cartVO) {
        if (cartVO == null || cartVO.getGroups() == null || cartVO.getGroups().size() == 0) {
            return;
        }
        List<MallGroupVO> groupList = cartVO.getGroups();
        for (MallGroupVO vo : groupList) {
            if (StringUtils.isEmpty((String)vo.getFreeId())) {
                vo.setFactPrice(PriceUtils.format((BigDecimal)vo.getSalePrice()));
                vo.setShareAmount(PriceUtils.multiply((BigDecimal)vo.getFactPrice(), (Integer)vo.getCount()));
            } else {
                vo.setShareAmount(BigDecimal.ZERO);
                if (vo.getOriginPrice().compareTo(vo.getFactPrice()) > 0) {
                    vo.setExchangeCutAmount(PriceUtils.subtract((BigDecimal)vo.getOriginPrice(), (BigDecimal)vo.getFactPrice()));
                }
            }
            this.setGroupProductPrice(vo);
        }
    }

    private void setGroupProductPrice(MallGroupVO vo) {
        Integer splitPriceMode = vo.getSplitPriceMode();
        if (splitPriceMode == 0) {
            Object originPrice = new BigDecimal("0.00");
            for (MallProductVO productVO : vo.getProductList()) {
                originPrice = PriceUtils.add((BigDecimal)originPrice, (BigDecimal)PriceUtils.multiply((BigDecimal)new BigDecimal(productVO.getProPrice()), (Integer)productVO.getCount()));
            }
            BigDecimal discount = BigDecimal.ONE;
            if (((BigDecimal)originPrice).intValue() != 0) {
                discount = PriceUtils.divide((BigDecimal)vo.getFactPrice(), (BigDecimal)originPrice);
            }
            for (MallProductVO productVO : vo.getProductList()) {
                productVO.setFactPrice(PriceUtils.multiply((BigDecimal)new BigDecimal(productVO.getProPrice()), (BigDecimal)discount));
            }
        } else if (splitPriceMode != 0) {
            for (MallProductVO productVO : vo.getProductList()) {
                productVO.setFactPrice(new BigDecimal(productVO.getProPrice()));
            }
        }
        if (vo.getShareAmount().compareTo(BigDecimal.ZERO) > 0) {
            List result = vo.getProductList().stream().map(c -> PriceUtils.multiply((BigDecimal)c.getFactPrice(), (Integer)c.getCount())).collect(Collectors.toList());
            BigDecimal rate = result.stream().reduce(BigDecimal.ZERO, BigDecimal::add).divide(vo.getShareAmount(), 6, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(vo.getCount().intValue()), 6, RoundingMode.HALF_UP);
            for (MallProductVO productVO : vo.getProductList()) {
                productVO.setFactPrice(PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (BigDecimal)rate));
                productVO.setShareAmount(PriceUtils.multiply((BigDecimal)PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getCount()).multiply(BigDecimal.valueOf(vo.getCount().intValue())), (BigDecimal)rate));
                productVO.setShareCount(vo.getCount() * productVO.getCount());
            }
        }
    }

    private void calcPromotion(MallShoppingcartVO cartVO, int orderSource, SimpleVipVo customerVip) {
        boolean newCard;
        this.logger.info("bindCode:{},orderSource={}", (Object)cartVO.getBindCode(), (Object)orderSource);
        if (cartVO == null || cartVO.getPromotions() == null || cartVO.getPromotions().size() == 0) {
            this.logger.info("bindCode:{},orderSource={}", (Object)cartVO.getBindCode(), (Object)orderSource);
            return;
        }
        List<Object> list = new ArrayList();
        if (Objects.equals(orderSource, OrderSourceEnum.RECHANGE_CARD.getValue())) {
            list = this.prepayCardItemInterface.getCardItemEntityListByBindCode(cartVO.getCustomerId(), cartVO.getBindCode(), SalesTypeEnum.SALES_PROMOTION.getValue());
        }
        List<MallPromotionVO> promotionList = cartVO.getPromotions();
        List<OrderSourceEnum> orderSourceEnumList = OrderSourceEnum.getList();
        OrderSourceEnum orderSourceEnum = Objects.equals(cartVO.getOrderSource(), 0) ? OrderSourceEnum.CART : OrderSourceEnum.getOrderSourceEnum(cartVO.getOrderSource());
        boolean bl = newCard = Objects.equals(cartVO.getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Cold.getValue())) || Objects.equals(cartVO.getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Nomal.getValue()));
        if (orderSource == OrderSourceEnum.PERIODIC_PURCHASE.getValue() || orderSource == OrderSourceEnum.CARD_PREPAY_CHANNEL.getValue() || orderSource == OrderSourceEnum.CARD_PREPAY_TMALL.getValue() || orderSource == OrderSourceEnum.COMMUNITY_GROUP.getValue() || orderSource == OrderSourceEnum.NEW_USER_CUT.getValue() || newCard) {
            orderSourceEnum = orderSourceEnumList.stream().filter(s -> Objects.equals(orderSource, s.getValue())).findFirst().get();
        }
        for (MallPromotionVO vo : promotionList) {
            this.logger.info("orderSource:{},\u5546\u54c1:{},\u5361\u4fc3\u9500\u539f\u4ef7:{},\u5361\u4fc3\u9500\u9500\u552e\u4ef7:{},\u4fc3\u9500\u4ef7:{},\u539f\u4ef7:{}", new Object[]{orderSource, vo.getPromotionName(), vo.getCardFactPrice(), vo.getCardOriginPrice(), vo.getFactPrice(), vo.getOriginPrice()});
            if (Objects.equals(orderSource, OrderSourceEnum.RECHANGE_CARD.getValue())) {
                this.logger.info("bindCode:{},\u4fc3\u9500:{}", (Object)cartVO.getBindCode(), (Object)vo.getPromotionName());
                if (CollectionUtils.isNotEmpty(list)) {
                    Optional<PrepayCardItemEntity> prepayCardItemEntity = list.stream().filter(pp -> Objects.equals(pp.getItemId(), vo.getPromotionId())).findFirst();
                    if (prepayCardItemEntity.isPresent()) {
                        vo.setCardFactPrice(prepayCardItemEntity.get().getSaleValue());
                        vo.setCardOriginPrice(prepayCardItemEntity.get().getOriginPrice());
                        if (Objects.equals(cartVO.getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Cold.getValue())) || Objects.equals(cartVO.getBindCode(), String.valueOf(PrepayCardTypeEnum.new_card_Nomal.getValue()))) {
                            vo.setPromotionPrice(prepayCardItemEntity.get().getSaleValue());
                            vo.setFactPrice(prepayCardItemEntity.get().getSaleValue());
                            vo.setOriginPrice(prepayCardItemEntity.get().getOriginPrice());
                        }
                    } else {
                        this.logger.info("\u70b9\u5361\u4fc3\u9500:{}\u914d\u7f6e\u4e3a\u7a7a", (Object)vo.getPromotionName());
                        throw new RuntimeException("\u4fc3\u9500" + vo.getPromotionName() + "\u5df2\u4e0b\u67b6");
                    }
                    this.logger.info("bindCode:{},\u5546\u54c1:{},\u5361\u4fc3\u9500\u539f\u4ef7:{},\u5361\u4fc3\u9500\u9500\u552e\u4ef7:{},\u4fc3\u9500\u4ef7:{},\u539f\u4ef7:{}", new Object[]{cartVO.getBindCode(), vo.getPromotionName(), vo.getCardFactPrice(), vo.getCardOriginPrice(), vo.getFactPrice(), vo.getOriginPrice()});
                }
            }
            MallPriceVO priceVO = this.getPrice(orderSourceEnum, SalesTypeEnum.SALES_PROMOTION, vo.getPromotionId(), customerVip, 0);
            if (StringUtils.isEmpty((String)vo.getFreeId())) {
                if (priceVO != null && priceVO.getOriginPrice() != null) {
                    vo.setOriginPrice(priceVO.getOriginPrice());
                }
                if (priceVO != null && priceVO.getFactPrice() != null) {
                    vo.setFactPrice(priceVO.getFactPrice());
                }
                if (priceVO != null && priceVO.getVipDiff() != null) {
                    vo.setVipDiff(priceVO.getVipDiff());
                }
                if (priceVO != null && priceVO.getPromotionDiff() != null) {
                    vo.setPromotionDiff(priceVO.getPromotionDiff());
                }
            } else if (vo.getOriginPrice().compareTo(vo.getFactPrice()) > 0) {
                vo.setExchangeCutAmount(PriceUtils.subtract((BigDecimal)vo.getOriginPrice(), (BigDecimal)vo.getFactPrice()));
            }
            if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(vo.getProductType()).intValue() && vo.getProduct() != null) {
                vo.getProduct().setFactPrice(vo.getFactPrice());
                vo.getProduct().setShareAmount(PriceUtils.multiply((BigDecimal)vo.getFactPrice(), (Integer)vo.getCount()));
                vo.getProduct().setShareCount(vo.getCount());
            } else if (SalesTypeEnum.SALES_GROUP.getValue() == Integer.valueOf(vo.getProductType()).intValue() && vo.getGroup() != null) {
                vo.getGroup().setFactPrice(vo.getFactPrice());
                vo.getGroup().setShareAmount(PriceUtils.multiply((BigDecimal)vo.getFactPrice(), (Integer)vo.getCount()));
                this.setGroupProductPrice(vo.getGroup());
            }
            this.logger.info("bindCode:{},\u5546\u54c1:{},\u5361\u4fc3\u9500\u539f\u4ef7:{},\u5361\u4fc3\u9500\u9500\u552e\u4ef7:{},\u4fc3\u9500\u4ef7:{},\u539f\u4ef7:{}", new Object[]{cartVO.getBindCode(), vo.getPromotionName(), vo.getCardFactPrice(), vo.getCardOriginPrice(), vo.getFactPrice(), vo.getOriginPrice()});
        }
    }

    private void calcFullCut(List<MallShoppingcartVO> shoppingcartVOS) {
        BaseJsonVo<MallFullcutVo> jsonVo;
        Boolean isGlobalFullcut = false;
        if (StringUtils.isNotEmpty((String)shoppingcartVOS.get(0).getBindCode()) && (jsonVo = this.fullcutService.getEnableFullcut(shoppingcartVOS.get(0).getBindCode())).isSuccess()) {
            MallFullcutVo fullcutVo = (MallFullcutVo)jsonVo.getValue();
            isGlobalFullcut = fullcutVo.getFullClass() == 1;
            if (fullcutVo != null) {
                BigDecimal facePrice;
                MallFullCutNumberVo numberVo;
                BigDecimal num;
                List<MallFullcutDetailEntity> fullcutDetailEntities = this.fullcutDetailService.getFullcutDetails(fullcutVo.getFullCutId());
                if (CollectionUtils.isEmpty(fullcutDetailEntities)) {
                    return;
                }
                if (!this.fullcutService.checkFullcut(fullcutVo, fullcutDetailEntities, shoppingcartVOS)) {
                    this.logger.info("\u6ee1\u51cf:{},\u7c7b\u578b:{}\u4e0d\u7b26\u5408\u6761\u4ef6", (Object)fullcutVo.getFullCutName(), (Object)FullCutTypeEnum.getName(fullcutVo.getType()));
                    return;
                }
                BigDecimal factPriceSum = BigDecimal.ZERO;
                if (fullcutVo.getType().intValue() == FullCutTypeEnum.amount_and_num.getValue() || fullcutVo.getType().intValue() == FullCutTypeEnum.order_amount_discount.getValue() || fullcutVo.getType().intValue() == FullCutTypeEnum.product_num_discount.getValue()) {
                    factPriceSum = shoppingcartVOS.stream().map(MallShoppingcartVO::getFactPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (fullcutVo.getFullAmout().compareTo(factPriceSum) > 0) {
                        return;
                    }
                }
                int quantity = 0;
                BigDecimal amount = BigDecimal.ZERO;
                ArrayList fullProductVos = new ArrayList();
                ArrayList fullGroupVos = new ArrayList();
                for (MallShoppingcartVO cartVO : shoppingcartVOS) {
                    if (fullcutVo.getDoubleFreeGift() == 0) {
                        this.logger.info("\u6ee1\u51cf\uff1a{},\u4e0d\u53e0\u52a0\u8d60\u54c1,\u8d60\u54c1\u6e05\u7a7a", (Object)fullcutVo.getFullCutName());
                        cartVO.setFrees(new ArrayList<MallFreeVO>());
                    }
                    if (fullcutVo.getDoublePromotion() == 0 && !isGlobalFullcut.booleanValue()) {
                        cartVO.setPromotionDiffPrice(BigDecimal.ZERO);
                        cartVO.setPromotions(new ArrayList<MallPromotionVO>());
                        cartVO.getProductsPool().removeAll(cartVO.getProductsPool().stream().filter(c -> StringUtils.isNotEmpty((String)c.getPromotionId())).collect(Collectors.toList()));
                    }
                    if (cartVO.getIsfullCutFree() != 0) continue;
                    if (isGlobalFullcut.booleanValue()) {
                        for (MallProductVO productVO : cartVO.getProductsPool()) {
                            productVO.setFullcutAmount(BigDecimal.ZERO);
                            productVO.setFullcutCount(0);
                        }
                        if (fullcutVo.getDoublePromotion() == 0) {
                            fullProductVos.addAll(cartVO.getProductsPool().stream().filter(c -> c.getFullCutId() != null && StringUtils.isEmpty((String)c.getPromotionId())).collect(Collectors.toList()));
                        } else {
                            fullProductVos.addAll(cartVO.getProductsPool().stream().filter(c -> c.getFullCutId() != null).collect(Collectors.toList()));
                        }
                    } else {
                        for (MallProductVO productVO : cartVO.getProducts()) {
                            productVO.setFullcutAmount(BigDecimal.ZERO);
                            productVO.setFullcutCount(0);
                        }
                        fullProductVos.addAll(cartVO.getProducts().stream().filter(c -> c.getFullCutId() != null).collect(Collectors.toList()));
                    }
                    for (MallGroupVO groupVO : cartVO.getGroups()) {
                        groupVO.setFullcutAmount(BigDecimal.ZERO);
                        groupVO.setFullcutCount(0);
                    }
                    fullGroupVos.addAll(cartVO.getGroups().stream().filter(c -> c.getFullCutId() != null).collect(Collectors.toList()));
                    cartVO.setFullcutName(fullcutVo.getFullCutName());
                    cartVO.setFullcutRuleName(fullcutVo.getCutRuleName());
                }
                if (fullProductVos != null) {
                    quantity = fullProductVos.stream().mapToInt(c -> c.getCount()).sum();
                    amount = BigDecimal.valueOf(fullProductVos.stream().mapToDouble(c -> c.getShareAmount().doubleValue()).sum());
                }
                if (fullGroupVos != null && !isGlobalFullcut.booleanValue()) {
                    quantity += fullGroupVos.stream().mapToInt(c -> c.getCount()).sum();
                    amount = BigDecimal.valueOf(fullGroupVos.stream().mapToDouble(c -> c.getShareAmount().doubleValue()).sum()).add(amount);
                }
                if ((num = BigDecimal.valueOf((numberVo = this.fullcutService.calculateFullCutAmount(fullcutVo, amount, quantity)).getCutNumber().intValue())).doubleValue() > 0.0) {
                    if (fullcutVo.getCutRule() == 1) {
                        Comparator comparator = (h1, h2) -> h1.getFactPrice().compareTo(h2.getFactPrice());
                        fullProductVos.sort(comparator.reversed());
                        String[] comparator1 = (h1, h2) -> h1.getFactPrice().compareTo(h2.getFactPrice());
                        fullGroupVos.sort(comparator1.reversed());
                    }
                    if (fullcutVo.getCutRule() == 2) {
                        fullProductVos.sort((v1, v2) -> v1.getFactPrice().compareTo(v2.getFactPrice()));
                        fullGroupVos.sort((v1, v2) -> v1.getFactPrice().compareTo(v2.getFactPrice()));
                    }
                    if (fullcutVo.getCutRule() == 3) {
                        Collections.shuffle(fullProductVos);
                        Collections.shuffle(fullGroupVos);
                    }
                    if (fullcutVo.getCutRule() == 4 && fullcutVo.getType() == 1) {
                        String[] productIds = fullcutVo.getProductIds().split(",");
                        for (String p : productIds) {
                            List list = fullProductVos.stream().filter(c -> c.getProId().equals(p)).collect(Collectors.toList());
                            MallProductVO productVO = new MallProductVO();
                            if (list != null && list.size() > 0) {
                                productVO = (MallProductVO)list.get(0);
                                if (fullcutVo.getProductRule() == 1) {
                                    this.logger.info("+1\u4e4b\u524d\uff1a" + String.valueOf(productVO.getCount()));
                                    productVO.setCount(productVO.getCount() + num.intValue());
                                    productVO.setFullCutId(fullcutVo.getFullCutId());
                                    productVO.setFullcutCount(productVO.getFullcutCount() == null ? num.intValue() : productVO.getFullcutCount() + num.intValue());
                                    productVO.setFullcutAmount(productVO.getFactPrice().multiply(BigDecimal.valueOf(productVO.getFullcutCount().intValue())));
                                }
                                if (fullcutVo.getProductRule() != 2) continue;
                                if (productVO.getFullcutCount() == productVO.getCount()) break;
                                productVO.setFullCutId(fullcutVo.getFullCutId());
                                productVO.setFullcutCount(productVO.getFullcutCount() == null ? 0 : productVO.getFullcutCount() + 1);
                                productVO.setFullcutAmount(productVO.getFactPrice().multiply(BigDecimal.valueOf(productVO.getFullcutCount().intValue())));
                                continue;
                            }
                            BaseJsonVo<MallProductVO> result = this.productService.buildProductVO(p, num.intValue(), "", "", fullcutVo.getFullCutId(), "", false, true, productVO.getSpeedUp(), null);
                            if (!result.isSuccess()) continue;
                            productVO = (MallProductVO)result.getValue();
                            MallShoppingcartVO shoppingcartVO = this.productService.getTransportType(shoppingcartVOS, TransportTypeEnum.getTransportTypeEnum(productVO.getTransportType()));
                            if (fullcutVo.getProductRule() != 1) continue;
                            productVO.setFullcutCount(productVO.getFullcutCount() == null ? num.intValue() : productVO.getFullcutCount() + num.intValue());
                            productVO.setFullcutAmount(productVO.getFactPrice().multiply(BigDecimal.valueOf(productVO.getFullcutCount().intValue())));
                            if (shoppingcartVO != null) {
                                shoppingcartVO.getProducts().add(productVO);
                                shoppingcartVO.setIsfullCutFree(1);
                                continue;
                            }
                            shoppingcartVO = new MallOrderVo();
                            shoppingcartVO.setPromotionDiffPrice(BigDecimal.ZERO);
                            shoppingcartVO.setPromotions(new ArrayList<MallPromotionVO>());
                            shoppingcartVO.setFrees(new ArrayList<MallFreeVO>());
                            shoppingcartVO.setOrderSource(shoppingcartVOS.get(0).getOrderSource());
                            shoppingcartVO.setPlatFormGroupId(shoppingcartVOS.get(0).getPlatFormGroupId());
                            shoppingcartVO.setPlatFormId(shoppingcartVOS.get(0).getPlatFormId());
                            shoppingcartVO.setCustomerId(shoppingcartVOS.get(0).getCustomerId());
                            shoppingcartVO.setGroups(new ArrayList<MallGroupVO>());
                            ArrayList<MallProductVO> productVOS = new ArrayList<MallProductVO>();
                            productVOS.add(productVO);
                            shoppingcartVO.setProducts(productVOS);
                            shoppingcartVO.setSelfMadeType(shoppingcartVOS.get(0).getSelfMadeType());
                            shoppingcartVO.setDeliverCount(shoppingcartVOS.get(0).getDeliverCount());
                            shoppingcartVO.setFactPrice(productVO.getFactPrice());
                            shoppingcartVO.setFullcutName(shoppingcartVOS.get(0).getFullcutName());
                            shoppingcartVO.setFullcutRuleName(shoppingcartVOS.get(0).getFullcutRuleName());
                            shoppingcartVO.setPrice(new BigDecimal(productVO.getProPrice()));
                            shoppingcartVO.setProductsPool(productVOS);
                            shoppingcartVO.setSpeedUp(shoppingcartVOS.get(0).getSpeedUp());
                            shoppingcartVO.setVipDiffPrice(BigDecimal.ZERO);
                            shoppingcartVO.setBindCode(shoppingcartVOS.get(0).getBindCode());
                            shoppingcartVO.setRule(shoppingcartVOS.get(0).getRule());
                            shoppingcartVO.setIsfullCutFree(1);
                            shoppingcartVOS.add(shoppingcartVO);
                        }
                        for (MallShoppingcartVO s : shoppingcartVOS) {
                            s.setIsfullCutFree(1);
                        }
                    } else if (fullcutVo.getType().intValue() == FullCutTypeEnum.product_num.getValue()) {
                        int tempNum = num.intValue();
                        for (int i = 1; i <= tempNum; ++i) {
                            MallProductVO productVO = null;
                            MallGroupVO groupVO = null;
                            if (fullGroupVos.size() > 0) {
                                groupVO = (MallGroupVO)fullGroupVos.get(0);
                            }
                            if (fullProductVos.size() > 0) {
                                productVO = (MallProductVO)fullProductVos.get(0);
                            }
                            if (num.doubleValue() > 0.0) {
                                if (productVO != null && (productVO.getFactPrice().compareTo(groupVO == null ? BigDecimal.ZERO : groupVO.getFactPrice()) >= 0 && fullcutVo.getCutRule() == 1 || productVO.getFactPrice().compareTo(groupVO == null ? BigDecimal.valueOf(100000000L) : groupVO.getFactPrice()) <= 0 && fullcutVo.getCutRule() == 2 || fullcutVo.getCutRule() == 3)) {
                                    if ((double)productVO.getCount().intValue() >= num.doubleValue()) {
                                        productVO.setFullCutId(fullcutVo.getFullCutId());
                                        productVO.setFullcutCount(num.intValue());
                                        productVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)num.intValue()));
                                        num = new BigDecimal(0);
                                    } else {
                                        productVO.setFullCutId(fullcutVo.getFullCutId());
                                        productVO.setFullcutCount(productVO.getCount());
                                        productVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getCount()));
                                        num = PriceUtils.subtract((BigDecimal)num, (BigDecimal)new BigDecimal(productVO.getCount()));
                                    }
                                    fullProductVos.remove(productVO);
                                }
                                if (groupVO != null && (groupVO.getFactPrice().compareTo(productVO == null ? BigDecimal.ZERO : productVO.getFactPrice()) > 0 && fullcutVo.getCutRule() == 1 || groupVO.getFactPrice().compareTo(productVO == null ? BigDecimal.valueOf(100000000L) : productVO.getFactPrice()) < 0 && fullcutVo.getCutRule() == 2 || fullcutVo.getCutRule() == 3)) {
                                    if ((double)groupVO.getCount().intValue() >= num.doubleValue()) {
                                        groupVO.setFullCutId(fullcutVo.getFullCutId());
                                        groupVO.setFullcutCount(num.intValue());
                                        groupVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)groupVO.getFactPrice(), (Integer)num.intValue()));
                                        num = new BigDecimal(0);
                                    } else {
                                        groupVO.setFullCutId(fullcutVo.getFullCutId());
                                        groupVO.setFullcutCount(groupVO.getCount());
                                        groupVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)groupVO.getFactPrice(), (Integer)groupVO.getCount()));
                                        num = PriceUtils.subtract((BigDecimal)num, (BigDecimal)new BigDecimal(groupVO.getCount()));
                                    }
                                    fullGroupVos.remove(groupVO);
                                }
                            }
                            if (num.intValue() != 0) {
                                continue;
                            }
                            break;
                        }
                    } else if (fullcutVo.getType().intValue() == FullCutTypeEnum.order_amount.getValue()) {
                        for (MallProductVO productVO : fullProductVos) {
                            if (!(num.doubleValue() > 0.0)) continue;
                            if (PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getShareCount()).compareTo(num) >= 0) {
                                productVO.setFullCutId(fullcutVo.getFullCutId());
                                productVO.setFullcutCount(0);
                                productVO.setFullcutAmount(num);
                                num = BigDecimal.ZERO;
                                continue;
                            }
                            productVO.setFullCutId(fullcutVo.getFullCutId());
                            productVO.setFullcutCount(0);
                            productVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getShareCount()));
                            num = PriceUtils.subtract((BigDecimal)num, (BigDecimal)PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getShareCount()));
                        }
                        if (!isGlobalFullcut.booleanValue()) {
                            for (MallGroupVO groupVO : fullGroupVos) {
                                if (!(num.doubleValue() > 0.0)) continue;
                                if (PriceUtils.multiply((BigDecimal)groupVO.getFactPrice(), (Integer)groupVO.getCount()).compareTo(num) >= 0) {
                                    groupVO.setFullCutId(fullcutVo.getFullCutId());
                                    groupVO.setFullcutCount(0);
                                    groupVO.setFullcutAmount(num);
                                    num = BigDecimal.ZERO;
                                    continue;
                                }
                                groupVO.setFullCutId(fullcutVo.getFullCutId());
                                groupVO.setFullcutCount(0);
                                groupVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)groupVO.getFactPrice(), (Integer)groupVO.getCount()));
                                num = PriceUtils.subtract((BigDecimal)num, (BigDecimal)PriceUtils.multiply((BigDecimal)groupVO.getFactPrice(), (Integer)groupVO.getCount()));
                            }
                        }
                    } else if (fullcutVo.getType().intValue() == FullCutTypeEnum.product_num_discount.getValue() || fullcutVo.getType().intValue() == FullCutTypeEnum.order_amount_discount.getValue()) {
                        BigDecimal discount = BigDecimal.ONE;
                        discount = numberVo.getCutNumber() >= 10 ? PriceUtils.divide((BigDecimal)new BigDecimal(numberVo.getCutNumber()), (BigDecimal)new BigDecimal(100)) : PriceUtils.divide((BigDecimal)new BigDecimal(numberVo.getCutNumber()), (BigDecimal)new BigDecimal(10));
                        if (discount.compareTo(BigDecimal.ZERO) <= 0) {
                            this.logger.error("\u6ee1\u51cf\u6298\u6263\u6bd4\u4f8b:{}\u4e0d\u6b63\u786e", (Object)discount);
                            return;
                        }
                        this.logger.info("\u6298\u6263:{}", (Object)discount);
                        BigDecimal cutAmout = PriceUtils.multiply((BigDecimal)factPriceSum, (BigDecimal)PriceUtils.subtract((BigDecimal)BigDecimal.ONE, (BigDecimal)discount));
                        int flag = fullProductVos.size() + fullGroupVos.size();
                        BigDecimal orderAmoutAfterDiscount = PriceUtils.multiply((BigDecimal)factPriceSum, (BigDecimal)discount);
                        this.logger.info("\u8ba2\u5355\u91d1\u989d\u6c47\u603b:{},\u6ee1\u51cf\u6307\u5b9a\u6570\u91cf:{}\u5171\u51cf\u591a\u5c11\u94b1:{},\u5546\u54c1\u7c7b\u522b\u6570:{}", new Object[]{factPriceSum, numberVo.getFullNumber(), cutAmout, flag});
                        if (cutAmout.compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal rate;
                            int i = 0;
                            BigDecimal orderAmount = BigDecimal.ZERO;
                            BigDecimal fullCutAmountSum = BigDecimal.ZERO;
                            facePrice = BigDecimal.ONE;
                            for (MallProductVO productVO : fullProductVos) {
                                productVO.setFullCutId(fullcutVo.getFullCutId());
                                productVO.setFullcutCount(0);
                                rate = PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getCount()), (BigDecimal)factPriceSum, (int)6, (Integer)4);
                                if (++i < flag) {
                                    facePrice = PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)orderAmoutAfterDiscount, (BigDecimal)rate), (BigDecimal)new BigDecimal(productVO.getCount()), (int)6, (Integer)4);
                                    productVO.setShareAmount(PriceUtils.multiply((BigDecimal)facePrice, (Integer)productVO.getCount()));
                                    orderAmount = PriceUtils.add((BigDecimal)orderAmount, (BigDecimal)PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (BigDecimal)new BigDecimal(productVO.getCount())));
                                    productVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)cutAmout, (BigDecimal)rate));
                                    fullCutAmountSum = PriceUtils.add((BigDecimal)fullCutAmountSum, (BigDecimal)productVO.getFullcutAmount());
                                } else {
                                    facePrice = PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)orderAmoutAfterDiscount, (BigDecimal)rate), (BigDecimal)new BigDecimal(productVO.getCount()), (int)6, (Integer)4);
                                    productVO.setShareAmount(PriceUtils.multiply((BigDecimal)facePrice, (Integer)productVO.getCount()));
                                    orderAmount = PriceUtils.add((BigDecimal)orderAmount, (BigDecimal)PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (BigDecimal)new BigDecimal(productVO.getCount())));
                                    productVO.setFullcutAmount(PriceUtils.subtract((BigDecimal)cutAmout, (BigDecimal)fullCutAmountSum));
                                }
                                this.logger.info("\u5546\u54c1:{}\u5360\u6bd4:{} \u629b\u6389\u6ee1\u51cf\u540e\u7684\u5b9e\u9645\u91d1\u989d:{} \u6ee1\u51cf\u91d1\u989d:{},{}", new Object[]{productVO.getProName(), rate, facePrice, productVO.getFullcutAmount(), fullCutAmountSum});
                            }
                            for (MallGroupVO groupVO : fullGroupVos) {
                                groupVO.setFullCutId(fullcutVo.getFullCutId());
                                groupVO.setFullcutCount(0);
                                rate = PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)groupVO.getFactPrice(), (Integer)groupVO.getCount()), (BigDecimal)factPriceSum, (int)6, (Integer)4);
                                if (++i < flag) {
                                    facePrice = PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)orderAmoutAfterDiscount, (BigDecimal)rate), (BigDecimal)new BigDecimal(groupVO.getCount()), (int)6, (Integer)4);
                                    groupVO.setShareAmount(PriceUtils.multiply((BigDecimal)facePrice, (Integer)groupVO.getCount()));
                                    orderAmount = PriceUtils.add((BigDecimal)orderAmount, (BigDecimal)PriceUtils.multiply((BigDecimal)groupVO.getFactPrice(), (BigDecimal)new BigDecimal(groupVO.getCount())));
                                    groupVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)cutAmout, (BigDecimal)rate));
                                    fullCutAmountSum = PriceUtils.add((BigDecimal)fullCutAmountSum, (BigDecimal)groupVO.getFullcutAmount());
                                    continue;
                                }
                                facePrice = PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)orderAmoutAfterDiscount, (BigDecimal)rate), (BigDecimal)new BigDecimal(groupVO.getCount()), (int)6, (Integer)4);
                                groupVO.setShareAmount(PriceUtils.multiply((BigDecimal)facePrice, (Integer)groupVO.getCount()));
                                orderAmount = PriceUtils.add((BigDecimal)orderAmount, (BigDecimal)PriceUtils.multiply((BigDecimal)groupVO.getFactPrice(), (BigDecimal)new BigDecimal(groupVO.getCount())));
                                groupVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)PriceUtils.subtract((BigDecimal)groupVO.getFactPrice(), (BigDecimal)facePrice), (Integer)groupVO.getCount()));
                                fullCutAmountSum = PriceUtils.subtract((BigDecimal)cutAmout, (BigDecimal)fullCutAmountSum);
                            }
                        }
                    }
                }
                if (fullcutVo.getType().intValue() == FullCutTypeEnum.amount_and_num.getValue()) {
                    num = PriceUtils.subtract((BigDecimal)factPriceSum, (BigDecimal)fullcutVo.getFullAmout());
                    int flag = fullProductVos.size() + fullGroupVos.size();
                    this.logger.info("\u8ba2\u5355\u91d1\u989d\u6c47\u603b:{},\u6ee1\u51cf\u6307\u5b9a\u91d1\u989d:{}\u5171\u51cf\u591a\u5c11\u94b1:{},\u5546\u54c1\u79cd\u7c7b\u6570:{}", new Object[]{factPriceSum, fullcutVo.getFullAmout(), num, flag});
                    if (num.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal rate;
                        int i = 0;
                        BigDecimal orderAmount = BigDecimal.ZERO;
                        BigDecimal fullCutAmountSum = BigDecimal.ZERO;
                        for (MallProductVO productVO : fullProductVos) {
                            ++i;
                            productVO.setFullCutId(fullcutVo.getFullCutId());
                            productVO.setFullcutCount(0);
                            rate = PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)productVO.getFactPrice(), (Integer)productVO.getCount()), (BigDecimal)factPriceSum, (int)6, (Integer)4);
                            facePrice = PriceUtils.divide((BigDecimal)PriceUtils.subtract((BigDecimal)fullcutVo.getFullAmout(), (BigDecimal)rate), (BigDecimal)new BigDecimal(productVO.getCount()));
                            productVO.setShareAmount(PriceUtils.multiply((BigDecimal)facePrice, (Integer)productVO.getCount()));
                            if (i < flag) {
                                fullCutAmountSum = PriceUtils.add((BigDecimal)fullCutAmountSum, (BigDecimal)PriceUtils.multiply((BigDecimal)num, (BigDecimal)rate));
                                orderAmount = PriceUtils.add((BigDecimal)orderAmount, (BigDecimal)PriceUtils.subtract((BigDecimal)productVO.getFactPrice(), (BigDecimal)new BigDecimal(productVO.getCount())));
                                productVO.setFullcutAmount(PriceUtils.multiply((BigDecimal)num, (BigDecimal)rate));
                            } else {
                                productVO.setFullcutAmount(PriceUtils.subtract((BigDecimal)num, (BigDecimal)fullCutAmountSum));
                            }
                            this.logger.info("\u5546\u54c1:{}\u5360\u6bd4:{} \u629b\u6389\u6ee1\u51cf\u540e\u7684\u5b9e\u9645\u91d1\u989d:{} \u6ee1\u51cf\u91d1\u989d:{},{}", new Object[]{productVO.getProName(), rate, facePrice, productVO.getFullcutAmount(), fullCutAmountSum});
                        }
                        for (MallGroupVO groupVO : fullGroupVos) {
                            ++i;
                            rate = PriceUtils.divide((BigDecimal)PriceUtils.subtract((BigDecimal)groupVO.getFactPrice(), (BigDecimal)new BigDecimal(groupVO.getCount())), (BigDecimal)factPriceSum, (int)6, (Integer)4);
                            facePrice = PriceUtils.divide((BigDecimal)PriceUtils.subtract((BigDecimal)fullcutVo.getFullAmout(), (BigDecimal)rate), (BigDecimal)new BigDecimal(groupVO.getCount()));
                            groupVO.setFullCutId(fullcutVo.getFullCutId());
                            groupVO.setFullcutCount(0);
                            fullCutAmountSum = PriceUtils.add((BigDecimal)fullCutAmountSum, (BigDecimal)PriceUtils.subtract((BigDecimal)num, (BigDecimal)rate));
                            groupVO.setShareAmount(PriceUtils.multiply((BigDecimal)facePrice, (Integer)groupVO.getCount()));
                            if (i < flag) {
                                groupVO.setFullcutAmount(PriceUtils.subtract((BigDecimal)groupVO.getFactPrice(), (BigDecimal)new BigDecimal(groupVO.getCount())));
                                orderAmount = PriceUtils.add((BigDecimal)orderAmount, (BigDecimal)PriceUtils.subtract((BigDecimal)groupVO.getFactPrice(), (BigDecimal)new BigDecimal(groupVO.getCount())));
                            } else {
                                groupVO.setFullcutAmount(PriceUtils.subtract((BigDecimal)fullcutVo.getFullAmout(), (BigDecimal)orderAmount));
                                groupVO.setShareAmount(PriceUtils.subtract((BigDecimal)fullcutVo.getFullAmout(), (BigDecimal)orderAmount));
                            }
                            this.logger.info("\u5957\u88c5:{}\u5360\u6bd4:{} \u6ee1\u51cf\u91d1\u989d:{}", new Object[]{groupVO.getGroupName(), rate, groupVO.getFullcutAmount()});
                        }
                    }
                }
                if (isGlobalFullcut.booleanValue()) {
                    if (fullGroupVos.size() > 0) {
                        for (MallGroupVO groupVO : fullGroupVos) {
                            double fullAmount = fullProductVos.stream().filter(c -> groupVO.getGroupId().equals(c.getGroupId())).mapToDouble(c -> c.getFullcutAmount().doubleValue()).sum();
                            if (!(fullAmount > 0.0)) continue;
                            groupVO.setFullcutAmount(BigDecimal.valueOf(fullAmount));
                        }
                    }
                    for (MallShoppingcartVO cart : shoppingcartVOS) {
                        if (cart.getPromotions() == null || cart.getPromotions().size() <= 0) continue;
                        for (MallPromotionVO promotionVO : cart.getPromotions()) {
                            double fullAmount = fullProductVos.stream().filter(c -> promotionVO.getPromotionId().equals(c.getPromotionId())).mapToDouble(c -> c.getFullcutAmount().doubleValue()).sum();
                            if (!(fullAmount > 0.0)) continue;
                            promotionVO.setFullcutAmount(BigDecimal.valueOf(fullAmount));
                            if (promotionVO.getGroup() == null) continue;
                            promotionVO.getGroup().setFullcutAmount(BigDecimal.valueOf(fullAmount));
                            promotionVO.getGroup().setFullCutId(fullcutVo.getFullCutId());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void totalCartVo(MallShoppingcartVO shoppingcartVO) {
        BigDecimal[] factPrice = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] cardFactPrice = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] price = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] exchangeCutPrice = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] vipDiffPrice = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] promotionDiffPrice = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] fullCutAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] longBuyCutSum = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] freightItemPrice = new BigDecimal[]{BigDecimal.ZERO};
        if (shoppingcartVO.getProducts().size() > 0) {
            shoppingcartVO.getProducts().forEach(c -> {
                if (c.getValid().booleanValue() && c.getShoppingcartCheck().booleanValue() && c.getValid().booleanValue()) {
                    factPrice[0] = PriceUtils.add((BigDecimal)factPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getFactPrice(), (Integer)c.getCount()));
                    if (c.getHasFreight() == 1) {
                        freightItemPrice[0] = PriceUtils.add((BigDecimal)freightItemPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getFactPrice(), (Integer)c.getCount()));
                    }
                    cardFactPrice[0] = PriceUtils.add((BigDecimal)cardFactPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getCardFactPrice(), (Integer)c.getCount()));
                    price[0] = PriceUtils.add((BigDecimal)price[0], (BigDecimal)PriceUtils.multiply((BigDecimal)new BigDecimal(c.getProPrice()), (Integer)c.getCount()));
                    vipDiffPrice[0] = PriceUtils.add((BigDecimal)vipDiffPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)(c.getVipDiff() == null ? new BigDecimal(0) : c.getVipDiff()), (BigDecimal)new BigDecimal(c.getCount())));
                    fullCutAmount[0] = PriceUtils.add((BigDecimal)fullCutAmount[0], (BigDecimal)(c.getFullcutAmount() == null ? new BigDecimal(0) : c.getFullcutAmount()));
                    exchangeCutPrice[0] = PriceUtils.add((BigDecimal)exchangeCutPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getExchangeCutAmount(), (Integer)c.getCount()));
                    if (Objects.equals(shoppingcartVO.getOrderSource(), OrderSourceEnum.PERIODIC_PURCHASE.getValue()) && c.getOriginPrice().compareTo(c.getFactPrice()) > 0) {
                        longBuyCutSum[0] = PriceUtils.add((BigDecimal)longBuyCutSum[0], (BigDecimal)PriceUtils.multiply((BigDecimal)PriceUtils.subtract((BigDecimal)c.getOriginPrice(), (BigDecimal)c.getFactPrice()), (Integer)c.getCount()));
                        vipDiffPrice[0] = BigDecimal.ZERO;
                    }
                    this.logger.info("\u6ee1\u51cf\u91d1\u989d:{}", (Object)fullCutAmount[0]);
                }
            });
        }
        if (shoppingcartVO.getGroups().size() > 0) {
            shoppingcartVO.getGroups().forEach(c -> {
                if (c.getValid().booleanValue() && c.getShoppingcartCheck().booleanValue() && c.getValid().booleanValue()) {
                    factPrice[0] = PriceUtils.add((BigDecimal)factPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getFactPrice(), (Integer)c.getCount()));
                    if (c.getHasFreight() == 1) {
                        freightItemPrice[0] = PriceUtils.add((BigDecimal)freightItemPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getFactPrice(), (Integer)c.getCount()));
                    }
                    price[0] = PriceUtils.add((BigDecimal)price[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getSalePrice(), (Integer)c.getCount()));
                    fullCutAmount[0] = PriceUtils.add((BigDecimal)fullCutAmount[0], (BigDecimal)(c.getFullcutAmount() == null ? new BigDecimal(0) : c.getFullcutAmount()));
                    exchangeCutPrice[0] = PriceUtils.add((BigDecimal)exchangeCutPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getExchangeCutAmount(), (Integer)c.getCount()));
                }
            });
        }
        if (shoppingcartVO.getPromotions().size() > 0) {
            shoppingcartVO.getPromotions().forEach(c -> {
                if (c.getValid().booleanValue() && c.getShoppingcartCheck().booleanValue() && c.getValid().booleanValue()) {
                    this.logger.info("\u4fc3\u9500:{},\u4ef7\u683c:{}", (Object)c.getPromotionName(), (Object)c.getFactPrice());
                    factPrice[0] = PriceUtils.add((BigDecimal)factPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getFactPrice(), (Integer)c.getCount()));
                    if (c.getHasFreight() == 1) {
                        freightItemPrice[0] = PriceUtils.add((BigDecimal)freightItemPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getFactPrice(), (Integer)c.getCount()));
                    }
                    price[0] = PriceUtils.add((BigDecimal)price[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getOriginPrice(), (Integer)c.getCount()));
                    cardFactPrice[0] = PriceUtils.add((BigDecimal)cardFactPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getCardFactPrice(), (Integer)c.getCount()));
                    vipDiffPrice[0] = PriceUtils.add((BigDecimal)vipDiffPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)(c.getVipDiff() == null ? BigDecimal.ZERO : c.getVipDiff()), (BigDecimal)new BigDecimal(c.getCount())));
                    promotionDiffPrice[0] = PriceUtils.add((BigDecimal)promotionDiffPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)(c.getPromotionDiff() == null ? BigDecimal.ZERO : c.getPromotionDiff()), (BigDecimal)new BigDecimal(c.getCount())));
                    fullCutAmount[0] = PriceUtils.add((BigDecimal)fullCutAmount[0], (BigDecimal)(c.getFullcutAmount() == null ? BigDecimal.ZERO : c.getFullcutAmount()));
                    exchangeCutPrice[0] = PriceUtils.add((BigDecimal)exchangeCutPrice[0], (BigDecimal)PriceUtils.multiply((BigDecimal)c.getExchangeCutAmount(), (Integer)c.getCount()));
                    if (Objects.equals(shoppingcartVO.getOrderSource(), OrderSourceEnum.PERIODIC_PURCHASE.getValue())) {
                        longBuyCutSum[0] = PriceUtils.add((BigDecimal)longBuyCutSum[0], (BigDecimal)promotionDiffPrice[0]);
                        promotionDiffPrice[0] = BigDecimal.ZERO;
                    }
                }
            });
        }
        shoppingcartVO.setFactPrice(factPrice[0]);
        shoppingcartVO.setPrice(price[0]);
        shoppingcartVO.setFreightItemPrice(freightItemPrice[0]);
        shoppingcartVO.setVipDiffPrice(vipDiffPrice[0]);
        shoppingcartVO.setCardFactPrice(cardFactPrice[0]);
        shoppingcartVO.setPromotionDiffPrice(promotionDiffPrice[0]);
        shoppingcartVO.setExchangeCutPrice(exchangeCutPrice[0]);
        shoppingcartVO.setLongBuyCutSum(longBuyCutSum[0]);
    }

    @Override
    public void totalOrderPrice(List<MallOrderVo> orderVos, MallMainOrderVo mainOrderVo) {
        ArrayList<MallShoppingcartVO> shoppingcartVOS = new ArrayList<MallShoppingcartVO>();
        shoppingcartVOS.addAll(orderVos);
        this.calcShoppingcartVO(shoppingcartVOS);
        if (shoppingcartVOS.size() > orderVos.size()) {
            orderVos.add((MallOrderVo)shoppingcartVOS.get(shoppingcartVOS.size() - 1));
        }
        for (MallOrderVo orderVo : orderVos) {
            BigDecimal[] fullCutAmount = new BigDecimal[]{BigDecimal.ZERO};
            BigDecimal orderAmount = orderVo.getFactPrice();
            BigDecimal deductionAmount = BigDecimal.ZERO;
            if (orderVo.getProducts().size() > 0) {
                for (MallProductVO mallProductVO : orderVo.getProducts()) {
                    fullCutAmount[0] = PriceUtils.add((BigDecimal)fullCutAmount[0], (BigDecimal)(mallProductVO.getFullcutAmount() == null ? BigDecimal.ZERO : mallProductVO.getFullcutAmount()));
                }
            }
            if (!orderVo.getGroups().isEmpty()) {
                for (MallGroupVO mallGroupVO : orderVo.getGroups()) {
                    fullCutAmount[0] = PriceUtils.add((BigDecimal)fullCutAmount[0], (BigDecimal)(mallGroupVO.getFullcutAmount() == null ? BigDecimal.ZERO : mallGroupVO.getFullcutAmount()));
                }
            }
            if (orderVo.getPromotions().size() > 0) {
                for (MallPromotionVO mallPromotionVO : orderVo.getPromotions()) {
                    fullCutAmount[0] = PriceUtils.add((BigDecimal)fullCutAmount[0], (BigDecimal)(mallPromotionVO.getFullcutAmount() == null ? BigDecimal.ZERO : mallPromotionVO.getFullcutAmount()));
                }
            }
            if (mainOrderVo != null && CollectionUtils.isNotEmpty(mainOrderVo.getMallOrderVos().get(0).getEnableExchanges())) {
                this.logger.info("\u628a\u7528\u6237:{},\u8ba2\u5355\u91d1\u989d:{},\u6362\u8d2d:{}", new Object[]{mainOrderVo.getCustomerId(), orderAmount, mainOrderVo.getMallOrderVos().get(0).getEnableExchanges().size()});
                for (MallExchangeVO mallExchangeVO : mainOrderVo.getMallOrderVos().get(0).getEnableExchanges()) {
                    if (!CollectionUtils.isNotEmpty(mallExchangeVO.getProductList())) continue;
                    for (MallExchangeProductVO exchangeProductVO : mallExchangeVO.getProductList()) {
                        if (exchangeProductVO.getQuantity() <= 0 || !Objects.equals(exchangeProductVO.getTransportType(), orderVo.getTransportType())) continue;
                        orderAmount = PriceUtils.addNoUp((BigDecimal)orderAmount, (BigDecimal)PriceUtils.multiply((BigDecimal)exchangeProductVO.getFactPrice(), (Integer)exchangeProductVO.getQuantity()));
                        this.logger.info("\u5b50\u5355\u603b\u91d1\u989d:{},\u52a0\u4e0a\u6362\u8d2d\u5546\u54c1\u91d1\u989d:{}", (Object)orderAmount, (Object)PriceUtils.multiply((BigDecimal)exchangeProductVO.getFactPrice(), (Integer)exchangeProductVO.getQuantity()));
                        orderVo.setOrderAmount(orderAmount);
                    }
                }
            }
            boolean subCardDeductionFlag = false;
            if (CollectionUtils.isNotEmpty(orderVo.getRecommendCardVOList())) {
                for (MallRecommendCardVO recommendCardVO : orderVo.getRecommendCardVOList()) {
                    this.logger.info("\u5e78\u798f\u5361:\u8ba2\u5355\u91d1\u989d{}\u52a0\u4e0a\u5361\u91d1\u989d{},\u5361\u62b5\u6263\u91d1\u989d:{}", new Object[]{orderAmount, recommendCardVO.getFactPrice(), recommendCardVO.getDeductionAmount()});
                    if (orderVo.getTransportType() != recommendCardVO.getCardType()) continue;
                    if (recommendCardVO.getSelect() == 1) {
                        subCardDeductionFlag = true;
                        deductionAmount = PriceUtils.addNoUp((BigDecimal)deductionAmount, (BigDecimal)recommendCardVO.getDeductionAmount());
                        orderAmount = PriceUtils.subtract((BigDecimal)PriceUtils.addNoUp((BigDecimal)orderAmount, (BigDecimal)PriceUtils.multiply((BigDecimal)recommendCardVO.getFactPrice(), (Integer)recommendCardVO.getCount())), (BigDecimal)recommendCardVO.getCardCutAmount());
                        this.logger.info("\u4f7f\u7528\u9009\u4e2d\u5e78\u798f\u5361\u8ba1\u7b97:\u8ba2\u5355\u91d1\u989d{}\u52a0\u4e0a\u5361\u91d1\u989d{},\u5361\u62b5\u6263\u91d1\u989d:{}", new Object[]{orderAmount, recommendCardVO.getFactPrice(), recommendCardVO.getDeductionAmount()});
                    }
                    orderVo.setDeductionAmount(deductionAmount);
                    orderVo.setUseCardCutAmount(recommendCardVO.getCardCutAmount());
                }
            }
            orderAmount = PriceUtils.subtract((BigDecimal)orderAmount, (BigDecimal)fullCutAmount[0]);
            BigDecimal toatalAmount = PriceUtils.add((BigDecimal)orderAmount, (BigDecimal)(orderVo.getFreight() == null ? BigDecimal.ZERO : orderVo.getFreight()));
            if (subCardDeductionFlag) {
                toatalAmount = PriceUtils.subtract((BigDecimal)toatalAmount, (BigDecimal)orderVo.getDeductionAmount());
            }
            BigDecimal payAmount = toatalAmount;
            payAmount = PriceUtils.subtractToSix((BigDecimal)payAmount, (BigDecimal)orderVo.getBalanceAmount());
            payAmount = PriceUtils.subtractToSix((BigDecimal)payAmount, (BigDecimal)orderVo.getCouponAmount());
            payAmount = PriceUtils.subtractToSix((BigDecimal)payAmount, (BigDecimal)orderVo.getSourceOrderAmount());
            orderVo.setTotalAmount(toatalAmount);
            orderVo.setOrderAmount(orderAmount);
            orderVo.setPayAmount(payAmount);
            orderVo.setFullcutAmount(fullCutAmount[0]);
            if (mainOrderVo != null && Objects.equals(OrderSourceEnum.RECHANGE_CARD.getValue(), mainOrderVo.getOrderCacheVo().getOrderSource())) {
                BigDecimal bigDecimal = BigDecimal.ZERO;
                BigDecimal cardPayAmount = BigDecimal.ZERO;
                BigDecimal cardOrderAmount = orderVo.getCardFactPrice();
                BigDecimal bigDecimal2 = PriceUtils.add((BigDecimal)cardOrderAmount, (BigDecimal)orderVo.getFreight());
                cardPayAmount = PriceUtils.subtractToSix((BigDecimal)bigDecimal2, (BigDecimal)PriceUtils.multiply((BigDecimal)orderVo.getCouponAmount(), (Integer)10));
                if ((cardPayAmount = PriceUtils.subtractToSix((BigDecimal)cardPayAmount, (BigDecimal)orderVo.getCardBalanceAmount())).compareTo(BigDecimal.ZERO) > 0) {
                    if (Objects.equals(mainOrderVo.getCardType(), PrepayCardTypeEnum.yogurt_card.getValue())) {
                        cardPayAmount = PriceUtils.subtractToSix((BigDecimal)cardPayAmount, (BigDecimal)PriceUtils.multiply((BigDecimal)orderVo.getBalanceAmount(), (Integer)10));
                        BigDecimal tempPayAmount = PriceUtils.divide((BigDecimal)cardPayAmount, (BigDecimal)new BigDecimal(10), (int)2, (Integer)5);
                        orderVo.setPayAmount(tempPayAmount);
                    } else {
                        cardPayAmount = PriceUtils.subtractToSix((BigDecimal)cardPayAmount, (BigDecimal)orderVo.getBalanceAmount());
                        orderVo.setPayAmount(cardPayAmount);
                    }
                }
                this.logger.info("\u70b9\u5361\u652f\u4ed8\u91d1\u989d:{},\u7528\u6237\u70b9\u5361\u5e10\u6237\u91d1\u989d:{},\u4f59\u989d\u652f\u4ed8\u91d1\u989d:{},\u5b9e\u9645\u652f\u4ed8\u91d1\u989d:{}", new Object[]{orderVo.getPayAmount(), orderVo.getCardOrderAmount(), orderVo.getBalanceAmount(), payAmount});
                orderVo.setCardTotalAmount(bigDecimal2);
                orderVo.setCardOrderAmount(cardOrderAmount);
                orderVo.setCardPayAmount(cardPayAmount);
            }
            this.logger.info("\u5b50\u5355\u652f\u4ed8\u91d1\u989d:{},\u4f18\u60e0\u5238\u91d1\u989d:{},\u4f59\u989d\u91d1\u989d:{},\u5361\u4f59\u989d\u91d1\u989d:{},\u6ee1\u51cf\u91d1\u989d:{}", new Object[]{payAmount, orderVo.getCouponAmount(), orderVo.getBalanceAmount(), orderVo.getCardBalanceAmount(), fullCutAmount[0]});
        }
    }

    @Override
    public void totalMainOrderPrice(MallMainOrderVo mainOrderVo) {
        SimpleVipVo customerVip = this.getMallCustomerVip(mainOrderVo.getOrderCacheVo().getOrderSource(), mainOrderVo.getCustomerId());
        BigDecimal[] orderAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] cardOrderAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] freight = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] couponAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] sourceOrderAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] balanceAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] vipDiffAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] promotionDiffAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] longBuyCutAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] useCardPointPrice = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] canUseCardPrice = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] exchangeCutAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] useCardCutAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] deductionAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal toatalAmount = BigDecimal.ZERO;
        BigDecimal cardToatalAmount = BigDecimal.ZERO;
        BigDecimal cardPayAmount = BigDecimal.ZERO;
        BigDecimal[] tempCardPayAmount = new BigDecimal[]{BigDecimal.ZERO};
        BigDecimal[] fullcutAmount = new BigDecimal[]{BigDecimal.ZERO};
        mainOrderVo.getMallOrderVos().forEach(c -> {
            orderAmount[0] = PriceUtils.addNoUp((BigDecimal)orderAmount[0], (BigDecimal)c.getOrderAmount());
            cardOrderAmount[0] = PriceUtils.addNoUp((BigDecimal)cardOrderAmount[0], (BigDecimal)c.getCardOrderAmount());
            freight[0] = PriceUtils.addNoUp((BigDecimal)freight[0], (BigDecimal)c.getFreight());
            balanceAmount[0] = PriceUtils.addNoUp((BigDecimal)balanceAmount[0], (BigDecimal)c.getBalanceAmount());
            if (c.getCanUseCardPrice().compareTo(BigDecimal.ZERO) > 0) {
                useCardPointPrice[0] = PriceUtils.addNoUp((BigDecimal)useCardPointPrice[0], (BigDecimal)c.getUseCardPointPrice());
                canUseCardPrice[0] = PriceUtils.addNoUp((BigDecimal)canUseCardPrice[0], (BigDecimal)c.getCanUseCardPrice());
                this.logger.info("\u4f7f\u7528\u5361\u652f\u4ed8\u7d2f\u8ba1\u70b9\u6570\u91d1\u989d\u548c:{},\u5b9e\u9645\u91d1\u989d:{},\u5b50\u5355\u5b9e\u9645\u91d1\u989d:{}", new Object[]{useCardPointPrice[0], canUseCardPrice[0], c.getCanUseCardPrice()});
                deductionAmount[0] = PriceUtils.addNoUp((BigDecimal)deductionAmount[0], (BigDecimal)c.getDeductionAmount());
                useCardCutAmount[0] = PriceUtils.addNoUp((BigDecimal)useCardCutAmount[0], (BigDecimal)c.getUseCardCutAmount());
            }
            couponAmount[0] = PriceUtils.addNoUp((BigDecimal)couponAmount[0], (BigDecimal)c.getCouponAmount());
            sourceOrderAmount[0] = PriceUtils.addNoUp((BigDecimal)sourceOrderAmount[0], (BigDecimal)c.getSourceOrderAmount());
            fullcutAmount[0] = PriceUtils.addNoUp((BigDecimal)fullcutAmount[0], (BigDecimal)c.getFullcutAmount());
            vipDiffAmount[0] = PriceUtils.addNoUp((BigDecimal)vipDiffAmount[0], (BigDecimal)c.getVipDiffPrice());
            promotionDiffAmount[0] = PriceUtils.addNoUp((BigDecimal)promotionDiffAmount[0], (BigDecimal)c.getPromotionDiffPrice());
            exchangeCutAmount[0] = PriceUtils.addNoUp((BigDecimal)exchangeCutAmount[0], (BigDecimal)c.getExchangeCutPrice());
            tempCardPayAmount[0] = PriceUtils.addNoUp((BigDecimal)tempCardPayAmount[0], (BigDecimal)c.getCardPayAmount());
            longBuyCutAmount[0] = PriceUtils.addNoUp((BigDecimal)longBuyCutAmount[0], (BigDecimal)c.getLongBuyCutSum());
            mainOrderVo.setFullcutName(c.getFullcutName());
            mainOrderVo.setFullcutRuleName(c.getFullcutRuleName());
            mainOrderVo.setDeductionAmount(PriceUtils.addNoUp((BigDecimal)mainOrderVo.getDeductionAmount(), (BigDecimal)c.getDeductionAmount()));
            this.logger.info("\u5b50\u5355\u4f18\u60e0\u5238\u91d1\u989d:{},\u4f59\u989d:{},\u6ee1\u51cf\u91d1\u989d:{}", new Object[]{c.getCouponAmount(), c.getBalanceAmount(), fullcutAmount[0]});
        });
        this.logger.info("\u8ba2\u5355\u91d1\u989d:{},\u4f18\u60e0\u5238\u91d1\u989d:{},\u7528\u5361\u4f18\u60e0\u91d1\u989d:{},\u8fd0\u8d39:{},\u6ee1\u51cf\u91d1\u989d={}", new Object[]{orderAmount[0], mainOrderVo.getCouponAmount(), mainOrderVo.getUseCardCutAmount(), freight[0], fullcutAmount[0]});
        toatalAmount = PriceUtils.addNoUp((BigDecimal)orderAmount[0], (BigDecimal)freight[0]);
        if (CollectionUtils.isNotEmpty(mainOrderVo.getRecommendCardVOList())) {
            for (MallRecommendCardVO recommendCardVO : mainOrderVo.getRecommendCardVOList()) {
                if (recommendCardVO.getSelect() != 1) continue;
                this.logger.info("\u4f7f\u7528\u9009\u4e2d\u5e78\u798f\u5361\u8ba1\u7b97:\u8ba2\u5355\u603b\u91d1\u989d{}\u5361\u62b5\u6263\u91d1\u989d:{}", (Object)toatalAmount, (Object)recommendCardVO.getDeductionAmount());
                toatalAmount = PriceUtils.subtract((BigDecimal)toatalAmount, (BigDecimal)recommendCardVO.getDeductionAmount());
                this.logger.info("\u4f7f\u7528\u9009\u4e2d\u5e78\u798f\u5361 \u51cf\u6389\u62b5\u6263\u91d1\u989d\u540e:\u8ba2\u5355\u603b\u91d1\u989d{}", (Object)toatalAmount);
            }
        }
        BigDecimal payAmount = toatalAmount;
        payAmount = PriceUtils.subtractToSix((BigDecimal)payAmount, (BigDecimal)couponAmount[0]);
        payAmount = PriceUtils.subtractToSix((BigDecimal)payAmount, (BigDecimal)balanceAmount[0]);
        payAmount = PriceUtils.subtractToSix((BigDecimal)payAmount, (BigDecimal)sourceOrderAmount[0]);
        cardPayAmount = cardToatalAmount = PriceUtils.addNoUp((BigDecimal)cardOrderAmount[0], (BigDecimal)freight[0]);
        cardPayAmount = PriceUtils.subtractToSix((BigDecimal)cardPayAmount, (BigDecimal)mainOrderVo.getCardBalanceAmount());
        if (OrderSourceEnum.RECHANGE_CARD.getValue() == mainOrderVo.getOrderCacheVo().getOrderSource()) {
            this.logger.info("\u70b9\u5361\u652f\u4ed8\u91d1\u989d:{},\u7528\u6237\u70b9\u5361\u5e10\u6237\u91d1\u989d:{}", (Object)cardPayAmount, (Object)mainOrderVo.getCardTotalBalanceAmount());
            if (mainOrderVo.getCardBalanceAmount().compareTo(mainOrderVo.getCardTotalAmount()) < 0) {
                this.logger.info("\u9700\u8981\u652f\u4ed8\u70b9\u6570:{}", (Object)cardPayAmount);
                payAmount = mainOrderVo.getOrderCacheVo().getBindCode().length() > 2 ? PriceUtils.divide((BigDecimal)cardPayAmount, (BigDecimal)new BigDecimal(10), (int)2, (Integer)5) : cardPayAmount;
                cardPayAmount = payAmount = PriceUtils.subtractToSix((BigDecimal)payAmount, (BigDecimal)mainOrderVo.getBalanceAmount());
            } else {
                cardPayAmount = payAmount = BigDecimal.ZERO;
            }
            this.logger.info("\u70b9\u5361\u652f\u4ed8\u91d1\u989d:{},\u7528\u6237\u70b9\u5361\u5e10\u6237\u91d1\u989d:{},\u4f59\u989d\u652f\u4ed8\u91d1\u989d:{},\u5b9e\u9645\u652f\u4ed8\u91d1\u989d:{}", new Object[]{cardPayAmount, mainOrderVo.getCardTotalBalanceAmount(), mainOrderVo.getBalanceAmount(), payAmount});
        }
        mainOrderVo.setTotalAmount(toatalAmount);
        mainOrderVo.setCardTotalAmount(cardToatalAmount);
        mainOrderVo.setOrderAmount(orderAmount[0]);
        mainOrderVo.setCardOrderAmount(cardOrderAmount[0]);
        mainOrderVo.setCouponAmount(couponAmount[0]);
        mainOrderVo.setBalanceAmount(balanceAmount[0]);
        mainOrderVo.setFreight(freight[0]);
        this.logger.info("\u8ba2\u5355\u603b\u91d1\u989d:{},\u8ba2\u5355\u91d1\u989d:{}, \u4f59\u989d\u652f\u4ed8\u91d1\u989d:{},\u652f\u4ed8\u91d1\u989d:{},\u6ee1\u51cf\u91d1\u989d:{}", new Object[]{toatalAmount, orderAmount[0], balanceAmount[0], payAmount, fullcutAmount[0]});
        mainOrderVo.setPayAmount(payAmount);
        mainOrderVo.setCardPayAmount(cardPayAmount);
        mainOrderVo.setFullcutAmount(fullcutAmount[0]);
        mainOrderVo.setVipDiffPrice(vipDiffAmount[0]);
        mainOrderVo.setPromotionDiffPrice(promotionDiffAmount[0]);
        mainOrderVo.setExchangeCutPrice(exchangeCutAmount[0]);
        mainOrderVo.setTotalAmountANdVipDiff(toatalAmount.add(vipDiffAmount[0]).add(promotionDiffAmount[0]));
        mainOrderVo.setDeductionAmount(deductionAmount[0]);
        mainOrderVo.setUseCardCutAmount(useCardCutAmount[0]);
        mainOrderVo.setCanUseCardPrice(canUseCardPrice[0]);
        mainOrderVo.setUseCardPointPrice(useCardPointPrice[0]);
        mainOrderVo.setLongBuyCutSum(longBuyCutAmount[0]);
        this.calcOrderFavorable(mainOrderVo);
    }

    private void calcOrderFavorable(MallMainOrderVo mainOrderVo) {
        if (mainOrderVo != null && mainOrderVo.getOrderFavorStrategies() != null && mainOrderVo.getOrderFavorStrategies().size() > 0) {
            BigDecimal[] orderSaved = new BigDecimal[]{BigDecimal.ZERO};
            mainOrderVo.getOrderFavorStrategies().forEach(favorStrategy -> {
                HashMap<String, Object> param = new HashMap<String, Object>();
                String inviteId = mainOrderVo.getMallOrderVos().get(0).getDefineField();
                try {
                    inviteId = JsonUtils.stringToMap((String)URLDecoder.decode(inviteId, "utf-8")).get("inviteId").toString();
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("\u672a\u83b7\u53d6\u5230inviteId,\u7c7b\u578b\u8f6c\u5316\u9519\u8bef");
                }
                param.put("inviteId", inviteId);
                BigDecimal moneySaved = favorStrategy.favorCalc(param);
                orderSaved[0] = PriceUtils.add((BigDecimal)orderSaved[0], (BigDecimal)moneySaved);
            });
            this.logger.info("\u62fc\u5355\u8282\u7701\uff1a" + orderSaved[0].doubleValue());
            mainOrderVo.setTotalAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getTotalAmount(), (BigDecimal)orderSaved[0]));
            mainOrderVo.setOrderAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getOrderAmount(), (BigDecimal)orderSaved[0]));
            mainOrderVo.setPayAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getPayAmount(), (BigDecimal)orderSaved[0]));
            mainOrderVo.getMallOrderVos().get(0).setTotalAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getMallOrderVos().get(0).getTotalAmount(), (BigDecimal)orderSaved[0]));
            mainOrderVo.getMallOrderVos().get(0).setOrderAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getMallOrderVos().get(0).getOrderAmount(), (BigDecimal)orderSaved[0]));
            mainOrderVo.getMallOrderVos().get(0).setPayAmount(PriceUtils.subtract((BigDecimal)mainOrderVo.getMallOrderVos().get(0).getPayAmount(), (BigDecimal)orderSaved[0]));
        }
    }

    @Override
    public MallPriceVO getPrice(OrderSourceEnum orderSourceEnum, SalesTypeEnum salesTypeEnum, String saleId, String customerId, int longPeriodTimes) {
        SimpleVipVo customerVip = this.getMallCustomerVip(orderSourceEnum.getValue(), customerId);
        return this.getPrice(orderSourceEnum, salesTypeEnum, saleId, customerVip, longPeriodTimes);
    }

    @NotNull
    private SimpleVipVo getMallCustomerVip(int orderSource, String customerId) {
        return this.vipService.getSimpleVipVo(customerId, VipLevelTypeEnum.superVip.getValue());
    }

    @Override
    public MallPriceVO getPrice(OrderSourceEnum orderSourceEnum, SalesTypeEnum salesTypeEnum, String saleId, SimpleVipVo customerVip, int longPeriodTimes) {
        this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e5getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
        if (!customerVip.getVip()) {
            this.logger.info("\u7528\u6237:{}\u4e0d\u662f\u4f1a\u5458", (Object)customerVip.getCustomerId());
            return null;
        }
        MallPriceVO priceVO = new MallPriceVO();
        priceVO.setBuyable(true);
        Boolean isVipDay = this.vipService.isVipDayNow();
        block0 : switch (orderSourceEnum) {
            case CART: {
                switch (salesTypeEnum) {
                    case SALES_PRODUCT: {
                        MallProductEntity productEntity = this.productService.getProduct(saleId);
                        priceVO.setOriginPrice(PriceUtils.format((String)productEntity.getProPrice()));
                        if (isVipDay.booleanValue() && customerVip.getVip() && StringUtils.isNotEmpty((String)customerVip.getCustomerId())) {
                            this.logger.info("\u5355\u54c11");
                            MallVipRightsEntity right = this.vipService.checkCustomerRight(customerVip.getCustomerId(), "3164601824691353085");
                            if (right != null && Integer.valueOf(right.getRightData()) > 0 && Integer.valueOf(right.getRightData()) < 100) {
                                this.logger.info("\u5355\u54c12");
                                priceVO.setVipPrice(PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)priceVO.getOriginPrice(), (Integer)Integer.valueOf(right.getRightData())), (BigDecimal)PriceUtils.format((BigDecimal)new BigDecimal(100))).setScale(1, RoundingMode.HALF_UP));
                                priceVO.setVipDiff(PriceUtils.subtract((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)priceVO.getVipPrice()));
                                priceVO.setFactPrice(priceVO.getVipPrice());
                                return priceVO;
                            }
                        } else if (!isVipDay.booleanValue() && customerVip.getVip() && StringUtils.isNotEmpty((String)customerVip.getCustomerId())) {
                            this.logger.info("\u5355\u54c13");
                            MallVipRightsEntity right = this.vipService.checkCustomerRight(customerVip.getCustomerId(), "3263699494671905110");
                            if (right != null && Integer.valueOf(right.getRightData()) > 0 && Integer.valueOf(right.getRightData()) < 100) {
                                this.logger.info("\u5355\u54c14");
                                priceVO.setVipPrice(PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)priceVO.getOriginPrice(), (Integer)Integer.valueOf(right.getRightData())), (BigDecimal)PriceUtils.format((BigDecimal)new BigDecimal(100))).setScale(1, RoundingMode.HALF_UP));
                                priceVO.setVipDiff(PriceUtils.subtract((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)priceVO.getVipPrice()));
                                priceVO.setFactPrice(priceVO.getVipPrice());
                                return priceVO;
                            }
                        }
                        this.logger.info("\u5355\u54c15");
                        priceVO.setFactPrice(priceVO.getOriginPrice());
                        break block0;
                    }
                    case SALES_GROUP: {
                        MallProductGroupEntity groupEntity = this.groupService.getGroup(saleId);
                        priceVO.setOriginPrice(groupEntity.getPrice());
                        priceVO.setFactPrice(groupEntity.getSalePrice());
                        return priceVO;
                    }
                    case SALES_PROMOTION: {
                        this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e52getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                        MallPromotionEntity promotionEntity = this.promotionService.getPromotion(saleId);
                        if (promotionEntity == null) {
                            return null;
                        }
                        this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e53getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                        MallPromotionProductEntity promotionProductEntity = this.promotionProductService.getPromotionProductEntity(saleId);
                        if ("1".equals(String.valueOf(promotionProductEntity.getIsvip())) && StringUtils.isNotEmpty((String)customerVip.getCustomerId())) {
                            this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e54getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                            MallVipRightsEntity right = this.vipService.checkCustomerRightByType(customerVip.getCustomerId(), promotionProductEntity.getVipRightType(), isVipDay);
                            if (right != null && "1".equals(right.getHasRight()) && "1".equals(right.getStatus())) {
                                this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e55getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                                priceVO.setOriginPrice(promotionProductEntity.getOriginPrice());
                                priceVO.setPromotionPrice(promotionProductEntity.getPromotionPrice());
                                if (String.valueOf(VipRightTypeEnum.RIGHT_XINPINCHANGXIAN.getValue()).equals(right.getRightType())) {
                                    priceVO.setFactPrice(PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)priceVO.getPromotionPrice(), (BigDecimal)PriceUtils.format((String)right.getRightData())), (BigDecimal)PriceUtils.format((BigDecimal)new BigDecimal(100))).setScale(1, RoundingMode.HALF_UP));
                                    priceVO.setVipPrice(priceVO.getFactPrice());
                                    priceVO.setVipDiff(PriceUtils.subtract((BigDecimal)priceVO.getPromotionPrice(), (BigDecimal)priceVO.getVipPrice()));
                                } else if (String.valueOf(VipRightTypeEnum.RIGHT_TAOZHUANG_ZHEKOU.getValue()).equals(right.getRightType())) {
                                    priceVO.setFactPrice(PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)priceVO.getPromotionPrice(), (BigDecimal)PriceUtils.format((String)right.getRightData())), (BigDecimal)PriceUtils.format((BigDecimal)new BigDecimal(100))).setScale(1, RoundingMode.HALF_UP));
                                    priceVO.setVipPrice(priceVO.getFactPrice());
                                    priceVO.setVipDiff(PriceUtils.subtract((BigDecimal)priceVO.getPromotionPrice(), (BigDecimal)priceVO.getVipPrice()));
                                } else if (String.valueOf(VipRightTypeEnum.RIGHT_MIAOSHA.getValue()).equals(right.getRightType())) {
                                    priceVO.setFactPrice(promotionProductEntity.getPromotionPrice());
                                    priceVO.setVipPrice(priceVO.getFactPrice());
                                    priceVO.setVipDiff(PriceUtils.subtract((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)priceVO.getVipPrice()));
                                }
                            } else {
                                this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e56getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                                priceVO.setOriginPrice(promotionProductEntity.getOriginPrice());
                                priceVO.setFactPrice(promotionProductEntity.getPromotionPrice());
                                priceVO.setPromotionPrice(promotionProductEntity.getPromotionPrice());
                                priceVO.setPromotionDiff(PriceUtils.subtract((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)priceVO.getPromotionPrice()));
                                if (StringUtils.isNotEmpty((String)promotionProductEntity.getVipRightType()) && String.valueOf(VipRightTypeEnum.RIGHT_XINPINCHANGXIAN.getValue()).equals(promotionProductEntity.getVipRightType())) {
                                    priceVO.setBuyable(false);
                                } else if ((!StringUtils.isNotEmpty((String)promotionProductEntity.getVipRightType()) || !String.valueOf(VipRightTypeEnum.RIGHT_TAOZHUANG_ZHEKOU.getValue()).equals(promotionProductEntity.getVipRightType())) && StringUtils.isNotEmpty((String)promotionProductEntity.getVipRightType()) && String.valueOf(VipRightTypeEnum.RIGHT_MIAOSHA.getValue()).equals(promotionProductEntity.getVipRightType())) {
                                    priceVO.setBuyable(false);
                                }
                            }
                        } else {
                            this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e57getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                            MallVipRightsEntity everyDayRight = this.vipService.checkCustomerRight(customerVip.getCustomerId(), "3263699494671905110");
                            DictionaryEntity dictionaryEntity = this.dictionaryInterface.getDictionary(PlatFormGroupEnum.LECHUN.getValue(), 224, "PROMOTION_STRATEGY");
                            Integer vipDayStrategy = 0;
                            if (dictionaryEntity != null) {
                                vipDayStrategy = Integer.valueOf(dictionaryEntity.getDictionaryName());
                            }
                            priceVO.setOriginPrice(promotionProductEntity.getOriginPrice());
                            priceVO.setPromotionPrice(promotionProductEntity.getPromotionPrice());
                            priceVO.setPromotionDiff(PriceUtils.subtract((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)priceVO.getPromotionPrice()));
                            priceVO.setFactPrice(priceVO.getPromotionPrice());
                            this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e58getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                            if (isVipDay.booleanValue() && promotionProductEntity.getVipDayRight() != null && promotionProductEntity.getVipDayRight() == 1) {
                                this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e59getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                                MallVipRightsEntity right = this.vipService.checkCustomerRight(customerVip.getCustomerId(), "3164601824691353085");
                                if (right != null && Integer.valueOf(right.getRightData()) > 0 && Integer.valueOf(right.getRightData()) < 100) {
                                    this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e510getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                                    if (vipDayStrategy == 1) {
                                        priceVO.setVipPrice(PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)priceVO.getPromotionPrice(), (Integer)Integer.valueOf(right.getRightData())), (BigDecimal)PriceUtils.format((BigDecimal)new BigDecimal(100))).setScale(1, RoundingMode.HALF_UP));
                                        priceVO.setVipDiff(PriceUtils.subtract((BigDecimal)priceVO.getPromotionPrice(), (BigDecimal)priceVO.getVipPrice()));
                                        priceVO.setFactPrice(priceVO.getVipPrice());
                                        this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e511getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                                    } else if (vipDayStrategy == 2 && priceVO.getVipPrice() != null) {
                                        this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e512getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                                        BigDecimal vipDayPrice = PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)priceVO.getOriginPrice(), (Integer)Integer.valueOf(right.getRightData())), (BigDecimal)PriceUtils.format((BigDecimal)new BigDecimal(100))).setScale(1, RoundingMode.HALF_UP);
                                        if (vipDayPrice.compareTo(priceVO.getPromotionPrice()) < 0) {
                                            priceVO.setVipPrice(vipDayPrice);
                                            priceVO.setVipDiff(PriceUtils.subtract((BigDecimal)priceVO.getPromotionPrice(), (BigDecimal)priceVO.getVipPrice()));
                                            priceVO.setFactPrice(priceVO.getVipPrice());
                                        }
                                    }
                                    this.logger.info("\u4f1a\u5458\u65e5\u4fc3\u9500\u6298\u6263\uff1a{}", (Object)JsonUtils.toJson((Object)priceVO, (boolean)false));
                                    return priceVO;
                                }
                            } else if (everyDayRight != null && Integer.valueOf(everyDayRight.getRightData()) > 0 && Integer.valueOf(everyDayRight.getRightData()) < 100 && promotionProductEntity.getVipEverydayRight() != null && promotionProductEntity.getVipEverydayRight() == 1) {
                                this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e513getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                                if (vipDayStrategy == 1) {
                                    this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e514getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                                    priceVO.setVipPrice(PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)priceVO.getPromotionPrice(), (Integer)Integer.valueOf(everyDayRight.getRightData())), (BigDecimal)PriceUtils.format((BigDecimal)new BigDecimal(100))).setScale(1, RoundingMode.HALF_UP));
                                    priceVO.setVipDiff(PriceUtils.subtract((BigDecimal)priceVO.getPromotionPrice(), (BigDecimal)priceVO.getVipPrice()));
                                    priceVO.setFactPrice(priceVO.getVipPrice());
                                } else if (vipDayStrategy == 2 && priceVO.getVipPrice() != null) {
                                    this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e515getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                                    BigDecimal everyDayPrice = PriceUtils.divide((BigDecimal)PriceUtils.multiply((BigDecimal)priceVO.getOriginPrice(), (Integer)Integer.valueOf(everyDayRight.getRightData())), (BigDecimal)PriceUtils.format((BigDecimal)new BigDecimal(100))).setScale(1, RoundingMode.HALF_UP);
                                    if (everyDayPrice.compareTo(priceVO.getPromotionPrice()) < 0) {
                                        priceVO.setVipPrice(everyDayPrice);
                                        priceVO.setVipDiff(PriceUtils.subtract((BigDecimal)priceVO.getPromotionPrice(), (BigDecimal)priceVO.getVipPrice()));
                                        priceVO.setFactPrice(priceVO.getVipPrice());
                                    }
                                }
                                this.logger.info("\u65e5\u5e38\u4fc3\u9500\u6298\u6263\uff1a{}", (Object)JsonUtils.toJson((Object)priceVO, (boolean)false));
                                return priceVO;
                            }
                            if (priceVO.getFactPrice() == null) {
                                this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e516getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                                priceVO.setOriginPrice(promotionProductEntity.getOriginPrice());
                                priceVO.setFactPrice(promotionProductEntity.getPromotionPrice());
                                priceVO.setPromotionPrice(promotionProductEntity.getPromotionPrice());
                                priceVO.setPromotionDiff(PriceUtils.subtract((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)priceVO.getPromotionPrice()));
                            }
                        }
                        this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e517getPrice:orderSourceEnum={},salesTypeEnum={},saleId={},customerId={},longPeriodTimes={}", new Object[]{orderSourceEnum.getName(), salesTypeEnum.getName(), saleId, customerVip.getCustomerId(), longPeriodTimes});
                        this.logger.info("\u4fc3\u9500\u4f1a\u5458\u65e5priceVO={}", (Object)JsonUtils.toJson((Object)priceVO, (boolean)false));
                        return priceVO;
                    }
                }
                break;
            }
            case LONGPERIOD_BUY: {
                MallProductEntity productEntity = this.productService.getProduct(saleId);
                MallRegularEntity regular = this.regularService.getRegular4GroupDCount(productEntity.getPlatformGroupId(), longPeriodTimes);
                if (regular != null) {
                    if (regular.getPriceMode() != 2) break;
                    priceVO.setOriginPrice(PriceUtils.format((String)productEntity.getProPrice()));
                    priceVO.setFactPrice(PriceUtils.multiply((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)PriceUtils.format((Float)regular.getDiscount())));
                    priceVO.setOtherDiff(PriceUtils.subtract((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)priceVO.getFactPrice()));
                    return priceVO;
                }
                priceVO.setOriginPrice(PriceUtils.format((String)productEntity.getProPrice()));
                priceVO.setFactPrice(priceVO.getOriginPrice());
                break;
            }
            case RECHANGE_CARD: {
                break;
            }
            case Supper_Member: {
                if (!Objects.equals(customerVip.getVipType(), VipLevelTypeEnum.superVip.getValue())) {
                    this.logger.info("\u7528\u6237:{},\u4e0d\u662f\u8d85\u7ea7\u4f1a\u5458 \u4e0d\u4eab\u53d7\u4f1a\u5458\u6743\u76ca", (Object)customerVip.getCustomerId(), (Object)customerVip.getVipType());
                    break;
                }
                if (!Objects.equals(customerVip.getStatus(), StatusEnum.STATUS_OK.getValue())) {
                    this.logger.info("\u7528\u6237:{},\u4f1a\u5458\u72b6:{}\u6001\u5931\u6548", (Object)customerVip.getCustomerId(), (Object)customerVip.getStatus());
                    break;
                }
                Integer vipLevel = customerVip.getVipLevel();
                Integer saleType = null;
                switch (salesTypeEnum) {
                    case SALES_PRODUCT: {
                        saleType = SalesTypeEnum.SALES_PRODUCT.getValue();
                        MallProductEntity productEntity2 = this.productService.getProduct(saleId);
                        priceVO.setOriginPrice(PriceUtils.format((String)productEntity2.getProPrice()));
                        break;
                    }
                    case SALES_PROMOTION: {
                        saleType = SalesTypeEnum.SALES_PROMOTION.getValue();
                        MallPromotionProductEntity promotionProductEntity = this.promotionProductService.getPromotionProductEntity(saleId);
                        priceVO.setOriginPrice(promotionProductEntity.getOriginPrice());
                        break;
                    }
                }
                MallProductPriceEntity productPrice = this.productPriceInterface.getByProductId(saleId, saleType, vipLevel);
                if (productPrice != null) {
                    priceVO.setVipPrice(productPrice.getPrice());
                    priceVO.setVipDiff(PriceUtils.subtract((BigDecimal)priceVO.getOriginPrice(), (BigDecimal)priceVO.getVipPrice()));
                    priceVO.setFactPrice(priceVO.getVipPrice());
                    this.logger.info("\u5546\u54c1\uff1a{}\u672a\u8d85\u7ea7\u4f1a\u5458\u4ef7:{}", (Object)saleId, (Object)saleType);
                } else {
                    this.logger.info("\u5546\u54c1\uff1a{}\u672a\u914d\u7f6e\u8d85\u7ea7\u4f1a\u5458\u4ef7:{}", (Object)saleId, (Object)saleType);
                }
                return priceVO;
            }
        }
        return null;
    }
}

